// -*- c++ -*-
//------------------------------------------------------------------------------
//                              Card.cpp
//------------------------------------------------------------------------------
// $Id: Card.cpp,v 1.5 2004/05/01 19:09:02 vlg Exp $
//
//  Copyright (c) 2004 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//
// Date: Jan 22, 2004
//------------------------------------------------------------------------------

#include <assa/TimeVal.h>
using ASSA::TimeVal;

#include "Card.h"

Card::
Card () 
{ 
	trace_with_mask("Card::Card",DECK); 
	
	mark_clean ();
	TimeVal t (TimeVal::gettimeofday ());
	m_id = t.sec ();
}

void
Card::
dump () const
{
	DL((DECK, "id       = \"%d\"\n", get_id ()));
	DL((DECK, "question = \"%s\"\n", get_question ().c_str ()));
	DL((DECK, "answer   = \"%s\"\n", get_answer ().c_str ()));
	DL((DECK, "example  = \"%s\"\n", get_example ().c_str ()));
	DL((DECK, "dirty?   = \"%s\"\n", (m_dirty ? "yes" : "no")));
}
