/* $Id: ShapeGenerator.cpp,v 1.7 2005/04/05 11:32:54 ellson Exp $ $Revision: 1.7 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
 This software is part of the graphviz package
 Copyright (c) 1995-2004 AT&T Corp.
 Licensed under the Common Public License, Version 1.0 (the "License")
 Any use, reproduction or distribution of this software constitutes
 acceptance of the License.  A copy of the License is available at:
     http://www.research.att.com/sw/license/cpl-1.0.html
 (with md5 checksum 201a9e4ba08a96f5d9677315d8ce1463)
*/

#include "common/Dynagraph.h"
#include "common/reorient.h"
#include <sstream>
using namespace std;
void ShapeGenerator::Process(ChangeQueue &Q) {
  Layout *subs[2] = {&Q.insN,&Q.modN};
  for(int i=0; i<2; ++i)
    for(Layout::node_iter ni = subs[i]->nodes().begin(); ni !=subs[i]->nodes().end(); ++ni) {
      Layout::Node *n = *ni;
      if((i==0 || igd<Update>(n).flags&DG_UPD_POLYDEF) && gd<IfPolyDef>(n).whether) {
		// hack: this fixes an apparent bug in gcc (genpoly will call clear() too)
		gd<Drawn>(n).clear(); 
        try {
		    genpoly(gd<PolyDef>(n),gd<Drawn>(n));
        }
        catch(BadPolyDef) {
            // silly users with your zero-gons and such
            gd<Drawn>(n).clear();
        }
		NodeGeom &ng = gd<NodeGeom>(n);
		ng.region.shape.Clear();
		if(gd<Drawn>(n).size()) {
			// it would be nice to make this section an update for a DG_UPD_DRAWN
			// flag, so that the user could specify gd<Drawn> instead of this shapegen...
			Line &biggest = gd<Drawn>(n).front(); // first one is biggest
			ng.region.shape.resize(biggest.size());
			for(size_t i = 0; i<biggest.size(); ++i) 
				ng.region.shape[i] = reorient(biggest[i],true,gd<Translation>(Q.current).orientation);
			ng.region.shape.degree = biggest.degree;
		}
		ng.region.updateBounds();
		Q.ModNode(n,DG_UPD_REGION|DG_UPD_DRAWN);
      }
    }
}
