IF(NOT ODBC_FOUND)
	IF(NOT "$ENV{ODBC_ROOT}" STREQUAL "")
		SET(ODBC_ROOT "$ENV{ODBC_ROOT}")
	ENDIF()

	if(WIN32)
		SET(ODBC_LIBS "-lodbc32")
		SET(ODBC_INCLUDE "")
		SET(ODBC_DEFS "")
	else()
		SET(LIBS odbc)
		IF(ODBC_USE_STATIC_LIBS OR USE_STATIC_LIBS)
			SET(CMAKE_FIND_LIBRARY_SUFFIXES .a)
			# static libraries are not supported
			SET(ODBC_ERROR TRUE)
		ENDIF()

		FIND_PATH(ODBC_INCLUDE sql.h HINTS ${ODBC_ROOT}/include)
		IF(NOT ODBC_INCLUDE)
			SET(ODBC_ERROR TRUE)
		ENDIF()

		FOREACH(LIB ${LIBS})
			FIND_LIBRARY(ODBC_${LIB}_LIB ${LIB} HINTS ${ODBC_ROOT}/lib)
			IF(ODBC_${LIB}_LIB)
				SET(ODBC_LIBS ${ODBC_LIBS} ${ODBC_${LIB}_LIB})
			ELSE()
				SET(ODBC_ERROR TRUE)
			ENDIF()
		ENDFOREACH()
		SET(ODBC_DEFS "-DUNIXODBC")
	endif()

	IF(NOT ODBC_ERROR)
		SET(ODBC_DEFS ${ODBC_DEFS} CACHE INTERNAL "")
		SET(ODBC_LIBS ${ODBC_LIBS} CACHE INTERNAL "")
		SET(ODBC_FOUND TRUE CACHE BOOL "Whether odbc driver has been found")
	ENDIF()

	IF(ODBC_FOUND)
		IF (NOT ODBC_FIND_QUIETLY)
			MESSAGE(STATUS "Looking for odbc... - found ${ODBC_LIB}")
		ENDIF (NOT ODBC_FIND_QUIETLY)
	ELSE()
		IF (ODBC_FIND_REQUIRED)
			MESSAGE(FATAL_ERROR "Looking for odbc... - NOT found")
		ENDIF (ODBC_FIND_REQUIRED)
		MESSAGE(STATUS "Looking for odbc... - NOT found")
	ENDIF()
ENDIF()

IF(ODBC_FOUND)
	SET(ODBC_INCLUDE_DIR ${ODBC_INCLUDE})
	SET(ODBC_LIBRARIES ${ODBC_LIBS})
	SET(ODBC_DEFINITIONS ${ODBC_DEFS})
ENDIF()
