/*
 * Preview widget module
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <gnome.h>
#include "preview.h"

/* Private function declarations */
static void preview_class_init(PreviewClass *klass);
static void preview_init(Preview *preview);


static GnomeDialogClass *parent_class = NULL;

GtkType
preview_get_type(void)
{
  static GtkType preview_type = 0;

  if (!preview_type) {
      static const GtkTypeInfo preview_info = {
		  "Preview",
		  sizeof(Preview),
		  sizeof(PreviewClass),
		  (GtkClassInitFunc)preview_class_init,
		  (GtkObjectInitFunc)preview_init,
		  /* reserved_1 */ NULL,
		  /* reserved_2 */ NULL,
		  (GtkClassInitFunc)NULL,
      };
      preview_type = gtk_type_unique(gnome_dialog_get_type(), &preview_info);
  }
  
  return preview_type;
}

static void
preview_class_init(PreviewClass *klass)
{
	parent_class = gtk_type_class(gnome_dialog_get_type());
}

static void
preview_init(Preview *preview)
{
	GnomeDialog *dialog;
	GtkWidget *darea;

	dialog = GNOME_DIALOG(preview);
	gtk_window_set_title(GTK_WINDOW(dialog), _("Preview"));
	gnome_dialog_append_buttons(dialog,
								GNOME_STOCK_BUTTON_CLOSE,
								NULL);
	gtk_window_set_policy(GTK_WINDOW(dialog), TRUE, TRUE, TRUE);
	gnome_dialog_set_close(dialog, TRUE);

	darea = gtk_drawing_area_new();
	preview->darea = GTK_DRAWING_AREA(darea);
	gtk_drawing_area_size(GTK_DRAWING_AREA(darea), 300, 300);
	gtk_container_add(GTK_CONTAINER(dialog->vbox), darea);
	gtk_widget_show(darea);
}

GtkWidget*
preview_new(void)
{
	return gtk_type_new(TYPE_PREVIEW);
}


/** Interfaces **/


/** Internal functions **/
