#include "gcd.h"

extern int helpon;
extern char *prog_name, *prog_ver;
WINDOW *helpw;

void show_help()
{   
   helpw = newwin(16,60,6,10);
   wbkgd(helpw, COLOR_PAIR(C_BLUE_HL) | 32);   
   box(helpw,ACS_VLINE,ACS_HLINE);
   
   wattrset(helpw, COLOR_PAIR(C_BLUE_HL)|A_BOLD);
   mvwprintw(helpw, 0, 22, " %s %s (C) 1998 Mark Landis ", prog_name, prog_ver);
   
   wattrset(helpw, COLOR_PAIR(C_BLUE_YELLOW)|A_BOLD);
   mvwprintw(helpw, 0, 3, " Help ");
   mvwprintw(helpw, 15, 3, " Press any key to continue... ");

   wattrset(helpw, COLOR_PAIR(C_BLUE_HL)|A_BOLD);
   mvwprintw(helpw, 2, 3, " Key               Command");
   wattrset(helpw, COLOR_PAIR(C_BLUE_HL));
   mvwprintw(helpw, 3, 3, "-----              -------");
   mvwprintw(helpw, 4, 3, "  A		      Toggle 7/8-bit display");
   mvwprintw(helpw, 5, 3, "  E                Eject CD and quit Groovy");
   mvwprintw(helpw, 6, 3, "  P                Play highlighted track");
   mvwprintw(helpw, 7, 3, "  S                Stop playing");
   mvwprintw(helpw, 8, 3, "  Z                Pause playing");
   mvwprintw(helpw, 9, 3, "  R                Toggle through play modes");
   mvwprintw(helpw,10, 3, "  T                Toggle through time modes");
   mvwprintw(helpw,11, 3, " +,-               Next/Previous tracks"); 
   mvwprintw(helpw,12, 3, " <,>               Rewind/Fast Forward 10 seconds");
   mvwprintw(helpw,13, 3, "  Q                Quit Groovy (keeps playing)");
   
   wrefresh(helpw);
   
   helpon = 1;  
}

void hide_help()
{
   werase(helpw);
   delwin(helpw);
   
   touchwin(stdscr);
   refresh();
   
   helpon = 0;
}
