/*
 * Some categories which add context menus to outline and table views.
 *
 * These routines were found on mailing lists and can probably be assumed
 * to be public domain.
 */

#import <AppKit/AppKit.h>

@protocol Delegate
- outlineView:view contextMenuForItem:item;
- tableView:view contextMenuForRow:(int)row col:(int)col;
@end

@interface NSOutlineView (ContextMenus)
- (NSMenu*)menuForEvent:(NSEvent*)e;
@end

@implementation NSOutlineView (ContextMenus)
- (NSMenu*)menuForEvent:(NSEvent*)e
{
	int row = [self rowAtPoint:[self convertPoint:[e locationInWindow]
		   fromView:nil]];
	if( row >= 0 )
	{
		id item;
		[self abortEditing];
		item = [self itemAtRow:row];
		if(item)
		{
			id d = [self delegate];
			if( ![d respondsToSelector:@selector(outlineView:shouldSelectItem:)] || [d outlineView:self shouldSelectItem:item] )
				[self selectRow:row byExtendingSelection:NO];
			if( [d respondsToSelector:@selector(outlineView:contextMenuForItem:)])
				return [d outlineView:self contextMenuForItem:item];
		}
	}
	else
		return [self menu];
	return nil;
}
@end

@interface NSTableView (ContextMenus)
- (NSMenu*)menuForEvent:(NSEvent*)e;
@end

@implementation NSTableView (ContextMenus)
- (NSMenu*)menuForEvent:(NSEvent*)e
{
	NSPoint p = [self convertPoint:[e locationInWindow] fromView:nil];
	int row = [self rowAtPoint:p], col = [self columnAtPoint:p];
	if( row >= 0 && col >= 0 )
	{
		id d = [self delegate];
		[self abortEditing];
		if( ![d respondsToSelector:@selector(tableView:shouldSelectRow:)] || [d tableView:self shouldSelectRow:row])
			[self selectRow:row byExtendingSelection:NO];
		if( [d respondsToSelector:@selector(tableView:contextMenuForRow:col:)] )
			return [d tableView:self contextMenuForRow:row col:col];
	}
	else
		return [self menu];
	return nil;
}
@end
