/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * Code for loading protocol bundles.
 */

#import <Foundation/NSBundle.h>

@protocol GrouchClient, GrouchSession;
@class NSArray;

@interface NSBundle (Grouch)

// Is this a protocol plugin?
- (BOOL)isGrouchProtocolPlugin;

// List protocol bundles in resource directory
// Returns array of NSBundles.
- (NSArray*)listGrouchProtocols;

// Load client
- (id<GrouchSession>)loadGrouchClient:(id<GrouchClient>)cli
  forHost:(NSString*)host atPort:(int)port
  withLogin:(NSString*)login andPassword:(NSString*)passwd;

@end
