/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * Protocol bundle loader.
 */

#import <Loader.h>
#import <ClientInstance.h>
#import <Grouch/NSBundle+Grouch.h>
#import <Foundation/NSArray.h>
#import <Foundation/NSDictionary.h>

#ifdef __APPLE__
#import <objc/objc.h>
#import <objc/objc-class.h>
#endif

static NSDictionary *dict = nil;
static NSArray *bundlesAsStrings = nil;

static void initialize()
{
	if( !dict )
	{
		NSMutableDictionary *d = [NSMutableDictionary dictionary];
		NSMutableArray *a = [NSMutableArray array];
		NSArray *src = [[NSBundle mainBundle] listGrouchProtocols];
		int i;
		for( i=0; i<[src count]; ++i )
		{
			NSBundle *b = [src objectAtIndex:i];
			Class principe = [b principalClass];
			NSString *s;
			s = [NSString stringWithCString:principe->name];
			[d setObject:b forKey:s];
			[a addObject:s];
		}
		dict = [[NSDictionary dictionaryWithDictionary:d] retain];
		bundlesAsStrings = [[NSArray arrayWithArray:a] retain];
	}
}

@implementation Loader

+ (NSArray*)getProtocols
{
	initialize();
	return bundlesAsStrings;
}

+ (void)loadProtocol:(NSString*)proto withHost:(NSString*)host atPort:(int)port
  withLogin:(NSString*)login andPassword:(NSString*)passwd
{
	ClientInstance *cli;
	NSBundle *b;
	id <GrouchSession> socket;
	initialize();
	b = [dict objectForKey:proto];
	cli = [ClientInstance new];
	socket = [b loadGrouchClient:cli forHost:host atPort:port
	 withLogin:login andPassword:passwd];
	if( socket )
		[cli setSock:socket];
	else
	{
		NSLog(@"error loading bundle!");
		[cli release];
	}
}

@end
