/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * All of the Oscar services have the same basic login sequence.
 * 	For auth, you need your password.
 * 	For others, you need a cookie.
 * Lo!  Through the magic of object orientation, they are one and the same!
 */

#import <Oscar/OscarFlap.h>
@class OscarTlvListIn;

@interface OscarPassword : NSObject <OscarCredentials>
{
	NSString *login, *password;
}

// NB: autoreleased
+ passwordWithLogin:(NSString*)user andPassword:(NSString*)pass;

- initWithLogin:(NSString*)user andPassword:(NSString*)pass;
- (void)dealloc;

- (void)addPasswordHash:(OscarBuffer*)buf;
- (void)writeCredentials:(OscarBuffer*)buf;

- (NSString*)login;
@end

@interface OscarAuthCookie : NSObject <OscarCredentials>
{
	void *cookie;
	size_t len;
}

// NB: autoreleased
+ cookieFromTLV:(OscarTlvListIn*)tlvs;
- initFromTLV:(OscarTlvListIn*)tlvs;

- init;
- (void)dealloc;

- (void)writeCredentials:(OscarBuffer*)buf;
@end
