#import <Oscar/OscarClient.h>
#import <Oscar/OscarCredentials.h>

#import <Grouch/GrouchClient.h>

@interface Oscar : NSObject <GrouchBundle>
- (id<GrouchSession>)loadGrouchClient:(id<GrouchClient>)cli
  forHost:(NSString*)host atPort:(int)port
  withLogin:(NSString*)login andPassword:(NSString*)passwd;
@end

@implementation Oscar
- (id<GrouchSession>)loadGrouchClient:(id<GrouchClient>)cli
  forHost:(NSString*)host atPort:(int)port
  withLogin:(NSString*)login andPassword:(NSString*)passwd
{
	OscarPassword *pass;

	pass = [OscarPassword passwordWithLogin:login andPassword:passwd];

	return [OscarClient clientForServer:host atPort:port
			    withCredentials:pass andUI:cli andTag:nil];
}
@end
