#import <Oscar/OscarHandlers.h>
#import <Oscar/OscarClient.h>
#import <Oscar/OscarIncomingSnac.h>
#import <Grouch/GrouchStringTool.h>
#import <Foundation/NSBundle.h>

@implementation OscarErrorHandler
+ get
{
	static id r = nil;
	if( r )
		return r;
	else
		return r = [OscarErrorHandler new];
}

- (void)handleSnacForClient:(OscarFlap*)flap
	ofFamily:(int)family andType:(int)type
	withFlags:(int)flags andTag:tag
	buffer:(OscarIncomingSnac*)buf
{
	static NSString *dict = @"SnacErrors";
	NSBundle *b = [NSBundle bundleForClass:[self class]];
	NSString *er = [NSString stringWithFormat:@"%i", [buf readInt16]];
	NSString *msg = [GrouchString getString:er fromDict:dict withBundle:b];
	OscarClient *cli = [flap client];
	if( !msg )
		msg = [GrouchString getString:@"?" fromDict:dict withBundle:b];
	msg = [[GrouchString getString:@"msg" fromDict:dict withBundle:b]
		createUserString:1,[msg createUserString:1,er]];
	[[cli getUI] error:msg fatal:NO];
}

@end
