/**************************************************************************
 *                                                                        *
 *   Copyright (C) 2001 Grub, Inc.                                        *
 *                                                                        *
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 1, or (at your option)  *
 *   any later version.                                                   *
 *                                                                        *
 *   This program is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *   GNU General Public License for more details.                         *
 *                                                                        *
 *   You should have received a copy of the GNU General Public License    *
 *   along with this program; if not, write to the Free Software          *
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                        *
 *                                                                        *
 **************************************************************************/  

/* Project: 	GRUB-CLIENT <http://www.grub.org>
 * module: 	Archive (crawler)
 * Author: 	Ledio Ago(lajesus@grub.org)
 * Date:	Feb 13, 2001	
 * File: 	CrawlerDB.cpp
 */

#include "CrawlerDB.h"

CrawlerDB::CrawlerDB(char *file_db) : 
	UtilDB( file_db ),
	col_URL("URL"),
	col_CRC("CRC"),
	col_content("content"),
	col_status("status"),
	col_mime("mime"),
	col_redirURL("redirURL")
{
	/* Creating a database table */
	db_tbl = db_storage.GetAs(
		"DB_TABLE[URL:S,CRC:I,status:I,mime:S,redirURL:S,content:B]");

	db_storage.Commit();
	tbl_size = db_tbl.GetSize();
	tbl_index = 0;
}

CrawlerDB::~CrawlerDB() {}

/*
 * Method: 	GetCrawledUrl
 * Description:	It will access the information stored in the
 *		first record of the crawled urls table.  The
 *		user of this method is expected to allocate
 *	 	and deallocate the memory for handle. 
 * Return:	It will return a structure with the obtained 
 *		information.
 */	
void CrawlerDB::GetCrawledUrl( URLHandler *handle )
	throw (GrubExp )
{
	char *tmp = NULL;

	assert( handle != NULL );

	tmp = (char*)col_URL.Get(db_tbl.ElementAt(tbl_index));
	if ( !tmp ) {
		throw GrubExp("GetServedUrl: Failed to get URL from "
			"crawled urls table!");
	}
	if ( handle->URL = new char[strlen(tmp)+1] ) {
	
		strcpy( handle->URL, tmp );
	} 
	else {
		throw GrubExp("GetServedUrl: Failed to allocate memory!");
	}
	tmp = NULL;

	c4_Bytes col_tmp = col_content.Get(db_tbl.ElementAt(tbl_index));

	/* We are decrementing size by one at this point, to be consistent
	 * with the real value of size.  There is NOTE in method
	 * InsertCrawledUrl which explains why we increased the size by 1
	 */
	handle->size = col_tmp.Size() - 1;
	tmp = (char *)col_tmp.Contents();	
	if ( !tmp ) {
		throw GrubExp("GetServedUrl: Failed to get content from "
			"crawled urls table!");
	}
	if ( handle->content = new char[(handle->size)+1] ) {

		memcpy( handle->content, tmp, (handle->size) + 1 );
	}
	else {
		throw GrubExp("GetServedUrl: Failed to allocate memory!");
	}
	tmp = NULL;

	tmp = (char*)col_mime.Get(db_tbl.ElementAt(tbl_index));
	if ( !tmp ) {
		throw GrubExp("GetServedUrl: Failed to get mime from "
			"crawled urls table!");
	}
	if ( handle->MIME = new char[strlen(tmp)+1] ) {

		strcpy( handle->MIME, tmp );
	}
	else {
		throw GrubExp("GetServedUrl: Failed to allocate memory!");
	}
	tmp = NULL;

	tmp = (char*)col_redirURL.Get(db_tbl.ElementAt(tbl_index));
	if ( !tmp ) {
		throw GrubExp("GetServedUrl: Failed to get redirURL from "
			"crawled urls table!");
	}
	if ( handle->redirURL = new char[strlen(tmp)+1] ) {

		strcpy( handle->redirURL, tmp );
	}
	else {
		throw GrubExp("GetServedUrl: Failed to allocate memory!");
	}
	tmp = NULL;

	handle->CRC = (unsigned long)col_CRC.Get(db_tbl.ElementAt(tbl_index));
	handle->status = (status_t)col_status.Get(db_tbl.ElementAt(tbl_index));

	tbl_size--;
	tbl_index++;

	if ( tbl_size == 0 ) { 
	
		db_tbl.RemoveAll();
		Commit();
		tbl_index = 0;
	}
}
/*
 * Method:	InsertCrawledUrl
 * Description:	It will insert a record in crawled urls table.
 */
void CrawlerDB::InsertCrawledUrl( URLHandler *handle )
	throw (GrubExp )
{
	assert( handle != NULL );

	db_tbl.Add (
			col_URL[handle->URL] + 
			/* NOTE: We are increasing the size of content
			 * by one, in case a Null character was stored
			 * before this function was called.
			 */
			col_content[c4_Bytes(handle->content,(handle->size)+1)] + 
			col_CRC[(int)handle->CRC] +
			col_status[(int)handle->status] +
			col_mime[handle->MIME] +
			col_redirURL[handle->redirURL]
	);
	Commit();
	tbl_size++;
}

