#include "ConsoleFace.h"
#include "input_thread.h"  // for the dirty hack for COM to work well


ConsoleFace::ConsoleFace() : Face(), host(0), port(1025)
{
	host = strcopy("localhost");

	ADD_FACE_EVENT(GetBandwidth);
	ADD_FACE_EVENT(GetBandwidthLimit);
	ADD_FACE_EVENT(GetCrawlerCount);
	ADD_FACE_EVENT(GetStatus);

	ADD_FACE_EVENT(GettingBegin);
	ADD_FACE_EVENT(GettingURL);
	ADD_FACE_EVENT(GettingEnd);
	ADD_FACE_EVENT(CrawlingBegin);
	ADD_FACE_EVENT(CrawlingURL);
	ADD_FACE_EVENT(CrawlingURLDone);
	ADD_FACE_EVENT(CrawlingEnd);
	ADD_FACE_EVENT(PuttingBegin);
	ADD_FACE_EVENT(PuttingURL);
	ADD_FACE_EVENT(PuttingEnd);

	ADD_FACE_EVENT(HostProtect);
	ADD_FACE_EVENT(HostUnprotect);
	ADD_FACE_EVENT(Sleep);
}

ConsoleFace::~ConsoleFace()
{
	if ( host ) delete [] host;
}

//////////////////////////
// Posts, Rings, Events //
//////////////////////////

void ConsoleFace::PostSetBandwidth(int Bandwidth)
{
	ENTER_FACE_POST(SetBandwidth);

	APPEND_INTEGER(Bandwidth);

	EXIT_FACE_POST();
}

void ConsoleFace::PostSetCrawlerCount(int Count)
{
	ENTER_FACE_POST(SetCrawlerCount);

	APPEND_INTEGER(Count);

	EXIT_FACE_POST();
}


void ConsoleFace::RingGetBandwidth()
{
	ENTER_FACE_RING(GetBandwidth);

	EXIT_FACE_RING();
}

void ConsoleFace::RingGetBandwidthLimit()
{
	ENTER_FACE_RING(GetBandwidthLimit);

	EXIT_FACE_RING();
}

void ConsoleFace::RingGetCrawlerCount()
{
	ENTER_FACE_RING(GetCrawlerCount);

	EXIT_FACE_RING();
}

void ConsoleFace::RingGetStatus()
{
	ENTER_FACE_RING(GetStatus);

	EXIT_FACE_RING();
}


void ConsoleFace::EventGetBandwidth(int Bandwidth)
{
	ENTER_FACE_EVENT(GetBandwidth);

	EXIT_FACE_EVENT();
}

void ConsoleFace::EventGetBandwidthLimit(int Limit)
{
	ENTER_FACE_EVENT(GetBandwidthLimit);

	EXIT_FACE_EVENT();
}

void ConsoleFace::EventGetCrawlerCount(int Count)
{
	ENTER_FACE_EVENT(GetCrawlerCount);

	EXIT_FACE_EVENT();
}

void ConsoleFace::EventGetStatus(int Status)
{
	ENTER_FACE_EVENT(GetStatus);

	EXIT_FACE_EVENT();
}


void ConsoleFace::EventGettingBegin()
{
	ENTER_FACE_EVENT(GettingBegin);

	EXIT_FACE_EVENT();
}

void ConsoleFace::EventGettingURL(const char *URL, int Size, int CRC)
{
	ENTER_FACE_EVENT(GettingURL);

	EXIT_FACE_EVENT();
}

void ConsoleFace::EventGettingEnd()
{
	ENTER_FACE_EVENT(GettingEnd);

	EXIT_FACE_EVENT();
}

void ConsoleFace::EventCrawlingBegin()
{
	ENTER_FACE_EVENT(CrawlingBegin);

	EXIT_FACE_EVENT();
}

void ConsoleFace::EventCrawlingURL(
	const char *URL,
	const char *Status,
	int Size,
	int CRC,
	int Bandwidth)
{
	ENTER_FACE_EVENT(CrawlingURL);

	EXIT_FACE_EVENT();
}

void ConsoleFace::EventCrawlingURLDone(const char *URL, const char *Status)
{
	ENTER_FACE_EVENT(CrawlingURLDone);

	EXIT_FACE_EVENT();
}

void ConsoleFace::EventCrawlingEnd()
{
	ENTER_FACE_EVENT(CrawlingEnd);

	EXIT_FACE_EVENT();
}

void ConsoleFace::EventPuttingBegin()
{
	ENTER_FACE_EVENT(PuttingBegin);

	EXIT_FACE_EVENT();
}

void ConsoleFace::EventPuttingURL(
	const char *URL,
	const char *Status,
	int Size,
	int CRC)
{
	ENTER_FACE_EVENT(PuttingURL);

	EXIT_FACE_EVENT();
}

void ConsoleFace::EventPuttingEnd()
{
	ENTER_FACE_EVENT(PuttingEnd);

	EXIT_FACE_EVENT();
}


void ConsoleFace::EventHostProtect()
{
	ENTER_FACE_EVENT(HostProtect);

	EXIT_FACE_EVENT();
}

void ConsoleFace::EventHostUnprotect()
{
	ENTER_FACE_EVENT(HostUnprotect);

	EXIT_FACE_EVENT();
}

void ConsoleFace::EventSleep(int Seconds)
{
	ENTER_FACE_EVENT(Sleep);

	EXIT_FACE_EVENT();
}

////////////////
// properties //
////////////////

void ConsoleFace::SetHost( const char *new_host )
{
	if ( host ) delete [] host;

	if ( new_host )
		host = strcopy( new_host );
	else
		host = strcopy("localhost");
}

const char *ConsoleFace::GetHost()
{
	return host;
}

void ConsoleFace::SetPort( unsigned short new_port )
{
	port = new_port;
}

unsigned short ConsoleFace::GetPort()
{
	return port;
}

/////////////
// methods //
/////////////

void ConsoleFace::Connect()
{
	connectClient( host, port );
}

void ConsoleFace::Disconnect()
{
	disconnect();
}

void ConsoleFace::Refresh()
{
	refresh();
}

bool ConsoleFace::IsConnected()
{
	return isConnected();
}

///////////////
// protected //
///////////////

// msg == NULL will be treated as bad data
void ConsoleFace::readCallback( const char *msg )
{
	BEGIN_FIRE_EVENTS

	BEGIN_FIRE(GetBandwidth)
	{
		GET_INTEGER(Bandwidth)

		EventGetBandwidth( Bandwidth );
	}
	END_FIRE

	BEGIN_FIRE(GetBandwidthLimit)
	{
		GET_INTEGER(Limit)

		EventGetBandwidthLimit(Limit);
	}
	END_FIRE

	BEGIN_FIRE(GetCrawlerCount)
	{
		GET_INTEGER(Count)

		EventGetCrawlerCount(Count);
	}
	END_FIRE

	BEGIN_FIRE(GetStatus)
	{
		GET_INTEGER(Status)

		EventGetStatus(Status);
	}
	END_FIRE


	BEGIN_FIRE(GettingBegin)
	{
		EventGettingBegin();
	}
	END_FIRE

	BEGIN_FIRE(GettingURL)
	{
		GET_STRING(URL)
		GET_INTEGER(Size)
		GET_INTEGER(CRC)

		EventGettingURL(URL, Size, CRC);
	}
	END_FIRE

	BEGIN_FIRE(GettingEnd)
	{
		EventGettingEnd();
	}
	END_FIRE

	BEGIN_FIRE(CrawlingBegin)
	{
		EventCrawlingBegin();
	}
	END_FIRE

	BEGIN_FIRE(CrawlingURL)
	{
		GET_STRING(URL)
		GET_STRING(Status)
		GET_INTEGER(Size)
		GET_INTEGER(CRC)
		GET_INTEGER(Bandwidth)

		EventCrawlingURL(URL, Status, Size, CRC, Bandwidth);
	}
	END_FIRE

	BEGIN_FIRE(CrawlingURLDone)
	{
		GET_STRING(URL)
		GET_STRING(Status)

		EventCrawlingURLDone(URL, Status);
	}
	END_FIRE

	BEGIN_FIRE(CrawlingEnd)
	{
		EventCrawlingEnd();
	}
	END_FIRE

	BEGIN_FIRE(PuttingBegin)
	{
		EventPuttingBegin();
	}
	END_FIRE

	BEGIN_FIRE(PuttingURL)
	{
		GET_STRING(URL)
		GET_STRING(Status)
		GET_INTEGER(Size)
		GET_INTEGER(CRC)

		EventPuttingURL(URL, Status, Size, CRC);
	}
	END_FIRE

	BEGIN_FIRE(PuttingEnd)
	{
		EventPuttingEnd();
	}
	END_FIRE


	BEGIN_FIRE(HostProtect)
	{
		EventHostProtect();
	}
	END_FIRE

	BEGIN_FIRE(HostUnprotect)
	{
		EventHostUnprotect();
	}
	END_FIRE

	BEGIN_FIRE(Sleep)
	{
		GET_INTEGER(Seconds)

		EventSleep(Seconds);
	}
	END_FIRE

	// Errors

	BEGIN_FIRE_BADPARSE
	{
		// XML parsing error
	}
	END_FIRE_BADPARSE

	BEGIN_FIRE_INVALIDMSG
	{
		// XML message was correct but unknown/unsupported
	}
	END_FIRE_INVALIDMSG

	END_FIRE_EVENTS
}

void ConsoleFace::errorCallback( const char *msg )
{
}
