#include "Face.h"

///////////////////////
// class MsgManagerX //
///////////////////////

MsgManagerX::MsgManagerX( unsigned short portnum ) :
	MsgManager(portnum), face(0) { }

MsgManagerX::MsgManagerX( unsigned short portnum, const char *hostname ) :
	MsgManager(portnum, hostname ), face(0) { }

MsgManagerX::~MsgManagerX() { }

void MsgManagerX::readCallback( const char *data )
{
	if (face) face->readCallback(data);
}

void MsgManagerX::errorCallback( const char *msg )
{
	if (face) face->errorCallback(msg);
}

////////////////
// class Face //
////////////////

Face::Face() : messenger(0), event_map(), event_map_count(0)
{
#ifdef GRUB_UNIX
	pthread_mutex_init(&mutex, (pthread_mutexattr_t *)0 );
#else
	InitializeCriticalSection( &mutex );
#endif
}

Face::~Face()
{
	disconnect();  // frees messenger

#ifdef GRUB_UNIX
	pthread_mutex_destroy(&mutex);
#else
	DeleteCriticalSection( &mutex );
#endif
}

void Face::connectServer( unsigned short portnum )
{
	disconnect();

	messenger = new MsgManagerX( portnum );
	messenger->setFace( (Face *)this );
	messenger->setActive(true);
}

void Face::connectClient( const char *hostname, unsigned short portnum )
{
	disconnect();

	messenger = new MsgManagerX( portnum, hostname );
	messenger->setFace( (Face *)this );
	messenger->setActive(true);
}

void Face::refresh()
{
	if ( messenger )
		messenger->setActive(true);
}

void Face::disconnect()
{
	if ( messenger ) {

		delete messenger;
		messenger = 0;
	}
}

bool Face::isConnected()
{
	return messenger != 0 && messenger->isConnected();
}

bool Face::isActive()
{
	return messenger != 0 && messenger->isActive();
}

void Face::lock()
{
#ifdef GRUB_UNIX
	pthread_mutex_lock( &mutex );
#else
	EnterCriticalSection( &mutex );
#endif
}

void Face::unlock()
{
#ifdef GRUB_UNIX
	pthread_mutex_unlock( &mutex );
#else
	LeaveCriticalSection( &mutex );
#endif
}

char *Face::strcopy( const char *str )
{
	int len;
	char *new_str;

	if ( !str ) return 0;

	len = strlen(str);

	new_str = new char[len + 1];
	strcpy( new_str, str );

	return new_str;
}
