#include "grubface.h"
#include "msgface.h"
#include "common.h"
#include <cstdio>
#include <cstring>

#ifdef GRUB_UNIX
#include <netinet/in.h>
#include <netdb.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#endif

/* ret = GF_SUCCESS, GF_REINIT, GF_SOCKERR */
int grub_attach( const char *hostname, unsigned short portnum )
{
	if ( grub_info.is_init )
		return GF_REINIT;

	struct sockaddr_in sa;
	struct hostent     *hp;
	SOCKET s;

	hp = gethostbyname( hostname );
	if ( hp == NULL ) /* we don't know who this host is */
		return GF_SOCKERR;

	memset( &sa,0,sizeof(sa) );
	memcpy( (char *)&sa.sin_addr, hp->h_addr, hp->h_length );
	sa.sin_family = hp->h_addrtype;
	sa.sin_port = htons( (u_short)portnum );

	s = socket( hp->h_addrtype, SOCK_STREAM, 0 );
	if ( s == GF_SOCKERR )
		return GF_SOCKERR;

	/* try to connect to the specified socket */
	if ( connect(s, (struct sockaddr *)&sa, sizeof sa) == SOCKET_ERROR ) {

		closesocket( s );
		return GF_SOCKERR;
	}

	/* it all went well */
	gmsg_init( s );

	return GF_SUCCESS;
}

/* ret = 1 (true), 0 (false) */
int grub_running( const char *hostname, unsigned short portnum )
{
	if ( grub_info.is_init )
		/* is this really a succesful way to check ???? */
		return 1;
	else {
		int ret;

		/* kinda dumm way to check if client is running */

		ret = grub_attach( hostname, portnum );
		if ( ret != GF_SUCCESS )
			return 0;

		grub_detach();
		return 1;
	}
}

/* ret = GF_SUCCESS */
int grub_detach()
{
	int ret = GF_SUCCESS;

	/* nothing to detach */
	if ( ! grub_info.is_init )
		return GF_SUCCESS;

	closesocket( grub_info.sock );

	gmsg_uninit();

	return ret;
}
