
/* autogenerated from gstvideoconvertorc.orc */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <glib.h>

#ifndef _ORC_INTEGER_TYPEDEFS_
#define _ORC_INTEGER_TYPEDEFS_
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#include <stdint.h>
typedef int8_t orc_int8;
typedef int16_t orc_int16;
typedef int32_t orc_int32;
typedef int64_t orc_int64;
typedef uint8_t orc_uint8;
typedef uint16_t orc_uint16;
typedef uint32_t orc_uint32;
typedef uint64_t orc_uint64;
#define ORC_UINT64_C(x) UINT64_C(x)
#elif defined(_MSC_VER)
typedef signed __int8 orc_int8;
typedef signed __int16 orc_int16;
typedef signed __int32 orc_int32;
typedef signed __int64 orc_int64;
typedef unsigned __int8 orc_uint8;
typedef unsigned __int16 orc_uint16;
typedef unsigned __int32 orc_uint32;
typedef unsigned __int64 orc_uint64;
#define ORC_UINT64_C(x) (x##Ui64)
#define inline __inline
#else
#include <limits.h>
typedef signed char orc_int8;
typedef short orc_int16;
typedef int orc_int32;
typedef unsigned char orc_uint8;
typedef unsigned short orc_uint16;
typedef unsigned int orc_uint32;
#if INT_MAX == LONG_MAX
typedef long long orc_int64;
typedef unsigned long long orc_uint64;
#define ORC_UINT64_C(x) (x##ULL)
#else
typedef long orc_int64;
typedef unsigned long orc_uint64;
#define ORC_UINT64_C(x) (x##UL)
#endif
#endif
typedef union
{
  orc_int16 i;
  orc_int8 x2[2];
} orc_union16;
typedef union
{
  orc_int32 i;
  float f;
  orc_int16 x2[2];
  orc_int8 x4[4];
} orc_union32;
typedef union
{
  orc_int64 i;
  double f;
  orc_int32 x2[2];
  float x2f[2];
  orc_int16 x4[4];
} orc_union64;
#endif
#ifndef ORC_RESTRICT
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#define ORC_RESTRICT restrict
#elif defined(__GNUC__) && __GNUC__ >= 4
#define ORC_RESTRICT __restrict__
#else
#define ORC_RESTRICT
#endif
#endif

#ifndef ORC_INTERNAL
#if defined(__SUNPRO_C) && (__SUNPRO_C >= 0x590)
#define ORC_INTERNAL __attribute__((visibility("hidden")))
#elif defined(__SUNPRO_C) && (__SUNPRO_C >= 0x550)
#define ORC_INTERNAL __hidden
#elif defined (__GNUC__)
#define ORC_INTERNAL __attribute__((visibility("hidden")))
#else
#define ORC_INTERNAL
#endif
#endif


#ifndef DISABLE_ORC
#include <orc/orc.h>
#endif
void video_convert_orc_memcpy_2d (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void video_convert_orc_convert_I420_UYVY (guint8 * ORC_RESTRICT d1,
    guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3,
    const guint8 * ORC_RESTRICT s4, int n);
void video_convert_orc_convert_I420_YUY2 (guint8 * ORC_RESTRICT d1,
    guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3,
    const guint8 * ORC_RESTRICT s4, int n);
void video_convert_orc_convert_I420_AYUV (guint8 * ORC_RESTRICT d1,
    guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3,
    const guint8 * ORC_RESTRICT s4, int n);
void video_convert_orc_convert_YUY2_I420 (guint8 * ORC_RESTRICT d1,
    guint8 * ORC_RESTRICT d2, guint8 * ORC_RESTRICT d3,
    guint8 * ORC_RESTRICT d4, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, int n);
void video_convert_orc_convert_UYVY_YUY2 (guint8 * ORC_RESTRICT d1,
    int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void video_convert_orc_planar_chroma_420_422 (guint8 * ORC_RESTRICT d1,
    int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void video_convert_orc_planar_chroma_420_444 (guint8 * ORC_RESTRICT d1,
    int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void video_convert_orc_planar_chroma_422_444 (guint8 * ORC_RESTRICT d1,
    int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void video_convert_orc_planar_chroma_444_422 (guint8 * ORC_RESTRICT d1,
    int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void video_convert_orc_planar_chroma_444_420 (guint8 * ORC_RESTRICT d1,
    int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride, int n, int m);
void video_convert_orc_planar_chroma_422_420 (guint8 * ORC_RESTRICT d1,
    int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride, int n, int m);
void video_convert_orc_convert_YUY2_AYUV (guint8 * ORC_RESTRICT d1,
    int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void video_convert_orc_convert_UYVY_AYUV (guint8 * ORC_RESTRICT d1,
    int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void video_convert_orc_convert_YUY2_Y42B (guint8 * ORC_RESTRICT d1,
    int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride,
    guint8 * ORC_RESTRICT d3, int d3_stride, const guint8 * ORC_RESTRICT s1,
    int s1_stride, int n, int m);
void video_convert_orc_convert_UYVY_Y42B (guint8 * ORC_RESTRICT d1,
    int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride,
    guint8 * ORC_RESTRICT d3, int d3_stride, const guint8 * ORC_RESTRICT s1,
    int s1_stride, int n, int m);
void video_convert_orc_convert_YUY2_Y444 (guint8 * ORC_RESTRICT d1,
    int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride,
    guint8 * ORC_RESTRICT d3, int d3_stride, const guint8 * ORC_RESTRICT s1,
    int s1_stride, int n, int m);
void video_convert_orc_convert_UYVY_Y444 (guint8 * ORC_RESTRICT d1,
    int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride,
    guint8 * ORC_RESTRICT d3, int d3_stride, const guint8 * ORC_RESTRICT s1,
    int s1_stride, int n, int m);
void video_convert_orc_convert_UYVY_I420 (guint8 * ORC_RESTRICT d1,
    guint8 * ORC_RESTRICT d2, guint8 * ORC_RESTRICT d3,
    guint8 * ORC_RESTRICT d4, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, int n);
void video_convert_orc_convert_AYUV_I420 (guint8 * ORC_RESTRICT d1,
    int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride,
    guint8 * ORC_RESTRICT d3, int d3_stride, guint8 * ORC_RESTRICT d4,
    int d4_stride, const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride, int n, int m);
void video_convert_orc_convert_AYUV_YUY2 (guint8 * ORC_RESTRICT d1,
    int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void video_convert_orc_convert_AYUV_UYVY (guint8 * ORC_RESTRICT d1,
    int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void video_convert_orc_convert_AYUV_Y42B (guint8 * ORC_RESTRICT d1,
    int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride,
    guint8 * ORC_RESTRICT d3, int d3_stride, const guint8 * ORC_RESTRICT s1,
    int s1_stride, int n, int m);
void video_convert_orc_convert_AYUV_Y444 (guint8 * ORC_RESTRICT d1,
    int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride,
    guint8 * ORC_RESTRICT d3, int d3_stride, const guint8 * ORC_RESTRICT s1,
    int s1_stride, int n, int m);
void video_convert_orc_convert_Y42B_YUY2 (guint8 * ORC_RESTRICT d1,
    int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m);
void video_convert_orc_convert_Y42B_UYVY (guint8 * ORC_RESTRICT d1,
    int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m);
void video_convert_orc_convert_Y42B_AYUV (guint8 * ORC_RESTRICT d1,
    int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m);
void video_convert_orc_convert_Y444_YUY2 (guint8 * ORC_RESTRICT d1,
    int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m);
void video_convert_orc_convert_Y444_UYVY (guint8 * ORC_RESTRICT d1,
    int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m);
void video_convert_orc_convert_Y444_AYUV (guint8 * ORC_RESTRICT d1,
    int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m);
void video_convert_orc_convert_AYUV_ARGB (guint8 * ORC_RESTRICT d1,
    int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int p1,
    int p2, int p3, int p4, int p5, int n, int m);
void video_convert_orc_convert_AYUV_BGRA (guint8 * ORC_RESTRICT d1,
    int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int p1,
    int p2, int p3, int p4, int p5, int n, int m);
void video_convert_orc_convert_AYUV_ABGR (guint8 * ORC_RESTRICT d1,
    int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int p1,
    int p2, int p3, int p4, int p5, int n, int m);
void video_convert_orc_convert_AYUV_RGBA (guint8 * ORC_RESTRICT d1,
    int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int p1,
    int p2, int p3, int p4, int p5, int n, int m);
void video_convert_orc_convert_I420_BGRA (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, int p1, int p2, int p3, int p4, int p5,
    int n);


/* begin Orc C target preamble */
#define ORC_CLAMP(x,a,b) ((x)<(a) ? (a) : ((x)>(b) ? (b) : (x)))
#define ORC_ABS(a) ((a)<0 ? -(a) : (a))
#define ORC_MIN(a,b) ((a)<(b) ? (a) : (b))
#define ORC_MAX(a,b) ((a)>(b) ? (a) : (b))
#define ORC_SB_MAX 127
#define ORC_SB_MIN (-1-ORC_SB_MAX)
#define ORC_UB_MAX 255
#define ORC_UB_MIN 0
#define ORC_SW_MAX 32767
#define ORC_SW_MIN (-1-ORC_SW_MAX)
#define ORC_UW_MAX 65535
#define ORC_UW_MIN 0
#define ORC_SL_MAX 2147483647
#define ORC_SL_MIN (-1-ORC_SL_MAX)
#define ORC_UL_MAX 4294967295U
#define ORC_UL_MIN 0
#define ORC_CLAMP_SB(x) ORC_CLAMP(x,ORC_SB_MIN,ORC_SB_MAX)
#define ORC_CLAMP_UB(x) ORC_CLAMP(x,ORC_UB_MIN,ORC_UB_MAX)
#define ORC_CLAMP_SW(x) ORC_CLAMP(x,ORC_SW_MIN,ORC_SW_MAX)
#define ORC_CLAMP_UW(x) ORC_CLAMP(x,ORC_UW_MIN,ORC_UW_MAX)
#define ORC_CLAMP_SL(x) ORC_CLAMP(x,ORC_SL_MIN,ORC_SL_MAX)
#define ORC_CLAMP_UL(x) ORC_CLAMP(x,ORC_UL_MIN,ORC_UL_MAX)
#define ORC_SWAP_W(x) ((((x)&0xffU)<<8) | (((x)&0xff00U)>>8))
#define ORC_SWAP_L(x) ((((x)&0xffU)<<24) | (((x)&0xff00U)<<8) | (((x)&0xff0000U)>>8) | (((x)&0xff000000U)>>24))
#define ORC_SWAP_Q(x) ((((x)&ORC_UINT64_C(0xff))<<56) | (((x)&ORC_UINT64_C(0xff00))<<40) | (((x)&ORC_UINT64_C(0xff0000))<<24) | (((x)&ORC_UINT64_C(0xff000000))<<8) | (((x)&ORC_UINT64_C(0xff00000000))>>8) | (((x)&ORC_UINT64_C(0xff0000000000))>>24) | (((x)&ORC_UINT64_C(0xff000000000000))>>40) | (((x)&ORC_UINT64_C(0xff00000000000000))>>56))
#define ORC_PTR_OFFSET(ptr,offset) ((void *)(((unsigned char *)(ptr)) + (offset)))
#define ORC_DENORMAL(x) ((x) & ((((x)&0x7f800000) == 0) ? 0xff800000 : 0xffffffff))
#define ORC_ISNAN(x) ((((x)&0x7f800000) == 0x7f800000) && (((x)&0x007fffff) != 0))
#define ORC_DENORMAL_DOUBLE(x) ((x) & ((((x)&ORC_UINT64_C(0x7ff0000000000000)) == 0) ? ORC_UINT64_C(0xfff0000000000000) : ORC_UINT64_C(0xffffffffffffffff)))
#define ORC_ISNAN_DOUBLE(x) ((((x)&ORC_UINT64_C(0x7ff0000000000000)) == ORC_UINT64_C(0x7ff0000000000000)) && (((x)&ORC_UINT64_C(0x000fffffffffffff)) != 0))
#ifndef ORC_RESTRICT
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#define ORC_RESTRICT restrict
#elif defined(__GNUC__) && __GNUC__ >= 4
#define ORC_RESTRICT __restrict__
#else
#define ORC_RESTRICT
#endif
#endif
/* end Orc C target preamble */



/* video_convert_orc_memcpy_2d */
#ifdef DISABLE_ORC
void
video_convert_orc_memcpy_2d (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  orc_int8 var32;
  orc_int8 var33;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: copyb */
      var33 = var32;
      /* 2: storeb */
      ptr0[i] = var33;
    }
  }

}

#else
static void
_backup_video_convert_orc_memcpy_2d (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  orc_int8 var32;
  orc_int8 var33;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: copyb */
      var33 = var32;
      /* 2: storeb */
      ptr0[i] = var33;
    }
  }

}

void
video_convert_orc_memcpy_2d (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 27, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114,
        116, 95, 111, 114, 99, 95, 109, 101, 109, 99, 112, 121, 95, 50, 100, 11,
        1, 1, 12, 1, 1, 42, 0, 4, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_convert_orc_memcpy_2d);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_convert_orc_memcpy_2d");
      orc_program_set_backup_function (p, _backup_video_convert_orc_memcpy_2d);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");

      orc_program_append_2 (p, "copyb", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_convert_I420_UYVY */
#ifdef DISABLE_ORC
void
video_convert_orc_convert_I420_UYVY (guint8 * ORC_RESTRICT d1,
    guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3,
    const guint8 * ORC_RESTRICT s4, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  orc_union32 *ORC_RESTRICT ptr1;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  const orc_int8 *ORC_RESTRICT ptr7;
  orc_int8 var33;
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;
  orc_union32 var38;
  orc_union16 var39;

  ptr0 = (orc_union32 *) d1;
  ptr1 = (orc_union32 *) d2;
  ptr4 = (orc_union16 *) s1;
  ptr5 = (orc_union16 *) s2;
  ptr6 = (orc_int8 *) s3;
  ptr7 = (orc_int8 *) s4;


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr6[i];
    /* 1: loadb */
    var34 = ptr7[i];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var33;
      _dest.x2[1] = var34;
      var39.i = _dest.i;
    }
    /* 3: loadw */
    var35 = ptr4[i];
    /* 4: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var39.x2[0];
      _dest.x2[1] = var35.x2[0];
      var36.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var39.x2[1];
      _dest.x2[1] = var35.x2[1];
      var36.x2[1] = _dest.i;
    }
    /* 5: storel */
    ptr0[i] = var36;
    /* 6: loadw */
    var37 = ptr5[i];
    /* 7: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var39.x2[0];
      _dest.x2[1] = var37.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var39.x2[1];
      _dest.x2[1] = var37.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 8: storel */
    ptr1[i] = var38;
  }

}

#else
static void
_backup_video_convert_orc_convert_I420_UYVY (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  orc_union32 *ORC_RESTRICT ptr1;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  const orc_int8 *ORC_RESTRICT ptr7;
  orc_int8 var33;
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;
  orc_union32 var38;
  orc_union16 var39;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr1 = (orc_union32 *) ex->arrays[1];
  ptr4 = (orc_union16 *) ex->arrays[4];
  ptr5 = (orc_union16 *) ex->arrays[5];
  ptr6 = (orc_int8 *) ex->arrays[6];
  ptr7 = (orc_int8 *) ex->arrays[7];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr6[i];
    /* 1: loadb */
    var34 = ptr7[i];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var33;
      _dest.x2[1] = var34;
      var39.i = _dest.i;
    }
    /* 3: loadw */
    var35 = ptr4[i];
    /* 4: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var39.x2[0];
      _dest.x2[1] = var35.x2[0];
      var36.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var39.x2[1];
      _dest.x2[1] = var35.x2[1];
      var36.x2[1] = _dest.i;
    }
    /* 5: storel */
    ptr0[i] = var36;
    /* 6: loadw */
    var37 = ptr5[i];
    /* 7: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var39.x2[0];
      _dest.x2[1] = var37.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var39.x2[1];
      _dest.x2[1] = var37.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 8: storel */
    ptr1[i] = var38;
  }

}

void
video_convert_orc_convert_I420_UYVY (guint8 * ORC_RESTRICT d1,
    guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3,
    const guint8 * ORC_RESTRICT s4, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 35, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114, 116,
        95, 111, 114, 99, 95, 99, 111, 110, 118, 101, 114, 116, 95, 73, 52, 50,
        48, 95, 85, 89, 86, 89, 11, 4, 4, 11, 4, 4, 12, 2, 2, 12,
        2, 2, 12, 1, 1, 12, 1, 1, 20, 2, 196, 32, 6, 7, 21, 1,
        196, 0, 32, 4, 21, 1, 196, 1, 32, 5, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_I420_UYVY);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_convert_orc_convert_I420_UYVY");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_I420_UYVY);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_destination (p, 4, "d2");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_S3, ORC_VAR_S4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D2, ORC_VAR_T1, ORC_VAR_S2,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->arrays[ORC_VAR_S3] = (void *) s3;
  ex->arrays[ORC_VAR_S4] = (void *) s4;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_convert_I420_YUY2 */
#ifdef DISABLE_ORC
void
video_convert_orc_convert_I420_YUY2 (guint8 * ORC_RESTRICT d1,
    guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3,
    const guint8 * ORC_RESTRICT s4, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  orc_union32 *ORC_RESTRICT ptr1;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  const orc_int8 *ORC_RESTRICT ptr7;
  orc_int8 var33;
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;
  orc_union32 var38;
  orc_union16 var39;

  ptr0 = (orc_union32 *) d1;
  ptr1 = (orc_union32 *) d2;
  ptr4 = (orc_union16 *) s1;
  ptr5 = (orc_union16 *) s2;
  ptr6 = (orc_int8 *) s3;
  ptr7 = (orc_int8 *) s4;


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr6[i];
    /* 1: loadb */
    var34 = ptr7[i];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var33;
      _dest.x2[1] = var34;
      var39.i = _dest.i;
    }
    /* 3: loadw */
    var35 = ptr4[i];
    /* 4: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var35.x2[0];
      _dest.x2[1] = var39.x2[0];
      var36.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var35.x2[1];
      _dest.x2[1] = var39.x2[1];
      var36.x2[1] = _dest.i;
    }
    /* 5: storel */
    ptr0[i] = var36;
    /* 6: loadw */
    var37 = ptr5[i];
    /* 7: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[0];
      _dest.x2[1] = var39.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[1];
      _dest.x2[1] = var39.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 8: storel */
    ptr1[i] = var38;
  }

}

#else
static void
_backup_video_convert_orc_convert_I420_YUY2 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  orc_union32 *ORC_RESTRICT ptr1;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  const orc_int8 *ORC_RESTRICT ptr7;
  orc_int8 var33;
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;
  orc_union32 var38;
  orc_union16 var39;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr1 = (orc_union32 *) ex->arrays[1];
  ptr4 = (orc_union16 *) ex->arrays[4];
  ptr5 = (orc_union16 *) ex->arrays[5];
  ptr6 = (orc_int8 *) ex->arrays[6];
  ptr7 = (orc_int8 *) ex->arrays[7];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr6[i];
    /* 1: loadb */
    var34 = ptr7[i];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var33;
      _dest.x2[1] = var34;
      var39.i = _dest.i;
    }
    /* 3: loadw */
    var35 = ptr4[i];
    /* 4: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var35.x2[0];
      _dest.x2[1] = var39.x2[0];
      var36.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var35.x2[1];
      _dest.x2[1] = var39.x2[1];
      var36.x2[1] = _dest.i;
    }
    /* 5: storel */
    ptr0[i] = var36;
    /* 6: loadw */
    var37 = ptr5[i];
    /* 7: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[0];
      _dest.x2[1] = var39.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[1];
      _dest.x2[1] = var39.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 8: storel */
    ptr1[i] = var38;
  }

}

void
video_convert_orc_convert_I420_YUY2 (guint8 * ORC_RESTRICT d1,
    guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3,
    const guint8 * ORC_RESTRICT s4, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 35, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114, 116,
        95, 111, 114, 99, 95, 99, 111, 110, 118, 101, 114, 116, 95, 73, 52, 50,
        48, 95, 89, 85, 89, 50, 11, 4, 4, 11, 4, 4, 12, 2, 2, 12,
        2, 2, 12, 1, 1, 12, 1, 1, 20, 2, 196, 32, 6, 7, 21, 1,
        196, 0, 4, 32, 21, 1, 196, 1, 5, 32, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_I420_YUY2);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_convert_orc_convert_I420_YUY2");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_I420_YUY2);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_destination (p, 4, "d2");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_S3, ORC_VAR_S4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D2, ORC_VAR_S2, ORC_VAR_T1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->arrays[ORC_VAR_S3] = (void *) s3;
  ex->arrays[ORC_VAR_S4] = (void *) s4;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_convert_I420_AYUV */
#ifdef DISABLE_ORC
void
video_convert_orc_convert_I420_AYUV (guint8 * ORC_RESTRICT d1,
    guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3,
    const guint8 * ORC_RESTRICT s4, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  orc_union32 *ORC_RESTRICT ptr1;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  const orc_int8 *ORC_RESTRICT ptr7;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_int8 var36;
#else
  orc_int8 var36;
#endif
  orc_int8 var37;
  orc_union32 var38;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_int8 var39;
#else
  orc_int8 var39;
#endif
  orc_int8 var40;
  orc_union32 var41;
  orc_int8 var42;
  orc_int8 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;

  ptr0 = (orc_union32 *) d1;
  ptr1 = (orc_union32 *) d2;
  ptr4 = (orc_int8 *) s1;
  ptr5 = (orc_int8 *) s2;
  ptr6 = (orc_int8 *) s3;
  ptr7 = (orc_int8 *) s4;

  /* 3: loadpb */
  var36 = (int) 0x000000ff;     /* 255 or 1.25987e-321f */
  /* 8: loadpb */
  var39 = (int) 0x000000ff;     /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadupdb */
    var42 = ptr6[i >> 1];
    /* 1: loadupdb */
    var43 = ptr7[i >> 1];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var42;
      _dest.x2[1] = var43;
      var44.i = _dest.i;
    }
    /* 4: loadb */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var36;
      _dest.x2[1] = var37;
      var45.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var45.i;
      _dest.x2[1] = var44.i;
      var38.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var38;
    /* 9: loadb */
    var40 = ptr5[i];
    /* 10: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var39;
      _dest.x2[1] = var40;
      var46.i = _dest.i;
    }
    /* 11: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var46.i;
      _dest.x2[1] = var44.i;
      var41.i = _dest.i;
    }
    /* 12: storel */
    ptr1[i] = var41;
  }

}

#else
static void
_backup_video_convert_orc_convert_I420_AYUV (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  orc_union32 *ORC_RESTRICT ptr1;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  const orc_int8 *ORC_RESTRICT ptr7;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_int8 var36;
#else
  orc_int8 var36;
#endif
  orc_int8 var37;
  orc_union32 var38;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_int8 var39;
#else
  orc_int8 var39;
#endif
  orc_int8 var40;
  orc_union32 var41;
  orc_int8 var42;
  orc_int8 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr1 = (orc_union32 *) ex->arrays[1];
  ptr4 = (orc_int8 *) ex->arrays[4];
  ptr5 = (orc_int8 *) ex->arrays[5];
  ptr6 = (orc_int8 *) ex->arrays[6];
  ptr7 = (orc_int8 *) ex->arrays[7];

  /* 3: loadpb */
  var36 = (int) 0x000000ff;     /* 255 or 1.25987e-321f */
  /* 8: loadpb */
  var39 = (int) 0x000000ff;     /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadupdb */
    var42 = ptr6[i >> 1];
    /* 1: loadupdb */
    var43 = ptr7[i >> 1];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var42;
      _dest.x2[1] = var43;
      var44.i = _dest.i;
    }
    /* 4: loadb */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var36;
      _dest.x2[1] = var37;
      var45.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var45.i;
      _dest.x2[1] = var44.i;
      var38.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var38;
    /* 9: loadb */
    var40 = ptr5[i];
    /* 10: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var39;
      _dest.x2[1] = var40;
      var46.i = _dest.i;
    }
    /* 11: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var46.i;
      _dest.x2[1] = var44.i;
      var41.i = _dest.i;
    }
    /* 12: storel */
    ptr1[i] = var41;
  }

}

void
video_convert_orc_convert_I420_AYUV (guint8 * ORC_RESTRICT d1,
    guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3,
    const guint8 * ORC_RESTRICT s4, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 35, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114, 116,
        95, 111, 114, 99, 95, 99, 111, 110, 118, 101, 114, 116, 95, 73, 52, 50,
        48, 95, 65, 89, 85, 86, 11, 4, 4, 11, 4, 4, 12, 1, 1, 12,
        1, 1, 12, 1, 1, 12, 1, 1, 14, 1, 255, 0, 0, 0, 20, 2,
        20, 2, 20, 1, 20, 1, 45, 34, 6, 45, 35, 7, 196, 32, 34, 35,
        196, 33, 16, 4, 195, 0, 33, 32, 196, 33, 16, 5, 195, 1, 33, 32,
        2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_I420_AYUV);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_convert_orc_convert_I420_AYUV");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_I420_AYUV);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_destination (p, 4, "d2");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_constant (p, 1, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");

      orc_program_append_2 (p, "loadupdb", 0, ORC_VAR_T3, ORC_VAR_S3,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadupdb", 0, ORC_VAR_T4, ORC_VAR_S4,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_S2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->arrays[ORC_VAR_S3] = (void *) s3;
  ex->arrays[ORC_VAR_S4] = (void *) s4;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_convert_YUY2_I420 */
#ifdef DISABLE_ORC
void
video_convert_orc_convert_YUY2_I420 (guint8 * ORC_RESTRICT d1,
    guint8 * ORC_RESTRICT d2, guint8 * ORC_RESTRICT d3,
    guint8 * ORC_RESTRICT d4, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, int n)
{
  int i;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  orc_int8 *ORC_RESTRICT ptr3;
  const orc_union32 *ORC_RESTRICT ptr4;
  const orc_union32 *ORC_RESTRICT ptr5;
  orc_union32 var35;
  orc_union32 var36;
  orc_int8 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  ptr0 = (orc_union16 *) d1;
  ptr1 = (orc_union16 *) d2;
  ptr2 = (orc_int8 *) d3;
  ptr3 = (orc_int8 *) d4;
  ptr4 = (orc_union32 *) s1;
  ptr5 = (orc_union32 *) s2;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var35 = ptr4[i];
    /* 1: splitwb */
    {
      orc_union16 _src;
      _src.i = var35.x2[0];
      var39.x2[0] = _src.x2[1];
      var40.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var35.x2[1];
      var39.x2[1] = _src.x2[1];
      var40.x2[1] = _src.x2[0];
    }
    /* 2: storew */
    ptr0[i] = var40;
    /* 3: loadl */
    var36 = ptr5[i];
    /* 4: splitwb */
    {
      orc_union16 _src;
      _src.i = var36.x2[0];
      var41.x2[0] = _src.x2[1];
      var42.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var36.x2[1];
      var41.x2[1] = _src.x2[1];
      var42.x2[1] = _src.x2[0];
    }
    /* 5: storew */
    ptr1[i] = var42;
    /* 6: avgub */
    var43.x2[0] = ((orc_uint8) var39.x2[0] + (orc_uint8) var41.x2[0] + 1) >> 1;
    var43.x2[1] = ((orc_uint8) var39.x2[1] + (orc_uint8) var41.x2[1] + 1) >> 1;
    /* 7: splitwb */
    {
      orc_union16 _src;
      _src.i = var43.i;
      var37 = _src.x2[1];
      var38 = _src.x2[0];
    }
    /* 8: storeb */
    ptr3[i] = var37;
    /* 9: storeb */
    ptr2[i] = var38;
  }

}

#else
static void
_backup_video_convert_orc_convert_YUY2_I420 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  orc_int8 *ORC_RESTRICT ptr3;
  const orc_union32 *ORC_RESTRICT ptr4;
  const orc_union32 *ORC_RESTRICT ptr5;
  orc_union32 var35;
  orc_union32 var36;
  orc_int8 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  ptr0 = (orc_union16 *) ex->arrays[0];
  ptr1 = (orc_union16 *) ex->arrays[1];
  ptr2 = (orc_int8 *) ex->arrays[2];
  ptr3 = (orc_int8 *) ex->arrays[3];
  ptr4 = (orc_union32 *) ex->arrays[4];
  ptr5 = (orc_union32 *) ex->arrays[5];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var35 = ptr4[i];
    /* 1: splitwb */
    {
      orc_union16 _src;
      _src.i = var35.x2[0];
      var39.x2[0] = _src.x2[1];
      var40.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var35.x2[1];
      var39.x2[1] = _src.x2[1];
      var40.x2[1] = _src.x2[0];
    }
    /* 2: storew */
    ptr0[i] = var40;
    /* 3: loadl */
    var36 = ptr5[i];
    /* 4: splitwb */
    {
      orc_union16 _src;
      _src.i = var36.x2[0];
      var41.x2[0] = _src.x2[1];
      var42.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var36.x2[1];
      var41.x2[1] = _src.x2[1];
      var42.x2[1] = _src.x2[0];
    }
    /* 5: storew */
    ptr1[i] = var42;
    /* 6: avgub */
    var43.x2[0] = ((orc_uint8) var39.x2[0] + (orc_uint8) var41.x2[0] + 1) >> 1;
    var43.x2[1] = ((orc_uint8) var39.x2[1] + (orc_uint8) var41.x2[1] + 1) >> 1;
    /* 7: splitwb */
    {
      orc_union16 _src;
      _src.i = var43.i;
      var37 = _src.x2[1];
      var38 = _src.x2[0];
    }
    /* 8: storeb */
    ptr3[i] = var37;
    /* 9: storeb */
    ptr2[i] = var38;
  }

}

void
video_convert_orc_convert_YUY2_I420 (guint8 * ORC_RESTRICT d1,
    guint8 * ORC_RESTRICT d2, guint8 * ORC_RESTRICT d3,
    guint8 * ORC_RESTRICT d4, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 35, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114, 116,
        95, 111, 114, 99, 95, 99, 111, 110, 118, 101, 114, 116, 95, 89, 85, 89,
        50, 95, 73, 52, 50, 48, 11, 2, 2, 11, 2, 2, 11, 1, 1, 11,
        1, 1, 12, 4, 4, 12, 4, 4, 20, 2, 20, 2, 20, 2, 21, 1,
        199, 32, 34, 4, 97, 0, 34, 21, 1, 199, 33, 34, 5, 97, 1, 34,
        21, 1, 39, 32, 32, 33, 199, 3, 2, 32, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_YUY2_I420);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_convert_orc_convert_YUY2_I420");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_YUY2_I420);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_destination (p, 1, "d4");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_source (p, 4, "s2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "storew", 0, ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_S2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "storew", 0, ORC_VAR_D2, ORC_VAR_T3, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_D4, ORC_VAR_D3, ORC_VAR_T1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->arrays[ORC_VAR_D4] = d4;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_convert_UYVY_YUY2 */
#ifdef DISABLE_ORC
void
video_convert_orc_convert_UYVY_YUY2 (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var32 = ptr4[i];
      /* 1: swapw */
      var33.x2[0] = ORC_SWAP_W (var32.x2[0]);
      var33.x2[1] = ORC_SWAP_W (var32.x2[1]);
      /* 2: storel */
      ptr0[i] = var33;
    }
  }

}

#else
static void
_backup_video_convert_orc_convert_UYVY_YUY2 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var32 = ptr4[i];
      /* 1: swapw */
      var33.x2[0] = ORC_SWAP_W (var32.x2[0]);
      var33.x2[1] = ORC_SWAP_W (var32.x2[1]);
      /* 2: storel */
      ptr0[i] = var33;
    }
  }

}

void
video_convert_orc_convert_UYVY_YUY2 (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 35, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114,
        116, 95, 111, 114, 99, 95, 99, 111, 110, 118, 101, 114, 116, 95, 85, 89,
        86, 89, 95, 89, 85, 89, 50, 11, 4, 4, 12, 4, 4, 21, 1, 183,
        0, 4, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_UYVY_YUY2);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_convert_orc_convert_UYVY_YUY2");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_UYVY_YUY2);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");

      orc_program_append_2 (p, "swapw", 1, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_planar_chroma_420_422 */
#ifdef DISABLE_ORC
void
video_convert_orc_planar_chroma_420_422 (guint8 * ORC_RESTRICT d1,
    int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_int8 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  const orc_int8 *ORC_RESTRICT ptr4;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;
  orc_int8 var35;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr1 = ORC_PTR_OFFSET (d2, d2_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: copyb */
      var33 = var32;
      /* 2: storeb */
      ptr0[i] = var33;
      /* 3: loadb */
      var34 = ptr4[i];
      /* 4: copyb */
      var35 = var34;
      /* 5: storeb */
      ptr1[i] = var35;
    }
  }

}

#else
static void
_backup_video_convert_orc_planar_chroma_420_422 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  const orc_int8 *ORC_RESTRICT ptr4;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;
  orc_int8 var35;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr1 = ORC_PTR_OFFSET (ex->arrays[1], ex->params[1] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: copyb */
      var33 = var32;
      /* 2: storeb */
      ptr0[i] = var33;
      /* 3: loadb */
      var34 = ptr4[i];
      /* 4: copyb */
      var35 = var34;
      /* 5: storeb */
      ptr1[i] = var35;
    }
  }

}

void
video_convert_orc_planar_chroma_420_422 (guint8 * ORC_RESTRICT d1,
    int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 39, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114,
        116, 95, 111, 114, 99, 95, 112, 108, 97, 110, 97, 114, 95, 99, 104, 114,
        111, 109, 97, 95, 52, 50, 48, 95, 52, 50, 50, 11, 1, 1, 11, 1,
        1, 12, 1, 1, 42, 0, 4, 42, 1, 4, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_planar_chroma_420_422);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_convert_orc_planar_chroma_420_422");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_planar_chroma_420_422);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_destination (p, 1, "d2");
      orc_program_add_source (p, 1, "s1");

      orc_program_append_2 (p, "copyb", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "copyb", 0, ORC_VAR_D2, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_D2] = d2_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_planar_chroma_420_444 */
#ifdef DISABLE_ORC
void
video_convert_orc_planar_chroma_420_444 (guint8 * ORC_RESTRICT d1,
    int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  const orc_int8 *ORC_RESTRICT ptr4;
  orc_int8 var33;
  orc_union16 var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr1 = ORC_PTR_OFFSET (d2, d2_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var33 = ptr4[i];
      /* 1: splatbw */
      var34.i = ((var33 & 0xff) << 8) | (var33 & 0xff);
      /* 2: storew */
      ptr0[i] = var34;
      /* 3: storew */
      ptr1[i] = var34;
    }
  }

}

#else
static void
_backup_video_convert_orc_planar_chroma_420_444 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  const orc_int8 *ORC_RESTRICT ptr4;
  orc_int8 var33;
  orc_union16 var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr1 = ORC_PTR_OFFSET (ex->arrays[1], ex->params[1] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var33 = ptr4[i];
      /* 1: splatbw */
      var34.i = ((var33 & 0xff) << 8) | (var33 & 0xff);
      /* 2: storew */
      ptr0[i] = var34;
      /* 3: storew */
      ptr1[i] = var34;
    }
  }

}

void
video_convert_orc_planar_chroma_420_444 (guint8 * ORC_RESTRICT d1,
    int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 39, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114,
        116, 95, 111, 114, 99, 95, 112, 108, 97, 110, 97, 114, 95, 99, 104, 114,
        111, 109, 97, 95, 52, 50, 48, 95, 52, 52, 52, 11, 2, 2, 11, 2,
        2, 12, 1, 1, 20, 2, 151, 32, 4, 97, 0, 32, 97, 1, 32, 2,
        0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_planar_chroma_420_444);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_convert_orc_planar_chroma_420_444");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_planar_chroma_420_444);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "storew", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "storew", 0, ORC_VAR_D2, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_D2] = d2_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_planar_chroma_422_444 */
#ifdef DISABLE_ORC
void
video_convert_orc_planar_chroma_422_444 (guint8 * ORC_RESTRICT d1,
    int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_union16 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  orc_int8 var33;
  orc_union16 var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var33 = ptr4[i];
      /* 1: splatbw */
      var34.i = ((var33 & 0xff) << 8) | (var33 & 0xff);
      /* 2: storew */
      ptr0[i] = var34;
    }
  }

}

#else
static void
_backup_video_convert_orc_planar_chroma_422_444 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  orc_int8 var33;
  orc_union16 var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var33 = ptr4[i];
      /* 1: splatbw */
      var34.i = ((var33 & 0xff) << 8) | (var33 & 0xff);
      /* 2: storew */
      ptr0[i] = var34;
    }
  }

}

void
video_convert_orc_planar_chroma_422_444 (guint8 * ORC_RESTRICT d1,
    int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 39, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114,
        116, 95, 111, 114, 99, 95, 112, 108, 97, 110, 97, 114, 95, 99, 104, 114,
        111, 109, 97, 95, 52, 50, 50, 95, 52, 52, 52, 11, 2, 2, 12, 1,
        1, 20, 2, 151, 32, 4, 97, 0, 32, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_planar_chroma_422_444);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_convert_orc_planar_chroma_422_444");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_planar_chroma_422_444);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "storew", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_planar_chroma_444_422 */
#ifdef DISABLE_ORC
void
video_convert_orc_planar_chroma_444_422 (guint8 * ORC_RESTRICT d1,
    int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var34 = ptr4[i];
      /* 1: splitwb */
      {
        orc_union16 _src;
        _src.i = var34.i;
        var36 = _src.x2[1];
        var37 = _src.x2[0];
      }
      /* 2: avgub */
      var35 = ((orc_uint8) var36 + (orc_uint8) var37 + 1) >> 1;
      /* 3: storeb */
      ptr0[i] = var35;
    }
  }

}

#else
static void
_backup_video_convert_orc_planar_chroma_444_422 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var34 = ptr4[i];
      /* 1: splitwb */
      {
        orc_union16 _src;
        _src.i = var34.i;
        var36 = _src.x2[1];
        var37 = _src.x2[0];
      }
      /* 2: avgub */
      var35 = ((orc_uint8) var36 + (orc_uint8) var37 + 1) >> 1;
      /* 3: storeb */
      ptr0[i] = var35;
    }
  }

}

void
video_convert_orc_planar_chroma_444_422 (guint8 * ORC_RESTRICT d1,
    int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 39, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114,
        116, 95, 111, 114, 99, 95, 112, 108, 97, 110, 97, 114, 95, 99, 104, 114,
        111, 109, 97, 95, 52, 52, 52, 95, 52, 50, 50, 11, 1, 1, 12, 2,
        2, 20, 1, 20, 1, 199, 32, 33, 4, 39, 0, 32, 33, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_planar_chroma_444_422);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_convert_orc_planar_chroma_444_422");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_planar_chroma_444_422);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_temporary (p, 1, "t1");
      orc_program_add_temporary (p, 1, "t2");

      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_planar_chroma_444_420 */
#ifdef DISABLE_ORC
void
video_convert_orc_planar_chroma_444_420 (guint8 * ORC_RESTRICT d1,
    int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride, int n, int m)
{
  int i;
  int j;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  orc_union16 var35;
  orc_union16 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_int8 var39;
  orc_int8 var40;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET (s2, s2_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var35 = ptr4[i];
      /* 1: loadw */
      var36 = ptr5[i];
      /* 2: avgub */
      var38.x2[0] =
          ((orc_uint8) var35.x2[0] + (orc_uint8) var36.x2[0] + 1) >> 1;
      var38.x2[1] =
          ((orc_uint8) var35.x2[1] + (orc_uint8) var36.x2[1] + 1) >> 1;
      /* 3: splitwb */
      {
        orc_union16 _src;
        _src.i = var38.i;
        var39 = _src.x2[1];
        var40 = _src.x2[0];
      }
      /* 4: avgub */
      var37 = ((orc_uint8) var39 + (orc_uint8) var40 + 1) >> 1;
      /* 5: storeb */
      ptr0[i] = var37;
    }
  }

}

#else
static void
_backup_video_convert_orc_planar_chroma_444_420 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  orc_union16 var35;
  orc_union16 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_int8 var39;
  orc_int8 var40;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET (ex->arrays[5], ex->params[5] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var35 = ptr4[i];
      /* 1: loadw */
      var36 = ptr5[i];
      /* 2: avgub */
      var38.x2[0] =
          ((orc_uint8) var35.x2[0] + (orc_uint8) var36.x2[0] + 1) >> 1;
      var38.x2[1] =
          ((orc_uint8) var35.x2[1] + (orc_uint8) var36.x2[1] + 1) >> 1;
      /* 3: splitwb */
      {
        orc_union16 _src;
        _src.i = var38.i;
        var39 = _src.x2[1];
        var40 = _src.x2[0];
      }
      /* 4: avgub */
      var37 = ((orc_uint8) var39 + (orc_uint8) var40 + 1) >> 1;
      /* 5: storeb */
      ptr0[i] = var37;
    }
  }

}

void
video_convert_orc_planar_chroma_444_420 (guint8 * ORC_RESTRICT d1,
    int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 39, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114,
        116, 95, 111, 114, 99, 95, 112, 108, 97, 110, 97, 114, 95, 99, 104, 114,
        111, 109, 97, 95, 52, 52, 52, 95, 52, 50, 48, 11, 1, 1, 12, 2,
        2, 12, 2, 2, 20, 2, 20, 1, 20, 1, 21, 1, 39, 32, 4, 5,
        199, 33, 34, 32, 39, 0, 33, 34, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_planar_chroma_444_420);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_convert_orc_planar_chroma_444_420");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_planar_chroma_444_420);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 1, "t2");
      orc_program_add_temporary (p, 1, "t3");

      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_S2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T3,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_planar_chroma_422_420 */
#ifdef DISABLE_ORC
void
video_convert_orc_planar_chroma_422_420 (guint8 * ORC_RESTRICT d1,
    int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride, int n, int m)
{
  int i;
  int j;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET (s2, s2_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: loadb */
      var33 = ptr5[i];
      /* 2: avgub */
      var34 = ((orc_uint8) var32 + (orc_uint8) var33 + 1) >> 1;
      /* 3: storeb */
      ptr0[i] = var34;
    }
  }

}

#else
static void
_backup_video_convert_orc_planar_chroma_422_420 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET (ex->arrays[5], ex->params[5] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: loadb */
      var33 = ptr5[i];
      /* 2: avgub */
      var34 = ((orc_uint8) var32 + (orc_uint8) var33 + 1) >> 1;
      /* 3: storeb */
      ptr0[i] = var34;
    }
  }

}

void
video_convert_orc_planar_chroma_422_420 (guint8 * ORC_RESTRICT d1,
    int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 39, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114,
        116, 95, 111, 114, 99, 95, 112, 108, 97, 110, 97, 114, 95, 99, 104, 114,
        111, 109, 97, 95, 52, 50, 50, 95, 52, 50, 48, 11, 1, 1, 12, 1,
        1, 12, 1, 1, 39, 0, 4, 5, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_planar_chroma_422_420);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_convert_orc_planar_chroma_422_420");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_planar_chroma_422_420);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");

      orc_program_append_2 (p, "avgub", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_convert_YUY2_AYUV */
#ifdef DISABLE_ORC
void
video_convert_orc_convert_YUY2_AYUV (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union64 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);

    /* 2: loadpb */
    var37.x2[0] = (int) 0x000000ff;     /* 255 or 1.25987e-321f */
    var37.x2[1] = (int) 0x000000ff;     /* 255 or 1.25987e-321f */

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var36 = ptr4[i];
      /* 1: splitwb */
      {
        orc_union16 _src;
        _src.i = var36.x2[0];
        var39.x2[0] = _src.x2[1];
        var40.x2[0] = _src.x2[0];
      }
      {
        orc_union16 _src;
        _src.i = var36.x2[1];
        var39.x2[1] = _src.x2[1];
        var40.x2[1] = _src.x2[0];
      }
      /* 3: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var37.x2[0];
        _dest.x2[1] = var40.x2[0];
        var41.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var37.x2[1];
        _dest.x2[1] = var40.x2[1];
        var41.x2[1] = _dest.i;
      }
      /* 4: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var39.i;
        _dest.x2[1] = var39.i;
        var42.i = _dest.i;
      }
      /* 5: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var41.x2[0];
        _dest.x2[1] = var42.x2[0];
        var38.x2[0] = _dest.i;
      }
      {
        orc_union32 _dest;
        _dest.x2[0] = var41.x2[1];
        _dest.x2[1] = var42.x2[1];
        var38.x2[1] = _dest.i;
      }
      /* 6: storeq */
      ptr0[i] = var38;
    }
  }

}

#else
static void
_backup_video_convert_orc_convert_YUY2_AYUV (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union64 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);

    /* 2: loadpb */
    var37.x2[0] = (int) 0x000000ff;     /* 255 or 1.25987e-321f */
    var37.x2[1] = (int) 0x000000ff;     /* 255 or 1.25987e-321f */

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var36 = ptr4[i];
      /* 1: splitwb */
      {
        orc_union16 _src;
        _src.i = var36.x2[0];
        var39.x2[0] = _src.x2[1];
        var40.x2[0] = _src.x2[0];
      }
      {
        orc_union16 _src;
        _src.i = var36.x2[1];
        var39.x2[1] = _src.x2[1];
        var40.x2[1] = _src.x2[0];
      }
      /* 3: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var37.x2[0];
        _dest.x2[1] = var40.x2[0];
        var41.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var37.x2[1];
        _dest.x2[1] = var40.x2[1];
        var41.x2[1] = _dest.i;
      }
      /* 4: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var39.i;
        _dest.x2[1] = var39.i;
        var42.i = _dest.i;
      }
      /* 5: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var41.x2[0];
        _dest.x2[1] = var42.x2[0];
        var38.x2[0] = _dest.i;
      }
      {
        orc_union32 _dest;
        _dest.x2[0] = var41.x2[1];
        _dest.x2[1] = var42.x2[1];
        var38.x2[1] = _dest.i;
      }
      /* 6: storeq */
      ptr0[i] = var38;
    }
  }

}

void
video_convert_orc_convert_YUY2_AYUV (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 35, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114,
        116, 95, 111, 114, 99, 95, 99, 111, 110, 118, 101, 114, 116, 95, 89, 85,
        89, 50, 95, 65, 89, 85, 86, 11, 8, 8, 12, 4, 4, 14, 2, 255,
        0, 0, 0, 20, 2, 20, 2, 20, 4, 20, 4, 21, 1, 199, 33, 32,
        4, 21, 1, 196, 34, 16, 32, 195, 35, 33, 33, 21, 1, 195, 0, 34,
        35, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_YUY2_AYUV);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_convert_orc_convert_YUY2_AYUV");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_YUY2_AYUV);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 2, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T3, ORC_VAR_C1, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_convert_UYVY_AYUV */
#ifdef DISABLE_ORC
void
video_convert_orc_convert_UYVY_AYUV (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union64 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);

    /* 2: loadpb */
    var37.x2[0] = (int) 0x000000ff;     /* 255 or 1.25987e-321f */
    var37.x2[1] = (int) 0x000000ff;     /* 255 or 1.25987e-321f */

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var36 = ptr4[i];
      /* 1: splitwb */
      {
        orc_union16 _src;
        _src.i = var36.x2[0];
        var39.x2[0] = _src.x2[1];
        var40.x2[0] = _src.x2[0];
      }
      {
        orc_union16 _src;
        _src.i = var36.x2[1];
        var39.x2[1] = _src.x2[1];
        var40.x2[1] = _src.x2[0];
      }
      /* 3: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var37.x2[0];
        _dest.x2[1] = var39.x2[0];
        var41.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var37.x2[1];
        _dest.x2[1] = var39.x2[1];
        var41.x2[1] = _dest.i;
      }
      /* 4: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var40.i;
        _dest.x2[1] = var40.i;
        var42.i = _dest.i;
      }
      /* 5: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var41.x2[0];
        _dest.x2[1] = var42.x2[0];
        var38.x2[0] = _dest.i;
      }
      {
        orc_union32 _dest;
        _dest.x2[0] = var41.x2[1];
        _dest.x2[1] = var42.x2[1];
        var38.x2[1] = _dest.i;
      }
      /* 6: storeq */
      ptr0[i] = var38;
    }
  }

}

#else
static void
_backup_video_convert_orc_convert_UYVY_AYUV (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union64 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);

    /* 2: loadpb */
    var37.x2[0] = (int) 0x000000ff;     /* 255 or 1.25987e-321f */
    var37.x2[1] = (int) 0x000000ff;     /* 255 or 1.25987e-321f */

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var36 = ptr4[i];
      /* 1: splitwb */
      {
        orc_union16 _src;
        _src.i = var36.x2[0];
        var39.x2[0] = _src.x2[1];
        var40.x2[0] = _src.x2[0];
      }
      {
        orc_union16 _src;
        _src.i = var36.x2[1];
        var39.x2[1] = _src.x2[1];
        var40.x2[1] = _src.x2[0];
      }
      /* 3: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var37.x2[0];
        _dest.x2[1] = var39.x2[0];
        var41.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var37.x2[1];
        _dest.x2[1] = var39.x2[1];
        var41.x2[1] = _dest.i;
      }
      /* 4: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var40.i;
        _dest.x2[1] = var40.i;
        var42.i = _dest.i;
      }
      /* 5: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var41.x2[0];
        _dest.x2[1] = var42.x2[0];
        var38.x2[0] = _dest.i;
      }
      {
        orc_union32 _dest;
        _dest.x2[0] = var41.x2[1];
        _dest.x2[1] = var42.x2[1];
        var38.x2[1] = _dest.i;
      }
      /* 6: storeq */
      ptr0[i] = var38;
    }
  }

}

void
video_convert_orc_convert_UYVY_AYUV (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 35, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114,
        116, 95, 111, 114, 99, 95, 99, 111, 110, 118, 101, 114, 116, 95, 85, 89,
        86, 89, 95, 65, 89, 85, 86, 11, 8, 8, 12, 4, 4, 14, 2, 255,
        0, 0, 0, 20, 2, 20, 2, 20, 4, 20, 4, 21, 1, 199, 32, 33,
        4, 21, 1, 196, 34, 16, 32, 195, 35, 33, 33, 21, 1, 195, 0, 34,
        35, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_UYVY_AYUV);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_convert_orc_convert_UYVY_AYUV");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_UYVY_AYUV);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 2, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T3, ORC_VAR_C1, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_convert_YUY2_Y42B */
#ifdef DISABLE_ORC
void
video_convert_orc_convert_YUY2_Y42B (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union16 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_union16 var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr1 = ORC_PTR_OFFSET (d2, d2_stride * j);
    ptr2 = ORC_PTR_OFFSET (d3, d3_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var33 = ptr4[i];
      /* 1: splitwb */
      {
        orc_union16 _src;
        _src.i = var33.x2[0];
        var37.x2[0] = _src.x2[1];
        var34.x2[0] = _src.x2[0];
      }
      {
        orc_union16 _src;
        _src.i = var33.x2[1];
        var37.x2[1] = _src.x2[1];
        var34.x2[1] = _src.x2[0];
      }
      /* 2: storew */
      ptr0[i] = var34;
      /* 3: splitwb */
      {
        orc_union16 _src;
        _src.i = var37.i;
        var35 = _src.x2[1];
        var36 = _src.x2[0];
      }
      /* 4: storeb */
      ptr2[i] = var35;
      /* 5: storeb */
      ptr1[i] = var36;
    }
  }

}

#else
static void
_backup_video_convert_orc_convert_YUY2_Y42B (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union16 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_union16 var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr1 = ORC_PTR_OFFSET (ex->arrays[1], ex->params[1] * j);
    ptr2 = ORC_PTR_OFFSET (ex->arrays[2], ex->params[2] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var33 = ptr4[i];
      /* 1: splitwb */
      {
        orc_union16 _src;
        _src.i = var33.x2[0];
        var37.x2[0] = _src.x2[1];
        var34.x2[0] = _src.x2[0];
      }
      {
        orc_union16 _src;
        _src.i = var33.x2[1];
        var37.x2[1] = _src.x2[1];
        var34.x2[1] = _src.x2[0];
      }
      /* 2: storew */
      ptr0[i] = var34;
      /* 3: splitwb */
      {
        orc_union16 _src;
        _src.i = var37.i;
        var35 = _src.x2[1];
        var36 = _src.x2[0];
      }
      /* 4: storeb */
      ptr2[i] = var35;
      /* 5: storeb */
      ptr1[i] = var36;
    }
  }

}

void
video_convert_orc_convert_YUY2_Y42B (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 35, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114,
        116, 95, 111, 114, 99, 95, 99, 111, 110, 118, 101, 114, 116, 95, 89, 85,
        89, 50, 95, 89, 52, 50, 66, 11, 2, 2, 11, 1, 1, 11, 1, 1,
        12, 4, 4, 20, 2, 21, 1, 199, 32, 0, 4, 199, 2, 1, 32, 2,
        0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_YUY2_Y42B);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_convert_orc_convert_YUY2_Y42B");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_YUY2_Y42B);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 1, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_D3, ORC_VAR_D2, ORC_VAR_T1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_D2] = d2_stride;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->params[ORC_VAR_D3] = d3_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_convert_UYVY_Y42B */
#ifdef DISABLE_ORC
void
video_convert_orc_convert_UYVY_Y42B (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union16 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_union16 var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr1 = ORC_PTR_OFFSET (d2, d2_stride * j);
    ptr2 = ORC_PTR_OFFSET (d3, d3_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var33 = ptr4[i];
      /* 1: splitwb */
      {
        orc_union16 _src;
        _src.i = var33.x2[0];
        var34.x2[0] = _src.x2[1];
        var37.x2[0] = _src.x2[0];
      }
      {
        orc_union16 _src;
        _src.i = var33.x2[1];
        var34.x2[1] = _src.x2[1];
        var37.x2[1] = _src.x2[0];
      }
      /* 2: storew */
      ptr0[i] = var34;
      /* 3: splitwb */
      {
        orc_union16 _src;
        _src.i = var37.i;
        var35 = _src.x2[1];
        var36 = _src.x2[0];
      }
      /* 4: storeb */
      ptr2[i] = var35;
      /* 5: storeb */
      ptr1[i] = var36;
    }
  }

}

#else
static void
_backup_video_convert_orc_convert_UYVY_Y42B (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union16 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_union16 var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr1 = ORC_PTR_OFFSET (ex->arrays[1], ex->params[1] * j);
    ptr2 = ORC_PTR_OFFSET (ex->arrays[2], ex->params[2] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var33 = ptr4[i];
      /* 1: splitwb */
      {
        orc_union16 _src;
        _src.i = var33.x2[0];
        var34.x2[0] = _src.x2[1];
        var37.x2[0] = _src.x2[0];
      }
      {
        orc_union16 _src;
        _src.i = var33.x2[1];
        var34.x2[1] = _src.x2[1];
        var37.x2[1] = _src.x2[0];
      }
      /* 2: storew */
      ptr0[i] = var34;
      /* 3: splitwb */
      {
        orc_union16 _src;
        _src.i = var37.i;
        var35 = _src.x2[1];
        var36 = _src.x2[0];
      }
      /* 4: storeb */
      ptr2[i] = var35;
      /* 5: storeb */
      ptr1[i] = var36;
    }
  }

}

void
video_convert_orc_convert_UYVY_Y42B (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 35, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114,
        116, 95, 111, 114, 99, 95, 99, 111, 110, 118, 101, 114, 116, 95, 85, 89,
        86, 89, 95, 89, 52, 50, 66, 11, 2, 2, 11, 1, 1, 11, 1, 1,
        12, 4, 4, 20, 2, 21, 1, 199, 0, 32, 4, 199, 2, 1, 32, 2,
        0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_UYVY_Y42B);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_convert_orc_convert_UYVY_Y42B");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_UYVY_Y42B);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 1, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_D3, ORC_VAR_D2, ORC_VAR_T1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_D2] = d2_stride;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->params[ORC_VAR_D3] = d3_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_convert_YUY2_Y444 */
#ifdef DISABLE_ORC
void
video_convert_orc_convert_YUY2_Y444 (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  orc_union16 *ORC_RESTRICT ptr2;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_int8 var41;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr1 = ORC_PTR_OFFSET (d2, d2_stride * j);
    ptr2 = ORC_PTR_OFFSET (d3, d3_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var35 = ptr4[i];
      /* 1: splitwb */
      {
        orc_union16 _src;
        _src.i = var35.x2[0];
        var39.x2[0] = _src.x2[1];
        var36.x2[0] = _src.x2[0];
      }
      {
        orc_union16 _src;
        _src.i = var35.x2[1];
        var39.x2[1] = _src.x2[1];
        var36.x2[1] = _src.x2[0];
      }
      /* 2: storew */
      ptr0[i] = var36;
      /* 3: splitwb */
      {
        orc_union16 _src;
        _src.i = var39.i;
        var40 = _src.x2[1];
        var41 = _src.x2[0];
      }
      /* 4: splatbw */
      var37.i = ((var41 & 0xff) << 8) | (var41 & 0xff);
      /* 5: storew */
      ptr1[i] = var37;
      /* 6: splatbw */
      var38.i = ((var40 & 0xff) << 8) | (var40 & 0xff);
      /* 7: storew */
      ptr2[i] = var38;
    }
  }

}

#else
static void
_backup_video_convert_orc_convert_YUY2_Y444 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  orc_union16 *ORC_RESTRICT ptr2;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_int8 var41;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr1 = ORC_PTR_OFFSET (ex->arrays[1], ex->params[1] * j);
    ptr2 = ORC_PTR_OFFSET (ex->arrays[2], ex->params[2] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var35 = ptr4[i];
      /* 1: splitwb */
      {
        orc_union16 _src;
        _src.i = var35.x2[0];
        var39.x2[0] = _src.x2[1];
        var36.x2[0] = _src.x2[0];
      }
      {
        orc_union16 _src;
        _src.i = var35.x2[1];
        var39.x2[1] = _src.x2[1];
        var36.x2[1] = _src.x2[0];
      }
      /* 2: storew */
      ptr0[i] = var36;
      /* 3: splitwb */
      {
        orc_union16 _src;
        _src.i = var39.i;
        var40 = _src.x2[1];
        var41 = _src.x2[0];
      }
      /* 4: splatbw */
      var37.i = ((var41 & 0xff) << 8) | (var41 & 0xff);
      /* 5: storew */
      ptr1[i] = var37;
      /* 6: splatbw */
      var38.i = ((var40 & 0xff) << 8) | (var40 & 0xff);
      /* 7: storew */
      ptr2[i] = var38;
    }
  }

}

void
video_convert_orc_convert_YUY2_Y444 (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 35, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114,
        116, 95, 111, 114, 99, 95, 99, 111, 110, 118, 101, 114, 116, 95, 89, 85,
        89, 50, 95, 89, 52, 52, 52, 11, 2, 2, 11, 2, 2, 11, 2, 2,
        12, 4, 4, 20, 2, 20, 1, 20, 1, 21, 1, 199, 32, 0, 4, 199,
        34, 33, 32, 151, 1, 33, 151, 2, 34, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_YUY2_Y444);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_convert_orc_convert_YUY2_Y444");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_YUY2_Y444);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_destination (p, 2, "d3");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 1, "t2");
      orc_program_add_temporary (p, 1, "t3");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_D3, ORC_VAR_T3, ORC_VAR_D1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_D2] = d2_stride;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->params[ORC_VAR_D3] = d3_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_convert_UYVY_Y444 */
#ifdef DISABLE_ORC
void
video_convert_orc_convert_UYVY_Y444 (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  orc_union16 *ORC_RESTRICT ptr2;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_int8 var41;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr1 = ORC_PTR_OFFSET (d2, d2_stride * j);
    ptr2 = ORC_PTR_OFFSET (d3, d3_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var35 = ptr4[i];
      /* 1: splitwb */
      {
        orc_union16 _src;
        _src.i = var35.x2[0];
        var36.x2[0] = _src.x2[1];
        var39.x2[0] = _src.x2[0];
      }
      {
        orc_union16 _src;
        _src.i = var35.x2[1];
        var36.x2[1] = _src.x2[1];
        var39.x2[1] = _src.x2[0];
      }
      /* 2: storew */
      ptr0[i] = var36;
      /* 3: splitwb */
      {
        orc_union16 _src;
        _src.i = var39.i;
        var40 = _src.x2[1];
        var41 = _src.x2[0];
      }
      /* 4: splatbw */
      var37.i = ((var41 & 0xff) << 8) | (var41 & 0xff);
      /* 5: storew */
      ptr1[i] = var37;
      /* 6: splatbw */
      var38.i = ((var40 & 0xff) << 8) | (var40 & 0xff);
      /* 7: storew */
      ptr2[i] = var38;
    }
  }

}

#else
static void
_backup_video_convert_orc_convert_UYVY_Y444 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  orc_union16 *ORC_RESTRICT ptr2;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_int8 var41;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr1 = ORC_PTR_OFFSET (ex->arrays[1], ex->params[1] * j);
    ptr2 = ORC_PTR_OFFSET (ex->arrays[2], ex->params[2] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var35 = ptr4[i];
      /* 1: splitwb */
      {
        orc_union16 _src;
        _src.i = var35.x2[0];
        var36.x2[0] = _src.x2[1];
        var39.x2[0] = _src.x2[0];
      }
      {
        orc_union16 _src;
        _src.i = var35.x2[1];
        var36.x2[1] = _src.x2[1];
        var39.x2[1] = _src.x2[0];
      }
      /* 2: storew */
      ptr0[i] = var36;
      /* 3: splitwb */
      {
        orc_union16 _src;
        _src.i = var39.i;
        var40 = _src.x2[1];
        var41 = _src.x2[0];
      }
      /* 4: splatbw */
      var37.i = ((var41 & 0xff) << 8) | (var41 & 0xff);
      /* 5: storew */
      ptr1[i] = var37;
      /* 6: splatbw */
      var38.i = ((var40 & 0xff) << 8) | (var40 & 0xff);
      /* 7: storew */
      ptr2[i] = var38;
    }
  }

}

void
video_convert_orc_convert_UYVY_Y444 (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 35, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114,
        116, 95, 111, 114, 99, 95, 99, 111, 110, 118, 101, 114, 116, 95, 85, 89,
        86, 89, 95, 89, 52, 52, 52, 11, 2, 2, 11, 2, 2, 11, 2, 2,
        12, 4, 4, 20, 2, 20, 1, 20, 1, 21, 1, 199, 0, 32, 4, 199,
        34, 33, 32, 151, 1, 33, 151, 2, 34, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_UYVY_Y444);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_convert_orc_convert_UYVY_Y444");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_UYVY_Y444);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_destination (p, 2, "d3");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 1, "t2");
      orc_program_add_temporary (p, 1, "t3");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_D3, ORC_VAR_T3, ORC_VAR_D1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_D2] = d2_stride;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->params[ORC_VAR_D3] = d3_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_convert_UYVY_I420 */
#ifdef DISABLE_ORC
void
video_convert_orc_convert_UYVY_I420 (guint8 * ORC_RESTRICT d1,
    guint8 * ORC_RESTRICT d2, guint8 * ORC_RESTRICT d3,
    guint8 * ORC_RESTRICT d4, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, int n)
{
  int i;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  orc_int8 *ORC_RESTRICT ptr3;
  const orc_union32 *ORC_RESTRICT ptr4;
  const orc_union32 *ORC_RESTRICT ptr5;
  orc_union32 var35;
  orc_union32 var36;
  orc_int8 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  ptr0 = (orc_union16 *) d1;
  ptr1 = (orc_union16 *) d2;
  ptr2 = (orc_int8 *) d3;
  ptr3 = (orc_int8 *) d4;
  ptr4 = (orc_union32 *) s1;
  ptr5 = (orc_union32 *) s2;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var35 = ptr4[i];
    /* 1: splitwb */
    {
      orc_union16 _src;
      _src.i = var35.x2[0];
      var39.x2[0] = _src.x2[1];
      var40.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var35.x2[1];
      var39.x2[1] = _src.x2[1];
      var40.x2[1] = _src.x2[0];
    }
    /* 2: storew */
    ptr0[i] = var39;
    /* 3: loadl */
    var36 = ptr5[i];
    /* 4: splitwb */
    {
      orc_union16 _src;
      _src.i = var36.x2[0];
      var41.x2[0] = _src.x2[1];
      var42.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var36.x2[1];
      var41.x2[1] = _src.x2[1];
      var42.x2[1] = _src.x2[0];
    }
    /* 5: storew */
    ptr1[i] = var41;
    /* 6: avgub */
    var43.x2[0] = ((orc_uint8) var40.x2[0] + (orc_uint8) var42.x2[0] + 1) >> 1;
    var43.x2[1] = ((orc_uint8) var40.x2[1] + (orc_uint8) var42.x2[1] + 1) >> 1;
    /* 7: splitwb */
    {
      orc_union16 _src;
      _src.i = var43.i;
      var37 = _src.x2[1];
      var38 = _src.x2[0];
    }
    /* 8: storeb */
    ptr3[i] = var37;
    /* 9: storeb */
    ptr2[i] = var38;
  }

}

#else
static void
_backup_video_convert_orc_convert_UYVY_I420 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  orc_int8 *ORC_RESTRICT ptr3;
  const orc_union32 *ORC_RESTRICT ptr4;
  const orc_union32 *ORC_RESTRICT ptr5;
  orc_union32 var35;
  orc_union32 var36;
  orc_int8 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  ptr0 = (orc_union16 *) ex->arrays[0];
  ptr1 = (orc_union16 *) ex->arrays[1];
  ptr2 = (orc_int8 *) ex->arrays[2];
  ptr3 = (orc_int8 *) ex->arrays[3];
  ptr4 = (orc_union32 *) ex->arrays[4];
  ptr5 = (orc_union32 *) ex->arrays[5];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var35 = ptr4[i];
    /* 1: splitwb */
    {
      orc_union16 _src;
      _src.i = var35.x2[0];
      var39.x2[0] = _src.x2[1];
      var40.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var35.x2[1];
      var39.x2[1] = _src.x2[1];
      var40.x2[1] = _src.x2[0];
    }
    /* 2: storew */
    ptr0[i] = var39;
    /* 3: loadl */
    var36 = ptr5[i];
    /* 4: splitwb */
    {
      orc_union16 _src;
      _src.i = var36.x2[0];
      var41.x2[0] = _src.x2[1];
      var42.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var36.x2[1];
      var41.x2[1] = _src.x2[1];
      var42.x2[1] = _src.x2[0];
    }
    /* 5: storew */
    ptr1[i] = var41;
    /* 6: avgub */
    var43.x2[0] = ((orc_uint8) var40.x2[0] + (orc_uint8) var42.x2[0] + 1) >> 1;
    var43.x2[1] = ((orc_uint8) var40.x2[1] + (orc_uint8) var42.x2[1] + 1) >> 1;
    /* 7: splitwb */
    {
      orc_union16 _src;
      _src.i = var43.i;
      var37 = _src.x2[1];
      var38 = _src.x2[0];
    }
    /* 8: storeb */
    ptr3[i] = var37;
    /* 9: storeb */
    ptr2[i] = var38;
  }

}

void
video_convert_orc_convert_UYVY_I420 (guint8 * ORC_RESTRICT d1,
    guint8 * ORC_RESTRICT d2, guint8 * ORC_RESTRICT d3,
    guint8 * ORC_RESTRICT d4, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 35, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114, 116,
        95, 111, 114, 99, 95, 99, 111, 110, 118, 101, 114, 116, 95, 85, 89, 86,
        89, 95, 73, 52, 50, 48, 11, 2, 2, 11, 2, 2, 11, 1, 1, 11,
        1, 1, 12, 4, 4, 12, 4, 4, 20, 2, 20, 2, 20, 2, 21, 1,
        199, 34, 32, 4, 97, 0, 34, 21, 1, 199, 34, 33, 5, 97, 1, 34,
        21, 1, 39, 32, 32, 33, 199, 3, 2, 32, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_UYVY_I420);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_convert_orc_convert_UYVY_I420");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_UYVY_I420);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_destination (p, 1, "d4");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_source (p, 4, "s2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "storew", 0, ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_S2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "storew", 0, ORC_VAR_D2, ORC_VAR_T3, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_D4, ORC_VAR_D3, ORC_VAR_T1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->arrays[ORC_VAR_D4] = d4;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_convert_AYUV_I420 */
#ifdef DISABLE_ORC
void
video_convert_orc_convert_AYUV_I420 (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, guint8 * ORC_RESTRICT d4, int d4_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride, int n, int m)
{
  int i;
  int j;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  orc_int8 *ORC_RESTRICT ptr3;
  const orc_union64 *ORC_RESTRICT ptr4;
  const orc_union64 *ORC_RESTRICT ptr5;
  orc_union64 var40;
  orc_union16 var41;
  orc_union64 var42;
  orc_union16 var43;
  orc_int8 var44;
  orc_int8 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;
  orc_union32 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_int8 var53;
  orc_int8 var54;
  orc_int8 var55;
  orc_int8 var56;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr1 = ORC_PTR_OFFSET (d2, d2_stride * j);
    ptr2 = ORC_PTR_OFFSET (d3, d3_stride * j);
    ptr3 = ORC_PTR_OFFSET (d4, d4_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET (s2, s2_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadq */
      var40 = ptr4[i];
      /* 1: splitlw */
      {
        orc_union32 _src;
        _src.i = var40.x2[0];
        var46.x2[0] = _src.x2[1];
        var47.x2[0] = _src.x2[0];
      }
      {
        orc_union32 _src;
        _src.i = var40.x2[1];
        var46.x2[1] = _src.x2[1];
        var47.x2[1] = _src.x2[0];
      }
      /* 2: select1wb */
      {
        orc_union16 _src;
        _src.i = var47.x2[0];
        var41.x2[0] = _src.x2[1];
      }
      {
        orc_union16 _src;
        _src.i = var47.x2[1];
        var41.x2[1] = _src.x2[1];
      }
      /* 3: storew */
      ptr0[i] = var41;
      /* 4: loadq */
      var42 = ptr5[i];
      /* 5: splitlw */
      {
        orc_union32 _src;
        _src.i = var42.x2[0];
        var48.x2[0] = _src.x2[1];
        var49.x2[0] = _src.x2[0];
      }
      {
        orc_union32 _src;
        _src.i = var42.x2[1];
        var48.x2[1] = _src.x2[1];
        var49.x2[1] = _src.x2[0];
      }
      /* 6: select1wb */
      {
        orc_union16 _src;
        _src.i = var49.x2[0];
        var43.x2[0] = _src.x2[1];
      }
      {
        orc_union16 _src;
        _src.i = var49.x2[1];
        var43.x2[1] = _src.x2[1];
      }
      /* 7: storew */
      ptr1[i] = var43;
      /* 8: avgub */
      var50.x4[0] =
          ((orc_uint8) var46.x4[0] + (orc_uint8) var48.x4[0] + 1) >> 1;
      var50.x4[1] =
          ((orc_uint8) var46.x4[1] + (orc_uint8) var48.x4[1] + 1) >> 1;
      var50.x4[2] =
          ((orc_uint8) var46.x4[2] + (orc_uint8) var48.x4[2] + 1) >> 1;
      var50.x4[3] =
          ((orc_uint8) var46.x4[3] + (orc_uint8) var48.x4[3] + 1) >> 1;
      /* 9: splitwb */
      {
        orc_union16 _src;
        _src.i = var50.x2[0];
        var51.x2[0] = _src.x2[1];
        var52.x2[0] = _src.x2[0];
      }
      {
        orc_union16 _src;
        _src.i = var50.x2[1];
        var51.x2[1] = _src.x2[1];
        var52.x2[1] = _src.x2[0];
      }
      /* 10: splitwb */
      {
        orc_union16 _src;
        _src.i = var52.i;
        var53 = _src.x2[1];
        var54 = _src.x2[0];
      }
      /* 11: avgub */
      var44 = ((orc_uint8) var53 + (orc_uint8) var54 + 1) >> 1;
      /* 12: storeb */
      ptr2[i] = var44;
      /* 13: splitwb */
      {
        orc_union16 _src;
        _src.i = var51.i;
        var55 = _src.x2[1];
        var56 = _src.x2[0];
      }
      /* 14: avgub */
      var45 = ((orc_uint8) var55 + (orc_uint8) var56 + 1) >> 1;
      /* 15: storeb */
      ptr3[i] = var45;
    }
  }

}

#else
static void
_backup_video_convert_orc_convert_AYUV_I420 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  orc_int8 *ORC_RESTRICT ptr3;
  const orc_union64 *ORC_RESTRICT ptr4;
  const orc_union64 *ORC_RESTRICT ptr5;
  orc_union64 var40;
  orc_union16 var41;
  orc_union64 var42;
  orc_union16 var43;
  orc_int8 var44;
  orc_int8 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;
  orc_union32 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_int8 var53;
  orc_int8 var54;
  orc_int8 var55;
  orc_int8 var56;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr1 = ORC_PTR_OFFSET (ex->arrays[1], ex->params[1] * j);
    ptr2 = ORC_PTR_OFFSET (ex->arrays[2], ex->params[2] * j);
    ptr3 = ORC_PTR_OFFSET (ex->arrays[3], ex->params[3] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET (ex->arrays[5], ex->params[5] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadq */
      var40 = ptr4[i];
      /* 1: splitlw */
      {
        orc_union32 _src;
        _src.i = var40.x2[0];
        var46.x2[0] = _src.x2[1];
        var47.x2[0] = _src.x2[0];
      }
      {
        orc_union32 _src;
        _src.i = var40.x2[1];
        var46.x2[1] = _src.x2[1];
        var47.x2[1] = _src.x2[0];
      }
      /* 2: select1wb */
      {
        orc_union16 _src;
        _src.i = var47.x2[0];
        var41.x2[0] = _src.x2[1];
      }
      {
        orc_union16 _src;
        _src.i = var47.x2[1];
        var41.x2[1] = _src.x2[1];
      }
      /* 3: storew */
      ptr0[i] = var41;
      /* 4: loadq */
      var42 = ptr5[i];
      /* 5: splitlw */
      {
        orc_union32 _src;
        _src.i = var42.x2[0];
        var48.x2[0] = _src.x2[1];
        var49.x2[0] = _src.x2[0];
      }
      {
        orc_union32 _src;
        _src.i = var42.x2[1];
        var48.x2[1] = _src.x2[1];
        var49.x2[1] = _src.x2[0];
      }
      /* 6: select1wb */
      {
        orc_union16 _src;
        _src.i = var49.x2[0];
        var43.x2[0] = _src.x2[1];
      }
      {
        orc_union16 _src;
        _src.i = var49.x2[1];
        var43.x2[1] = _src.x2[1];
      }
      /* 7: storew */
      ptr1[i] = var43;
      /* 8: avgub */
      var50.x4[0] =
          ((orc_uint8) var46.x4[0] + (orc_uint8) var48.x4[0] + 1) >> 1;
      var50.x4[1] =
          ((orc_uint8) var46.x4[1] + (orc_uint8) var48.x4[1] + 1) >> 1;
      var50.x4[2] =
          ((orc_uint8) var46.x4[2] + (orc_uint8) var48.x4[2] + 1) >> 1;
      var50.x4[3] =
          ((orc_uint8) var46.x4[3] + (orc_uint8) var48.x4[3] + 1) >> 1;
      /* 9: splitwb */
      {
        orc_union16 _src;
        _src.i = var50.x2[0];
        var51.x2[0] = _src.x2[1];
        var52.x2[0] = _src.x2[0];
      }
      {
        orc_union16 _src;
        _src.i = var50.x2[1];
        var51.x2[1] = _src.x2[1];
        var52.x2[1] = _src.x2[0];
      }
      /* 10: splitwb */
      {
        orc_union16 _src;
        _src.i = var52.i;
        var53 = _src.x2[1];
        var54 = _src.x2[0];
      }
      /* 11: avgub */
      var44 = ((orc_uint8) var53 + (orc_uint8) var54 + 1) >> 1;
      /* 12: storeb */
      ptr2[i] = var44;
      /* 13: splitwb */
      {
        orc_union16 _src;
        _src.i = var51.i;
        var55 = _src.x2[1];
        var56 = _src.x2[0];
      }
      /* 14: avgub */
      var45 = ((orc_uint8) var55 + (orc_uint8) var56 + 1) >> 1;
      /* 15: storeb */
      ptr3[i] = var45;
    }
  }

}

void
video_convert_orc_convert_AYUV_I420 (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, guint8 * ORC_RESTRICT d4, int d4_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 35, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114,
        116, 95, 111, 114, 99, 95, 99, 111, 110, 118, 101, 114, 116, 95, 65, 89,
        85, 86, 95, 73, 52, 50, 48, 11, 2, 2, 11, 2, 2, 11, 1, 1,
        11, 1, 1, 12, 8, 8, 12, 8, 8, 20, 4, 20, 4, 20, 4, 20,
        4, 20, 2, 20, 2, 20, 1, 20, 1, 21, 1, 198, 33, 32, 4, 21,
        1, 189, 0, 32, 21, 1, 198, 34, 32, 5, 21, 1, 189, 1, 32, 21,
        2, 39, 35, 33, 34, 21, 1, 199, 37, 36, 35, 199, 38, 39, 36, 39,
        2, 38, 39, 199, 38, 39, 37, 39, 3, 38, 39, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_AYUV_I420);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_convert_orc_convert_AYUV_I420");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_AYUV_I420);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_destination (p, 1, "d4");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_source (p, 8, "s2");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");
      orc_program_add_temporary (p, 2, "t5");
      orc_program_add_temporary (p, 2, "t6");
      orc_program_add_temporary (p, 1, "t7");
      orc_program_add_temporary (p, 1, "t8");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_S2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_D2, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 2, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_T3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T6, ORC_VAR_T5, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T7, ORC_VAR_T8, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 0, ORC_VAR_D3, ORC_VAR_T7, ORC_VAR_T8,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T7, ORC_VAR_T8, ORC_VAR_T6,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 0, ORC_VAR_D4, ORC_VAR_T7, ORC_VAR_T8,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_D2] = d2_stride;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->params[ORC_VAR_D3] = d3_stride;
  ex->arrays[ORC_VAR_D4] = d4;
  ex->params[ORC_VAR_D4] = d4_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_convert_AYUV_YUY2 */
#ifdef DISABLE_ORC
void
video_convert_orc_convert_AYUV_YUY2 (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadq */
      var37 = ptr4[i];
      /* 1: splitlw */
      {
        orc_union32 _src;
        _src.i = var37.x2[0];
        var39.x2[0] = _src.x2[1];
        var40.x2[0] = _src.x2[0];
      }
      {
        orc_union32 _src;
        _src.i = var37.x2[1];
        var39.x2[1] = _src.x2[1];
        var40.x2[1] = _src.x2[0];
      }
      /* 2: splitlw */
      {
        orc_union32 _src;
        _src.i = var39.i;
        var41.i = _src.x2[1];
        var42.i = _src.x2[0];
      }
      /* 3: avgub */
      var43.x2[0] =
          ((orc_uint8) var41.x2[0] + (orc_uint8) var42.x2[0] + 1) >> 1;
      var43.x2[1] =
          ((orc_uint8) var41.x2[1] + (orc_uint8) var42.x2[1] + 1) >> 1;
      /* 4: select1wb */
      {
        orc_union16 _src;
        _src.i = var40.x2[0];
        var44.x2[0] = _src.x2[1];
      }
      {
        orc_union16 _src;
        _src.i = var40.x2[1];
        var44.x2[1] = _src.x2[1];
      }
      /* 5: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var44.x2[0];
        _dest.x2[1] = var43.x2[0];
        var38.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var44.x2[1];
        _dest.x2[1] = var43.x2[1];
        var38.x2[1] = _dest.i;
      }
      /* 6: storel */
      ptr0[i] = var38;
    }
  }

}

#else
static void
_backup_video_convert_orc_convert_AYUV_YUY2 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadq */
      var37 = ptr4[i];
      /* 1: splitlw */
      {
        orc_union32 _src;
        _src.i = var37.x2[0];
        var39.x2[0] = _src.x2[1];
        var40.x2[0] = _src.x2[0];
      }
      {
        orc_union32 _src;
        _src.i = var37.x2[1];
        var39.x2[1] = _src.x2[1];
        var40.x2[1] = _src.x2[0];
      }
      /* 2: splitlw */
      {
        orc_union32 _src;
        _src.i = var39.i;
        var41.i = _src.x2[1];
        var42.i = _src.x2[0];
      }
      /* 3: avgub */
      var43.x2[0] =
          ((orc_uint8) var41.x2[0] + (orc_uint8) var42.x2[0] + 1) >> 1;
      var43.x2[1] =
          ((orc_uint8) var41.x2[1] + (orc_uint8) var42.x2[1] + 1) >> 1;
      /* 4: select1wb */
      {
        orc_union16 _src;
        _src.i = var40.x2[0];
        var44.x2[0] = _src.x2[1];
      }
      {
        orc_union16 _src;
        _src.i = var40.x2[1];
        var44.x2[1] = _src.x2[1];
      }
      /* 5: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var44.x2[0];
        _dest.x2[1] = var43.x2[0];
        var38.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var44.x2[1];
        _dest.x2[1] = var43.x2[1];
        var38.x2[1] = _dest.i;
      }
      /* 6: storel */
      ptr0[i] = var38;
    }
  }

}

void
video_convert_orc_convert_AYUV_YUY2 (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 35, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114,
        116, 95, 111, 114, 99, 95, 99, 111, 110, 118, 101, 114, 116, 95, 65, 89,
        85, 86, 95, 89, 85, 89, 50, 11, 4, 4, 12, 8, 8, 20, 2, 20,
        2, 20, 2, 20, 4, 20, 4, 21, 1, 198, 36, 35, 4, 198, 33, 34,
        36, 21, 1, 39, 33, 33, 34, 21, 1, 189, 32, 35, 21, 1, 196, 0,
        32, 33, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_AYUV_YUY2);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_convert_orc_convert_AYUV_YUY2");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_AYUV_YUY2);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 4, "t4");
      orc_program_add_temporary (p, 4, "t5");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T5, ORC_VAR_T4, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_T1, ORC_VAR_T4,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_convert_AYUV_UYVY */
#ifdef DISABLE_ORC
void
video_convert_orc_convert_AYUV_UYVY (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadq */
      var37 = ptr4[i];
      /* 1: splitlw */
      {
        orc_union32 _src;
        _src.i = var37.x2[0];
        var39.x2[0] = _src.x2[1];
        var40.x2[0] = _src.x2[0];
      }
      {
        orc_union32 _src;
        _src.i = var37.x2[1];
        var39.x2[1] = _src.x2[1];
        var40.x2[1] = _src.x2[0];
      }
      /* 2: splitlw */
      {
        orc_union32 _src;
        _src.i = var39.i;
        var41.i = _src.x2[1];
        var42.i = _src.x2[0];
      }
      /* 3: avgub */
      var43.x2[0] =
          ((orc_uint8) var41.x2[0] + (orc_uint8) var42.x2[0] + 1) >> 1;
      var43.x2[1] =
          ((orc_uint8) var41.x2[1] + (orc_uint8) var42.x2[1] + 1) >> 1;
      /* 4: select1wb */
      {
        orc_union16 _src;
        _src.i = var40.x2[0];
        var44.x2[0] = _src.x2[1];
      }
      {
        orc_union16 _src;
        _src.i = var40.x2[1];
        var44.x2[1] = _src.x2[1];
      }
      /* 5: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var43.x2[0];
        _dest.x2[1] = var44.x2[0];
        var38.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var43.x2[1];
        _dest.x2[1] = var44.x2[1];
        var38.x2[1] = _dest.i;
      }
      /* 6: storel */
      ptr0[i] = var38;
    }
  }

}

#else
static void
_backup_video_convert_orc_convert_AYUV_UYVY (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadq */
      var37 = ptr4[i];
      /* 1: splitlw */
      {
        orc_union32 _src;
        _src.i = var37.x2[0];
        var39.x2[0] = _src.x2[1];
        var40.x2[0] = _src.x2[0];
      }
      {
        orc_union32 _src;
        _src.i = var37.x2[1];
        var39.x2[1] = _src.x2[1];
        var40.x2[1] = _src.x2[0];
      }
      /* 2: splitlw */
      {
        orc_union32 _src;
        _src.i = var39.i;
        var41.i = _src.x2[1];
        var42.i = _src.x2[0];
      }
      /* 3: avgub */
      var43.x2[0] =
          ((orc_uint8) var41.x2[0] + (orc_uint8) var42.x2[0] + 1) >> 1;
      var43.x2[1] =
          ((orc_uint8) var41.x2[1] + (orc_uint8) var42.x2[1] + 1) >> 1;
      /* 4: select1wb */
      {
        orc_union16 _src;
        _src.i = var40.x2[0];
        var44.x2[0] = _src.x2[1];
      }
      {
        orc_union16 _src;
        _src.i = var40.x2[1];
        var44.x2[1] = _src.x2[1];
      }
      /* 5: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var43.x2[0];
        _dest.x2[1] = var44.x2[0];
        var38.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var43.x2[1];
        _dest.x2[1] = var44.x2[1];
        var38.x2[1] = _dest.i;
      }
      /* 6: storel */
      ptr0[i] = var38;
    }
  }

}

void
video_convert_orc_convert_AYUV_UYVY (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 35, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114,
        116, 95, 111, 114, 99, 95, 99, 111, 110, 118, 101, 114, 116, 95, 65, 89,
        85, 86, 95, 85, 89, 86, 89, 11, 4, 4, 12, 8, 8, 20, 2, 20,
        2, 20, 2, 20, 4, 20, 4, 21, 1, 198, 36, 35, 4, 198, 33, 34,
        36, 21, 1, 39, 33, 33, 34, 21, 1, 189, 32, 35, 21, 1, 196, 0,
        33, 32, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_AYUV_UYVY);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_convert_orc_convert_AYUV_UYVY");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_AYUV_UYVY);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 4, "t4");
      orc_program_add_temporary (p, 4, "t5");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T5, ORC_VAR_T4, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_T1, ORC_VAR_T4,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_convert_AYUV_Y42B */
#ifdef DISABLE_ORC
void
video_convert_orc_convert_AYUV_Y42B (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var36;
  orc_int8 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr1 = ORC_PTR_OFFSET (d2, d2_stride * j);
    ptr2 = ORC_PTR_OFFSET (d3, d3_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadq */
      var36 = ptr4[i];
      /* 1: splitlw */
      {
        orc_union32 _src;
        _src.i = var36.x2[0];
        var40.x2[0] = _src.x2[1];
        var41.x2[0] = _src.x2[0];
      }
      {
        orc_union32 _src;
        _src.i = var36.x2[1];
        var40.x2[1] = _src.x2[1];
        var41.x2[1] = _src.x2[0];
      }
      /* 2: splitlw */
      {
        orc_union32 _src;
        _src.i = var40.i;
        var42.i = _src.x2[1];
        var43.i = _src.x2[0];
      }
      /* 3: avgub */
      var44.x2[0] =
          ((orc_uint8) var42.x2[0] + (orc_uint8) var43.x2[0] + 1) >> 1;
      var44.x2[1] =
          ((orc_uint8) var42.x2[1] + (orc_uint8) var43.x2[1] + 1) >> 1;
      /* 4: splitwb */
      {
        orc_union16 _src;
        _src.i = var44.i;
        var37 = _src.x2[1];
        var38 = _src.x2[0];
      }
      /* 5: storeb */
      ptr2[i] = var37;
      /* 6: storeb */
      ptr1[i] = var38;
      /* 7: select1wb */
      {
        orc_union16 _src;
        _src.i = var41.x2[0];
        var39.x2[0] = _src.x2[1];
      }
      {
        orc_union16 _src;
        _src.i = var41.x2[1];
        var39.x2[1] = _src.x2[1];
      }
      /* 8: storew */
      ptr0[i] = var39;
    }
  }

}

#else
static void
_backup_video_convert_orc_convert_AYUV_Y42B (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var36;
  orc_int8 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr1 = ORC_PTR_OFFSET (ex->arrays[1], ex->params[1] * j);
    ptr2 = ORC_PTR_OFFSET (ex->arrays[2], ex->params[2] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadq */
      var36 = ptr4[i];
      /* 1: splitlw */
      {
        orc_union32 _src;
        _src.i = var36.x2[0];
        var40.x2[0] = _src.x2[1];
        var41.x2[0] = _src.x2[0];
      }
      {
        orc_union32 _src;
        _src.i = var36.x2[1];
        var40.x2[1] = _src.x2[1];
        var41.x2[1] = _src.x2[0];
      }
      /* 2: splitlw */
      {
        orc_union32 _src;
        _src.i = var40.i;
        var42.i = _src.x2[1];
        var43.i = _src.x2[0];
      }
      /* 3: avgub */
      var44.x2[0] =
          ((orc_uint8) var42.x2[0] + (orc_uint8) var43.x2[0] + 1) >> 1;
      var44.x2[1] =
          ((orc_uint8) var42.x2[1] + (orc_uint8) var43.x2[1] + 1) >> 1;
      /* 4: splitwb */
      {
        orc_union16 _src;
        _src.i = var44.i;
        var37 = _src.x2[1];
        var38 = _src.x2[0];
      }
      /* 5: storeb */
      ptr2[i] = var37;
      /* 6: storeb */
      ptr1[i] = var38;
      /* 7: select1wb */
      {
        orc_union16 _src;
        _src.i = var41.x2[0];
        var39.x2[0] = _src.x2[1];
      }
      {
        orc_union16 _src;
        _src.i = var41.x2[1];
        var39.x2[1] = _src.x2[1];
      }
      /* 8: storew */
      ptr0[i] = var39;
    }
  }

}

void
video_convert_orc_convert_AYUV_Y42B (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 35, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114,
        116, 95, 111, 114, 99, 95, 99, 111, 110, 118, 101, 114, 116, 95, 65, 89,
        85, 86, 95, 89, 52, 50, 66, 11, 2, 2, 11, 1, 1, 11, 1, 1,
        12, 8, 8, 20, 4, 20, 4, 20, 2, 20, 2, 21, 1, 198, 33, 32,
        4, 198, 34, 35, 33, 21, 1, 39, 34, 34, 35, 199, 2, 1, 34, 21,
        1, 189, 0, 32, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_AYUV_Y42B);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_convert_orc_convert_AYUV_Y42B");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_AYUV_Y42B);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 1, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_D3, ORC_VAR_D2, ORC_VAR_T3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_D2] = d2_stride;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->params[ORC_VAR_D3] = d3_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_convert_AYUV_Y444 */
#ifdef DISABLE_ORC
void
video_convert_orc_convert_AYUV_Y444 (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_int8 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_union16 var39;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr1 = ORC_PTR_OFFSET (d2, d2_stride * j);
    ptr2 = ORC_PTR_OFFSET (d3, d3_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var34 = ptr4[i];
      /* 1: splitlw */
      {
        orc_union32 _src;
        _src.i = var34.i;
        var38.i = _src.x2[1];
        var39.i = _src.x2[0];
      }
      /* 2: splitwb */
      {
        orc_union16 _src;
        _src.i = var38.i;
        var35 = _src.x2[1];
        var36 = _src.x2[0];
      }
      /* 3: storeb */
      ptr2[i] = var35;
      /* 4: storeb */
      ptr1[i] = var36;
      /* 5: select1wb */
      {
        orc_union16 _src;
        _src.i = var39.i;
        var37 = _src.x2[1];
      }
      /* 6: storeb */
      ptr0[i] = var37;
    }
  }

}

#else
static void
_backup_video_convert_orc_convert_AYUV_Y444 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_union16 var39;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr1 = ORC_PTR_OFFSET (ex->arrays[1], ex->params[1] * j);
    ptr2 = ORC_PTR_OFFSET (ex->arrays[2], ex->params[2] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var34 = ptr4[i];
      /* 1: splitlw */
      {
        orc_union32 _src;
        _src.i = var34.i;
        var38.i = _src.x2[1];
        var39.i = _src.x2[0];
      }
      /* 2: splitwb */
      {
        orc_union16 _src;
        _src.i = var38.i;
        var35 = _src.x2[1];
        var36 = _src.x2[0];
      }
      /* 3: storeb */
      ptr2[i] = var35;
      /* 4: storeb */
      ptr1[i] = var36;
      /* 5: select1wb */
      {
        orc_union16 _src;
        _src.i = var39.i;
        var37 = _src.x2[1];
      }
      /* 6: storeb */
      ptr0[i] = var37;
    }
  }

}

void
video_convert_orc_convert_AYUV_Y444 (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 35, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114,
        116, 95, 111, 114, 99, 95, 99, 111, 110, 118, 101, 114, 116, 95, 65, 89,
        85, 86, 95, 89, 52, 52, 52, 11, 1, 1, 11, 1, 1, 11, 1, 1,
        12, 4, 4, 20, 2, 20, 2, 198, 33, 32, 4, 199, 2, 1, 33, 189,
        0, 32, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_AYUV_Y444);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_convert_orc_convert_AYUV_Y444");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_AYUV_Y444);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_destination (p, 1, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_D3, ORC_VAR_D2, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 0, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_D2] = d2_stride;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->params[ORC_VAR_D3] = d3_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_convert_Y42B_YUY2 */
#ifdef DISABLE_ORC
void
video_convert_orc_convert_Y42B_YUY2 (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m)
{
  int i;
  int j;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_int8 var33;
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET (s2, s2_stride * j);
    ptr6 = ORC_PTR_OFFSET (s3, s3_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var33 = ptr5[i];
      /* 1: loadb */
      var34 = ptr6[i];
      /* 2: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var33;
        _dest.x2[1] = var34;
        var37.i = _dest.i;
      }
      /* 3: loadw */
      var35 = ptr4[i];
      /* 4: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var35.x2[0];
        _dest.x2[1] = var37.x2[0];
        var36.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var35.x2[1];
        _dest.x2[1] = var37.x2[1];
        var36.x2[1] = _dest.i;
      }
      /* 5: storel */
      ptr0[i] = var36;
    }
  }

}

#else
static void
_backup_video_convert_orc_convert_Y42B_YUY2 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_int8 var33;
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET (ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET (ex->arrays[6], ex->params[6] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var33 = ptr5[i];
      /* 1: loadb */
      var34 = ptr6[i];
      /* 2: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var33;
        _dest.x2[1] = var34;
        var37.i = _dest.i;
      }
      /* 3: loadw */
      var35 = ptr4[i];
      /* 4: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var35.x2[0];
        _dest.x2[1] = var37.x2[0];
        var36.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var35.x2[1];
        _dest.x2[1] = var37.x2[1];
        var36.x2[1] = _dest.i;
      }
      /* 5: storel */
      ptr0[i] = var36;
    }
  }

}

void
video_convert_orc_convert_Y42B_YUY2 (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 35, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114,
        116, 95, 111, 114, 99, 95, 99, 111, 110, 118, 101, 114, 116, 95, 89, 52,
        50, 66, 95, 89, 85, 89, 50, 11, 4, 4, 12, 2, 2, 12, 1, 1,
        12, 1, 1, 20, 2, 196, 32, 5, 6, 21, 1, 196, 0, 4, 32, 2,
        0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_Y42B_YUY2);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_convert_orc_convert_Y42B_YUY2");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_Y42B_YUY2);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->arrays[ORC_VAR_S3] = (void *) s3;
  ex->params[ORC_VAR_S3] = s3_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_convert_Y42B_UYVY */
#ifdef DISABLE_ORC
void
video_convert_orc_convert_Y42B_UYVY (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m)
{
  int i;
  int j;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_int8 var33;
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET (s2, s2_stride * j);
    ptr6 = ORC_PTR_OFFSET (s3, s3_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var33 = ptr5[i];
      /* 1: loadb */
      var34 = ptr6[i];
      /* 2: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var33;
        _dest.x2[1] = var34;
        var37.i = _dest.i;
      }
      /* 3: loadw */
      var35 = ptr4[i];
      /* 4: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var37.x2[0];
        _dest.x2[1] = var35.x2[0];
        var36.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var37.x2[1];
        _dest.x2[1] = var35.x2[1];
        var36.x2[1] = _dest.i;
      }
      /* 5: storel */
      ptr0[i] = var36;
    }
  }

}

#else
static void
_backup_video_convert_orc_convert_Y42B_UYVY (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_int8 var33;
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET (ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET (ex->arrays[6], ex->params[6] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var33 = ptr5[i];
      /* 1: loadb */
      var34 = ptr6[i];
      /* 2: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var33;
        _dest.x2[1] = var34;
        var37.i = _dest.i;
      }
      /* 3: loadw */
      var35 = ptr4[i];
      /* 4: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var37.x2[0];
        _dest.x2[1] = var35.x2[0];
        var36.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var37.x2[1];
        _dest.x2[1] = var35.x2[1];
        var36.x2[1] = _dest.i;
      }
      /* 5: storel */
      ptr0[i] = var36;
    }
  }

}

void
video_convert_orc_convert_Y42B_UYVY (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 35, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114,
        116, 95, 111, 114, 99, 95, 99, 111, 110, 118, 101, 114, 116, 95, 89, 52,
        50, 66, 95, 85, 89, 86, 89, 11, 4, 4, 12, 2, 2, 12, 1, 1,
        12, 1, 1, 20, 2, 196, 32, 5, 6, 21, 1, 196, 0, 32, 4, 2,
        0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_Y42B_UYVY);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_convert_orc_convert_Y42B_UYVY");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_Y42B_UYVY);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->arrays[ORC_VAR_S3] = (void *) s3;
  ex->params[ORC_VAR_S3] = s3_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_convert_Y42B_AYUV */
#ifdef DISABLE_ORC
void
video_convert_orc_convert_Y42B_AYUV (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m)
{
  int i;
  int j;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_int8 var36;
  orc_int8 var37;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
  orc_union16 var39;
  orc_union64 var40;
  orc_union16 var41;
  orc_union32 var42;
  orc_union32 var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET (s2, s2_stride * j);
    ptr6 = ORC_PTR_OFFSET (s3, s3_stride * j);

    /* 3: loadpb */
    var38.x2[0] = (int) 0x000000ff;     /* 255 or 1.25987e-321f */
    var38.x2[1] = (int) 0x000000ff;     /* 255 or 1.25987e-321f */

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var36 = ptr5[i];
      /* 1: loadb */
      var37 = ptr6[i];
      /* 2: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var36;
        _dest.x2[1] = var37;
        var41.i = _dest.i;
      }
      /* 4: loadw */
      var39 = ptr4[i];
      /* 5: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var38.x2[0];
        _dest.x2[1] = var39.x2[0];
        var42.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var38.x2[1];
        _dest.x2[1] = var39.x2[1];
        var42.x2[1] = _dest.i;
      }
      /* 6: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var41.i;
        _dest.x2[1] = var41.i;
        var43.i = _dest.i;
      }
      /* 7: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var42.x2[0];
        _dest.x2[1] = var43.x2[0];
        var40.x2[0] = _dest.i;
      }
      {
        orc_union32 _dest;
        _dest.x2[0] = var42.x2[1];
        _dest.x2[1] = var43.x2[1];
        var40.x2[1] = _dest.i;
      }
      /* 8: storeq */
      ptr0[i] = var40;
    }
  }

}

#else
static void
_backup_video_convert_orc_convert_Y42B_AYUV (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_int8 var36;
  orc_int8 var37;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
  orc_union16 var39;
  orc_union64 var40;
  orc_union16 var41;
  orc_union32 var42;
  orc_union32 var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET (ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET (ex->arrays[6], ex->params[6] * j);

    /* 3: loadpb */
    var38.x2[0] = (int) 0x000000ff;     /* 255 or 1.25987e-321f */
    var38.x2[1] = (int) 0x000000ff;     /* 255 or 1.25987e-321f */

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var36 = ptr5[i];
      /* 1: loadb */
      var37 = ptr6[i];
      /* 2: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var36;
        _dest.x2[1] = var37;
        var41.i = _dest.i;
      }
      /* 4: loadw */
      var39 = ptr4[i];
      /* 5: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var38.x2[0];
        _dest.x2[1] = var39.x2[0];
        var42.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var38.x2[1];
        _dest.x2[1] = var39.x2[1];
        var42.x2[1] = _dest.i;
      }
      /* 6: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var41.i;
        _dest.x2[1] = var41.i;
        var43.i = _dest.i;
      }
      /* 7: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var42.x2[0];
        _dest.x2[1] = var43.x2[0];
        var40.x2[0] = _dest.i;
      }
      {
        orc_union32 _dest;
        _dest.x2[0] = var42.x2[1];
        _dest.x2[1] = var43.x2[1];
        var40.x2[1] = _dest.i;
      }
      /* 8: storeq */
      ptr0[i] = var40;
    }
  }

}

void
video_convert_orc_convert_Y42B_AYUV (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 35, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114,
        116, 95, 111, 114, 99, 95, 99, 111, 110, 118, 101, 114, 116, 95, 89, 52,
        50, 66, 95, 65, 89, 85, 86, 11, 8, 8, 12, 2, 2, 12, 1, 1,
        12, 1, 1, 14, 1, 255, 0, 0, 0, 20, 2, 20, 2, 20, 4, 20,
        4, 196, 32, 5, 6, 21, 1, 196, 35, 16, 4, 195, 34, 32, 32, 21,
        1, 195, 0, 35, 34, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_Y42B_AYUV);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_convert_orc_convert_Y42B_AYUV");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_Y42B_AYUV);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_constant (p, 1, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T4, ORC_VAR_C1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T4, ORC_VAR_T3,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->arrays[ORC_VAR_S3] = (void *) s3;
  ex->params[ORC_VAR_S3] = s3_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_convert_Y444_YUY2 */
#ifdef DISABLE_ORC
void
video_convert_orc_convert_Y444_YUY2 (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m)
{
  int i;
  int j;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  const orc_union16 *ORC_RESTRICT ptr6;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET (s2, s2_stride * j);
    ptr6 = ORC_PTR_OFFSET (s3, s3_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var36 = ptr5[i];
      /* 1: loadw */
      var37 = ptr6[i];
      /* 2: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var36.x2[0];
        _dest.x2[1] = var37.x2[0];
        var40.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var36.x2[1];
        _dest.x2[1] = var37.x2[1];
        var40.x2[1] = _dest.i;
      }
      /* 3: splitlw */
      {
        orc_union32 _src;
        _src.i = var40.i;
        var41.i = _src.x2[1];
        var42.i = _src.x2[0];
      }
      /* 4: avgub */
      var43.x2[0] =
          ((orc_uint8) var41.x2[0] + (orc_uint8) var42.x2[0] + 1) >> 1;
      var43.x2[1] =
          ((orc_uint8) var41.x2[1] + (orc_uint8) var42.x2[1] + 1) >> 1;
      /* 5: loadw */
      var38 = ptr4[i];
      /* 6: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var38.x2[0];
        _dest.x2[1] = var43.x2[0];
        var39.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var38.x2[1];
        _dest.x2[1] = var43.x2[1];
        var39.x2[1] = _dest.i;
      }
      /* 7: storel */
      ptr0[i] = var39;
    }
  }

}

#else
static void
_backup_video_convert_orc_convert_Y444_YUY2 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  const orc_union16 *ORC_RESTRICT ptr6;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET (ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET (ex->arrays[6], ex->params[6] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var36 = ptr5[i];
      /* 1: loadw */
      var37 = ptr6[i];
      /* 2: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var36.x2[0];
        _dest.x2[1] = var37.x2[0];
        var40.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var36.x2[1];
        _dest.x2[1] = var37.x2[1];
        var40.x2[1] = _dest.i;
      }
      /* 3: splitlw */
      {
        orc_union32 _src;
        _src.i = var40.i;
        var41.i = _src.x2[1];
        var42.i = _src.x2[0];
      }
      /* 4: avgub */
      var43.x2[0] =
          ((orc_uint8) var41.x2[0] + (orc_uint8) var42.x2[0] + 1) >> 1;
      var43.x2[1] =
          ((orc_uint8) var41.x2[1] + (orc_uint8) var42.x2[1] + 1) >> 1;
      /* 5: loadw */
      var38 = ptr4[i];
      /* 6: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var38.x2[0];
        _dest.x2[1] = var43.x2[0];
        var39.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var38.x2[1];
        _dest.x2[1] = var43.x2[1];
        var39.x2[1] = _dest.i;
      }
      /* 7: storel */
      ptr0[i] = var39;
    }
  }

}

void
video_convert_orc_convert_Y444_YUY2 (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 35, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114,
        116, 95, 111, 114, 99, 95, 99, 111, 110, 118, 101, 114, 116, 95, 89, 52,
        52, 52, 95, 89, 85, 89, 50, 11, 4, 4, 12, 2, 2, 12, 2, 2,
        12, 2, 2, 20, 2, 20, 4, 20, 2, 20, 2, 21, 1, 196, 33, 5,
        6, 198, 34, 35, 33, 21, 1, 39, 32, 34, 35, 21, 1, 196, 0, 4,
        32, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_Y444_YUY2);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_convert_orc_convert_Y444_YUY2");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_Y444_YUY2);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 2, "s3");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");

      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_S3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->arrays[ORC_VAR_S3] = (void *) s3;
  ex->params[ORC_VAR_S3] = s3_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_convert_Y444_UYVY */
#ifdef DISABLE_ORC
void
video_convert_orc_convert_Y444_UYVY (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m)
{
  int i;
  int j;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  const orc_union16 *ORC_RESTRICT ptr6;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET (s2, s2_stride * j);
    ptr6 = ORC_PTR_OFFSET (s3, s3_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var36 = ptr5[i];
      /* 1: loadw */
      var37 = ptr6[i];
      /* 2: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var36.x2[0];
        _dest.x2[1] = var37.x2[0];
        var40.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var36.x2[1];
        _dest.x2[1] = var37.x2[1];
        var40.x2[1] = _dest.i;
      }
      /* 3: splitlw */
      {
        orc_union32 _src;
        _src.i = var40.i;
        var41.i = _src.x2[1];
        var42.i = _src.x2[0];
      }
      /* 4: avgub */
      var43.x2[0] =
          ((orc_uint8) var41.x2[0] + (orc_uint8) var42.x2[0] + 1) >> 1;
      var43.x2[1] =
          ((orc_uint8) var41.x2[1] + (orc_uint8) var42.x2[1] + 1) >> 1;
      /* 5: loadw */
      var38 = ptr4[i];
      /* 6: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var43.x2[0];
        _dest.x2[1] = var38.x2[0];
        var39.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var43.x2[1];
        _dest.x2[1] = var38.x2[1];
        var39.x2[1] = _dest.i;
      }
      /* 7: storel */
      ptr0[i] = var39;
    }
  }

}

#else
static void
_backup_video_convert_orc_convert_Y444_UYVY (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  const orc_union16 *ORC_RESTRICT ptr6;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET (ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET (ex->arrays[6], ex->params[6] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var36 = ptr5[i];
      /* 1: loadw */
      var37 = ptr6[i];
      /* 2: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var36.x2[0];
        _dest.x2[1] = var37.x2[0];
        var40.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var36.x2[1];
        _dest.x2[1] = var37.x2[1];
        var40.x2[1] = _dest.i;
      }
      /* 3: splitlw */
      {
        orc_union32 _src;
        _src.i = var40.i;
        var41.i = _src.x2[1];
        var42.i = _src.x2[0];
      }
      /* 4: avgub */
      var43.x2[0] =
          ((orc_uint8) var41.x2[0] + (orc_uint8) var42.x2[0] + 1) >> 1;
      var43.x2[1] =
          ((orc_uint8) var41.x2[1] + (orc_uint8) var42.x2[1] + 1) >> 1;
      /* 5: loadw */
      var38 = ptr4[i];
      /* 6: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var43.x2[0];
        _dest.x2[1] = var38.x2[0];
        var39.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var43.x2[1];
        _dest.x2[1] = var38.x2[1];
        var39.x2[1] = _dest.i;
      }
      /* 7: storel */
      ptr0[i] = var39;
    }
  }

}

void
video_convert_orc_convert_Y444_UYVY (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 35, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114,
        116, 95, 111, 114, 99, 95, 99, 111, 110, 118, 101, 114, 116, 95, 89, 52,
        52, 52, 95, 85, 89, 86, 89, 11, 4, 4, 12, 2, 2, 12, 2, 2,
        12, 2, 2, 20, 2, 20, 4, 20, 2, 20, 2, 21, 1, 196, 33, 5,
        6, 198, 34, 35, 33, 21, 1, 39, 32, 34, 35, 21, 1, 196, 0, 32,
        4, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_Y444_UYVY);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_convert_orc_convert_Y444_UYVY");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_Y444_UYVY);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 2, "s3");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");

      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_S3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->arrays[ORC_VAR_S3] = (void *) s3;
  ex->params[ORC_VAR_S3] = s3_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_convert_Y444_AYUV */
#ifdef DISABLE_ORC
void
video_convert_orc_convert_Y444_AYUV (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m)
{
  int i;
  int j;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_int8 var34;
  orc_int8 var35;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_int8 var36;
#else
  orc_int8 var36;
#endif
  orc_int8 var37;
  orc_union32 var38;
  orc_union16 var39;
  orc_union16 var40;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET (s2, s2_stride * j);
    ptr6 = ORC_PTR_OFFSET (s3, s3_stride * j);

    /* 3: loadpb */
    var36 = (int) 0x000000ff;   /* 255 or 1.25987e-321f */

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var34 = ptr5[i];
      /* 1: loadb */
      var35 = ptr6[i];
      /* 2: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var34;
        _dest.x2[1] = var35;
        var39.i = _dest.i;
      }
      /* 4: loadb */
      var37 = ptr4[i];
      /* 5: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var36;
        _dest.x2[1] = var37;
        var40.i = _dest.i;
      }
      /* 6: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var40.i;
        _dest.x2[1] = var39.i;
        var38.i = _dest.i;
      }
      /* 7: storel */
      ptr0[i] = var38;
    }
  }

}

#else
static void
_backup_video_convert_orc_convert_Y444_AYUV (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_int8 var34;
  orc_int8 var35;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_int8 var36;
#else
  orc_int8 var36;
#endif
  orc_int8 var37;
  orc_union32 var38;
  orc_union16 var39;
  orc_union16 var40;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET (ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET (ex->arrays[6], ex->params[6] * j);

    /* 3: loadpb */
    var36 = (int) 0x000000ff;   /* 255 or 1.25987e-321f */

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var34 = ptr5[i];
      /* 1: loadb */
      var35 = ptr6[i];
      /* 2: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var34;
        _dest.x2[1] = var35;
        var39.i = _dest.i;
      }
      /* 4: loadb */
      var37 = ptr4[i];
      /* 5: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var36;
        _dest.x2[1] = var37;
        var40.i = _dest.i;
      }
      /* 6: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var40.i;
        _dest.x2[1] = var39.i;
        var38.i = _dest.i;
      }
      /* 7: storel */
      ptr0[i] = var38;
    }
  }

}

void
video_convert_orc_convert_Y444_AYUV (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 35, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114,
        116, 95, 111, 114, 99, 95, 99, 111, 110, 118, 101, 114, 116, 95, 89, 52,
        52, 52, 95, 65, 89, 85, 86, 11, 4, 4, 12, 1, 1, 12, 1, 1,
        12, 1, 1, 14, 1, 255, 0, 0, 0, 20, 2, 20, 2, 196, 32, 5,
        6, 196, 33, 16, 4, 195, 0, 33, 32, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_Y444_AYUV);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_convert_orc_convert_Y444_AYUV");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_Y444_AYUV);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_constant (p, 1, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->arrays[ORC_VAR_S3] = (void *) s3;
  ex->params[ORC_VAR_S3] = s3_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_convert_AYUV_ARGB */
#ifdef DISABLE_ORC
void
video_convert_orc_convert_AYUV_ARGB (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int p1, int p2, int p3,
    int p4, int p5, int n, int m)
{
  int i;
  int j;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var46;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union32 var47;
#else
  orc_union32 var47;
#endif
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union32 var53;
#else
  orc_union32 var53;
#endif
  orc_union32 var54;
  orc_union32 var55;
  orc_union16 var56;
  orc_union16 var57;
  orc_int8 var58;
  orc_int8 var59;
  orc_int8 var60;
  orc_int8 var61;
  orc_union16 var62;
  orc_union16 var63;
  orc_union16 var64;
  orc_union16 var65;
  orc_union16 var66;
  orc_union16 var67;
  orc_union16 var68;
  orc_union16 var69;
  orc_union16 var70;
  orc_union16 var71;
  orc_union16 var72;
  orc_union16 var73;
  orc_int8 var74;
  orc_int8 var75;
  orc_int8 var76;
  orc_union16 var77;
  orc_union16 var78;
  orc_union32 var79;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);

    /* 1: loadpb */
    var47.x4[0] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var47.x4[1] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var47.x4[2] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var47.x4[3] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    /* 9: loadpw */
    var48.i = p1;
    /* 11: loadpw */
    var49.i = p2;
    /* 14: loadpw */
    var50.i = p3;
    /* 17: loadpw */
    var51.i = p4;
    /* 20: loadpw */
    var52.i = p5;
    /* 29: loadpb */
    var53.x4[0] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var53.x4[1] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var53.x4[2] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var53.x4[3] = (int) 0x00000080;     /* 128 or 6.32404e-322f */

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var46 = ptr4[i];
      /* 2: subb */
      var55.x4[0] = var46.x4[0] - var47.x4[0];
      var55.x4[1] = var46.x4[1] - var47.x4[1];
      var55.x4[2] = var46.x4[2] - var47.x4[2];
      var55.x4[3] = var46.x4[3] - var47.x4[3];
      /* 3: splitlw */
      {
        orc_union32 _src;
        _src.i = var55.i;
        var56.i = _src.x2[1];
        var57.i = _src.x2[0];
      }
      /* 4: splitwb */
      {
        orc_union16 _src;
        _src.i = var57.i;
        var58 = _src.x2[1];
        var59 = _src.x2[0];
      }
      /* 5: splitwb */
      {
        orc_union16 _src;
        _src.i = var56.i;
        var60 = _src.x2[1];
        var61 = _src.x2[0];
      }
      /* 6: splatbw */
      var62.i = ((var58 & 0xff) << 8) | (var58 & 0xff);
      /* 7: splatbw */
      var63.i = ((var61 & 0xff) << 8) | (var61 & 0xff);
      /* 8: splatbw */
      var64.i = ((var60 & 0xff) << 8) | (var60 & 0xff);
      /* 10: mulhsw */
      var65.i = (var62.i * var48.i) >> 16;
      /* 12: mulhsw */
      var66.i = (var64.i * var49.i) >> 16;
      /* 13: addssw */
      var67.i = ORC_CLAMP_SW (var65.i + var66.i);
      /* 15: mulhsw */
      var68.i = (var63.i * var50.i) >> 16;
      /* 16: addssw */
      var69.i = ORC_CLAMP_SW (var65.i + var68.i);
      /* 18: mulhsw */
      var70.i = (var63.i * var51.i) >> 16;
      /* 19: addssw */
      var71.i = ORC_CLAMP_SW (var65.i + var70.i);
      /* 21: mulhsw */
      var72.i = (var64.i * var52.i) >> 16;
      /* 22: addssw */
      var73.i = ORC_CLAMP_SW (var71.i + var72.i);
      /* 23: convssswb */
      var74 = ORC_CLAMP_SB (var67.i);
      /* 24: convssswb */
      var75 = ORC_CLAMP_SB (var73.i);
      /* 25: convssswb */
      var76 = ORC_CLAMP_SB (var69.i);
      /* 26: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var59;
        _dest.x2[1] = var74;
        var77.i = _dest.i;
      }
      /* 27: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var75;
        _dest.x2[1] = var76;
        var78.i = _dest.i;
      }
      /* 28: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var77.i;
        _dest.x2[1] = var78.i;
        var79.i = _dest.i;
      }
      /* 30: addb */
      var54.x4[0] = var79.x4[0] + var53.x4[0];
      var54.x4[1] = var79.x4[1] + var53.x4[1];
      var54.x4[2] = var79.x4[2] + var53.x4[2];
      var54.x4[3] = var79.x4[3] + var53.x4[3];
      /* 31: storel */
      ptr0[i] = var54;
    }
  }

}

#else
static void
_backup_video_convert_orc_convert_AYUV_ARGB (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var46;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union32 var47;
#else
  orc_union32 var47;
#endif
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union32 var53;
#else
  orc_union32 var53;
#endif
  orc_union32 var54;
  orc_union32 var55;
  orc_union16 var56;
  orc_union16 var57;
  orc_int8 var58;
  orc_int8 var59;
  orc_int8 var60;
  orc_int8 var61;
  orc_union16 var62;
  orc_union16 var63;
  orc_union16 var64;
  orc_union16 var65;
  orc_union16 var66;
  orc_union16 var67;
  orc_union16 var68;
  orc_union16 var69;
  orc_union16 var70;
  orc_union16 var71;
  orc_union16 var72;
  orc_union16 var73;
  orc_int8 var74;
  orc_int8 var75;
  orc_int8 var76;
  orc_union16 var77;
  orc_union16 var78;
  orc_union32 var79;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);

    /* 1: loadpb */
    var47.x4[0] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var47.x4[1] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var47.x4[2] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var47.x4[3] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    /* 9: loadpw */
    var48.i = ex->params[24];
    /* 11: loadpw */
    var49.i = ex->params[25];
    /* 14: loadpw */
    var50.i = ex->params[26];
    /* 17: loadpw */
    var51.i = ex->params[27];
    /* 20: loadpw */
    var52.i = ex->params[28];
    /* 29: loadpb */
    var53.x4[0] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var53.x4[1] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var53.x4[2] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var53.x4[3] = (int) 0x00000080;     /* 128 or 6.32404e-322f */

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var46 = ptr4[i];
      /* 2: subb */
      var55.x4[0] = var46.x4[0] - var47.x4[0];
      var55.x4[1] = var46.x4[1] - var47.x4[1];
      var55.x4[2] = var46.x4[2] - var47.x4[2];
      var55.x4[3] = var46.x4[3] - var47.x4[3];
      /* 3: splitlw */
      {
        orc_union32 _src;
        _src.i = var55.i;
        var56.i = _src.x2[1];
        var57.i = _src.x2[0];
      }
      /* 4: splitwb */
      {
        orc_union16 _src;
        _src.i = var57.i;
        var58 = _src.x2[1];
        var59 = _src.x2[0];
      }
      /* 5: splitwb */
      {
        orc_union16 _src;
        _src.i = var56.i;
        var60 = _src.x2[1];
        var61 = _src.x2[0];
      }
      /* 6: splatbw */
      var62.i = ((var58 & 0xff) << 8) | (var58 & 0xff);
      /* 7: splatbw */
      var63.i = ((var61 & 0xff) << 8) | (var61 & 0xff);
      /* 8: splatbw */
      var64.i = ((var60 & 0xff) << 8) | (var60 & 0xff);
      /* 10: mulhsw */
      var65.i = (var62.i * var48.i) >> 16;
      /* 12: mulhsw */
      var66.i = (var64.i * var49.i) >> 16;
      /* 13: addssw */
      var67.i = ORC_CLAMP_SW (var65.i + var66.i);
      /* 15: mulhsw */
      var68.i = (var63.i * var50.i) >> 16;
      /* 16: addssw */
      var69.i = ORC_CLAMP_SW (var65.i + var68.i);
      /* 18: mulhsw */
      var70.i = (var63.i * var51.i) >> 16;
      /* 19: addssw */
      var71.i = ORC_CLAMP_SW (var65.i + var70.i);
      /* 21: mulhsw */
      var72.i = (var64.i * var52.i) >> 16;
      /* 22: addssw */
      var73.i = ORC_CLAMP_SW (var71.i + var72.i);
      /* 23: convssswb */
      var74 = ORC_CLAMP_SB (var67.i);
      /* 24: convssswb */
      var75 = ORC_CLAMP_SB (var73.i);
      /* 25: convssswb */
      var76 = ORC_CLAMP_SB (var69.i);
      /* 26: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var59;
        _dest.x2[1] = var74;
        var77.i = _dest.i;
      }
      /* 27: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var75;
        _dest.x2[1] = var76;
        var78.i = _dest.i;
      }
      /* 28: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var77.i;
        _dest.x2[1] = var78.i;
        var79.i = _dest.i;
      }
      /* 30: addb */
      var54.x4[0] = var79.x4[0] + var53.x4[0];
      var54.x4[1] = var79.x4[1] + var53.x4[1];
      var54.x4[2] = var79.x4[2] + var53.x4[2];
      var54.x4[3] = var79.x4[3] + var53.x4[3];
      /* 31: storel */
      ptr0[i] = var54;
    }
  }

}

void
video_convert_orc_convert_AYUV_ARGB (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int p1, int p2, int p3,
    int p4, int p5, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 35, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114,
        116, 95, 111, 114, 99, 95, 99, 111, 110, 118, 101, 114, 116, 95, 65, 89,
        85, 86, 95, 65, 82, 71, 66, 11, 4, 4, 12, 4, 4, 14, 1, 128,
        0, 0, 0, 16, 2, 16, 2, 16, 2, 16, 2, 16, 2, 20, 1, 20,
        1, 20, 1, 20, 1, 20, 2, 20, 2, 20, 2, 20, 2, 20, 2, 20,
        2, 20, 1, 20, 1, 20, 1, 20, 4, 21, 2, 65, 45, 4, 16, 198,
        38, 36, 45, 199, 33, 32, 36, 199, 35, 34, 38, 151, 36, 33, 151, 37,
        34, 151, 38, 35, 90, 36, 36, 24, 90, 39, 38, 25, 71, 39, 36, 39,
        90, 41, 37, 26, 71, 41, 36, 41, 90, 40, 37, 27, 71, 40, 36, 40,
        90, 36, 38, 28, 71, 40, 40, 36, 159, 42, 39, 159, 43, 40, 159, 44,
        41, 196, 39, 32, 42, 196, 41, 43, 44, 195, 45, 39, 41, 21, 2, 33,
        0, 45, 16, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_AYUV_ARGB);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_convert_orc_convert_AYUV_ARGB");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_AYUV_ARGB);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 1, 0x00000080, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_parameter (p, 2, "p5");
      orc_program_add_temporary (p, 1, "t1");
      orc_program_add_temporary (p, 1, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");
      orc_program_add_temporary (p, 2, "t5");
      orc_program_add_temporary (p, 2, "t6");
      orc_program_add_temporary (p, 2, "t7");
      orc_program_add_temporary (p, 2, "t8");
      orc_program_add_temporary (p, 2, "t9");
      orc_program_add_temporary (p, 2, "t10");
      orc_program_add_temporary (p, 1, "t11");
      orc_program_add_temporary (p, 1, "t12");
      orc_program_add_temporary (p, 1, "t13");
      orc_program_add_temporary (p, 4, "t14");

      orc_program_append_2 (p, "subb", 2, ORC_VAR_T14, ORC_VAR_S1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T7, ORC_VAR_T5,
          ORC_VAR_T14, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_T7,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T5, ORC_VAR_T2, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T6, ORC_VAR_T3, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T7, ORC_VAR_T4, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_P1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T8, ORC_VAR_T7, ORC_VAR_P2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T8, ORC_VAR_T5, ORC_VAR_T8,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T10, ORC_VAR_T6, ORC_VAR_P3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T10, ORC_VAR_T5,
          ORC_VAR_T10, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T9, ORC_VAR_T6, ORC_VAR_P4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T9, ORC_VAR_T5, ORC_VAR_T9,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T5, ORC_VAR_T7, ORC_VAR_P5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T9, ORC_VAR_T9, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T11, ORC_VAR_T8,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T12, ORC_VAR_T9,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T13, ORC_VAR_T10,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T8, ORC_VAR_T1,
          ORC_VAR_T11, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T10, ORC_VAR_T12,
          ORC_VAR_T13, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T14, ORC_VAR_T8,
          ORC_VAR_T10, ORC_VAR_D1);
      orc_program_append_2 (p, "addb", 2, ORC_VAR_D1, ORC_VAR_T14, ORC_VAR_C1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;
  ex->params[ORC_VAR_P5] = p5;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_convert_AYUV_BGRA */
#ifdef DISABLE_ORC
void
video_convert_orc_convert_AYUV_BGRA (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int p1, int p2, int p3,
    int p4, int p5, int n, int m)
{
  int i;
  int j;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var46;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union32 var47;
#else
  orc_union32 var47;
#endif
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union32 var53;
#else
  orc_union32 var53;
#endif
  orc_union32 var54;
  orc_union32 var55;
  orc_union16 var56;
  orc_union16 var57;
  orc_int8 var58;
  orc_int8 var59;
  orc_int8 var60;
  orc_int8 var61;
  orc_union16 var62;
  orc_union16 var63;
  orc_union16 var64;
  orc_union16 var65;
  orc_union16 var66;
  orc_union16 var67;
  orc_union16 var68;
  orc_union16 var69;
  orc_union16 var70;
  orc_union16 var71;
  orc_union16 var72;
  orc_union16 var73;
  orc_int8 var74;
  orc_int8 var75;
  orc_int8 var76;
  orc_union16 var77;
  orc_union16 var78;
  orc_union32 var79;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);

    /* 1: loadpb */
    var47.x4[0] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var47.x4[1] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var47.x4[2] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var47.x4[3] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    /* 9: loadpw */
    var48.i = p1;
    /* 11: loadpw */
    var49.i = p2;
    /* 14: loadpw */
    var50.i = p3;
    /* 17: loadpw */
    var51.i = p4;
    /* 20: loadpw */
    var52.i = p5;
    /* 29: loadpb */
    var53.x4[0] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var53.x4[1] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var53.x4[2] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var53.x4[3] = (int) 0x00000080;     /* 128 or 6.32404e-322f */

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var46 = ptr4[i];
      /* 2: subb */
      var55.x4[0] = var46.x4[0] - var47.x4[0];
      var55.x4[1] = var46.x4[1] - var47.x4[1];
      var55.x4[2] = var46.x4[2] - var47.x4[2];
      var55.x4[3] = var46.x4[3] - var47.x4[3];
      /* 3: splitlw */
      {
        orc_union32 _src;
        _src.i = var55.i;
        var56.i = _src.x2[1];
        var57.i = _src.x2[0];
      }
      /* 4: splitwb */
      {
        orc_union16 _src;
        _src.i = var57.i;
        var58 = _src.x2[1];
        var59 = _src.x2[0];
      }
      /* 5: splitwb */
      {
        orc_union16 _src;
        _src.i = var56.i;
        var60 = _src.x2[1];
        var61 = _src.x2[0];
      }
      /* 6: splatbw */
      var62.i = ((var58 & 0xff) << 8) | (var58 & 0xff);
      /* 7: splatbw */
      var63.i = ((var61 & 0xff) << 8) | (var61 & 0xff);
      /* 8: splatbw */
      var64.i = ((var60 & 0xff) << 8) | (var60 & 0xff);
      /* 10: mulhsw */
      var65.i = (var62.i * var48.i) >> 16;
      /* 12: mulhsw */
      var66.i = (var64.i * var49.i) >> 16;
      /* 13: addssw */
      var67.i = ORC_CLAMP_SW (var65.i + var66.i);
      /* 15: mulhsw */
      var68.i = (var63.i * var50.i) >> 16;
      /* 16: addssw */
      var69.i = ORC_CLAMP_SW (var65.i + var68.i);
      /* 18: mulhsw */
      var70.i = (var63.i * var51.i) >> 16;
      /* 19: addssw */
      var71.i = ORC_CLAMP_SW (var65.i + var70.i);
      /* 21: mulhsw */
      var72.i = (var64.i * var52.i) >> 16;
      /* 22: addssw */
      var73.i = ORC_CLAMP_SW (var71.i + var72.i);
      /* 23: convssswb */
      var74 = ORC_CLAMP_SB (var67.i);
      /* 24: convssswb */
      var75 = ORC_CLAMP_SB (var73.i);
      /* 25: convssswb */
      var76 = ORC_CLAMP_SB (var69.i);
      /* 26: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var76;
        _dest.x2[1] = var75;
        var77.i = _dest.i;
      }
      /* 27: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var74;
        _dest.x2[1] = var59;
        var78.i = _dest.i;
      }
      /* 28: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var77.i;
        _dest.x2[1] = var78.i;
        var79.i = _dest.i;
      }
      /* 30: addb */
      var54.x4[0] = var79.x4[0] + var53.x4[0];
      var54.x4[1] = var79.x4[1] + var53.x4[1];
      var54.x4[2] = var79.x4[2] + var53.x4[2];
      var54.x4[3] = var79.x4[3] + var53.x4[3];
      /* 31: storel */
      ptr0[i] = var54;
    }
  }

}

#else
static void
_backup_video_convert_orc_convert_AYUV_BGRA (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var46;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union32 var47;
#else
  orc_union32 var47;
#endif
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union32 var53;
#else
  orc_union32 var53;
#endif
  orc_union32 var54;
  orc_union32 var55;
  orc_union16 var56;
  orc_union16 var57;
  orc_int8 var58;
  orc_int8 var59;
  orc_int8 var60;
  orc_int8 var61;
  orc_union16 var62;
  orc_union16 var63;
  orc_union16 var64;
  orc_union16 var65;
  orc_union16 var66;
  orc_union16 var67;
  orc_union16 var68;
  orc_union16 var69;
  orc_union16 var70;
  orc_union16 var71;
  orc_union16 var72;
  orc_union16 var73;
  orc_int8 var74;
  orc_int8 var75;
  orc_int8 var76;
  orc_union16 var77;
  orc_union16 var78;
  orc_union32 var79;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);

    /* 1: loadpb */
    var47.x4[0] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var47.x4[1] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var47.x4[2] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var47.x4[3] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    /* 9: loadpw */
    var48.i = ex->params[24];
    /* 11: loadpw */
    var49.i = ex->params[25];
    /* 14: loadpw */
    var50.i = ex->params[26];
    /* 17: loadpw */
    var51.i = ex->params[27];
    /* 20: loadpw */
    var52.i = ex->params[28];
    /* 29: loadpb */
    var53.x4[0] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var53.x4[1] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var53.x4[2] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var53.x4[3] = (int) 0x00000080;     /* 128 or 6.32404e-322f */

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var46 = ptr4[i];
      /* 2: subb */
      var55.x4[0] = var46.x4[0] - var47.x4[0];
      var55.x4[1] = var46.x4[1] - var47.x4[1];
      var55.x4[2] = var46.x4[2] - var47.x4[2];
      var55.x4[3] = var46.x4[3] - var47.x4[3];
      /* 3: splitlw */
      {
        orc_union32 _src;
        _src.i = var55.i;
        var56.i = _src.x2[1];
        var57.i = _src.x2[0];
      }
      /* 4: splitwb */
      {
        orc_union16 _src;
        _src.i = var57.i;
        var58 = _src.x2[1];
        var59 = _src.x2[0];
      }
      /* 5: splitwb */
      {
        orc_union16 _src;
        _src.i = var56.i;
        var60 = _src.x2[1];
        var61 = _src.x2[0];
      }
      /* 6: splatbw */
      var62.i = ((var58 & 0xff) << 8) | (var58 & 0xff);
      /* 7: splatbw */
      var63.i = ((var61 & 0xff) << 8) | (var61 & 0xff);
      /* 8: splatbw */
      var64.i = ((var60 & 0xff) << 8) | (var60 & 0xff);
      /* 10: mulhsw */
      var65.i = (var62.i * var48.i) >> 16;
      /* 12: mulhsw */
      var66.i = (var64.i * var49.i) >> 16;
      /* 13: addssw */
      var67.i = ORC_CLAMP_SW (var65.i + var66.i);
      /* 15: mulhsw */
      var68.i = (var63.i * var50.i) >> 16;
      /* 16: addssw */
      var69.i = ORC_CLAMP_SW (var65.i + var68.i);
      /* 18: mulhsw */
      var70.i = (var63.i * var51.i) >> 16;
      /* 19: addssw */
      var71.i = ORC_CLAMP_SW (var65.i + var70.i);
      /* 21: mulhsw */
      var72.i = (var64.i * var52.i) >> 16;
      /* 22: addssw */
      var73.i = ORC_CLAMP_SW (var71.i + var72.i);
      /* 23: convssswb */
      var74 = ORC_CLAMP_SB (var67.i);
      /* 24: convssswb */
      var75 = ORC_CLAMP_SB (var73.i);
      /* 25: convssswb */
      var76 = ORC_CLAMP_SB (var69.i);
      /* 26: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var76;
        _dest.x2[1] = var75;
        var77.i = _dest.i;
      }
      /* 27: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var74;
        _dest.x2[1] = var59;
        var78.i = _dest.i;
      }
      /* 28: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var77.i;
        _dest.x2[1] = var78.i;
        var79.i = _dest.i;
      }
      /* 30: addb */
      var54.x4[0] = var79.x4[0] + var53.x4[0];
      var54.x4[1] = var79.x4[1] + var53.x4[1];
      var54.x4[2] = var79.x4[2] + var53.x4[2];
      var54.x4[3] = var79.x4[3] + var53.x4[3];
      /* 31: storel */
      ptr0[i] = var54;
    }
  }

}

void
video_convert_orc_convert_AYUV_BGRA (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int p1, int p2, int p3,
    int p4, int p5, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 35, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114,
        116, 95, 111, 114, 99, 95, 99, 111, 110, 118, 101, 114, 116, 95, 65, 89,
        85, 86, 95, 66, 71, 82, 65, 11, 4, 4, 12, 4, 4, 14, 1, 128,
        0, 0, 0, 16, 2, 16, 2, 16, 2, 16, 2, 16, 2, 20, 1, 20,
        1, 20, 1, 20, 1, 20, 2, 20, 2, 20, 2, 20, 2, 20, 2, 20,
        2, 20, 1, 20, 1, 20, 1, 20, 4, 21, 2, 65, 45, 4, 16, 198,
        38, 36, 45, 199, 33, 32, 36, 199, 35, 34, 38, 151, 36, 33, 151, 37,
        34, 151, 38, 35, 90, 36, 36, 24, 90, 39, 38, 25, 71, 39, 36, 39,
        90, 41, 37, 26, 71, 41, 36, 41, 90, 40, 37, 27, 71, 40, 36, 40,
        90, 36, 38, 28, 71, 40, 40, 36, 159, 42, 39, 159, 43, 40, 159, 44,
        41, 196, 41, 44, 43, 196, 39, 42, 32, 195, 45, 41, 39, 21, 2, 33,
        0, 45, 16, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_AYUV_BGRA);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_convert_orc_convert_AYUV_BGRA");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_AYUV_BGRA);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 1, 0x00000080, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_parameter (p, 2, "p5");
      orc_program_add_temporary (p, 1, "t1");
      orc_program_add_temporary (p, 1, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");
      orc_program_add_temporary (p, 2, "t5");
      orc_program_add_temporary (p, 2, "t6");
      orc_program_add_temporary (p, 2, "t7");
      orc_program_add_temporary (p, 2, "t8");
      orc_program_add_temporary (p, 2, "t9");
      orc_program_add_temporary (p, 2, "t10");
      orc_program_add_temporary (p, 1, "t11");
      orc_program_add_temporary (p, 1, "t12");
      orc_program_add_temporary (p, 1, "t13");
      orc_program_add_temporary (p, 4, "t14");

      orc_program_append_2 (p, "subb", 2, ORC_VAR_T14, ORC_VAR_S1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T7, ORC_VAR_T5,
          ORC_VAR_T14, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_T7,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T5, ORC_VAR_T2, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T6, ORC_VAR_T3, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T7, ORC_VAR_T4, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_P1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T8, ORC_VAR_T7, ORC_VAR_P2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T8, ORC_VAR_T5, ORC_VAR_T8,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T10, ORC_VAR_T6, ORC_VAR_P3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T10, ORC_VAR_T5,
          ORC_VAR_T10, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T9, ORC_VAR_T6, ORC_VAR_P4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T9, ORC_VAR_T5, ORC_VAR_T9,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T5, ORC_VAR_T7, ORC_VAR_P5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T9, ORC_VAR_T9, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T11, ORC_VAR_T8,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T12, ORC_VAR_T9,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T13, ORC_VAR_T10,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T10, ORC_VAR_T13,
          ORC_VAR_T12, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T8, ORC_VAR_T11,
          ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T14, ORC_VAR_T10,
          ORC_VAR_T8, ORC_VAR_D1);
      orc_program_append_2 (p, "addb", 2, ORC_VAR_D1, ORC_VAR_T14, ORC_VAR_C1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;
  ex->params[ORC_VAR_P5] = p5;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_convert_AYUV_ABGR */
#ifdef DISABLE_ORC
void
video_convert_orc_convert_AYUV_ABGR (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int p1, int p2, int p3,
    int p4, int p5, int n, int m)
{
  int i;
  int j;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var46;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union32 var47;
#else
  orc_union32 var47;
#endif
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union32 var53;
#else
  orc_union32 var53;
#endif
  orc_union32 var54;
  orc_union32 var55;
  orc_union16 var56;
  orc_union16 var57;
  orc_int8 var58;
  orc_int8 var59;
  orc_int8 var60;
  orc_int8 var61;
  orc_union16 var62;
  orc_union16 var63;
  orc_union16 var64;
  orc_union16 var65;
  orc_union16 var66;
  orc_union16 var67;
  orc_union16 var68;
  orc_union16 var69;
  orc_union16 var70;
  orc_union16 var71;
  orc_union16 var72;
  orc_union16 var73;
  orc_int8 var74;
  orc_int8 var75;
  orc_int8 var76;
  orc_union16 var77;
  orc_union16 var78;
  orc_union32 var79;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);

    /* 1: loadpb */
    var47.x4[0] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var47.x4[1] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var47.x4[2] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var47.x4[3] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    /* 9: loadpw */
    var48.i = p1;
    /* 11: loadpw */
    var49.i = p2;
    /* 14: loadpw */
    var50.i = p3;
    /* 17: loadpw */
    var51.i = p4;
    /* 20: loadpw */
    var52.i = p5;
    /* 29: loadpb */
    var53.x4[0] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var53.x4[1] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var53.x4[2] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var53.x4[3] = (int) 0x00000080;     /* 128 or 6.32404e-322f */

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var46 = ptr4[i];
      /* 2: subb */
      var55.x4[0] = var46.x4[0] - var47.x4[0];
      var55.x4[1] = var46.x4[1] - var47.x4[1];
      var55.x4[2] = var46.x4[2] - var47.x4[2];
      var55.x4[3] = var46.x4[3] - var47.x4[3];
      /* 3: splitlw */
      {
        orc_union32 _src;
        _src.i = var55.i;
        var56.i = _src.x2[1];
        var57.i = _src.x2[0];
      }
      /* 4: splitwb */
      {
        orc_union16 _src;
        _src.i = var57.i;
        var58 = _src.x2[1];
        var59 = _src.x2[0];
      }
      /* 5: splitwb */
      {
        orc_union16 _src;
        _src.i = var56.i;
        var60 = _src.x2[1];
        var61 = _src.x2[0];
      }
      /* 6: splatbw */
      var62.i = ((var58 & 0xff) << 8) | (var58 & 0xff);
      /* 7: splatbw */
      var63.i = ((var61 & 0xff) << 8) | (var61 & 0xff);
      /* 8: splatbw */
      var64.i = ((var60 & 0xff) << 8) | (var60 & 0xff);
      /* 10: mulhsw */
      var65.i = (var62.i * var48.i) >> 16;
      /* 12: mulhsw */
      var66.i = (var64.i * var49.i) >> 16;
      /* 13: addssw */
      var67.i = ORC_CLAMP_SW (var65.i + var66.i);
      /* 15: mulhsw */
      var68.i = (var63.i * var50.i) >> 16;
      /* 16: addssw */
      var69.i = ORC_CLAMP_SW (var65.i + var68.i);
      /* 18: mulhsw */
      var70.i = (var63.i * var51.i) >> 16;
      /* 19: addssw */
      var71.i = ORC_CLAMP_SW (var65.i + var70.i);
      /* 21: mulhsw */
      var72.i = (var64.i * var52.i) >> 16;
      /* 22: addssw */
      var73.i = ORC_CLAMP_SW (var71.i + var72.i);
      /* 23: convssswb */
      var74 = ORC_CLAMP_SB (var67.i);
      /* 24: convssswb */
      var75 = ORC_CLAMP_SB (var73.i);
      /* 25: convssswb */
      var76 = ORC_CLAMP_SB (var69.i);
      /* 26: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var59;
        _dest.x2[1] = var76;
        var77.i = _dest.i;
      }
      /* 27: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var75;
        _dest.x2[1] = var74;
        var78.i = _dest.i;
      }
      /* 28: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var77.i;
        _dest.x2[1] = var78.i;
        var79.i = _dest.i;
      }
      /* 30: addb */
      var54.x4[0] = var79.x4[0] + var53.x4[0];
      var54.x4[1] = var79.x4[1] + var53.x4[1];
      var54.x4[2] = var79.x4[2] + var53.x4[2];
      var54.x4[3] = var79.x4[3] + var53.x4[3];
      /* 31: storel */
      ptr0[i] = var54;
    }
  }

}

#else
static void
_backup_video_convert_orc_convert_AYUV_ABGR (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var46;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union32 var47;
#else
  orc_union32 var47;
#endif
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union32 var53;
#else
  orc_union32 var53;
#endif
  orc_union32 var54;
  orc_union32 var55;
  orc_union16 var56;
  orc_union16 var57;
  orc_int8 var58;
  orc_int8 var59;
  orc_int8 var60;
  orc_int8 var61;
  orc_union16 var62;
  orc_union16 var63;
  orc_union16 var64;
  orc_union16 var65;
  orc_union16 var66;
  orc_union16 var67;
  orc_union16 var68;
  orc_union16 var69;
  orc_union16 var70;
  orc_union16 var71;
  orc_union16 var72;
  orc_union16 var73;
  orc_int8 var74;
  orc_int8 var75;
  orc_int8 var76;
  orc_union16 var77;
  orc_union16 var78;
  orc_union32 var79;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);

    /* 1: loadpb */
    var47.x4[0] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var47.x4[1] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var47.x4[2] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var47.x4[3] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    /* 9: loadpw */
    var48.i = ex->params[24];
    /* 11: loadpw */
    var49.i = ex->params[25];
    /* 14: loadpw */
    var50.i = ex->params[26];
    /* 17: loadpw */
    var51.i = ex->params[27];
    /* 20: loadpw */
    var52.i = ex->params[28];
    /* 29: loadpb */
    var53.x4[0] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var53.x4[1] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var53.x4[2] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var53.x4[3] = (int) 0x00000080;     /* 128 or 6.32404e-322f */

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var46 = ptr4[i];
      /* 2: subb */
      var55.x4[0] = var46.x4[0] - var47.x4[0];
      var55.x4[1] = var46.x4[1] - var47.x4[1];
      var55.x4[2] = var46.x4[2] - var47.x4[2];
      var55.x4[3] = var46.x4[3] - var47.x4[3];
      /* 3: splitlw */
      {
        orc_union32 _src;
        _src.i = var55.i;
        var56.i = _src.x2[1];
        var57.i = _src.x2[0];
      }
      /* 4: splitwb */
      {
        orc_union16 _src;
        _src.i = var57.i;
        var58 = _src.x2[1];
        var59 = _src.x2[0];
      }
      /* 5: splitwb */
      {
        orc_union16 _src;
        _src.i = var56.i;
        var60 = _src.x2[1];
        var61 = _src.x2[0];
      }
      /* 6: splatbw */
      var62.i = ((var58 & 0xff) << 8) | (var58 & 0xff);
      /* 7: splatbw */
      var63.i = ((var61 & 0xff) << 8) | (var61 & 0xff);
      /* 8: splatbw */
      var64.i = ((var60 & 0xff) << 8) | (var60 & 0xff);
      /* 10: mulhsw */
      var65.i = (var62.i * var48.i) >> 16;
      /* 12: mulhsw */
      var66.i = (var64.i * var49.i) >> 16;
      /* 13: addssw */
      var67.i = ORC_CLAMP_SW (var65.i + var66.i);
      /* 15: mulhsw */
      var68.i = (var63.i * var50.i) >> 16;
      /* 16: addssw */
      var69.i = ORC_CLAMP_SW (var65.i + var68.i);
      /* 18: mulhsw */
      var70.i = (var63.i * var51.i) >> 16;
      /* 19: addssw */
      var71.i = ORC_CLAMP_SW (var65.i + var70.i);
      /* 21: mulhsw */
      var72.i = (var64.i * var52.i) >> 16;
      /* 22: addssw */
      var73.i = ORC_CLAMP_SW (var71.i + var72.i);
      /* 23: convssswb */
      var74 = ORC_CLAMP_SB (var67.i);
      /* 24: convssswb */
      var75 = ORC_CLAMP_SB (var73.i);
      /* 25: convssswb */
      var76 = ORC_CLAMP_SB (var69.i);
      /* 26: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var59;
        _dest.x2[1] = var76;
        var77.i = _dest.i;
      }
      /* 27: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var75;
        _dest.x2[1] = var74;
        var78.i = _dest.i;
      }
      /* 28: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var77.i;
        _dest.x2[1] = var78.i;
        var79.i = _dest.i;
      }
      /* 30: addb */
      var54.x4[0] = var79.x4[0] + var53.x4[0];
      var54.x4[1] = var79.x4[1] + var53.x4[1];
      var54.x4[2] = var79.x4[2] + var53.x4[2];
      var54.x4[3] = var79.x4[3] + var53.x4[3];
      /* 31: storel */
      ptr0[i] = var54;
    }
  }

}

void
video_convert_orc_convert_AYUV_ABGR (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int p1, int p2, int p3,
    int p4, int p5, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 35, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114,
        116, 95, 111, 114, 99, 95, 99, 111, 110, 118, 101, 114, 116, 95, 65, 89,
        85, 86, 95, 65, 66, 71, 82, 11, 4, 4, 12, 4, 4, 14, 1, 128,
        0, 0, 0, 16, 2, 16, 2, 16, 2, 16, 2, 16, 2, 20, 1, 20,
        1, 20, 1, 20, 1, 20, 2, 20, 2, 20, 2, 20, 2, 20, 2, 20,
        2, 20, 1, 20, 1, 20, 1, 20, 4, 21, 2, 65, 45, 4, 16, 198,
        38, 36, 45, 199, 33, 32, 36, 199, 35, 34, 38, 151, 36, 33, 151, 37,
        34, 151, 38, 35, 90, 36, 36, 24, 90, 39, 38, 25, 71, 39, 36, 39,
        90, 41, 37, 26, 71, 41, 36, 41, 90, 40, 37, 27, 71, 40, 36, 40,
        90, 36, 38, 28, 71, 40, 40, 36, 159, 42, 39, 159, 43, 40, 159, 44,
        41, 196, 41, 32, 44, 196, 39, 43, 42, 195, 45, 41, 39, 21, 2, 33,
        0, 45, 16, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_AYUV_ABGR);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_convert_orc_convert_AYUV_ABGR");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_AYUV_ABGR);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 1, 0x00000080, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_parameter (p, 2, "p5");
      orc_program_add_temporary (p, 1, "t1");
      orc_program_add_temporary (p, 1, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");
      orc_program_add_temporary (p, 2, "t5");
      orc_program_add_temporary (p, 2, "t6");
      orc_program_add_temporary (p, 2, "t7");
      orc_program_add_temporary (p, 2, "t8");
      orc_program_add_temporary (p, 2, "t9");
      orc_program_add_temporary (p, 2, "t10");
      orc_program_add_temporary (p, 1, "t11");
      orc_program_add_temporary (p, 1, "t12");
      orc_program_add_temporary (p, 1, "t13");
      orc_program_add_temporary (p, 4, "t14");

      orc_program_append_2 (p, "subb", 2, ORC_VAR_T14, ORC_VAR_S1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T7, ORC_VAR_T5,
          ORC_VAR_T14, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_T7,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T5, ORC_VAR_T2, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T6, ORC_VAR_T3, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T7, ORC_VAR_T4, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_P1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T8, ORC_VAR_T7, ORC_VAR_P2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T8, ORC_VAR_T5, ORC_VAR_T8,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T10, ORC_VAR_T6, ORC_VAR_P3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T10, ORC_VAR_T5,
          ORC_VAR_T10, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T9, ORC_VAR_T6, ORC_VAR_P4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T9, ORC_VAR_T5, ORC_VAR_T9,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T5, ORC_VAR_T7, ORC_VAR_P5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T9, ORC_VAR_T9, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T11, ORC_VAR_T8,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T12, ORC_VAR_T9,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T13, ORC_VAR_T10,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T10, ORC_VAR_T1,
          ORC_VAR_T13, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T8, ORC_VAR_T12,
          ORC_VAR_T11, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T14, ORC_VAR_T10,
          ORC_VAR_T8, ORC_VAR_D1);
      orc_program_append_2 (p, "addb", 2, ORC_VAR_D1, ORC_VAR_T14, ORC_VAR_C1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;
  ex->params[ORC_VAR_P5] = p5;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_convert_AYUV_RGBA */
#ifdef DISABLE_ORC
void
video_convert_orc_convert_AYUV_RGBA (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int p1, int p2, int p3,
    int p4, int p5, int n, int m)
{
  int i;
  int j;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var46;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union32 var47;
#else
  orc_union32 var47;
#endif
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union32 var53;
#else
  orc_union32 var53;
#endif
  orc_union32 var54;
  orc_union32 var55;
  orc_union16 var56;
  orc_union16 var57;
  orc_int8 var58;
  orc_int8 var59;
  orc_int8 var60;
  orc_int8 var61;
  orc_union16 var62;
  orc_union16 var63;
  orc_union16 var64;
  orc_union16 var65;
  orc_union16 var66;
  orc_union16 var67;
  orc_union16 var68;
  orc_union16 var69;
  orc_union16 var70;
  orc_union16 var71;
  orc_union16 var72;
  orc_union16 var73;
  orc_int8 var74;
  orc_int8 var75;
  orc_int8 var76;
  orc_union16 var77;
  orc_union16 var78;
  orc_union32 var79;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);

    /* 1: loadpb */
    var47.x4[0] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var47.x4[1] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var47.x4[2] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var47.x4[3] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    /* 9: loadpw */
    var48.i = p1;
    /* 11: loadpw */
    var49.i = p2;
    /* 14: loadpw */
    var50.i = p3;
    /* 17: loadpw */
    var51.i = p4;
    /* 20: loadpw */
    var52.i = p5;
    /* 29: loadpb */
    var53.x4[0] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var53.x4[1] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var53.x4[2] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var53.x4[3] = (int) 0x00000080;     /* 128 or 6.32404e-322f */

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var46 = ptr4[i];
      /* 2: subb */
      var55.x4[0] = var46.x4[0] - var47.x4[0];
      var55.x4[1] = var46.x4[1] - var47.x4[1];
      var55.x4[2] = var46.x4[2] - var47.x4[2];
      var55.x4[3] = var46.x4[3] - var47.x4[3];
      /* 3: splitlw */
      {
        orc_union32 _src;
        _src.i = var55.i;
        var56.i = _src.x2[1];
        var57.i = _src.x2[0];
      }
      /* 4: splitwb */
      {
        orc_union16 _src;
        _src.i = var57.i;
        var58 = _src.x2[1];
        var59 = _src.x2[0];
      }
      /* 5: splitwb */
      {
        orc_union16 _src;
        _src.i = var56.i;
        var60 = _src.x2[1];
        var61 = _src.x2[0];
      }
      /* 6: splatbw */
      var62.i = ((var58 & 0xff) << 8) | (var58 & 0xff);
      /* 7: splatbw */
      var63.i = ((var61 & 0xff) << 8) | (var61 & 0xff);
      /* 8: splatbw */
      var64.i = ((var60 & 0xff) << 8) | (var60 & 0xff);
      /* 10: mulhsw */
      var65.i = (var62.i * var48.i) >> 16;
      /* 12: mulhsw */
      var66.i = (var64.i * var49.i) >> 16;
      /* 13: addssw */
      var67.i = ORC_CLAMP_SW (var65.i + var66.i);
      /* 15: mulhsw */
      var68.i = (var63.i * var50.i) >> 16;
      /* 16: addssw */
      var69.i = ORC_CLAMP_SW (var65.i + var68.i);
      /* 18: mulhsw */
      var70.i = (var63.i * var51.i) >> 16;
      /* 19: addssw */
      var71.i = ORC_CLAMP_SW (var65.i + var70.i);
      /* 21: mulhsw */
      var72.i = (var64.i * var52.i) >> 16;
      /* 22: addssw */
      var73.i = ORC_CLAMP_SW (var71.i + var72.i);
      /* 23: convssswb */
      var74 = ORC_CLAMP_SB (var67.i);
      /* 24: convssswb */
      var75 = ORC_CLAMP_SB (var73.i);
      /* 25: convssswb */
      var76 = ORC_CLAMP_SB (var69.i);
      /* 26: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var74;
        _dest.x2[1] = var75;
        var77.i = _dest.i;
      }
      /* 27: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var76;
        _dest.x2[1] = var59;
        var78.i = _dest.i;
      }
      /* 28: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var77.i;
        _dest.x2[1] = var78.i;
        var79.i = _dest.i;
      }
      /* 30: addb */
      var54.x4[0] = var79.x4[0] + var53.x4[0];
      var54.x4[1] = var79.x4[1] + var53.x4[1];
      var54.x4[2] = var79.x4[2] + var53.x4[2];
      var54.x4[3] = var79.x4[3] + var53.x4[3];
      /* 31: storel */
      ptr0[i] = var54;
    }
  }

}

#else
static void
_backup_video_convert_orc_convert_AYUV_RGBA (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var46;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union32 var47;
#else
  orc_union32 var47;
#endif
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union32 var53;
#else
  orc_union32 var53;
#endif
  orc_union32 var54;
  orc_union32 var55;
  orc_union16 var56;
  orc_union16 var57;
  orc_int8 var58;
  orc_int8 var59;
  orc_int8 var60;
  orc_int8 var61;
  orc_union16 var62;
  orc_union16 var63;
  orc_union16 var64;
  orc_union16 var65;
  orc_union16 var66;
  orc_union16 var67;
  orc_union16 var68;
  orc_union16 var69;
  orc_union16 var70;
  orc_union16 var71;
  orc_union16 var72;
  orc_union16 var73;
  orc_int8 var74;
  orc_int8 var75;
  orc_int8 var76;
  orc_union16 var77;
  orc_union16 var78;
  orc_union32 var79;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);

    /* 1: loadpb */
    var47.x4[0] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var47.x4[1] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var47.x4[2] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var47.x4[3] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    /* 9: loadpw */
    var48.i = ex->params[24];
    /* 11: loadpw */
    var49.i = ex->params[25];
    /* 14: loadpw */
    var50.i = ex->params[26];
    /* 17: loadpw */
    var51.i = ex->params[27];
    /* 20: loadpw */
    var52.i = ex->params[28];
    /* 29: loadpb */
    var53.x4[0] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var53.x4[1] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var53.x4[2] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var53.x4[3] = (int) 0x00000080;     /* 128 or 6.32404e-322f */

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var46 = ptr4[i];
      /* 2: subb */
      var55.x4[0] = var46.x4[0] - var47.x4[0];
      var55.x4[1] = var46.x4[1] - var47.x4[1];
      var55.x4[2] = var46.x4[2] - var47.x4[2];
      var55.x4[3] = var46.x4[3] - var47.x4[3];
      /* 3: splitlw */
      {
        orc_union32 _src;
        _src.i = var55.i;
        var56.i = _src.x2[1];
        var57.i = _src.x2[0];
      }
      /* 4: splitwb */
      {
        orc_union16 _src;
        _src.i = var57.i;
        var58 = _src.x2[1];
        var59 = _src.x2[0];
      }
      /* 5: splitwb */
      {
        orc_union16 _src;
        _src.i = var56.i;
        var60 = _src.x2[1];
        var61 = _src.x2[0];
      }
      /* 6: splatbw */
      var62.i = ((var58 & 0xff) << 8) | (var58 & 0xff);
      /* 7: splatbw */
      var63.i = ((var61 & 0xff) << 8) | (var61 & 0xff);
      /* 8: splatbw */
      var64.i = ((var60 & 0xff) << 8) | (var60 & 0xff);
      /* 10: mulhsw */
      var65.i = (var62.i * var48.i) >> 16;
      /* 12: mulhsw */
      var66.i = (var64.i * var49.i) >> 16;
      /* 13: addssw */
      var67.i = ORC_CLAMP_SW (var65.i + var66.i);
      /* 15: mulhsw */
      var68.i = (var63.i * var50.i) >> 16;
      /* 16: addssw */
      var69.i = ORC_CLAMP_SW (var65.i + var68.i);
      /* 18: mulhsw */
      var70.i = (var63.i * var51.i) >> 16;
      /* 19: addssw */
      var71.i = ORC_CLAMP_SW (var65.i + var70.i);
      /* 21: mulhsw */
      var72.i = (var64.i * var52.i) >> 16;
      /* 22: addssw */
      var73.i = ORC_CLAMP_SW (var71.i + var72.i);
      /* 23: convssswb */
      var74 = ORC_CLAMP_SB (var67.i);
      /* 24: convssswb */
      var75 = ORC_CLAMP_SB (var73.i);
      /* 25: convssswb */
      var76 = ORC_CLAMP_SB (var69.i);
      /* 26: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var74;
        _dest.x2[1] = var75;
        var77.i = _dest.i;
      }
      /* 27: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var76;
        _dest.x2[1] = var59;
        var78.i = _dest.i;
      }
      /* 28: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var77.i;
        _dest.x2[1] = var78.i;
        var79.i = _dest.i;
      }
      /* 30: addb */
      var54.x4[0] = var79.x4[0] + var53.x4[0];
      var54.x4[1] = var79.x4[1] + var53.x4[1];
      var54.x4[2] = var79.x4[2] + var53.x4[2];
      var54.x4[3] = var79.x4[3] + var53.x4[3];
      /* 31: storel */
      ptr0[i] = var54;
    }
  }

}

void
video_convert_orc_convert_AYUV_RGBA (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int p1, int p2, int p3,
    int p4, int p5, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 35, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114,
        116, 95, 111, 114, 99, 95, 99, 111, 110, 118, 101, 114, 116, 95, 65, 89,
        85, 86, 95, 82, 71, 66, 65, 11, 4, 4, 12, 4, 4, 14, 1, 128,
        0, 0, 0, 16, 2, 16, 2, 16, 2, 16, 2, 16, 2, 20, 1, 20,
        1, 20, 1, 20, 1, 20, 2, 20, 2, 20, 2, 20, 2, 20, 2, 20,
        2, 20, 1, 20, 1, 20, 1, 20, 4, 21, 2, 65, 45, 4, 16, 198,
        38, 36, 45, 199, 33, 32, 36, 199, 35, 34, 38, 151, 36, 33, 151, 37,
        34, 151, 38, 35, 90, 36, 36, 24, 90, 39, 38, 25, 71, 39, 36, 39,
        90, 41, 37, 26, 71, 41, 36, 41, 90, 40, 37, 27, 71, 40, 36, 40,
        90, 36, 38, 28, 71, 40, 40, 36, 159, 42, 39, 159, 43, 40, 159, 44,
        41, 196, 39, 42, 43, 196, 41, 44, 32, 195, 45, 39, 41, 21, 2, 33,
        0, 45, 16, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_AYUV_RGBA);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_convert_orc_convert_AYUV_RGBA");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_AYUV_RGBA);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 1, 0x00000080, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_parameter (p, 2, "p5");
      orc_program_add_temporary (p, 1, "t1");
      orc_program_add_temporary (p, 1, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");
      orc_program_add_temporary (p, 2, "t5");
      orc_program_add_temporary (p, 2, "t6");
      orc_program_add_temporary (p, 2, "t7");
      orc_program_add_temporary (p, 2, "t8");
      orc_program_add_temporary (p, 2, "t9");
      orc_program_add_temporary (p, 2, "t10");
      orc_program_add_temporary (p, 1, "t11");
      orc_program_add_temporary (p, 1, "t12");
      orc_program_add_temporary (p, 1, "t13");
      orc_program_add_temporary (p, 4, "t14");

      orc_program_append_2 (p, "subb", 2, ORC_VAR_T14, ORC_VAR_S1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T7, ORC_VAR_T5,
          ORC_VAR_T14, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_T7,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T5, ORC_VAR_T2, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T6, ORC_VAR_T3, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T7, ORC_VAR_T4, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_P1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T8, ORC_VAR_T7, ORC_VAR_P2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T8, ORC_VAR_T5, ORC_VAR_T8,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T10, ORC_VAR_T6, ORC_VAR_P3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T10, ORC_VAR_T5,
          ORC_VAR_T10, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T9, ORC_VAR_T6, ORC_VAR_P4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T9, ORC_VAR_T5, ORC_VAR_T9,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T5, ORC_VAR_T7, ORC_VAR_P5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T9, ORC_VAR_T9, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T11, ORC_VAR_T8,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T12, ORC_VAR_T9,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T13, ORC_VAR_T10,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T8, ORC_VAR_T11,
          ORC_VAR_T12, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T10, ORC_VAR_T13,
          ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T14, ORC_VAR_T8,
          ORC_VAR_T10, ORC_VAR_D1);
      orc_program_append_2 (p, "addb", 2, ORC_VAR_D1, ORC_VAR_T14, ORC_VAR_C1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;
  ex->params[ORC_VAR_P5] = p5;

  func = c->exec;
  func (ex);
}
#endif


/* video_convert_orc_convert_I420_BGRA */
#ifdef DISABLE_ORC
void
video_convert_orc_convert_I420_BGRA (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, int p1, int p2, int p3, int p4, int p5,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_int8 var42;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_int8 var43;
#else
  orc_int8 var43;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_int8 var44;
#else
  orc_int8 var44;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_int8 var45;
#else
  orc_int8 var45;
#endif
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_int8 var51;
#else
  orc_int8 var51;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union32 var52;
#else
  orc_union32 var52;
#endif
  orc_union32 var53;
  orc_int8 var54;
  orc_union16 var55;
  orc_int8 var56;
  orc_int8 var57;
  orc_union16 var58;
  orc_int8 var59;
  orc_int8 var60;
  orc_union16 var61;
  orc_union16 var62;
  orc_union16 var63;
  orc_union16 var64;
  orc_union16 var65;
  orc_union16 var66;
  orc_union16 var67;
  orc_union16 var68;
  orc_union16 var69;
  orc_union16 var70;
  orc_int8 var71;
  orc_int8 var72;
  orc_int8 var73;
  orc_union16 var74;
  orc_union16 var75;
  orc_union32 var76;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_int8 *) s1;
  ptr5 = (orc_int8 *) s2;
  ptr6 = (orc_int8 *) s3;

  /* 1: loadpb */
  var43 = (int) 0x00000080;     /* 128 or 6.32404e-322f */
  /* 5: loadpb */
  var44 = (int) 0x00000080;     /* 128 or 6.32404e-322f */
  /* 9: loadpb */
  var45 = (int) 0x00000080;     /* 128 or 6.32404e-322f */
  /* 12: loadpw */
  var46.i = p1;
  /* 14: loadpw */
  var47.i = p2;
  /* 17: loadpw */
  var48.i = p3;
  /* 20: loadpw */
  var49.i = p4;
  /* 23: loadpw */
  var50.i = p5;
  /* 30: loadpb */
  var51 = (int) 0x0000007f;     /* 127 or 6.27463e-322f */
  /* 33: loadpb */
  var52.x4[0] = (int) 0x00000080;       /* 128 or 6.32404e-322f */
  var52.x4[1] = (int) 0x00000080;       /* 128 or 6.32404e-322f */
  var52.x4[2] = (int) 0x00000080;       /* 128 or 6.32404e-322f */
  var52.x4[3] = (int) 0x00000080;       /* 128 or 6.32404e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var42 = ptr4[i];
    /* 2: subb */
    var54 = var42 - var43;
    /* 3: splatbw */
    var55.i = ((var54 & 0xff) << 8) | (var54 & 0xff);
    /* 4: loadupdb */
    var56 = ptr5[i >> 1];
    /* 6: subb */
    var57 = var56 - var44;
    /* 7: splatbw */
    var58.i = ((var57 & 0xff) << 8) | (var57 & 0xff);
    /* 8: loadupdb */
    var59 = ptr6[i >> 1];
    /* 10: subb */
    var60 = var59 - var45;
    /* 11: splatbw */
    var61.i = ((var60 & 0xff) << 8) | (var60 & 0xff);
    /* 13: mulhsw */
    var62.i = (var55.i * var46.i) >> 16;
    /* 15: mulhsw */
    var63.i = (var61.i * var47.i) >> 16;
    /* 16: addssw */
    var64.i = ORC_CLAMP_SW (var62.i + var63.i);
    /* 18: mulhsw */
    var65.i = (var58.i * var48.i) >> 16;
    /* 19: addssw */
    var66.i = ORC_CLAMP_SW (var62.i + var65.i);
    /* 21: mulhsw */
    var67.i = (var58.i * var49.i) >> 16;
    /* 22: addssw */
    var68.i = ORC_CLAMP_SW (var62.i + var67.i);
    /* 24: mulhsw */
    var69.i = (var61.i * var50.i) >> 16;
    /* 25: addssw */
    var70.i = ORC_CLAMP_SW (var68.i + var69.i);
    /* 26: convssswb */
    var71 = ORC_CLAMP_SB (var64.i);
    /* 27: convssswb */
    var72 = ORC_CLAMP_SB (var70.i);
    /* 28: convssswb */
    var73 = ORC_CLAMP_SB (var66.i);
    /* 29: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var73;
      _dest.x2[1] = var72;
      var74.i = _dest.i;
    }
    /* 31: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var71;
      _dest.x2[1] = var51;
      var75.i = _dest.i;
    }
    /* 32: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var74.i;
      _dest.x2[1] = var75.i;
      var76.i = _dest.i;
    }
    /* 34: addb */
    var53.x4[0] = var76.x4[0] + var52.x4[0];
    var53.x4[1] = var76.x4[1] + var52.x4[1];
    var53.x4[2] = var76.x4[2] + var52.x4[2];
    var53.x4[3] = var76.x4[3] + var52.x4[3];
    /* 35: storel */
    ptr0[i] = var53;
  }

}

#else
static void
_backup_video_convert_orc_convert_I420_BGRA (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_int8 var42;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_int8 var43;
#else
  orc_int8 var43;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_int8 var44;
#else
  orc_int8 var44;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_int8 var45;
#else
  orc_int8 var45;
#endif
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_int8 var51;
#else
  orc_int8 var51;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union32 var52;
#else
  orc_union32 var52;
#endif
  orc_union32 var53;
  orc_int8 var54;
  orc_union16 var55;
  orc_int8 var56;
  orc_int8 var57;
  orc_union16 var58;
  orc_int8 var59;
  orc_int8 var60;
  orc_union16 var61;
  orc_union16 var62;
  orc_union16 var63;
  orc_union16 var64;
  orc_union16 var65;
  orc_union16 var66;
  orc_union16 var67;
  orc_union16 var68;
  orc_union16 var69;
  orc_union16 var70;
  orc_int8 var71;
  orc_int8 var72;
  orc_int8 var73;
  orc_union16 var74;
  orc_union16 var75;
  orc_union32 var76;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_int8 *) ex->arrays[4];
  ptr5 = (orc_int8 *) ex->arrays[5];
  ptr6 = (orc_int8 *) ex->arrays[6];

  /* 1: loadpb */
  var43 = (int) 0x00000080;     /* 128 or 6.32404e-322f */
  /* 5: loadpb */
  var44 = (int) 0x00000080;     /* 128 or 6.32404e-322f */
  /* 9: loadpb */
  var45 = (int) 0x00000080;     /* 128 or 6.32404e-322f */
  /* 12: loadpw */
  var46.i = ex->params[24];
  /* 14: loadpw */
  var47.i = ex->params[25];
  /* 17: loadpw */
  var48.i = ex->params[26];
  /* 20: loadpw */
  var49.i = ex->params[27];
  /* 23: loadpw */
  var50.i = ex->params[28];
  /* 30: loadpb */
  var51 = (int) 0x0000007f;     /* 127 or 6.27463e-322f */
  /* 33: loadpb */
  var52.x4[0] = (int) 0x00000080;       /* 128 or 6.32404e-322f */
  var52.x4[1] = (int) 0x00000080;       /* 128 or 6.32404e-322f */
  var52.x4[2] = (int) 0x00000080;       /* 128 or 6.32404e-322f */
  var52.x4[3] = (int) 0x00000080;       /* 128 or 6.32404e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var42 = ptr4[i];
    /* 2: subb */
    var54 = var42 - var43;
    /* 3: splatbw */
    var55.i = ((var54 & 0xff) << 8) | (var54 & 0xff);
    /* 4: loadupdb */
    var56 = ptr5[i >> 1];
    /* 6: subb */
    var57 = var56 - var44;
    /* 7: splatbw */
    var58.i = ((var57 & 0xff) << 8) | (var57 & 0xff);
    /* 8: loadupdb */
    var59 = ptr6[i >> 1];
    /* 10: subb */
    var60 = var59 - var45;
    /* 11: splatbw */
    var61.i = ((var60 & 0xff) << 8) | (var60 & 0xff);
    /* 13: mulhsw */
    var62.i = (var55.i * var46.i) >> 16;
    /* 15: mulhsw */
    var63.i = (var61.i * var47.i) >> 16;
    /* 16: addssw */
    var64.i = ORC_CLAMP_SW (var62.i + var63.i);
    /* 18: mulhsw */
    var65.i = (var58.i * var48.i) >> 16;
    /* 19: addssw */
    var66.i = ORC_CLAMP_SW (var62.i + var65.i);
    /* 21: mulhsw */
    var67.i = (var58.i * var49.i) >> 16;
    /* 22: addssw */
    var68.i = ORC_CLAMP_SW (var62.i + var67.i);
    /* 24: mulhsw */
    var69.i = (var61.i * var50.i) >> 16;
    /* 25: addssw */
    var70.i = ORC_CLAMP_SW (var68.i + var69.i);
    /* 26: convssswb */
    var71 = ORC_CLAMP_SB (var64.i);
    /* 27: convssswb */
    var72 = ORC_CLAMP_SB (var70.i);
    /* 28: convssswb */
    var73 = ORC_CLAMP_SB (var66.i);
    /* 29: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var73;
      _dest.x2[1] = var72;
      var74.i = _dest.i;
    }
    /* 31: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var71;
      _dest.x2[1] = var51;
      var75.i = _dest.i;
    }
    /* 32: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var74.i;
      _dest.x2[1] = var75.i;
      var76.i = _dest.i;
    }
    /* 34: addb */
    var53.x4[0] = var76.x4[0] + var52.x4[0];
    var53.x4[1] = var76.x4[1] + var52.x4[1];
    var53.x4[2] = var76.x4[2] + var52.x4[2];
    var53.x4[3] = var76.x4[3] + var52.x4[3];
    /* 35: storel */
    ptr0[i] = var53;
  }

}

void
video_convert_orc_convert_I420_BGRA (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, int p1, int p2, int p3, int p4, int p5,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 35, 118, 105, 100, 101, 111, 95, 99, 111, 110, 118, 101, 114, 116,
        95, 111, 114, 99, 95, 99, 111, 110, 118, 101, 114, 116, 95, 73, 52, 50,
        48, 95, 66, 71, 82, 65, 11, 4, 4, 12, 1, 1, 12, 1, 1, 12,
        1, 1, 14, 1, 128, 0, 0, 0, 14, 4, 127, 0, 0, 0, 16, 2,
        16, 2, 16, 2, 16, 2, 16, 2, 20, 2, 20, 2, 20, 2, 20, 2,
        20, 2, 20, 2, 20, 1, 20, 1, 20, 1, 20, 4, 65, 38, 4, 16,
        151, 32, 38, 45, 38, 5, 65, 38, 38, 16, 151, 33, 38, 45, 38, 6,
        65, 38, 38, 16, 151, 34, 38, 90, 32, 32, 24, 90, 35, 34, 25, 71,
        35, 32, 35, 90, 37, 33, 26, 71, 37, 32, 37, 90, 36, 33, 27, 71,
        36, 32, 36, 90, 32, 34, 28, 71, 36, 36, 32, 159, 38, 35, 159, 39,
        36, 159, 40, 37, 196, 37, 40, 39, 196, 35, 38, 17, 195, 41, 37, 35,
        21, 2, 33, 0, 41, 16, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_I420_BGRA);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_convert_orc_convert_I420_BGRA");
      orc_program_set_backup_function (p,
          _backup_video_convert_orc_convert_I420_BGRA);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_constant (p, 1, 0x00000080, "c1");
      orc_program_add_constant (p, 4, 0x0000007f, "c2");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_parameter (p, 2, "p5");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 2, "t5");
      orc_program_add_temporary (p, 2, "t6");
      orc_program_add_temporary (p, 1, "t7");
      orc_program_add_temporary (p, 1, "t8");
      orc_program_add_temporary (p, 1, "t9");
      orc_program_add_temporary (p, 4, "t10");

      orc_program_append_2 (p, "subb", 0, ORC_VAR_T7, ORC_VAR_S1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T1, ORC_VAR_T7, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "loadupdb", 0, ORC_VAR_T7, ORC_VAR_S2,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subb", 0, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T2, ORC_VAR_T7, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "loadupdb", 0, ORC_VAR_T7, ORC_VAR_S3,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subb", 0, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T3, ORC_VAR_T7, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_P2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T4, ORC_VAR_T1, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T6, ORC_VAR_T2, ORC_VAR_P3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T6, ORC_VAR_T1, ORC_VAR_T6,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T5, ORC_VAR_T2, ORC_VAR_P4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T5, ORC_VAR_T1, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_P5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T7, ORC_VAR_T4,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T8, ORC_VAR_T5,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T9, ORC_VAR_T6,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T6, ORC_VAR_T9, ORC_VAR_T8,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T4, ORC_VAR_T7, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T10, ORC_VAR_T6,
          ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "addb", 2, ORC_VAR_D1, ORC_VAR_T10, ORC_VAR_C1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->arrays[ORC_VAR_S3] = (void *) s3;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;
  ex->params[ORC_VAR_P5] = p5;

  func = c->exec;
  func (ex);
}
#endif
