/* Copyright (C) 1999-2000 Aaron Lehmann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */



#include <stdio.h>

#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "gtkplot.h"
#include "gtksheet.h"

#include "app.h"
#include "calc.h"
#include "prefs.h"
#include "mathparsesym.h"
#include "mathparse.h"
#include "history.h"
#include "xpm/history-mini.xpm"
#include "command_line.h"

GtkWidget *dlg;
GtkWidget *text, *eqnentry;
GdkFont *fixed_font;
GdkColor fntcolor;

symrec *ptr;
extern int yyparse ();

struct mp_stack *ouridx[2][2];


void calc_new (void)
{
    GtkWidget *vscrollbar, *vbox, *hbox, *hbox1, *label, *button, *pixmapwid, *frame;
    GtkTooltips *tooltips;
    GdkColormap *cmap;
    GdkPixmap *pixmap;
    GdkBitmap *mask;
    GtkStyle *style;
    
    ouridx[0][0] = 0;
    ouridx[0][1] = 0;
    ouridx[1][0] = 0;
    ouridx[1][1] = 0;

    dlg = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_widget_set_usize (dlg, 500, 350);
    gtk_window_set_policy (GTK_WINDOW(dlg), TRUE, TRUE, TRUE);
    gtk_signal_connect (GTK_OBJECT(dlg), "delete-event", GTK_SIGNAL_FUNC(calc_hide), GTK_OBJECT(dlg));
    gtk_window_set_title (GTK_WINDOW(dlg), "GtkGraph Arithmatic Window");
    gtk_container_set_border_width (GTK_CONTAINER(dlg), 0);
    gtk_widget_realize (dlg);

    vbox = gtk_vbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (dlg), vbox);
    gtk_widget_show (vbox);
    
    hbox=gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX(vbox), hbox, TRUE, TRUE, 0);
    gtk_widget_show (hbox);
    
    text = gtk_text_new (NULL, NULL);
    gtk_text_set_editable (GTK_TEXT(text), FALSE);
    gtk_box_pack_start (GTK_BOX(hbox), text, TRUE, TRUE, 0);
    gtk_widget_show (text);
    
    /* Add a vertical scrollbar to the GtkText widget */
    vscrollbar = gtk_vscrollbar_new (GTK_TEXT (text)->vadj);
    gtk_box_pack_start (GTK_BOX(hbox), vscrollbar, FALSE, FALSE, 0);
    gtk_widget_show (vscrollbar);


    /* Get the system color map and allocate the color red */
    cmap = gdk_colormap_get_system();
    fntcolor.red = 0xffff;
    fntcolor.green = 0;
    fntcolor.blue = 0;
    if (!gdk_color_alloc(cmap, &fntcolor)) {
	g_error(_("Couldn't allocate color"));
    }
    /* Load a fixed font */
    fixed_font = gdk_font_load ("-misc-fixed-medium-r-normal-*-13-*-*-*-c-*-iso8859-1");
    /* Realizing a widget creates a window for it,
     * ready for us to insert some text */
    gtk_widget_realize (text);
    
    hbox=gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
    gtk_widget_show (hbox);
    
    label = gtk_label_new (_("Expression:   "));
    gtk_box_pack_start (GTK_BOX(hbox), label, FALSE, FALSE, 0);
    gtk_widget_show (label);
    
    eqnentry = gtk_entry_new_with_max_length(512);
    gtk_box_pack_start (GTK_BOX(hbox), eqnentry, TRUE, TRUE, 0);
    gtk_widget_show (eqnentry);
    
    gtk_signal_connect(GTK_OBJECT(eqnentry), "key_press_event",
		       GTK_SIGNAL_FUNC(commandKey_event),
		       NULL);
    
    hbox1=gtk_hbox_new (TRUE, 0);
    gtk_widget_show (hbox1);
    
    button = gtk_button_new();
    gtk_signal_connect (GTK_OBJECT(button), "button_press_event",
			GTK_SIGNAL_FUNC(showHistory_signal),
			NULL);
    gtk_widget_set_usize(GTK_WIDGET(button), 13, 10);
    gtk_box_pack_start (GTK_BOX(hbox1), button, TRUE, TRUE, 0);
    
    tooltips = gtk_tooltips_new ();
    gtk_tooltips_set_tip (tooltips, button, "History", NULL);
    
    style = gtk_widget_get_style (dlg);
    pixmap = gdk_pixmap_create_from_xpm_d (dlg->window, &mask, &style->bg[GTK_STATE_NORMAL], (gchar **)history_mini_xpm);
    pixmapwid = gtk_pixmap_new (pixmap, mask);
    gtk_container_add(GTK_CONTAINER(button), pixmapwid);
    gtk_widget_show (button);
    gtk_widget_show (pixmapwid);
    
    
    frame = gtk_frame_new(NULL);
    gtk_container_set_border_width(GTK_CONTAINER(frame), 1);
    gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_IN);
    gtk_container_add(GTK_CONTAINER(frame), hbox1);
    gtk_box_pack_start(GTK_BOX(hbox), frame, FALSE, FALSE, 0);
    gtk_widget_show (frame);
    
    
    button = gtk_button_new_with_label (_("Evaluate"));
    gtk_box_pack_start (GTK_BOX(hbox), button, FALSE, FALSE, 0);
    gtk_widget_show (button);
    gtk_signal_connect (GTK_OBJECT (button), "clicked", GTK_SIGNAL_FUNC (calc_eval), NULL);
    
    ptr = getsym ("a");
}


void calc_show (GtkWidget *w, gpointer data)
{
    gtk_widget_show (dlg);
}


gboolean calc_hide (GtkObject *w, gpointer data)
{
    gtk_widget_hide (dlg);
    return (TRUE);
}


void calc_eval (GtkWidget *w, gpointer data)
{
    extern short flagend, initial;
    extern char *c;
    extern int historyPosition;
    extern short parseerr;
    extern struct mp_stack **entryidx[2][2];
    extern func_thing *formn;
    char ascii[30];
    int err = -1;
    double result;
    
    entryidx[0][0] = &ouridx[0][0];
    entryidx[0][1] = &ouridx[0][1];
    entryidx[1][0] = &ouridx[1][0];
    entryidx[1][1] = &ouridx[1][1];

    mp_stack_clean ();
    initial=1;
    flagend=0;
    formn=0; /* This is a single expression - not a function */

    c = gtk_entry_get_text (GTK_ENTRY(eqnentry));


    yyparse ();
    
    if (!parseerr) /* Parsed successfully */
    {
	result = mp_eval_exp (0, &err);
	if (err == -1)
	{
	    sprintf (ascii, "%-20.13g", result);
	    ptr->value.var = result;
	}
	else
	{
	    sprintf (ascii, "%s", "Some kind of error - sorry");
	    ptr->value.var = 0;
	    parseerr = 1;
	}
    }
    gtk_text_freeze (GTK_TEXT(text));
    gtk_text_insert (GTK_TEXT(text), fixed_font, NULL, NULL, gtk_entry_get_text (GTK_ENTRY(eqnentry)), -1);
    gtk_text_insert (GTK_TEXT(text), fixed_font, NULL, NULL, "\n", -1);
    if (!parseerr) /* Parsed successfully */
	gtk_text_insert (GTK_TEXT(text), fixed_font, &fntcolor, NULL, ascii, -1);
    else
	gtk_text_insert (GTK_TEXT(text), fixed_font, &fntcolor, NULL, "Syntax error", -1);
    gtk_text_insert (GTK_TEXT(text), fixed_font, NULL, NULL, "\n\n", -1);
    gtk_text_thaw (GTK_TEXT(text));
    gtk_adjustment_set_value (GTK_TEXT(text)->vadj, GTK_TEXT (text)->vadj->upper - GTK_TEXT (text)->vadj->lower - GTK_TEXT (text)->vadj->page_size);
    mp_fix_stack ();
    appendHistoryEntry((char *) gtk_entry_get_text(GTK_ENTRY(eqnentry)));
    historyPosition = HISTORY_DEPTH-1;
    
    if (!prf.errappend || !parseerr)
    {
	switch (prf.calcmode)
	{
	case CALCMODE_CLEAR:
	    gtk_editable_delete_text (GTK_EDITABLE(eqnentry), 0, -1); /* Clear field */	
	    historyPosition = HISTORY_DEPTH;
	    break;
	case CALCMODE_SELECT:
	    gtk_editable_select_region (GTK_EDITABLE(eqnentry), 0, -1); /* Select field */
	    break;
	default:
	    /* Do nothing */
	    break;
	}
    }
    
    
    
  parseerr = 0;
}


void calc_key (char *string)
{
    int pos = 0;
    int pos2 = gtk_editable_get_position (GTK_EDITABLE(eqnentry));
    int changed=0;
    
    if (!gtk_editable_get_position (GTK_EDITABLE(eqnentry)) && !GTK_EDITABLE(eqnentry)->has_selection)
  {
      gtk_editable_insert_text (GTK_EDITABLE(eqnentry), "a", 1, &pos);
      pos = 1;
      changed = 1;
  }
    else if (GTK_EDITABLE(eqnentry)->selection_start_pos == 0 && GTK_EDITABLE(eqnentry)->has_selection)
    {
	gtk_editable_delete_selection (GTK_EDITABLE(eqnentry));
	gtk_editable_insert_text (GTK_EDITABLE(eqnentry), "a", 1, &pos);
	pos = 1;
	changed = 1;
    }
    if (GTK_EDITABLE(eqnentry)->has_selection) gtk_editable_delete_selection (GTK_EDITABLE(eqnentry));
    if (!changed) { gtk_editable_insert_text (GTK_EDITABLE(eqnentry), string, 1, &pos2);
    pos2 = gtk_editable_get_position (GTK_EDITABLE(eqnentry)); }
  else
  {
      gtk_editable_insert_text (GTK_EDITABLE(eqnentry), string, 1, &pos);
      pos = 1;
  }
    if (!changed) gtk_editable_set_position (GTK_EDITABLE(eqnentry), pos2
	);
    else gtk_editable_set_position (GTK_EDITABLE(eqnentry), ++pos
	);
    
}
