/* 
 * Copyright (c) Tony Bybell 1999.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 */

#ifndef WAVE_DEBUG_H
#define WAVE_DEBUG_H

#include <stdlib.h>
#include <stdio.h>

struct memchunk
{
struct memchunk *next;
void *ptr;
size_t size;
};


/*
 * If you have problems viewing traces (mangled timevalues),
 * make sure that you use longs rather than the glib 64-bit
 * types...
 */
#define G_HAVE_GINT64
#define gint64 long long
#define guint64 unsigned long long

#ifdef G_HAVE_GINT64
typedef gint64          TimeType; 
typedef guint64         UTimeType;

#ifndef _MSC_VER
#define LLDescriptor(x) x##LL
#define ULLDescriptor(x) x##ULL
#define TTFormat "%lld"
#else
#define LLDescriptor(x) x##i64
#define ULLDescriptor(x) x##i64
#define TTFormat "%I64d"
#endif

#else
typedef long            TimeType; 
typedef unsigned long   UTimeType;

#define TTFormat "%d"
#define LLDescriptor(x) x
#define ULLDescriptor(x) x
#endif


#ifdef DEBUG_PRINTF
#define DEBUG(x) x
#else
#define DEBUG(x)
#endif

#ifdef DEBUG_MALLOC
#define DEBUG_M(x) x
#else
#define DEBUG_M(x)
#endif

void *malloc_2(size_t size);
void *realloc_2(void *ptr, size_t size);
void *calloc_2(size_t nmemb, size_t size);
void free_2(void *ptr);

TimeType atoi_64(char *str);

/*
 * if your system really doesn't have alloca() at all, 
 * you can force functionality by using malloc
 * instead.  but note that you're going to have some
 * memory leaks because of it.  you have been warned.
 */

#ifndef __sun__
#ifndef alloca
#define alloca __alloca
#endif
#else
#include <alloca.h>
#endif

#define wave_alloca alloca


#endif
