//$Id: session.h,v 1.3 2001/11/06 12:54:53 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_SESSION_H
#define GUIKACHU_SESSION_H

#include <string>
#include <vector>
#include <gnome--/main.h>

namespace Guikachu
{
    class Main: public Gnome::Main
    {
	static Main *instance_;

	poptContext              ctx;
	std::string              cmd_self;
	std::vector<std::string> cmd_arguments;
	std::string              last_filename;
	
    public:
	Main (int argc, char **argv);
	static inline Main *instance () { return instance_; };
	virtual ~Main ();

	const std::vector<std::string>& get_cmd_arguments ();
	
	void   set_filename (const std::string &filename);

    private:
	int    session_save_cb (int                phase,
				GnomeSaveStyle     save_style,
				gint               is_shutdown,
				GnomeInteractStyle interact_style,
				int                is_fast);
	void   session_die_cb  ();
	
	void   save_open_file ();
    };
}

#endif /* !GUIKACHU_SESSION_H */
