//$Id: storage.cc,v 1.2 2001/11/06 12:54:53 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "storage.h"

#include <gnome-xml/parser.h>
#include <glib.h>

using namespace Guikachu;

Storage::Storage ():
    doc (xmlNewDoc ((xmlChar*)"1.0"))
{
}

Storage::~Storage ()
{
    if (doc)
	xmlFreeDoc (doc);
}

bool Storage::load (const std::string &filename)
{
    if (doc)
	xmlFreeDoc (doc);
    
    doc = xmlParseFile (filename.c_str ());

    return (doc != 0);
}

void Storage::save (const std::string &filename) const
{
    g_return_if_fail (doc != 0);
    if (!doc)
	return;
    
    xmlSaveFile (filename.c_str (), doc);
}

StorageNode Storage::get_root () const
{
    g_return_val_if_fail (doc != 0, 0);
    
    return StorageNode (xmlDocGetRootElement (doc));
}

void Storage::set_root (StorageNode &node)
{
    g_return_if_fail (doc != 0);
    
    xmlDocSetRootElement (doc, node.c_node ());
}

StorageNode Storage::create_root (const std::string &name)
{
    g_return_val_if_fail (doc != 0, 0);
    
    xmlNodePtr root_node = xmlNewNode (NULL, (xmlChar*) name.c_str ());
    xmlDocSetRootElement (doc, root_node);

    return StorageNode (root_node);
}
