with Ada.Text_IO; use Ada.Text_IO;
with GNAT.Exception_Traces; use GNAT.Exception_Traces;

procedure Tasking is

   task Simple_Task is
      entry E (I : Integer);
   end Simple_Task;

   task body Simple_Task is
      Value : Integer := 0;

      task Delay_Task;

      task body Delay_Task is
      begin
         Put_Line ("In task Delay_Task");
         delay 3.0;
      end Delay_Task;

   begin
      Put_Line ("In task Simple_Task");
      accept E (I : Integer) do
         Value := I + 1;
      end E;
   end Simple_Task;

   task Complex_Task;

   task body Complex_Task is

      task Select_Task is
         entry E1;
         entry E2;
         entry E3;
      end Select_Task;

      task body Select_Task is
      begin
         Put_Line ("In task Select_Task");
         select
            accept E1;
         or
            accept E2;
            Put_Line ("In accept E2");
         or
            accept E3;
         or
            delay 2.0;
            Put_Line ("Delay expired");
         end select;
      end Select_Task;


   begin
      Put_Line ("In Task Complex_Task");
      delay 0.5;
      Simple_Task.E (12);
      delay 5.0;
      Select_Task.E2;
   end Complex_Task;

begin
   Trace_On (Unhandled_Raise);
end Tasking;
