/*
 *  FileOperation.h: Interface and declarations for the FileOperation Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef FILEOPERATION_H
#define FILEOPERATION_H

#import <Foundation/NSObject.h>
#include "FileOperationProtocol.h"

@class NSString;
@class NSMutableArray;
@class NSMutableDictionary;
@class NSView;
@class NSTextField;
@class NSImageView;
@class NSButton;
@class NSFileManager;
@class GWorkspace;

@interface FileOperation: NSObject <FileOperationProtocol>
{
	NSString *operation;
	NSString *source;
	NSString *destination;
	NSMutableArray *files;
  NSMutableDictionary *operationDict;
  NSView *taskAlerts;
  BOOL mustusealerts, usingalerts;
  NSString *myLabel;
  NSTextField *fileField, *sourceField, *destField;
  NSTextField *label1, *label2, *label3;     
  int filescount;
	int stopped;
  int steps;
  float stepdegr;  
  NSImageView *timerView;
  NSButton *stopButt;
  NSFileManager *fm;
  GWorkspace *gw;
}

- (id)initWithOperation:(NSString *)opr
                 source:(NSString *)src
		 	      destination:(NSString *)dest
                  files:(NSArray *)fls;

- (void)prepareViewForProcsWin;

- (void)updateTimerImage;

- (void)stopOperation:(id)sender;

- (void)sendWillChangeNotification;

- (NSView *)taskAlerts;

- (NSString *)myLabel;

- (BOOL)usingalerts;

- (BOOL)showFileOperationAlert;

- (void)connectionDidDie:(NSNotification *)notification;
                 
@end

#endif // FILEOPERATION_H
