/*  -*-objc-*-
 *  FileOperation.m: Implementation of the FileOperation Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#include "FileOperation.h"
#include "GWorkspace.h"
#include "Functions.h"
#include "GNUstep.h"

extern NSString *GWFileSystemWillChangeNotification;
extern NSString *GWFileSystemDidChangeNotification;

extern NSString *GWorkspaceRecycleOutOperation;
extern NSString *GWorkspaceEmptyRecyclerOperation;

@implementation FileOperation

- (void)dealloc
{
	[[NSNotificationCenter defaultCenter] removeObserver: self];
  TEST_RELEASE (fileField);
  TEST_RELEASE (sourceField);
  TEST_RELEASE (destField);
  TEST_RELEASE (label1);
  TEST_RELEASE (label2);
  TEST_RELEASE (label3);
  TEST_RELEASE (timerView);
  TEST_RELEASE (stopButt);
  TEST_RELEASE (taskAlerts);
  TEST_RELEASE (myLabel);
  TEST_RELEASE (operation);
  TEST_RELEASE (source);
  TEST_RELEASE (destination);
  TEST_RELEASE (operationDict);
  TEST_RELEASE (files);
  [super dealloc];
}

- (id)initWithOperation:(NSString *)opr
                 source:(NSString *)src
		 	      destination:(NSString *)dest
                  files:(NSArray *)fls
{
	self = [super init];
  
  if (self) {
    int i;
    
    gw = [GWorkspace gworkspace];
    fm = [NSFileManager defaultManager];
       
		operation = [[NSString alloc] initWithString: opr];
    operationDict = [[NSMutableDictionary alloc] initWithCapacity: 1];
    [operationDict setObject: operation forKey: @"operation"]; 

		if (src != nil) {
			source = [[NSString alloc] initWithString: src];
      [operationDict setObject: source forKey: @"source"]; 
		}
		if (dest != nil) {
			destination = [[NSString alloc] initWithString: dest];
      [operationDict setObject: destination forKey: @"destination"]; 
		}
		if (fls != nil) {
			files = [[NSMutableArray alloc] initWithCapacity: 1];	
			for(i = 0; i < [fls count]; i++) {
				[files addObject: [fls objectAtIndex: i]];
      }
      [operationDict setObject: files forKey: @"files"]; 
		}
    
    if ([operation isEqualToString: NSWorkspaceMoveOperation]
        || [operation isEqualToString: NSWorkspaceCopyOperation] 
          || [operation isEqualToString: NSWorkspaceLinkOperation]
						|| [operation isEqualToString: NSWorkspaceRecycleOperation]) {
      myLabel = [[NSString alloc] initWithFormat: @"%@/", source];
      mustusealerts = YES;
    } else if ([operation isEqualToString: GWorkspaceRecycleOutOperation]) {
      myLabel = [[NSString alloc] initWithString: NSLocalizedString(@"Recycler", @"")];
      mustusealerts = YES;		
		} else if ([operation isEqualToString: GWorkspaceEmptyRecyclerOperation]) {
      myLabel = [[NSString alloc] initWithString: NSLocalizedString(@"Recycler", @"")];
      mustusealerts = YES;
    } else if ([operation isEqualToString: NSWorkspaceDuplicateOperation]
        || [operation isEqualToString: NSWorkspaceDestroyOperation]) {
      myLabel = [[NSString alloc] initWithFormat: @"%@/", destination];
      mustusealerts = YES;
    } else {
      mustusealerts = NO; 
    }
    
    if([self showFileOperationAlert] == NO) {                	        
      [self endOperation];
      return self; 
           										
    } else {
      NSDictionary *env;
      NSString *cmd;
	    NSString *connName;
      NSConnection *connection;
      NSTask *tsk;
      NSArray *taskargs;
      int ref;
			
			stopped = 0;
      [self sendWillChangeNotification];
      
      ref = [gw fileOperationRef];
      connName = [NSString stringWithFormat: @"file_operation_with_ref_%i", ref];

		#ifdef GNUSTEP
			connection = [NSConnection newRegisteringAtName: connName 
                                       withRootObject: self];
    #else  
  		connection = [[NSConnection alloc] initWithReceivePort: [NSPort port] 
																										sendPort: nil];
  		[connection setRootObject: self];
			[connection registerName: connName];
		#endif		
		  
      [[NSNotificationCenter defaultCenter] addObserver: self
                        selector: @selector(connectionDidDie:)
                            name: NSConnectionDidDieNotification
                          object: connection];    

      env = [[NSProcessInfo processInfo] environment];
      taskargs = [NSArray arrayWithObject: [NSString stringWithFormat: @"%i", ref]];
//      cmd = [NSString stringWithFormat: @"%@/Tools/backgrounder", 
//                                    [env objectForKey: @"GNUSTEP_SYSTEM_ROOT"]];
      cmd = @"backgrounder";
  
      tsk = [NSTask launchedTaskWithLaunchPath: cmd arguments: taskargs];
    }
	}			

	return self;
}

- (void)prepareViewForProcsWin
{ 
  NSString *label1str, *label2str, *sourcestr, *deststr;
  int label1width;
  NSRect rect;
  
  if ([operation isEqualToString: NSWorkspaceMoveOperation]) {
    label1str = NSLocalizedString(@"Moving", @"");
    label2str = NSLocalizedString(@"From:", @""); 
    sourcestr = source;
    deststr = destination;
    label1width = 72; 
  } else if ([operation isEqualToString: NSWorkspaceCopyOperation]) {
    label1str = NSLocalizedString(@"Copying", @"");
    label2str = NSLocalizedString(@"From:", @"");
    sourcestr = source;
    deststr = destination;
    label1width = 81; 
  } else if ([operation isEqualToString: NSWorkspaceLinkOperation]) {
    label1str = NSLocalizedString(@"Linking", @"");
    label2str = NSLocalizedString(@"From:", @""); 
    sourcestr = source;
    deststr = destination;
    label1width = 82;
  } else if ([operation isEqualToString: NSWorkspaceRecycleOperation]) {
    label1str = NSLocalizedString(@"Moving", @"");
    label2str = NSLocalizedString(@"From:", @""); 
    sourcestr = source;
    deststr = NSLocalizedString(@"the Recycler", @"");
    label1width = 72;		
  } else if ([operation isEqualToString: GWorkspaceEmptyRecyclerOperation]) {
    label1str = NSLocalizedString(@"Destroying", @"");
    label2str = NSLocalizedString(@"In", @""); 
    sourcestr = NSLocalizedString(@"the Recycler", @"");
    deststr = NSLocalizedString(@"the Recycler", @"");
    label1width = 72;		
  } else if ([operation isEqualToString: GWorkspaceRecycleOutOperation]) {
    label1str = NSLocalizedString(@"Moving", @"");
    label2str = NSLocalizedString(@"From:", @""); 
    sourcestr = NSLocalizedString(@"the Recycler", @"");
    deststr = destination;
    label1width = 72;		
  } else if ([operation isEqualToString: NSWorkspaceDuplicateOperation]) {
    label1str = NSLocalizedString(@"Duplicating", @"");
    label2str = NSLocalizedString(@"In:", @"");  
    sourcestr = destination;
    label1width = 103;
  } else if ([operation isEqualToString: NSWorkspaceDestroyOperation]) {
    label1str = NSLocalizedString(@"Destroying", @"");
    label2str = NSLocalizedString(@"In:", @"");
    sourcestr = destination;
    label1width = 100;
  }
  
  taskAlerts = [[NSView alloc] initWithFrame: NSMakeRect(0, 0, 366, 150)];
   
  rect = NSMakeRect(5, 104, label1width, 25);
  label1 = [[NSTextField alloc] initWithFrame: rect];	
  [label1 setFont: [NSFont systemFontOfSize: 18]];
  [label1 setAlignment: NSLeftTextAlignment];
	[label1 setBackgroundColor: [NSColor windowBackgroundColor]];
	[label1 setBezeled: NO];
	[label1 setEditable: NO];
	[label1 setSelectable: NO];
  [label1 setStringValue: label1str];
  [taskAlerts addSubview: label1]; 

  rect = NSMakeRect(label1width, 104, 290 - label1width, 25);
  fileField = [[NSTextField alloc] initWithFrame: rect];	
  [fileField setFont: [NSFont systemFontOfSize: 18]];
  [fileField setAlignment: NSLeftTextAlignment];
	[fileField setBackgroundColor: [NSColor windowBackgroundColor]];
	[fileField setBezeled: NO];
	[fileField setEditable: NO];
	[fileField setSelectable: NO];
  [taskAlerts addSubview: fileField]; 
  
  rect = NSMakeRect(304, 95, 48, 48);
  timerView = [[NSImageView alloc] initWithFrame: rect];
  [timerView setImageFrameStyle: NSImageFrameNone];
  [timerView setEditable: NO];
  [taskAlerts addSubview: timerView];

  rect = NSMakeRect(0, 65, 39, 20);
  label2 = [[NSTextField alloc] initWithFrame: rect];	
  [label2 setFont: [NSFont systemFontOfSize: 12]];
  [label2 setAlignment: NSRightTextAlignment];
	[label2 setBackgroundColor: [NSColor windowBackgroundColor]];
	[label2 setBezeled: NO];
	[label2 setEditable: NO];
	[label2 setSelectable: NO];
  [label2 setStringValue: label2str];
  [taskAlerts addSubview: label2]; 

  rect = NSMakeRect(45, 65, 313, 20);
  sourceField = [[NSTextField alloc] initWithFrame: rect];	
  [sourceField setFont: [NSFont systemFontOfSize: 12]];
  [sourceField setAlignment: NSLeftTextAlignment];
	[sourceField setBackgroundColor: [NSColor windowBackgroundColor]];
	[sourceField setBezeled: NO];
	[sourceField setEditable: NO];
	[sourceField setSelectable: NO];
  [sourceField setStringValue: sourcestr];
  [taskAlerts addSubview: sourceField]; 

  if ([label2str isEqualToString: NSLocalizedString(@"From:", @"")]) {
    rect = NSMakeRect(0, 43, 39, 20);
    label3 = [[NSTextField alloc] initWithFrame: rect];	
    [label3 setFont: [NSFont systemFontOfSize: 12]];
    [label3 setAlignment: NSRightTextAlignment];
	  [label3 setBackgroundColor: [NSColor windowBackgroundColor]];
	  [label3 setBezeled: NO];
	  [label3 setEditable: NO];
	  [label3 setSelectable: NO];
    [label3 setStringValue: NSLocalizedString(@"To:", @"")];
    [taskAlerts addSubview: label3]; 
  
    rect = NSMakeRect(45, 43, 313, 20);
    destField = [[NSTextField alloc] initWithFrame: rect];	
    [destField setFont: [NSFont systemFontOfSize: 12]];
    [destField setAlignment: NSLeftTextAlignment];
	  [destField setBackgroundColor: [NSColor windowBackgroundColor]];
	  [destField setBezeled: NO];
	  [destField setEditable: NO];
	  [destField setSelectable: NO];
    [destField setStringValue: deststr];
    [taskAlerts addSubview: destField]; 
  }

  rect = NSMakeRect(277, 4, 88, 24);
 	stopButt = [[NSButton alloc] initWithFrame: rect];
	[stopButt setButtonType: NSMomentaryLight];
	[stopButt setTitle: NSLocalizedString(@"Stop", @"")];		
	[stopButt setTarget: self];
	[stopButt setAction: @selector(stopOperation:)];
	[taskAlerts addSubview: stopButt]; 
}

- (void)updateTimerImage
{
/*  NSImage *image;
  NSBezierPath *circlePath, *slicePath;
  NSRect rect;
  float slicedegr;

  steps++;
  slicedegr = steps * stepdegr;
  
  image = [[NSImage alloc] initWithSize: NSMakeSize(48, 48)];
  
  [image lockFocus];
  [[NSColor windowBackgroundColor] set];
  rect = NSMakeRect(0, 0, 48, 48);
  NSRectFill (rect);

  rect = NSMakeRect(2, 2, 44, 44);
  circlePath = [NSBezierPath bezierPathWithOvalInRect: rect];
  [circlePath setLineWidth: 1];

  slicePath = [NSBezierPath bezierPath];
  [slicePath moveToPoint: NSMakePoint(24, 24)];
  [slicePath lineToPoint: NSMakePoint(24, 45)];
  [slicePath appendBezierPathWithArcWithCenter: NSMakePoint(24, 24)
			  radius: 21 startAngle: 90 endAngle: 90 + slicedegr clockwise: YES];
  [slicePath closePath];
  
  PSsetrgbcolor(0.5, 0.5, 0.5);      
  [slicePath fill];  
  PSsetrgbcolor(0, 0, 0);  
  [slicePath stroke];
  [circlePath stroke];   
  [image unlockFocus];
  
  [timerView setImage: image];  
  RELEASE (image);
*/
}

- (void)stopOperation:(id)sender
{
	stopped = 1;
}

- (void)sendWillChangeNotification
{
  NSString *fulldestpath;
	NSMutableDictionary *dict;
  NSMutableArray *fnames;
  int i;
  
  fnames = [NSMutableArray arrayWithCapacity: [files count] -1];
  
  if ([operation isEqualToString: NSWorkspaceDuplicateOperation]) {       
    for(i = 0; i < [files count]; i++) {
      NSString *name = [files objectAtIndex: i];     
			while(1) {
				name = [name stringByAppendingString: @"_copy"];
				fulldestpath = [destination stringByAppendingPathComponent: name];        
				if (![fm fileExistsAtPath: fulldestpath]) {          
          [fnames addObject: name];
					break;
        }
			}
    }
  } else {
    [fnames addObjectsFromArray: files];
  }
  
	dict = [NSMutableDictionary dictionaryWithCapacity: 1];		
	[dict setObject: operation forKey: @"operation"];	
  [dict setObject: source forKey: @"source"];	
  [dict setObject: destination forKey: @"destination"];	
  [dict setObject: fnames forKey: @"files"];	

	[[NSNotificationCenter defaultCenter]
 				postNotificationName: GWFileSystemWillChangeNotification
	 								object: dict];
}

- (NSView *)taskAlerts
{
  return taskAlerts;
}

- (NSString *)myLabel
{
  return myLabel;
}

- (BOOL)usingalerts
{
  return usingalerts;
}

- (BOOL)showFileOperationAlert
{
	NSString *title;
	NSString *msg, *msg1, *msg2;
	int result;
		
	if ([operation isEqualToString: NSWorkspaceMoveOperation]) {
		title = NSLocalizedString(@"Move", @"");
		msg1 = NSLocalizedString(@"Move from: ", @"");
		msg2 = NSLocalizedString(@"\nto: ", @"");
		msg = [NSString stringWithFormat: @"%@%@%@%@?", msg1, source, msg2, destination];
	}
	if ([operation isEqualToString: NSWorkspaceCopyOperation]) {
		title = NSLocalizedString(@"Copy", @"");
		msg1 = NSLocalizedString(@"Copy from: ", @"");
		msg2 = NSLocalizedString(@"\nto: ", @"");
		msg = [NSString stringWithFormat: @"%@%@%@%@?", msg1, source, msg2, destination];
	}
	if ([operation isEqualToString: NSWorkspaceLinkOperation]) {
		title = NSLocalizedString(@"Link", @"");
		msg1 = NSLocalizedString(@"Link ", @"");
		msg2 = NSLocalizedString(@"\nto: ", @"");
		msg = [NSString stringWithFormat: @"%@%@%@%@?", msg1, source, msg2, destination];
	}
	if ([operation isEqualToString: NSWorkspaceRecycleOperation]) {
		title = NSLocalizedString(@"Recycler", @"");
		msg1 = NSLocalizedString(@"Move from: ", @"");
		msg2 = NSLocalizedString(@"\nto the Recycler", @"");
		msg = [NSString stringWithFormat: @"%@%@%@?", msg1, source, msg2];
	}
	if ([operation isEqualToString: GWorkspaceRecycleOutOperation]) {
		title = NSLocalizedString(@"Recycler", @"");
		msg1 = NSLocalizedString(@"Move from the Recycler ", @"");
		msg2 = NSLocalizedString(@"\nto: ", @"");
		msg = [NSString stringWithFormat: @"%@%@%@?", msg1, msg2, destination];
	}	
	if ([operation isEqualToString: GWorkspaceEmptyRecyclerOperation]) {
		title = NSLocalizedString(@"Recycler", @"");
		msg = NSLocalizedString(@"Empty the Recycler?", @"");
	}	
	if ([operation isEqualToString: NSWorkspaceDestroyOperation]) {
		title = NSLocalizedString(@"Delete", @"");
		msg = NSLocalizedString(@"Delete the selected objects?", @"");
	}
	if ([operation isEqualToString: NSWorkspaceDuplicateOperation]) {
		title = NSLocalizedString(@"Duplicate", @"");
		msg = NSLocalizedString(@"Duplicate the selected objects?", @"");
	}
	
	result = NSRunAlertPanel(title, msg, NSLocalizedString(@"OK", @""), 
																		NSLocalizedString(@"Cancel", @""), NULL);
	if (result != NSAlertDefaultReturn) {
		return NO;
  }
	
	return YES;	
}

//
// FileOperationProtocol
//
- (NSDictionary *)operationDict
{ 
  return operationDict;
}

- (int)requestUserConfirmationWithMessage:(NSString *)message 
                                    title:(NSString *)title
{
  return NSRunAlertPanel(NSLocalizedString(title, @""),
														NSLocalizedString(message, @""),
																NSLocalizedString(@"OK", @""), 
																		NSLocalizedString(@"Cancel", @""), NULL);
}

- (int)prepareAlertViewsWithFilesCount:(int)fcount
{
  filescount = fcount;    
  usingalerts = (mustusealerts && (filescount > 1)) ? YES : NO;
              
  if (usingalerts == YES) {
    steps = 0;
    stepdegr = 360 / filescount;
    [self prepareViewForProcsWin];    
    [gw addAlertsFromFileOperation: self];
    [taskAlerts setNeedsDisplay: YES];
  }
  return 0;
}

- (int)updateAlertsForFileName:(NSString *)name
{
	if (usingalerts == YES) {    
    [fileField setStringValue: name];
    [fileField setNeedsDisplay: YES];
 //   [self updateTimerImage];
//    [timerView setNeedsDisplay: YES];
  }
  return stopped;
}

- (int)sendDidChangeNotification
{
  NSMutableDictionary *notifObj; 
  NSMutableArray *fnames;
  int i;

  fnames = [NSMutableArray arrayWithCapacity: 1];

  if ([operation isEqualToString: NSWorkspaceDuplicateOperation]) {  
    NSString *fulldestpath;
     
    for(i = 0; i < [files count]; i++) {
      NSString *name = [files objectAtIndex: i];  
			   
			while(1) {
				name = [name stringByAppendingString: @"_copy"];
				
				fulldestpath = [destination stringByAppendingPathComponent: name]; 
				       
				if ([fm fileExistsAtPath: fulldestpath]) {   
					NSString *test = [name stringByAppendingString: @"_copy"];
					
					fulldestpath = [destination stringByAppendingPathComponent: test];        
					
					if ([fm fileExistsAtPath: fulldestpath] == NO) { 
          	[fnames addObject: name];
						break;
					}
        }
			}
    }
  } else {
    [fnames addObjectsFromArray: files];
  }
  
	notifObj = [NSMutableDictionary dictionaryWithCapacity: 1];		
	[notifObj setObject: operation forKey: @"operation"];	
  [notifObj setObject: source forKey: @"source"];	
  [notifObj setObject: destination forKey: @"destination"];	
  [notifObj setObject: fnames forKey: @"files"];	

	[[NSNotificationCenter defaultCenter]
 				postNotificationName: GWFileSystemDidChangeNotification
	 								object: notifObj];
  return 0;
}

- (int)showErrorAlertWithMessage:(NSString *)message
{
  return NSRunAlertPanel(nil, NSLocalizedString(message, @""), 
																NSLocalizedString(@"Continue", @""), nil, nil);
}

- (void)endOperation
{  
  if (usingalerts == YES) {
    [fileField removeFromSuperview];
    [sourceField removeFromSuperview];      
    if ([[label2 stringValue] isEqualToString: @"From:"]) { 
      [destField removeFromSuperview];
      [label3 removeFromSuperview];
    }        
    [label2 removeFromSuperview];
    [timerView removeFromSuperview];
    [stopButt removeFromSuperview];
    [label1 setFrame: NSMakeRect(5, 104, 300, 25)];      
    [label1 setStringValue: NSLocalizedString(@"File Operation Completed", @"")];
    [label1 setNeedsDisplay: YES];

    [[NSRunLoop currentRunLoop] runUntilDate: [NSDate dateWithTimeIntervalSinceNow: 1.0]];
  }

  [gw fileOperationDone: self];  
}

- (void)connectionDidDie:(NSNotification *)notification
{
	id connection = [notification object];
	NSString *msg = NSLocalizedString(@"Backgrounder connection died!", @"");
	NSString *buttstr = NSLocalizedString(@"Continue", @"");
	
  [[NSNotificationCenter defaultCenter] removeObserver: self
	      name: NSConnectionDidDieNotification object: connection];

  NSRunAlertPanel(nil, msg, buttstr, nil, nil);
  [self sendDidChangeNotification];
  [self endOperation];
}

@end
