/*
 *  GWorkspace.h: Principal Class  
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef GWORKSPACE_H
#define GWORKSPACE_H

#import <AppKit/NSApplication.h>

#define NOEDIT 0
#define NOXTERM 1

typedef enum { 
	byname,
	bykind,
	bydate, 
	bysize,
	byowner
} SortType;

@class NSString;
@class NSArray;
@class NSMutableArray;
@class NSMutableDictionary;
@class NSNotification;
@class NSTimer;
@class NSFileManager;
@class NSWorkspace;
@class ViewersWindow;
@class InspectorsWin;
@class PreferencesWin;
@class Finder;
@class Processes;
@class FileOperation;
@class Watcher;
@class Fiend;
@class Recycler;
@class History;
	#ifdef GNUSTEP 
@class DesktopWindow;
@class DesktopView;
	#endif

@interface GWorkspace : NSObject
{
	NSString *defEditor, *defXterm, *defXtermArgs;
	SortType defSortType;
	
  NSMutableArray *bgdOpsArr;
  
	InspectorsWin *inspectorsWin;
	NSArray *selectedPaths;
	
  Processes *processes;
  Finder *finder;
  PreferencesWin *prefWin;
  Fiend *fiend;
  History *history;
	
  ViewersWindow *rootViewer, *currentViewer;	
  NSMutableArray *viewers;
	NSMutableArray *viewersDescription;

#ifdef GNUSTEP  
  DesktopWindow *desktopWindow;
#endif
		
	Recycler *recycler;
	NSString *trashPath;
	
	NSMutableDictionary *dirsSortTypeDict;

  NSMutableArray *watchers;
	NSMutableArray *watchTimers;
	      
  NSMutableDictionary *geometryDict;
  
	NSMutableDictionary *smallIconsDict;
      
  NSFileManager *fm;
  NSWorkspace *ws;
}

+ (GWorkspace *)gworkspace;

+ (void)registerForServices;

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification;

- (BOOL)applicationShouldTerminate:(NSApplication *)app;

- (void)createMenu;

- (NSString *)defEditor;

- (NSString *)defXterm;

- (NSString *)defXtermArgs;

- (History *)historyWindow;

#ifdef GNUSTEP 
	- (id)desktopView;	
	- (void)showHideDesktop:(BOOL)active;
#endif

- (id)rootViewer;

- (void)changeDefaultEditor:(NSString *)editor;

- (void)changeDefaultXTerm:(NSString *)xterm arguments:(NSString *)args;
                             
- (void)updateDefaults;
					 
- (void)startXTermOnDirectory:(NSString *)dirPath;

- (void)fileOperationDone:(FileOperation *)ops;

- (SortType)sortTypeForDirectoryAtPath:(NSString *)aPath;

- (SortType)defaultSortType;

- (void)setSortType:(SortType)type forDirectoryAtPath:(NSString *)aPath;

- (void)setDefaultSortType:(SortType)type;

- (int)shelfCellsWidth; 

- (int)defaultShelfCellsWidth; 

- (void)setShelfCellsWidth:(int)w; 

- (int)iconViewCellsWidth; 

- (int)defaultIconViewCellsWidth; 

- (void)setIconViewCellsWidth:(int)w; 

- (int)browserColumnsWidth;

- (int)defaultBrowserColumnsWidth;

- (void)setBrowserColumnsWidth:(int)w; 

- (void)createRecycler;

- (NSString *)trashPath;

- (NSImage *)smallIconForFile:(NSString*)aPath;

- (NSImage *)smallIconForFiles:(NSArray*)pathArray;

- (void)makeViewersDescription;

- (void)updateViewersDescription:(NSArray *)newDescription;

- (NSArray *)viewersPaths;

- (ViewersWindow *)newViewerAtPath:(NSString *)path canViewApps:(BOOL)viewapps;

- (void)viewerHasClosed:(id)sender;

- (void)setCurrentViewer:(ViewersWindow *)viewer;

- (NSArray *)viewersDescription;

- (int)fileOperationRef;

- (void)addAlertsFromFileOperation:(FileOperation *)ops; 
           
- (void)setSelectedPaths:(NSArray *)paths;

#ifdef GNUSTEP 
	- (void)setSelectedPaths:(NSArray *)paths fromDeskTopView:(DesktopView *)view;
#endif

- (void)openSelectedPaths:(NSArray *)paths newViewer:(BOOL)newv;

- (NSArray *)selectedPaths;

- (void)closeInspectors;

- (void)closePreferences;

- (void)newObject:(BOOL)directory;

- (void)duplicateFiles;

- (void)deleteFiles;

- (BOOL)verifyFileAtPath:(NSString *)path;

- (id)connectApplication:(NSString *)appName;

- (id)validRequestorForSendType:(NSString *)sendType
                     returnType:(NSString *)returnType;
										 
//
// Menu Operations
//
- (void)closeMainWin:(id)sender;

- (void)showInfo:(id)sender;

- (void)showPreferences:(id)sender;

- (void)showViewer:(id)sender;

- (void)showHistory:(id)sender;

- (void)showInspector:(id)sender;

- (void)showAttributesInspector:(id)sender;

- (void)showContentsInspector:(id)sender;

- (void)showToolsInspector:(id)sender;

- (void)showPermissionsInspector:(id)sender;

- (void)showProsesses:(id)sender;

- (void)showFinder:(id)sender;

- (void)showFiend:(id)sender;

- (void)hideFiend:(id)sender;

- (void)addFiendLayer:(id)sender;

- (void)removeFiendLayer:(id)sender;

- (void)startXTerm:(id)sender;

- (void)emptyRecycler:(id)sender;

- (void)putAway:(id)sender;

@end

@interface GWorkspace (WorkspaceMethods)

- (BOOL)openFile:(NSString *)fullPath;

- (BOOL)performFileOperation:(NSString *)operation 
                      source:(NSString *)source 
                 destination:(NSString *)destination 
                       files:(NSArray *)files 
                         tag:(int *)tag;

- (BOOL)selectFile:(NSString *)fullPath
							inFileViewerRootedAtPath:(NSString *)rootFullpath;

- (BOOL)openFile:(NSString *)fullPath 
			 fromImage:(NSImage *)anImage 
			  			at:(NSPoint)point 
					inView:(NSView *)aView;
					
- (void)slideImage:(NSImage *)image 
							from:(NSPoint)fromPoint 
								to:(NSPoint)toPoint;

- (void)noteFileSystemChanged;

- (void)noteFileSystemChanged:(NSString *)path;

@end

@interface GWorkspace (FileWatchers)

- (void)addWatcherForPath:(NSString *)path;

- (void)removeWatcherForPath:(NSString *)path;

- (void)removeWatcher:(Watcher *)awatcher;

- (Watcher *)watcherForPath:(NSString *)path;

- (NSTimer *)timerForPath:(NSString *)path;

- (void)watcherTimeOut:(id)sender;

@end

#endif // GWORKSPACE_H
