/*  -*-objc-*-
 *  AppsView.m: Implementation of the AppsView Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#include "AppsView.h"
#include "ToolsPanel.h"
#include "InspectorsProtocol.h"
#include "Functions.h"
#include "GNUstep.h"

@implementation AppsView

- (void)dealloc
{
	RELEASE (insppaths);
  RELEASE (extensions);
	TEST_RELEASE (currentApp);
	RELEASE (scroll);
	RELEASE (matrix);
	RELEASE (defAppField);
	RELEASE (defPathField);			
  [super dealloc];
}

- (id)initInPanel:(id)apanel withFrame:(NSRect)frame
{ 
	self = [super init];
	
	if(self) {
    id label, cell;

		[self setFrame: frame];
    ws = [NSWorkspace sharedWorkspace];
		panel = apanel;
		             
		MAKE_LOCALIZED_LABEL(label, NSMakeRect(0, 219, 257, 20), 
						@"Double-click to open selected document(s)", @"", 'c', YES, self);
		[label setTextColor: [NSColor grayColor]];	
		    
    scroll = [[NSScrollView alloc] initWithFrame: NSMakeRect(30, 120, 197, 87)];
    [scroll setHasHorizontalScroller: YES];
    [scroll setHasVerticalScroller: NO]; 
    [scroll setAutoresizingMask: NSViewHeightSizable | NSViewWidthSizable];
    [self addSubview: scroll]; 

  	cell = AUTORELEASE ([NSButtonCell new]);
  	[cell setButtonType: NSPushOnPushOffButton];
  	[cell setImagePosition: NSImageOnly]; 

  	matrix = [[NSMatrix alloc] initWithFrame: NSZeroRect
			      	  					mode: NSRadioModeMatrix prototype: cell
		       							    			numberOfRows: 0 numberOfColumns: 0];
		[matrix setIntercellSpacing: NSZeroSize];
		[matrix setCellSize: NSMakeSize(64, 64)];
  	[matrix setTarget: self];		
  	[matrix setAction: @selector(setCurrentApplication:)];		
  	[matrix setDoubleAction: @selector(openFile:)];		    
		[scroll setDocumentView: matrix];	
				
		MAKE_LOCALIZED_LABEL(label, NSMakeRect(0, 82, 47, 20), @"Default:", @"", 'r', YES, self);
		MAKE_LABEL(defAppField, NSMakeRect(52, 82, 200, 20), nil, 'l', NO, self);
		MAKE_LOCALIZED_LABEL(label, NSMakeRect(0, 54, 47, 20), @"Path:", @"", 'r', YES, self);
		MAKE_LABEL(defPathField, NSMakeRect(53, 54, 195, 20), nil, 'l', NO, self);
		MAKE_LOCALIZED_LABEL(label, NSMakeRect(2, 7, 253, 40), 
				@"Click 'Set Default' to set default application\nfor all documents with this extension", @"", 'c', YES, self);
		[label setTextColor: [NSColor grayColor]];	
    
		currentApp = nil;
	  buttOk = [panel okButton];
    [buttOk setEnabled: NO]; 
    buttCancel = [panel revertButton];	
    [buttCancel setEnabled: NO];         
	}
	
	return self;
}

- (void)setPaths:(NSArray *)paths
{
	NSMutableDictionary *extensionsAndApps;
  NSMutableArray *commonApps;   
  NSString *s;
	id cell;
	BOOL appsforext;
  int i, count;
		
  ASSIGN (insppaths, paths);

	TEST_RELEASE (extensions);
  extensions = [[NSMutableArray alloc] initWithCapacity: 1];
  extensionsAndApps = [NSMutableDictionary dictionaryWithCapacity: 1];

	DESTROY (currentApp);
	[defAppField setStringValue: @""];
	[defPathField setStringValue: @""];

	appsforext = YES;
	
  for (i = 0; i < [insppaths count]; i++) {
    NSString *ext = [[insppaths objectAtIndex: i] pathExtension];		

    if ([extensions containsObject: ext] == NO) { 
		  NSDictionary *extinfo;
						
			#ifdef GNUSTEP
				extinfo = [ws infoForExtension: ext];
			#else
				extinfo = nil;
			#endif
			
      if (extinfo != nil) {
		    NSMutableArray *appsnames = [NSMutableArray arrayWithCapacity: 1];
				[appsnames addObjectsFromArray: [extinfo allKeys]];
        [extensionsAndApps setObject: appsnames forKey: ext];
				[extensions addObject: ext];				
      } else {
				appsforext = NO;
			}
    }            
  }   
				
  if ([extensions count] == 1) {
    NSString *ext = [extensions objectAtIndex: 0];
    commonApps = [NSArray arrayWithArray: [extensionsAndApps objectForKey: ext]];
    
		#ifdef GNUSTEP
			currentApp = [ws getBestAppInRole: nil forExtension: ext];
		#else
			currentApp = nil;
		#endif

		if (currentApp != nil) {
			RETAIN (currentApp);			
    } 
		
  } else {
    int j, n;
		
		for (i = 0; i < [extensions count]; i++) {
			NSString *ext1 = [extensions objectAtIndex: i];
			NSMutableArray *a1 = [extensionsAndApps objectForKey: ext1];			
			
			for (j = 0; j < [extensions count]; j++) {
				NSString *ext2 = [extensions objectAtIndex: j];
				NSMutableArray *a2 = [extensionsAndApps objectForKey: ext2];
				
				count = [a1 count];			
				for (n = 0; n < count; n++) {
					NSString *s = [a1 objectAtIndex: n];
					if ([a2 containsObject: s] == NO) {
						[a1 removeObject: s];
						count--;
						n--;
					}
				}
				[extensionsAndApps setObject: a1 forKey: ext1];
			}
		}

    commonApps = [NSMutableArray arrayWithCapacity: 1];

    for (i = 0; i < [extensions count]; i++) {
      NSString *ext = [extensions objectAtIndex: i];
			NSArray *apps = [extensionsAndApps objectForKey: ext];
			
			for (j = 0; j < [apps count]; j++) {
				NSString *app = [apps objectAtIndex: j];
				if ([commonApps containsObject: app] == NO) {
					[commonApps addObject: app];
				}
			}
    }
		
		if ([commonApps count] != 0) {
			BOOL iscommapp = YES;		
			NSString *ext1 = [extensions objectAtIndex: 0];
			currentApp = [ws getBestAppInRole: nil forExtension: ext1];
			
			if ([commonApps containsObject: currentApp]) {
    		for (i = 1; i < [extensions count]; i++) {
					NSString *ext2 = [extensions objectAtIndex: i];
					NSString *app = [ws getBestAppInRole: nil forExtension: ext2];

					if ([currentApp isEqual: app] == NO) {
						iscommapp = NO;
					}
    		}
			} else {
				currentApp = nil;
			}
			
			if ((iscommapp == YES) && (currentApp != nil) && appsforext) {
				RETAIN (currentApp);		
			} else {
				currentApp = nil;
			}
		}
  }

  if (([commonApps count] != 0) && (currentApp != nil) && (appsforext == YES)) {
    [buttOk setTarget: self];	
    [buttOk setAction: @selector(setDefaultApplication:)];
 	  [buttOk setEnabled: YES];
  }	
	
	count = [commonApps count];
	
	[scroll setFrame: NSMakeRect(30, 120, 197, 87)];
	[matrix renewRows: 1 columns: count];
	[matrix sizeToCells];
	
	if (appsforext == YES) {
		for(i = 0; i < count; i++) {
			NSString *appName = [commonApps objectAtIndex: i];
			NSString *appPath = [ws fullPathForApplication: appName];
			cell = [matrix cellAtRow: 0 column: i];
			[cell setImage: [ws iconForFile: appPath]];
			[cell setTitle: appName];
		}
		[matrix sizeToCells];
	}
	
	if(currentApp != nil) {
		NSArray *cells = [matrix cells];
		
		for(i = 0; i < [cells count]; i++) {
			cell = [cells objectAtIndex: i];
			if(cell && ([[cell title] isEqualToString: currentApp])) {
				[matrix selectCellAtRow: 0 column: i];
				[matrix scrollCellToVisibleAtRow: 0 column: i];
				break;
			}
		}

	  [defAppField setStringValue: [currentApp stringByDeletingPathExtension]];
    s = [ws fullPathForApplication: currentApp];
		if (s != nil) {
    	s = relativePathFittingInContainer(defPathField, s);
		} else {
			s = @"";
		}
	  [defPathField setStringValue: s];
	}
}

- (void)setCurrentApplication:(id)sender
{
  NSString *s;
	
	ASSIGN (currentApp, [[sender selectedCell] title]);	
  s = [ws fullPathForApplication: currentApp];
  s = relativePathFittingInContainer(defPathField, s);
	[defPathField setStringValue: s];
  [defAppField setStringValue: [currentApp stringByDeletingPathExtension]];  
}

- (void)setDefaultApplication:(id)sender
{
  NSString *ext, *app;
  NSArray *cells;
  NSMutableArray *newApps;
  id cell;
  int i, count;
  
  for (i = 0; i < [extensions count]; i++) {
    ext = [extensions objectAtIndex: i];  		
		#ifdef GNUSTEP
    	[ws setBestApp: currentApp inRole: nil forExtension: ext];    
		#endif	
  }
  
  newApps = [NSMutableArray arrayWithCapacity: 1];
  [newApps addObject: currentApp];
  
  cells = [matrix cells];
	for(i = 0; i < [cells count]; i++) {
    app = [[cells objectAtIndex: i] title];
		if([app isEqualToString: currentApp] == NO) {
      [newApps addObject: app];
		}
  }
  
	count = [newApps count];
	[matrix renewRows: 1 columns: count];
  
  for(i = 0; i < count; i++) {
		app = [newApps objectAtIndex: i];
		cell = [matrix cellAtRow: 0 column: i];
		[cell setTitle: app];
		app = [ws fullPathForApplication: app];
		[cell setImage: [ws iconForFile: app]];
	}

  [matrix selectCellAtRow: 0 column: 0];
}

- (void)openFile:(id)sender
{
  int i;
  
  for (i = 0; i < [insppaths count]; i++) {
    NSString *fpath = [insppaths objectAtIndex: i];
	  [ws openFile: fpath withApplication: [[sender selectedCell] title]];
  }
}

@end
