/*
 *  Interface and declarations for the ViewersPrefsView Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef VIEWERSPREFS_H
#define VIEWERSPREFS_H

#import <AppKit/NSView.h>
#import <AppKit/NSBox.h>

@class NSArray;
@class NSMutableArray;
@class NSImageView;
@class NSColor;
@class NSButton;
@class GWorkspace;

@interface ViewersBox : NSBox
{
	NSColor *backColor;
}

@end

@interface ViewersPrefsView : NSView
{
	ViewersBox *vwrBox;
  NSImageView *imView;
	NSButton *leftButt, *rightButt;
	NSButton *chooseButt;
	NSButton *setButt, *revertButt;
	NSMutableArray *viewersDescription; 
	NSArray *revertDescription; 
	int vwrindex;
  GWorkspace *gw;  
}

- (void)showViewer:(id)sender;

- (void)addRemoveViewer:(id)sender;

- (void)activateChanges:(id)sender;

- (void)revertToDefaults:(id)sender;

- (NSString *)prefsname;

@end

#endif // VIEWERSPREFS_H
