/*  -*-objc-*-
 *  Banner.m: Implementation of the Banner Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2002 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: February 2002
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#include "Banner.h"
#include "PathsPopUp.h"
#include "GNUstep.h"

@implementation Banner

- (void)dealloc
{
	RELEASE (leftLabel);
	RELEASE (pathsPopUp);
	RELEASE (rightLabel);	
  [super dealloc];
}

- (id)init
{
	self = [super initWithFrame: NSZeroRect];

	if (self) {
		leftLabel = [[NSTextField alloc] initWithFrame: NSZeroRect];	
		[leftLabel setAlignment: NSLeftTextAlignment];
		[leftLabel setBackgroundColor: [NSColor windowBackgroundColor]];
		[leftLabel setTextColor: [NSColor grayColor]];
		[leftLabel setFont: [NSFont systemFontOfSize: 10]];
		[leftLabel setBezeled: NO];
		[leftLabel setEditable: NO];
		[leftLabel setSelectable: NO];
		[leftLabel setStringValue: @""];
    [self addSubview: leftLabel]; 

		pathsPopUp = [[PathsPopUp alloc] initWithFrame: NSZeroRect pullsDown: NO];
		[self addSubview: pathsPopUp];   
		
		rightLabel = [[NSTextField alloc] initWithFrame: NSZeroRect];	
		[rightLabel setAlignment: NSRightTextAlignment];
		[rightLabel setBackgroundColor: [NSColor windowBackgroundColor]];
		[rightLabel setTextColor: [NSColor grayColor]];
		[rightLabel setFont: [NSFont systemFontOfSize: 10]];
		[rightLabel setBezeled: NO];
		[rightLabel setEditable: NO];
		[rightLabel setSelectable: NO];
		[rightLabel setStringValue: @""];
    [self addSubview: rightLabel]; 
	}
	
	return self;
}

- (void)updateInfo:(NSDictionary *)infoDict
{
	NSString *leftText = [infoDict objectForKey: @"freespace"];
	NSString *rightText = [infoDict objectForKey: @"operation"];
		
	if (leftText) {
		[leftLabel setStringValue: leftText];
	} else {
		[leftLabel setStringValue: @""];
	}

	if (rightText) {
		[rightLabel setStringValue: rightText];
	} else {
		[rightLabel setStringValue: @""];
	}
}

- (PathsPopUp *)pathsPopUp
{
	return pathsPopUp;
}

- (void)resizeWithOldSuperviewSize:(NSSize)oldFrameSize
{
	int popupwidth = 100;
	float w = [self frame].size.width;
	float leftspace = (w - popupwidth) / 4 * 3 - 4;
	float rightspace = w - popupwidth - leftspace - 4;
	
	[pathsPopUp setFrame: NSMakeRect((w - popupwidth) / 2, 4, popupwidth, 20)];
	[leftLabel setFrame: NSMakeRect(4, 4, leftspace, 20)];
	[rightLabel setFrame: NSMakeRect(w - rightspace, 4, rightspace, 20)];
}

@end



