{-# LANGUAGE ForeignFunctionInterface #-}

#include <bindings.dsl.h>
#include <nettle/sha3.h>

module Bindings.Nettle.Hash.SHA3 where
#strict_import

#num SHA3_256_DIGEST_SIZE
#num SHA3_256_DATA_SIZE

#starttype struct sha3_256_ctx
#stoptype

#ccall sha3_256_init , Ptr <struct sha3_256_ctx> -> IO ()
#ccall sha3_256_update , Ptr <struct sha3_256_ctx> -> CUInt -> Ptr CUChar -> IO ()
#ccall sha3_256_digest , Ptr <struct sha3_256_ctx> -> CUInt -> Ptr CUChar -> IO ()


#num SHA3_224_DIGEST_SIZE
#num SHA3_224_DATA_SIZE

#starttype struct sha3_224_ctx
#stoptype

#ccall sha3_224_init , Ptr <struct sha3_224_ctx> -> IO ()
#ccall sha3_224_update , Ptr <struct sha3_224_ctx> -> CUInt -> Ptr CUChar -> IO ()
#ccall sha3_224_digest , Ptr <struct sha3_224_ctx> -> CUInt -> Ptr CUChar -> IO ()


#num SHA3_512_DIGEST_SIZE
#num SHA3_512_DATA_SIZE

#starttype struct sha3_512_ctx
#stoptype

#ccall sha3_512_init , Ptr <struct sha3_512_ctx> -> IO ()
#ccall sha3_512_update , Ptr <struct sha3_512_ctx> -> CUInt -> Ptr CUChar -> IO ()
#ccall sha3_512_digest , Ptr <struct sha3_512_ctx> -> CUInt -> Ptr CUChar -> IO ()


#num SHA3_384_DIGEST_SIZE
#num SHA3_384_DATA_SIZE

#starttype struct sha3_384_ctx
#stoptype

#ccall sha3_384_init , Ptr <struct sha3_384_ctx> -> IO ()
#ccall sha3_384_update , Ptr <struct sha3_384_ctx> -> CUInt -> Ptr CUChar -> IO ()
#ccall sha3_384_digest , Ptr <struct sha3_384_ctx> -> CUInt -> Ptr CUChar -> IO ()

