/*C*
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#include "ButtonCtrl.h"
#include "CtrlEvent.h"
#include "Events.h"
#include "../gl/Color.h"
#include "../gl/Console.h"
#include "../gl/Font.h"
#include "../gl/VgaBlur.h"

//--------------------------------------------------------------------------------------------------------------------------------

ButtonCtrl::ButtonCtrl(Rect _rect, Events* _events, int _key, Control* _notify, int _id, Font* _font, const char* _text)
 : Control(_rect, _events)
{
 key = _key;
 notify = _notify;
 id = _id;
 font = _font;
 text = _text;
 down = drawnDown = false;
}

//--------------------------------------------------------------------------------------------------------------------------------

void ButtonCtrl::evLBDown(Point p)
{
 down = drawnDown = true;
 events->redraw(rect());
}

void ButtonCtrl::evLBUp(Point p)
{
 down = drawnDown = false;
 events->redraw(rect());
 if(rect().contains(p))
  events->add(new CommandEvent(notify, id));
}

void ButtonCtrl::evPtrMove(Point p)
{
 if(down && drawnDown != rect().contains(p))
  {
   drawnDown = rect().contains(p);
   events->redraw(rect());
  }
}

//--------------------------------------------------------------------------------------------------------------------------------

void ButtonCtrl::evKeyDown(int _key)
{
 if(_key == key) events->add(new CommandEvent(notify, id));
}

//--------------------------------------------------------------------------------------------------------------------------------

void ButtonCtrl::draw(Rect r)
{
 Color fillColor = Color(colorLGray, 0x7F);
 Color topShadow = Color(drawnDown? colorGray : colorWhite, 0x7F);
 Color bottomShadow = Color(drawnDown? colorWhite : colorGray, 0x7F);
 Point textOffset = drawnDown? Point(1, 1) : Point(0, 0);

 screen->fillBox(Rect(rect().topLeft() + Point(2, 2), rect().z() - Point(4, 4)), fillColor);

 screen->drawHLine(rect().topLeft() + Point(0, 0), rect().w - 0, topShadow);
 screen->drawHLine(rect().topLeft() + Point(0, 1), rect().w - 1, topShadow);

 screen->drawVLine(rect().topLeft() + Point(0, 2), rect().h - 2, topShadow);
 screen->drawVLine(rect().topLeft() + Point(1, 2), rect().h - 3, topShadow);

 screen->drawHLine(rect().bottomLeft() + Point(1,  0), rect().w - 1, bottomShadow);
 screen->drawHLine(rect().bottomLeft() + Point(2, -1), rect().w - 2, bottomShadow);

 screen->drawVLine(rect().topRight() + Point( 0, 1), rect().h - 3, bottomShadow);
 screen->drawVLine(rect().topRight() + Point(-1, 2), rect().h - 4, bottomShadow);

 font->vAlign = Font::VMiddle;
 font->hAlign = Font::HMiddle;
 font->writef(screen, rect().middle() + textOffset, colorWhite, "%s", (const char*) text);
}

//--------------------------------------------------------------------------------------------------------------------------------
