/*C*
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#include "Control.h"
#include "../util/String.h"

//--------------------------------------------------------------------------------------------------------------------------------

class ButtonCtrl : public Control
{
private:
 int key;
 Control* notify;
 int id;
 class Font* font;
 String text;
 bool down, drawnDown;

public:
 ButtonCtrl(Rect _rect, Events* _events, int _key, Control* _notify, int _id, Font* _font, const char* _text);

 virtual void evLBDown(Point p);
 virtual void evLBUp(Point p);
 virtual void evPtrMove(Point p);

 virtual void evKeyDown(int _key);

 virtual void draw(Rect r);
};

//--------------------------------------------------------------------------------------------------------------------------------
