/*C* -*-c++-*-
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#ifndef vgaxx_Font_h
#define vgaxx_Font_h

#include "../util/Object.h"

class Font : public Object
{
private:
 class Glyph* glyphs[96];
 int pH;

public:
 enum HAlign { HLeft, HMiddle, HRight } hAlign;
 enum VAlign { VTop, VMiddle, VBottom } vAlign;

 Font();
 ~Font();

 bool load(const char* filename, int _h);

 int strw(const char* s);
 class Rect writef(class VgaContext* vc, class Point p, class Color c, const char* format, ...);

 int h() { return pH; }
};

#endif
