/*C*
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#if 0

#include "Background.h"
#include "Data.h"
#include "SpriteEditor.h"
#include "../control/ColorCtrl.h"
#include "../control/SprEditCanvasDockCtrl.h"
#include "../gl/Console.h"
#include "../gl/keycodes.h"
#include "../gl/Keyboard.h"
#include "../gl/Mouse.h"
#include "../gl/Sprite.h"
#include "../gl/VgaBlur.h"
#include "../util/debug.h"
#include "../util/File.h"

//--------------------------------------------------------------------------------------------------------------------------------

SpriteEditor::SpriteEditor(Control* _parent, Rect _rect)
 : Control(_parent, _rect)
{
 currentSprite = new Sprite;
 children->add(colorCtrl = new ColorCtrl(this, Rect(0, 450, 640, 30), Color(0, 0, 0)));
 children->add(canvasCtrl = new SprEditCanvasDockCtrl(this, Rect(0, 0, 640, 450)));
 assert(!overlap());
}

SpriteEditor::~SpriteEditor()
{
 delete currentSprite;
}

//--------------------------------------------------------------------------------------------------------------------------------

void SpriteEditor::run()
{
 VPRINTF("<spredit> SpriteEditor started\n");
 currentSprite->size(Point(40, 40));
 int zoom = 10;

 // initialise the screen
 draw();
 screen->keepAndUpdate();

 // reset keyboard
 keyboard->setMode(kmode_repeat);
 keyboard->waitRelease();

 VPRINTF("<spredit> entering main loop\n");
 bool quit = false;
 while(!quit)
  {
   if(keyboard->update())
    {
     if(KP_S)
      if(!save("sprite.spr", currentSprite, (objectWriteFunc) &Sprite::write)) nonFatal("%s\n", errStr);

     if(KP_Q)
      quit = true;

     if(KP_ESCAPE) 
      quit = true;
    }
   if(mouse->update())
    {
     // send mouse to controls
     distributeMouse(mouse->position(), mouse->button());
    }
   screen->blur2(mouse->sprite->draw(screen, mouse->position()));
   screen->copyBlurs();
  }
 VPRINTF("<spredit> exiting main loop\n");
}

//--------------------------------------------------------------------------------------------------------------------------------

void SpriteEditor::myDraw()
{
 bk->copyTo(screen);
}

//--------------------------------------------------------------------------------------------------------------------------------

#endif
