/*C* $Id: files.cc,v 1.2 1997/08/11 19:21:31 james Exp james $
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#include "files.h"
#include "options.h"
#include "../util/File.h"
#include "../util/util.h"
#include <errno.h>
#include <string.h>

String libFileName(const char* name)
{
 char* s = new char[strlen(options->libDir) + strlen(name) + 2];
 strcpy(s, options->libDir);
 strcat(s, "/");
 strcat(s, name);
 String str(s);
 delete s;
 return str;
}

String libFileName(const char* prefix, const char* name)
{
 return String(options->libDir) + '/' + prefix + '/' + name;
}

/*
File* openLibFile(const char* name)
{
 String filename;

 filename = options->libDir;
 filename += "/";
 filename += name;
 File* f = gzFilename(filename)? new GzipPipe(filename, "r") : new File(filename, "r");
 if(*f) return f;
 delete f;
 if(errno != ENOENT || !strcmp(options->libDir, installLibDirString)) return NULL;

 filename = LIBDIR"/";
 filename += name;
 f = gzFilename(filename)? new GzipPipe(filename, "r") : new File(filename, "r");
 if(*f) return f;
 delete f;
 return NULL;
}
*/
