/***************************************************************************
                          cmdlineoptions.h  -  description
                             -------------------
    begin                : Sun Nov 25 2001
    copyright            : (C) 2001 by Andr Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CMDLINEOPTIONS_H
#define CMDLINEOPTIONS_H

#include <string>
#include <map>
#include <cstdlib>
#include <iostream>
#include <fstream>

#include "platform_fs.h"
#include "configurationreader.h"
#include "datadir.h"
#include "enums.h"

#ifdef _WIN32
  #include <windows.h>
#endif

// If your system does not know getopt_long, define USE_LOCAL_GETOPT
#if defined(_WIN32) || defined(__SVR4) || defined(__sun__)
  // some compilers don't like redefinitions...
  #ifndef USE_LOCAL_GETOPT
     #define USE_LOCAL_GETOPT
  #endif
#endif

#ifdef USE_LOCAL_GETOPT
  #include "getopt.h"
#else
  #include <getopt.h>
#endif

#define OPT_VERBOSE      "verbose"
#define OPT_INCLUDECSS   "include-css"
#define OPT_HELP         "help"
#define OPT_LINENO       "linenumbers"
#define OPT_XHTML        "xhtml"
#define OPT_RTF          "rtf"
#define OPT_TEX          "tex"
#define OPT_LATEX        "latex"
#define OPT_XSLFO        "xsl-fo"
#define OPT_FRAGMENT     "fragment"
#define OPT_ANCHORS      "anchors"
#define OPT_LISTTHEMES   "list-themes"
#define OPT_LISTLANGS    "list-langs"
#define OPT_VERSION      "version"
#define OPT_IN           "input"
#define OPT_OUT          "output"
#define OPT_SYNTAX       "syntax"
#define OPT_STYLE        "style"
#define OPT_CSSOUT       "css-outfile"
#define OPT_CSSIN        "css-infile"
#define OPT_DELTABS      "replace-tabs"
#define OPT_BATCHREC     "batch-recursive"
#define OPT_OUTDIR       "outdir"
#define OPT_FORMATSTYLE  "format-style"
#define OPT_DATADIR      "data-dir"
#define OPT_ADDDATADIR   "add-data-dir"
#define OPT_INDEXFILE    "print-index"
#define OPT_HELPINT      "help-int"
#define OPT_WRAP         "wrap"
#define OPT_WRAPSIMPLE   "wrap-simple"
#define OPT_QUIET        "quiet"
#define OPT_REPLACE_QUOTES  "replace-quotes"
#define OPT_FOP          "fop-compatible"
#define OPT_PROGRESSBAR  "progress"
#define OPT_FILLZEROES   "zeroes"
#define OPT_ANSI         "ansi"
#define OPT_XML          "xml"

#define S_OPT_ANSI       'A'
#define S_OPT_OUT        'o'
#define S_OPT_IN         'i'
#define S_OPT_SYNTAX     'S'
#define S_OPT_VERBOSE    'v'
#define S_OPT_INCLUDECSS 'I'
#define S_OPT_HELP       'h'
#define S_OPT_HELPINT    'H'
#define S_OPT_LINENO     'l'
#define S_OPT_STYLE      's'
#define S_OPT_CSSOUT     'c'
#define S_OPT_CSSIN      'e'
#define S_OPT_DELTABS    't'
#define S_OPT_XHTML      'X'
#define S_OPT_RTF        'R'
#define S_OPT_TEX        'T'
#define S_OPT_LATEX      'L'
#define S_OPT_XSLFO      'Y'
#define S_OPT_XML        'Z'
#define S_OPT_BATCHREC   'B'
#define S_OPT_FRAGMENT   'f'
#define S_OPT_ANCHORS    'a'
#define S_OPT_LISTTHEMES 'w'
#define S_OPT_LISTLANGS  'p'
#define S_OPT_OUTDIR     'O'

#define S_OPT_FORMATSTYLE 'F'
#define S_OPT_DATADIR     'D'
#define S_OPT_ADDDATADIR  'E'
#define S_OPT_INDEXFILE   'C'
#define S_OPT_WRAP        'W'
#define S_OPT_WRAPSIMPLE  'V'
#define S_OPT_QUIET       'q'
#define S_OPT_FOP            'g'
#define S_OPT_REPLACE_QUOTES 'r'
#define S_OPT_VERSION        'Q'
#define S_OPT_PROGRESSBAR    'P'
#define S_OPT_FILLZEROES     'z'

#define S_OPTIONS_STRING "o:i:S:B:O:s:c:e:t:F:D:H:E:afghlvwpqrzACILYRTZXV::W::P"

using namespace std;

/**Command line options*/

class CmdLineOptions
  {
  public:

    /**Constructor
     \param argc Argument count
     \param argv Argument strings
    */
    CmdLineOptions(int argc, char *argv[]);
    ~CmdLineOptions();

    /** \return Single output file name*/
    const string &getSingleOutFilename();

    /** \return Single input file name*/
    const string &getSingleInFilename() const;

    /** \return Output directory*/
    const string& getOutDirectory() ;

    /** \return CSS output file name*/
    const string&getCssOutFilename() const;

    /** \return CSS input file name*/
    const string&getCssInFilename() const;

    /** \return Number of spaces to replace a tab*/
    int getNumberSpaces() const;

    /** \return True if version information should be printed*/
    bool printVersion() const;

   /** \return True if help information should be printed*/
    bool printHelp() const;

    /** \return True if debug information should be printed*/
    bool printDebugInfo()const;

    /** \return True if CSS should be included in output*/
    bool includeCssDefinition() const;

    /** \return True if line numbers should be printed*/
    bool printLineNumbers() const;

    /** \return colour theme name */
    string getStyleName()const ;

    /** gibt true zurck, falls deutsche Hilfe ausgegeben werden soll */
    int helpLanguage() const;

    /** \return True if batch mode is active*/
    bool enableBatchMode() const;

    /** \return True if output shluld be fragmented*/
    bool fragmentOutput() const;

    /** \return output file suffix */
    string getOutFileSuffix() const;

    /** \return True if anchors should be attached to line numbers*/
    bool attachLineAnchors() const;

    /** \return True if list of installed themes should be printed*/
    bool showThemes() const;

    /** \return True if list of installed language definitions should be printed*/
    bool showLangdefs() const;

    /** \return True if loutput directory is given*/
    bool outDirGiven() const;

    /** \return True if refomatting is enabled*/
    bool formattingEnabled();

    /** \return True if a new data directory is given*/
    bool dataDirGiven()const;

    /** \return True if an additional data directory is given*/
    bool additionalDataDirGiven()const;

    /** \return True if index file should be printed*/
    bool printIndexFile() const;

    /** \return True if quotes should be replaced by /dq in LaTeX*/
    bool replaceQuotes() const;

    /** \return Data directory*/
    const string &getDataDir()const;

    /** \return Additional data directory*/
    const string &getAdditionalDataDir()const;

    /** \return True if language syntax is given*/
    bool syntaxGiven() const;

    /** \return True if quiet mode is active*/
    bool quietMode() const;

    /** \return True if XSL-FO output should be FOP compatible*/
    bool fopCompatible() const;

    /** \return True if progress bar should be printed in batch mode */
    bool printProgress() const;

    /** \return True if line numbers are filled with leading zeroes */
    bool fillLineNrZeroes() const;

    /** \return name of help message file*/
    const string getHelpLang() const;

    /** \return programming language */
    const string &getLanguage() ;

    /** \return Wrapping style*/
    highlight::WrapMode getWrappingStyle() const;

    /** \return List of input file names*/
    const vector <string> & getInputFileNames() const;

    /** \return Name of indentation scheme file */
    const string &getIndentScheme() const;

    /** \return Output file format */
    highlight::OutputType getOutputType() const;

  private:

    int numberSpaces;   // number of spaces which replace a tab
    highlight::WrapMode wrappingStyle; // line wrapping mode
    highlight::OutputType outputType;

    // name of single output file
    string outFilename,
    // output directory
    outDirectory,
    // programming language which will be loaded
    language,
    // name of colour theme
    styleName,
    // name of external style file
    cssOutFilename,
    // name of file to be included in external style file
    cssInFilename,
    // used to define data directories at runtime
    dataDir, additionalDataDir;
    // name of indenation scheme
    string indentScheme;

    bool opt_language;
    bool opt_include_css;
    bool opt_help;
    bool opt_version ;
    bool opt_verbose;
    bool opt_linenumbers;
    bool opt_css_style;
    bool opt_batch_mode;
    bool opt_fragment;
    bool opt_attach_line_anchors;
    bool opt_show_themes;
    bool opt_show_langdefs;
    bool opt_asformat_output;
    bool opt_printindex;
    bool opt_quiet;
    bool opt_xslfo_fop;
    bool opt_replacequotes;
    bool opt_print_progress;
    bool opt_fill_zeroes;

    bool configFileRead;

    string helpLang;


    string configFilePath;


    // list of all input file names
    vector <string> inputFileNames;

    /** load highlight configuration file */
    void loadConfigurationFile();

    /** \return file suffix */
    string getFileSuffix( const string & fileName) const;

    /** \return directory name of path */
    string getDirName( const string & path);

    /** get all entries in the directory defined by wildcard */
    void readDirectory(const string & wildcard);

    /** \return Boolean value of paramVal */
    bool getFlag(const string& paramVal);

    /** \return Valid path name */
    string validateDirPath(const string & path);

  };

#endif
