/***************************************************************************
                          htmlcode.cpp  -  description
                             -------------------
    begin                : Wed Nov 28 2001
    copyright            : (C) 2001 by Andr Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "xhtmlgenerator.h"

using namespace std;

namespace highlight {

XHtmlGenerator::XHtmlGenerator(void)
{}

XHtmlGenerator::XHtmlGenerator (
  const string &cssStyle,
  const string &cssInFilename,
  const string &cssOutFilename,
  bool includeCssDef,
  bool withAnchors)
  : HtmlGenerator(cssStyle,
                  cssInFilename,
                  cssOutFilename,
                  includeCssDef,
                  withAnchors)
{
   fileSuffix=".xhtml";
   brTag="<br />";
   hrTag="<hr />";
   idAttr="id";

   HTML_HEADER1=
  "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\n"
  "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\""
  "  \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n"
  "<html xmlns=\"http://www.w3.org/1999/xhtml\">\n"
  "<head>\n\t<title>";

  HTML_HEADER2=  "</title>\n";

  HTML_FOOTER=
  "\n</body>\n</html>\n<!--XHTML generated by highlight "
  HIGHLIGHT_VERSION
  ", "
  HIGHLIGHT_URL
  "-->\n";
}


string XHtmlGenerator::getHeader(const string &title)
{
  ostringstream osPart1;
  osPart1 << HTML_HEADER1
          << ((title.empty())?"Source file":title )
          << HTML_HEADER2;

  if (langInfo.getSyntaxHighlight())
    {
      if (includeCss)    //CSS-Definition in HTML-<head> einfuegen
        {
          osPart1 << "\t<style type=\"text/css\">\n";
          osPart1 << "\t<![CDATA[\n";
          osPart1 << getStyleDefinition();
          osPart1 << readUserStyleDef();
          osPart1 << "\t]]>\n";
          osPart1 << "\t</style>\n";
        }
      else  //Referenz auf CSS-Datei einfuegen
        {
          osPart1 << "\t<link rel=\"stylesheet\" type=\"text/css\" href=\""
                  << cssOutFile
                  << "\""
                  << "/"
                  << ">\n";
        }
    }
    osPart1 << "</head>\n<body>\n<pre>";

  return osPart1.str();
}

}
