#
# Copyright (c) 2006 Mellanox Technologies. All rights reserved.
#
# This Software is licensed under one of the following licenses:
#
# 1) under the terms of the "Common Public License 1.0" a copy of which is
#    available from the Open Source Initiative, see
#    http://www.opensource.org/licenses/cpl.php.
#
# 2) under the terms of the "The BSD License" a copy of which is
#    available from the Open Source Initiative, see
#    http://www.opensource.org/licenses/bsd-license.php.
#
# 3) under the terms of the "GNU General Public License (GPL) Version 2" a
#    copy of which is available from the Open Source Initiative, see
#    http://www.opensource.org/licenses/gpl-license.php.
#
# Licensee has the right to choose one of the above licenses.
#
# Redistributions of source code must retain the above copyright
# notice and one of the license notices.
#
# Redistributions in binary form must reproduce both the above copyright
# notice, one of the license notices in the documentation
# and/or other materials provided with the distribution.
#

%{?build_ibmgtsim: %define ibmgtsim --enable-ibmgtsim}

Summary: OpenIB Mellanox InfiniBand Diagnostic Tools
Name: ibutils
Version: 1.2
Release: 1.ofed1.4.2
License: GPL/BSD
Url: http://openib.org/downloads/%{name}-%{version}.tar.gz
Group: System Environment/Libraries
Source: http://www.openfabrics.org/downloads/ibutils-1.2.tar.gz
BuildRoot: %{?build_root:%{build_root}}%{!?build_root:%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)}
# Requires: opensm
Vendor: Mellanox Technologies Ltd.
%description
ibutils provides IB network and path diagnostics.


%prep
%setup -n %{name}-%{version}

%build
%configure %{?configure_options} %{?ibmgtsim}
%{__make} %{?mflags}

%install
rm -rf $RPM_BUILD_ROOT
%{__make} install DESTDIR=$RPM_BUILD_ROOT %{?mflags_install}
/bin/rm -f $RPM_BUILD_ROOT/%{_libdir}/*.la
/bin/rm -f $RPM_BUILD_ROOT/%{_prefix}/bin/git_version.tcl

install -d $RPM_BUILD_ROOT/etc/profile.d
cat > $RPM_BUILD_ROOT/etc/profile.d/ibutils.sh << EOF
if ! echo \${PATH} | grep -q %{_prefix}/bin ; then
        PATH=\${PATH}:%{_prefix}/bin
fi
EOF
cat > $RPM_BUILD_ROOT/etc/profile.d/ibutils.csh << EOF
if ( "\${path}" !~ *%{_prefix}/bin* ) then
        set path = ( \$path %{_prefix}/bin )
endif
EOF

touch ibutils-files
case %{_prefix} in
        /usr | /usr/)
        ;;
        *)
        install -d $RPM_BUILD_ROOT/etc/ld.so.conf.d
        echo "%{_libdir}" >> $RPM_BUILD_ROOT/etc/ld.so.conf.d/ibutils.conf
        echo "/etc/ld.so.conf.d/ibutils.conf" >> ibutils-files
        ;;
esac


%clean
#Remove installed driver after rpm build finished
rm -rf $RPM_BUILD_DIR/%{name}-%{version}
rm -rf $RPM_BUILD_ROOT

%post
/sbin/ldconfig

###
### Files
###
%files -f ibutils-files
%defattr(-,root,root)
%{_prefix}/bin/ibis
%{_prefix}/bin/ibdmsh
%{_prefix}/bin/ibtopodiff
%{_prefix}/bin/ibnlparse
%{_prefix}/bin/ibdmtr
%{_prefix}/bin/ibdmchk
%{_prefix}/bin/ibdiagui
%{_prefix}/bin/ibdiagnet
%{_prefix}/bin/ibdiagpath
%{_libdir}/libibdmcom.so*
%{_libdir}/libibdmcom.a
%{_libdir}/libibdm.so*
%{_libdir}/libibdm.a
%{_libdir}/ibis1.2
%{_libdir}/ibdm1.2
%{_libdir}/ibdiagnet1.2
%{_libdir}/ibdiagpath1.2
%{_libdir}/ibdiagui1.2
%{_prefix}/include/ibdm
%{_mandir}/man1/ibdiagnet.1*
%{_mandir}/man1/ibdiagpath.1*
%{_mandir}/man1/ibdiagui.1*
%{_mandir}/man1/ibis.1*
%{_mandir}/man1/ibtopodiff.1*
%{_mandir}/man1/ibdmtr.1*
%{_mandir}/man1/ibdmsh.1*
%{_mandir}/man1/ibdmchk.1*
%{_mandir}/man1/ibdm-topo-file.1*
%{_mandir}/man1/ibdm-ibnl-file.1*
/etc/profile.d/ibutils.sh
/etc/profile.d/ibutils.csh
%{_prefix}/bin/mkSimNodeDir
%{_prefix}/bin/ibmssh
%{_prefix}/bin/ibmsquit
%{_prefix}/bin/RunSimTest
%{_prefix}/bin/IBMgtSim
%{_libdir}/libibmscli.so*
%{_libdir}/libibmscli.a
%{_prefix}/include/ibmgtsim
%{_prefix}/share/ibmgtsim
%{_mandir}/man1/ibmssh.1*
%{_mandir}/man1/ibmsquit.1*
%{_mandir}/man1/mkSimNodeDir.1*
%{_mandir}/man1/RunSimTest.1*
%{_mandir}/man1/IBMgtSim.1*
# END Files

%changelog
* Tue Aug 21 2006 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Added ibmgtsim to the rpm
* Sun Jul 30 2006 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Added man pages and share/ibmgtsim
* Tue May 16 2006 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Added ibutils sh, csh and conf to update environment
* Sun Apr  2 2006 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Initial packaging for openib gen2 stack
