/***************************************************************************
 *   Copyright (C) 2004-2006 by Jim Campbell                               *
 *   ifpgui@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef IFP_GUI_H
#define IFP_GUI_H

#include <qmainwindow.h>
#include "ifpguiview.h"

class QTextEdit;

class ifp_gui: public QMainWindow
   {
   Q_OBJECT

public:
   ifp_gui();
   ~ifp_gui();

protected:
   void closeEvent( QCloseEvent* );

private slots:
   void ifpConnect();
   void uploadPlayList();
   void show_ifp_info();
   void show_radiofreq_info();
   void about();
   void aboutQt();
   void auto_convert();

   void create_directory(void);
   void rename_file(void);
   void delete_file(void);
   void file_properties(void);
   void align_horizontal(void);
   void align_vertical(void);
   void updateFirware(void);


private:
   ifpGUIView *m_view;
   QPrinter *printer;
   QString filename;
   QTimer *connect_timer;
   QPopupMenu *file, *view, *options, *help;
   int  autoConvertMenuID;
   int  horizontalMenuID;
   int  verticalMenuID;
   };


#endif
