#!/usr/bin/python

TNS_ERROR_CODES = {
    "TNS-00000":'Not An Error',
    "TNS-00001":'INTCTL: error while getting command line from the terminal',
    "TNS-00002":'INTCTL: error while starting the Interchange',
    "TNS-00003":'INTCTL: error while sending request to the Interchange',
    "TNS-00004":'INTCTL: error while starting the Navigator',
    "TNS-00005":'INTCTL: error while sending request to the Navigator',
    "TNS-00006":'INTCTL: HOST variable is not defined',
    "TNS-00007":'INTCTL: unknown host',
    "TNS-00008":'INTCTL: could not contact destination Navigator',
    "TNS-00009":'INTCTL: could not contact destination Connection Manager',
    "TNS-00010":'Error while flushing NS context',
    "TNS-00011":'INTCTL: error while starting the Connection Manager',
    "TNS-00012":'INTCTL: error while processing Connection Manager request',
    "TNS-00013":'INTCTL: error while performing NS disconnect command',
    "TNS-00014":'INTCTL: error while opening terminal input channel',
    "TNS-00015":'INTCTL: error while closing terminal input channel',
    "TNS-00016":'INTCTL: error while performing NS send command',
    "TNS-00017":'INTCTL: error while performing NS receive command',
    "TNS-00018":'INTCTL: TNS_ADMIN not defined',
    "TNS-00019":'INTCTL: error initializing the national language interface',
    "TNS-00020":'INTCTL: missing NAVIGATOR_DATA in TNSNAV.ORA',
    "TNS-00021":'INTCTL: missing INTERCHANGE_DATA in INTCHG.ORA',
    "TNS-00022":'INTCTL: missing CMANAGER_NAME in INTCHG.ORA',
    "TNS-00023":'INTCTL: missing ADDRESS(es) in config files',
    "TNS-00024":'INTCTL: Unable to contact Navigator to obtain Connection Manager address',
    "TNS-00025":'INTCTL: The ORACLE environment is not set up correctly',
    "TNS-00026":'INTCTL: TNS_ADMIN directory set, and is being used',
    "TNS-00027":'INTCTL: Could not resolve Navigator"s name/address',
    "TNS-00028":'INTCTL: Could not resolve Connection Manager"s name/address',
    "TNS-00031":'INTCTL: internal NT error',
    "TNS-00032":'INTCTL: internal NS error',
    "TNS-00033":'INTCTL: internal NL error',
    "TNS-00034":'INTCTL: internal NR error',
    "TNS-00035":'INTCTL: error while constructing full file name',
    "TNS-00036":'INTCTL: error reading from Navigator or Connection Manager error files',
    "TNS-00037":'INTCTL: error opening Navigator or Connection Manager error files',
    "TNS-00038":'INTCTL: Poorly formed address or command string',
    "TNS-00039":'INTCTL: error while spawning a process',
    "TNS-00040":'INTCTL: failed to initialize trace context- Continuing anyway',
    "TNS-00041":'INTCTL: Navigator already running. Start operation cancelled',
    "TNS-00042":'INTCTL: CMANAGER already running. Start operation cancelled',
    "TNS-00043":'The CMANAGER has active connections, do you still want to stop it (y/n)?',
    "TNS-00044":'INTCTL: You must have an INTCHG.ORA file to contact the Connection Manager',
    "TNS-00045":'INTCTL: Could not contact the Navigator on address',
    "TNS-00046":'INTCTL: Could not contact the CMANAGER on address',
    "TNS-00060":'INTCTL: Bad command: only the STATUS command can be used on remote Interchanges',
    "TNS-00061":'INTCTL: Bad command or syntax error: You must specify a trace level',
    "TNS-00062":'INTCTL: Bad command or syntax error: For help type help/h/?',
    "TNS-00063":'INTCTL: Failed to allocate memory for buffers',
    "TNS-00064":'INTCTL: Failed to find CMANAGER_NAME in INTCHG.ORA',
    "TNS-00065":'INTCTL: Command cannot be executed remotely',
    "TNS-00070":'INTCTL usage: [intctl] <command> <process_name> [argument]',
    "TNS-00071":'where <command> is one of following:',
    "TNS-00072":'* start - start up process_name',
    "TNS-00073":'* stop/abort - stop the process_name',
    "TNS-00074":'* status - get statistics from the process_name',
    "TNS-00075":'NOTE: the user may get the status info of a remote',
    "TNS-00076":'component by specifying the component name in',
    "TNS-00077":'the argument field',
    "TNS-00078":'* log_on - ask process_name to turn logging on',
    "TNS-00079":'* log_off - ask process_name to turn logging off',
    "TNS-00080":'* force_log - ask process_name to dump its state',
    "TNS-00081":'* trace_on - ask process name to turn tracing on',
    "TNS-00082":'NOTE: the user MUST specify a trace level',
    "TNS-00083":'(USER or ADMIN) in the argument field',
    "TNS-00084":'* trace_off - ask process name to turn tracing off',
    "TNS-00085":'* reread - ask the process name to reread parameter files',
    "TNS-00086":'* reload - ask the Navigator to reload TNSNET.ORA',
    "TNS-00087":'* version - ask the process name to display its version number',
    "TNS-00088":'* exit - quit the Interchange controller',
    "TNS-00089":'process_name is one of Interchange, CMANAGER, or Navigator',
    "TNS-00090":'* Interchange - will ask the Interchange',
    "TNS-00091":'* Navigator (or navgatr) - will ask the Navigator only',
    "TNS-00092":'* CMANAGER (or intlsnr) - will ask the Cmanager only',
    "TNS-00093":'argument is only supplied to either status or trace_on',
    "TNS-00094":'* to status - argument is considered the remote process_name',
    "TNS-00095":'* to trace_on - argument is considered the trace level',
    "TNS-00100":'Unable to allocate memory',
    "TNS-00101":'File operation error',
    "TNS-00102":'Keyword-Value binding operation error',
    "TNS-00103":'Parameter file load error',
    "TNS-00104":'Data stream open/access error',
    "TNS-00105":'Could not initialize tracing',
    "TNS-00106":'Failed to open log file',
    "TNS-00107":'Unable to initialize TNS global data',
    "TNS-00108":'TNS_ADMIN not defined',
    "TNS-00109":'Message could not be printed; not enough memory',
    "TNS-00110":'Could not initialize network from file TNSNET.ORA',
    "TNS-00111":'Failed to get configuration data from file',
    "TNS-00112":'Failed to find configuration file name',
    "TNS-00113":'Failed to open error log file',
    "TNS-00114":'Internal error- Allocation of addresses not performed',
    "TNS-00115":'Could not allocate pump global buffers',
    "TNS-00116":'Pump failed during initial bequeath',
    "TNS-00117":'Internal error- No data passed through pump',
    "TNS-00119":'Missing PUMP_CONNECTIONS in INTCHG.ORA',
    "TNS-00120":'Missing PUMPS in INTCHG.ORA',
    "TNS-00121":'Missing CMANAGER_NAME in INTCHG.ORA',
    "TNS-00122":'Missing ADDRESS(es) in TNSNET.ORA file',
    "TNS-00123":'Unable to perform a listen on configured ADDRESS(es)',
    "TNS-00124":'Internal error - Unable to create empty address',
    "TNS-00125":'Failed to get number of Interchanges in TNSNET.ORA',
    "TNS-00126":'Missing Connection Manager name and address in TNSNET.ORA',
    "TNS-00127":'Missing Connection Manager name in TNSNET.ORA',
    "TNS-00128":'Missing COMMUNITY in TNSNET.ORA',
    "TNS-00129":'Internal error - Failed to create new community',
    "TNS-00130":'Failed to create Interchange"s internal address',
    "TNS-00131":'Missing COMMUNITY in COMMUNITY_COST_LIST in TNSNET.ORA',
    "TNS-00132":'COST value must be an integer greater than 0',
    "TNS-00133":'Missing LOCAL_COMMUNITIES field in TNSNAV.ORA',
    "TNS-00134":'Missing COMMUNITY component in addresses for the Navigator in TNSNAV.ORA',
    "TNS-00135":'Missing TNS error message file',
    "TNS-00136":'Did not register product/facility for TNS error message',
    "TNS-00137":'Failed to get TNS error message file entry',
    "TNS-00138":'Failed to find ORACLE executable directory',
    "TNS-00139":'Internal - Data passed from the Interchange listener is poorly formed',
    "TNS-00140":'Interchange specified was not found in network tables',
    "TNS-00141":'Failed to get file stream information',
    "TNS-00142":'Community mismatch in TNSNAV.ORA',
    "TNS-00143":'Illegal PREFERRED_CMANAGERS entry in TNSNAV.ORA',
    "TNS-00144":'PUMP_CONNECTIONS value in INTCHG.ORA is too large.',
    "TNS-00145":'PUMPS value in INTCHG.ORA is too large.',
    "TNS-00146":'Internal-- Retry data request withing pump.',
    "TNS-00147":'Failed to start a pre-spawned pump.',
    "TNS-00200":'Unable to do nsanswer on context result=string',
    "TNS-00201":'Unable to read answer connection data :string:',
    "TNS-00202":'Failure in redirecting call : Original to string Redirect to string',
    "TNS-00203":'Unable to start tracing in intlsnr',
    "TNS-00204":'Started tracing in intlsnr',
    "TNS-00205":'Turning off tracing in intlsnr',
    "TNS-00206":'Status Information for Interchange string:',
    "TNS-00207":'Uptime : number days number hr. number min. number sec',
    "TNS-00208":'Logging : string',
    "TNS-00209":'Tracing : string',
    "TNS-00210":'Total Pumps Available : number',
    "TNS-00211":'Total Active Pumps : number',
    "TNS-00212":'Total Pumps Started : number',
    "TNS-00213":'Available Connections : number',
    "TNS-00214":'Total Connections in Use : number',
    "TNS-00215":'Total Successful Connections : number',
    "TNS-00216":'Total Failed Connections : number',
    "TNS-00217":'Total Bytes of Data : number',
    "TNS-00218":'Current Bytes/Sec. : number',
    "TNS-00219":'Pump Strategy : string',
    "TNS-00220":'Pump Breakdown --------------',
    "TNS-00221":'Pump Connections Total Data Bytes/Second',
    "TNS-00222":'-------------------------------------------------------------------',
    "TNS-00223":'numbernumbernumbernumber',
    "TNS-00224":'No more connections available',
    "TNS-00225":'Unable to bequeath connection to pump',
    "TNS-00226":'Unable to contact pump number to send broadcast message string',
    "TNS-00227":'Unable to contact pump; Connection Manager declared pump dead',
    "TNS-00228":'Failure in finding pump data',
    "TNS-00229":'Error in call: unable to deliver message :string: string string string',
    "TNS-00230":'Cannot start new pump process: string string Protocol Adapter errors:number',
    "TNS-00231":'Pump is alive',
    "TNS-00232":'Unable to setup connection',
    "TNS-00233":'Interchange failed to make contact with destination with errors: string string string',
    "TNS-00234":'Connect data for failed call: CALL DATA = string RECEIVE DATA = :string:',
    "TNS-00235":'Aborting connection: Protocol Apapter errors: string;number,number string;number,number',
    "TNS-00236":'Failed to initialize tracing',
    "TNS-00237":'Failed to refuse connection',
    "TNS-00238":'Pump number @: string:',
    "TNS-00239":'Connection Manager has been stopped',
    "TNS-00240":'Connection Manager: Logging is now ON',
    "TNS-00241":'Connection Manager: Logging is now OFF',
    "TNS-00242":'Connection Manager: Tracing is now ON',
    "TNS-00243":'Connection Manager: Tracing is now OFF',
    "TNS-00244":'Connection Manager: Request Failed',
    "TNS-00245":'Connection Manager: Failed to open log file',
    "TNS-00246":'Connection Manager: Failed to start tracing',
    "TNS-00247":'Unable to allocate memory for configuration data from TNSNET.ORA file',
    "TNS-00248":'Unable to get information from file :string: Exiting with NR error:number',
    "TNS-00249":'Unable to read network configuration data from file string with error: string',
    "TNS-00250":'Navigator has been started',
    "TNS-00251":'Failure in nstest:',
    "TNS-00252":'Unable to handle route request: string',
    "TNS-00253":'Error in reading network configuration data from file string with error string',
    "TNS-00254":'Navigator has been stopped',
    "TNS-00255":'Closing down log, stopping Navigator',
    "TNS-00256":'Status of Navigator:',
    "TNS-00257":'Number of Successful Requests : number',
    "TNS-00258":'Number of Failed Requests : number',
    "TNS-00259":'Disabled Interchange list:',
    "TNS-00260":'-------------------------------------------------------------------',
    "TNS-00261":'Interchange Name Community Link Down Time Remaining (secs)',
    "TNS-00262":'%20sstringnumber',
    "TNS-00263":'Navigator: Request Failed',
    "TNS-00264":'Navigator: Failed to reload configuration data',
    "TNS-00265":'Navigator: Reloaded network configuration data',
    "TNS-00266":'Navigator: Unknown Request',
    "TNS-00267":'Navigator: Internal Error',
    "TNS-00268":'ON',
    "TNS-00269":'OFF',
    "TNS-00270":'%s: Terminal Error string',
    "TNS-00271":'Connection Manager',
    "TNS-00272":'Navigator',
    "TNS-00273":'Navigator: Logging is now ON',
    "TNS-00274":'Navigator: Logging is now OFF',
    "TNS-00275":'Navigator: Tracing is now ON',
    "TNS-00276":'Navigator: Tracing is now OFF',
    "TNS-00277":'Navigator: Request Failed',
    "TNS-00278":'Navigator: Failed to Open Log file',
    "TNS-00279":'Navigator: Failed to Start Tracing',
    "TNS-00280":'Max Avg Bytes/Sec : number',
    "TNS-00281":'Connection Manager: Forced Log output',
    "TNS-00282":'Connection Manager: Failed to force log, logging is off',
    "TNS-00283":'Listening on the following TNS addresses:',
    "TNS-00284":'Imm Max Avg Bytes/Sec : number',
    "TNS-00285":'Avg Connect Time (secs) : number',
    "TNS-00286":'Max Connect Time (secs) : number',
    "TNS-00287":'Min Connect Time (secs) : number',
    "TNS-00288":'Navigator: Failed to Disable Interchange',
    "TNS-00289":'Navigator: Disabled Interchange',
    "TNS-00290":'Navigator: Failed to Enable Interchange',
    "TNS-00291":'Navigator: Enabled Interchange',
    "TNS-00292":'Log File Name : string',
    "TNS-00293":'Trace File Name : string',
    "TNS-00294":'Connection Manager: Security is enabled, you cannot STOP the Interchange',
    "TNS-00295":'Navigator: Security is enabled, you cannot STOP the Navigator',
    "TNS-00296":'Stoppable : string',
    "TNS-00297":'Logging Level : string',
    "TNS-00298":'Request to Navigator: string',
    "TNS-00299":'Response from Navigator: string',
    "TNS-00300":'***Disabling Interchange : string',
    "TNS-00301":'***Enabling Interchange : string',
    "TNS-00302":'Connection Manager: Unknown Request',
    "TNS-00303":'Connection Manager: Reread parameter data',
    "TNS-00304":'Status Information for Connection Manager:',
    "TNS-00305":'The Navigator encountered an invalid/unknown trace level',
    "TNS-00306":'Connection Manager encountered an invalid/unknown trace level',
    "TNS-00307":'Navigator: Reread parameter data',
    "TNS-00308":'Navigator: Failed to open log while rereading parameter data',
    "TNS-00309":'Connection Manager: Failed to open log while re-reading parameter data',
    "TNS-00310":'Navigator: Failed to start tracing after rereading parameter data',
    "TNS-00311":'Connection Manager: Failed to start tracing after rereading parameter data',
    "TNS-00312":'Connection Manager: Failed to get version information',
    "TNS-00313":'Navigator: Failed to get version information',
    "TNS-00314":'Protocol Adapter Errors: number,number',
    "TNS-00315":'Failed to allocate larger connect data area for getting pump data: number',
    "TNS-00316":'Ran out of data buffers in the pump',
    "TNS-00317":'Failed to contact Connection Manager',
    "TNS-00501":'Cannot allocate memory',
    "TNS-00502":'Invalid argument',
    "TNS-00503":'Illegal ADDRESS parameters',
    "TNS-00504":'Operation not supported',
    "TNS-00505":'Operation timed out',
    "TNS-00506":'Operation would block',
    "TNS-00507":'Connection closed',
    "TNS-00508":'No such protocol adapter',
    "TNS-00509":'Buffer overflow',
    "TNS-00510":'Internal limit restriction exceeded',
    "TNS-00511":'No listener',
    "TNS-00512":'Address already in use',
    "TNS-00513":'Destination host unreachable',
    "TNS-00514":'Contexts have different wait/test functions',
    "TNS-00515":'Connect failed because target host or object does not exist',
    "TNS-00516":'Permission denied',
    "TNS-00517":'Lost contact',
    "TNS-00518":'Incomplete read or write',
    "TNS-00519":'Operating system resource quota exceeded',
    "TNS-00520":'Syntax error',
    "TNS-00521":'Missing keyword',
    "TNS-00522":'Operation was interrupted',
    "TNS-00523":'Previous operation was busy',
    "TNS-00524":'Current operation is still in progress',
    "TNS-00525":'Insufficient privilege for operation',
    "TNS-00526":'No caller (false async event)',
    "TNS-00527":'Protocol Adapter not loadable',
    "TNS-00528":'Protocol Adapter not loaded',
    "TNS-00530":'Protocol adapter error',
    "TNS-00532":'No previous async operation to wait on',
    "TNS-00533":'Connection dissolved or not yet made',
    "TNS-00534":'Failed to grant connection ownership to child',
    "TNS-00535":'Failed to send or receive disconnect message',
    "TNS-00536":'Connection entered inappropriate state',
    "TNS-00537":'Index into protocol adapter table is out of legal range',
    "TNS-00539":'Network or Protocol services are down',
    "TNS-00540":'SSL protocol adapter failure',
    "TNS-00541":'underlying transport does not exist.',
    "TNS-00542":'SSL Handshake failed',
    "TNS-00543":'internal error',
    "TNS-00544":'unsupported operation',
    "TNS-00545":'parameter retrieval failure',
    "TNS-00546":'control failure',
    "TNS-00547":'user information retrieval failed',
    "TNS-00548":'value specified for client authentication parameter is not boolean',
    "TNS-00549":'value specified for the SSL version is not valid',
    "TNS-00550":'disconnection error',
    "TNS-00551":'underlying transport connection failed',
    "TNS-00552":'no valid cipher suites were specified',
    "TNS-00553":'read failed',
    "TNS-00554":'write failed',
    "TNS-00555":'no directory specified for wallet resource locator',
    "TNS-00556":'no method specified for wallet retrieval',
    "TNS-00557":'unsupported wallet retrieval method',
    "TNS-00558":'Entrust login failed',
    "TNS-00559":'load of Entrust certificate failed',
    "TNS-00560":'extraction of name from Entrust certificate failed',
    "TNS-00580":'Read failed due to closed or invalid transport connection',
    "TNS-00581":'Send failed due to timeout',
    "TNS-00582":'Receive failed due to timeout',
    "TNS-00583":'Valid node checking: unable to parse configuration parameters',
    "TNS-00584":'Valid node checking configuration error',
    "TNS-01000":'spawn [<listener_name>] <spawn_alias> [<(ARGUMENTS="arg0, arg1,...")>]',
    "TNS-01001":'start [<listener_name>] : start listener',
    "TNS-01002":'stop [<listener_name>] : stop listener',
    "TNS-01003":'status [<listener_name>] : get the status of listener',
    "TNS-01004":'reload [<listener_name>] : reload the parameter files and SIDs',
    "TNS-01005":'trace OFF | USER | ADMIN | SUPPORT [<listener_name>] : set tracing to the specified level',
    "TNS-01006":'set password : set the password for subsequent calls',
    "TNS-01007":'quit | exit : exit LSNRCTL',
    "TNS-01008":'version [<listener_name>] : get the version information of the listener',
    "TNS-01009":'service [<listener_name>] : get the service information of the listener',
    "TNS-01013":'set|show trc_{ } [<value>]: set|show trace parameters of current listener',
    "TNS-01014":'set|show log_{ } [<value>]: set|show log parameters of current listener',
    "TNS-01015":'set|show parm_name [<value>]: sets|shows current listener parm values',
    "TNS-01016":'change_password [<listener_name>]: changes the password of the listener',
    "TNS-01017":'set|show current_listener [<listener_name>]: sets|shows current listener',
    "TNS-01018":'save_config [<listener_name>]: saves configuration changes to parameter file',
    "TNS-01019":'set rawmode ON | OFF: set output mode for services and status commands',
    "TNS-01020":'STATUS of the LISTENER',
    "TNS-01021":'------------------------',
    "TNS-01022":'Alias string',
    "TNS-01023":'Version string',
    "TNS-01024":'Trace Level string',
    "TNS-01025":'Security string',
    "TNS-01026":'Start Date string',
    "TNS-01027":'Listener Trace File string',
    "TNS-01028":'Listener Log File string',
    "TNS-01029":'Services Summary...',
    "TNS-01030":'The listener supports no services',
    "TNS-01033":'Listener Parameter File string',
    "TNS-01034":'Uptime number days number hr. number min. number sec',
    "TNS-01036":'%s established:string refused:string',
    "TNS-01037":'"string" established:string refused:string',
    "TNS-01038":'%s established:string refused:string current:string max:string state:string',
    "TNS-01039":'%s has string service handler(s)',
    "TNS-01040":'SNMP string',
    "TNS-01041":'%s parameter "string" set to string',
    "TNS-01042":'Current Listener is string',
    "TNS-01043":'Password changed for string',
    "TNS-01044":'%s(Registered) has string service handler(s)',
    "TNS-01045":'%s(Not Registered) has string service handler(s)',
    "TNS-01046":'Saved string configuration parameters.',
    "TNS-01047":'Old Parameter File string',
    "TNS-01048":'No changes to save for string.',
    "TNS-01049":'%s (string) has string service handler(s)',
    "TNS-01050":'%s',
    "TNS-01052":'The command completed successfully',
    "TNS-01053":'Connecting to string',
    "TNS-01054":'Contacted the listener successfully',
    "TNS-01055":'Successfully stopped the listener',
    "TNS-01057":'Program name: string',
    "TNS-01058":'Arguments : string',
    "TNS-01059":'Environment : string',
    "TNS-01060":'The password has has been set to: string',
    "TNS-01061":'The password has not been set',
    "TNS-01062":'The db subagent is already running.',
    "TNS-01063":'The db subagent is not started.',
    "TNS-01064":'Listener configuration changes will not be persistent',
    "TNS-01065":'Raw mode is string',
    "TNS-01066":'Presentation: string',
    "TNS-01067":'Service display mode is string',
    "TNS-01070":'Starting string: please wait...',
    "TNS-01071":'%s is set to string',
    "TNS-01072":'Started at string',
    "TNS-01073":'Listening on: string',
    "TNS-01074":'Error listening on: string',
    "TNS-01075":'Opened log file: string',
    "TNS-01076":'Opened trace file: string',
    "TNS-01077":'Opened parameter file: string',
    "TNS-01078":'Opened name lookup file: string',
    "TNS-01079":'Attempted to bequeath: string',
    "TNS-01080":'Listener failed to start. See the error message(s) above...',
    "TNS-01081":'Started with pid=string',
    "TNS-01082":'Running in PROXY mode',
    "TNS-01090":'No longer listening on: string',
    "TNS-01093":'%s * string * number',
    "TNS-01094":'%s * number',
    "TNS-01095":'%s * string * string * number',
    "TNS-01096":'%s * string * string * string * string * number',
    "TNS-01097":'TIMESTAMP * CONNECT DATA [* PROTOCOL INFO] * EVENT [* SID] * RETURN CODE',
    "TNS-01098":'TIMESTAMP * CONNECT DATA * ADDRESS * [PRESENTATION *] COMMAND * ERROR TIMESTAMP * [INSTANCE NAME *] [ADDRESS *] [PRESENTATION *] COMMAND * ERROR -------------------------------------------------------------------------------',
    "TNS-01099":'%s * string * string * string * number',
    "TNS-01100":'TNS returned error number when attempting to start the listener',
    "TNS-01101":'Could not find service name string',
    "TNS-01102":'TNS application contacted was not the listener',
    "TNS-01103":'Protocol specific component of the address is incorrectly specified',
    "TNS-01106":'Listener using listener name string has already been started',
    "TNS-01107":'A valid trace level was not specified',
    "TNS-01108":'Listener password prompt failed',
    "TNS-01109":'Listener password encryption failed',
    "TNS-01110":'Mismatch - password unchanged',
    "TNS-01111":'Log status can either be ON or OFF',
    "TNS-01112":'Plug and play can either be ON or OFF',
    "TNS-01113":'save_config_on_stop can either be ON or OFF',
    "TNS-01114":'LSNRCTL could not perform local OS authentication with the listener',
    "TNS-01115":'OS error string creating shared memory segment of string bytes with key string',
    "TNS-01116":'Listener alias name given as connect identifier is too long',
    "TNS-01150":'The address of the specified listener name is incorrect',
    "TNS-01151":'Missing listener name, string, in LISTENER.ORA',
    "TNS-01152":'All addresses specified for the listener name, string, failed',
    "TNS-01153":'Failed to process string: string',
    "TNS-01154":'SID detected in old format that is no longer supported',
    "TNS-01155":'Incorrectly specified SID_LIST_string parameter in LISTENER.ORA',
    "TNS-01156":'Missing or inappropriate PROTOCOL, TIMEOUT or POOL_SIZE parameter from PRESPAWN_DESC',
    "TNS-01157":'Can only listen on number addresses - ignoring string',
    "TNS-01158":'Internal connection limit reached, preventing dispatcher from connecting',
    "TNS-01159":'Internal connection limit has been reached; listener has shut down',
    "TNS-01160":'Trace level was not specified',
    "TNS-01161":'Spawn alias string was not found. Check listener parameter file',
    "TNS-01162":'Syntax error in the address resolved from the spawn alias: string',
    "TNS-01163":'Failed to spawn process: string',
    "TNS-01164":'No spawn alias sent to listener',
    "TNS-01165":'Spawn alias has no program name set in it',
    "TNS-01167":'The command string is not supported by the listener contacted',
    "TNS-01168":'Cannot allocate memory',
    "TNS-01169":'The listener has not recognized the password',
    "TNS-01170":'Event detection broke for address: string',
    "TNS-01171":'Event detection broke for dispatcher: string',
    "TNS-01172":'Listener has shut down since all listen addresses have been deallocated',
    "TNS-01173":'Missing or inappropriate PRESPAWN_MAX parameter from SID_DESC',
    "TNS-01174":'The sum of the POOL_SIZEs from each PRESPAWN_DESC is greater than the PRESPAWN_MAX',
    "TNS-01175":'Password unchanged',
    "TNS-01176":'Error in loading the new parameter value',
    "TNS-01177":'Log Status is OFF. Log file/directory unchanged',
    "TNS-01178":'Trace Level is 0. Trace file/directory unchanged',
    "TNS-01179":'Listener cannot load instance class "string"',
    "TNS-01180":'Missing listener object string in Directory Server',
    "TNS-01181":'Internal registration connection limit reached',
    "TNS-01182":'Listener rejected registration of service "string"',
    "TNS-01183":'Listener rejected registration or update of instance "string"',
    "TNS-01184":'Listener rejected registration or update of service handler "string"',
    "TNS-01185":'Registration attempted from a remote node',
    "TNS-01186":'Client connection was dropped based on a filtering rule',
    "TNS-01187":'No proxy service handler available',
    "TNS-01188":'Listener cannot operate with incompatible transport protocols',
    "TNS-01189":'The listener could not authenticate the user',
    "TNS-01190":'The user is not authorized to execute the requested listener command',
    "TNS-01191":'Failed to initialize the local OS authentication subsystem',
    "TNS-01192":'Missing SID_LIST_ value left of equation for SID description in LISTENER.ORA',
    "TNS-01200":'The listener must be suid root',
    "TNS-01201":'Listener cannot find executable string for SID string',
    "TNS-01202":'Missing the dba group (string) specified by DBA_GROUP in SID_DESC',
    "TNS-01203":'Missing the account (string) specified by DEFAULT_USER_ACCOUNT in SID_DESC',
    "TNS-01204":'Unprivileged account (string) is in dba group (string)',
    "TNS-01300":'ERROR at string',
    "TNS-01301":'TNS error structure:',
    "TNS-01302":'nr err code: number',
    "TNS-01303":'ns main err code: number',
    "TNS-01304":'ns secondary err code: number',
    "TNS-01305":'nt main err code: number',
    "TNS-01306":'nt secondary err code: number',
    "TNS-01307":'nt OS err code: number',
    "TNS-01400":'Instance "string" has number handlers.',
    "TNS-01401":'Class: string',
    "TNS-01402":'TYPE: string',
    "TNS-01403":'Load: string',
    "TNS-01404":'Max Load: string',
    "TNS-01405":'Host: string',
    "TNS-01406":'ID: string',
    "TNS-01407":'Status: string Total handlers: string Relevant handlers: string',
    "TNS-01408":'Instance "string", status string, has string handler(s) for this service...',
    "TNS-01409":'Instance "string"',
    "TNS-01410":'Service "string" has number instances.',
    "TNS-01411":'Service "string" has number instance(s).',
    "TNS-01412":'Handler(s):',
    "TNS-01413":'"string" established:string refused:string current:string max:string state:string',
    "TNS-01414":'"string", state string, established string, refused string, current string, max string',
    "TNS-01415":'Listening Endpoints Summary...',
    "TNS-01416":'Process ID string',
    "TNS-01417":'"string" established:string refused:string state:string',
    "TNS-01418":'Proxy service "string" has number instance(s).',
    "TNS-01420":'Presentation: string',
    "TNS-01421":'Session: string',
    "TNS-01441":'Number of filtering rules currently in effect: number',
    "TNS-01442":'No filtering rules currently in effect.',
    "TNS-02020":'set displaymode RAW | COMPAT | NORMAL | VERBOSE: output mode for lsnrctl display',
    "TNS-02021":'DIRECT_HANDOFF can be either ON or OFF.',
    "TNS-02022":'show rules: Show rules that are currently in effect',
    "TNS-02401":'gbname string too long, allowed number characters',
    "TNS-02402":'Bad CLBGNAMES parameter in tnsnames.ora',
    "TNS-02403":'Bad alias string or alias not present in tnsnames.ora',
    "TNS-02404":'Service string contains no local handlers',
    "TNS-02405":'GMS call failed, check GMS logs.',
    "TNS-02501":'Authentication: no more roles',
    "TNS-02502":'Authentication: unable to find initialization function',
    "TNS-02503":'Parameter retrieval failed',
    "TNS-02504":'Parameter count retrieval failed',
    "TNS-02505":'Authentication: null context pointer provided',
    "TNS-02506":'Authentication: no type string',
    "TNS-02507":'Encryption: algorithm not installed',
    "TNS-02508":'Encryption: server negotiation response in error',
    "TNS-02509":'Authentication: invalid process state',
    "TNS-02510":'Invalid numeric data type',
    "TNS-02511":'Invalid data type',
    "TNS-02512":'Invalid status received',
    "TNS-02513":'Requested data type does not match retrieved type',
    "TNS-02514":'Invalid packet received',
    "TNS-02515":'Encryption/crypto-checksumming: unknown control type',
    "TNS-02516":'No data available',
    "TNS-02517":'key smaller than requested size',
    "TNS-02518":'key negotiation error',
    "TNS-02519":'no appropriate key-negotiation parameters',
    "TNS-02520":'encryption/crypto-checksumming: no Diffie-Hellman seed',
    "TNS-02521":'encryption/crypto-checksumming: Diffie-Hellman seed too small',
    "TNS-02524":'Authentication: privilege check failed',
    "TNS-02525":'encryption/crypto-checksumming: self test failed',
    "TNS-02526":'server proxy type does not match client type',
    "TNS-03501":'OK',
    "TNS-03502":'Insufficient arguments. Usage: tnsping <address> [<count>]',
    "TNS-03503":'Could not initialize NL',
    "TNS-03504":'Service name too long',
    "TNS-03505":'Failed to resolve name',
    "TNS-03506":'Failed to create address binding',
    "TNS-03507":'Failure looking for ADDRESS keyword',
    "TNS-03508":'Failed to create address string',
    "TNS-03509":'OK (number msec)',
    "TNS-03510":'Failed due to I/O error',
    "TNS-03511":'Used parameter files: string',
    "TNS-03512":'Used string adapter to resolve the alias',
    "TNS-03601":'Failed in route information collection',
    "TNS-03602":'Insufficient arguments. Usage: trcroute <address>',
    "TNS-03603":'Encountered a node with a version eariler than SQL*Net 2.3',
    "TNS-04001":'%s',
    "TNS-04002":'The command completed successfully.',
    "TNS-04003":'Syntax Error.',
    "TNS-04004":'Unable to encrypt the supplied password.',
    "TNS-04005":'Unable to resolve address for string.',
    "TNS-04006":'Invalid password',
    "TNS-04007":'Internal error number.',
    "TNS-04008":'%-25s | string',
    "TNS-04009":'%-25s | number',
    "TNS-04010":'Command cannot be issued before the ADMINISTER command.',
    "TNS-04011":'Oracle Connection Manager instance not yet started.',
    "TNS-04012":'Unable to start Oracle Connection Manager instance.',
    "TNS-04013":'CMCTL timed out waiting for Oracle Connection Manager to start',
    "TNS-04014":'Current instance string is already started',
    "TNS-04015":'Current instance string is not yet started',
    "TNS-04016":'Connecting to string',
    "TNS-04017":'Please wait. Shutdown in progress.',
    "TNS-04018":'Instance already started',
    "TNS-04019":'Starting Oracle Connection Manager instance string. Please wait...',
    "TNS-04020":'CMCTL Version: number.number.number.number.number',
    "TNS-04021":'The SET command is unsuccessful for parameter string.',
    "TNS-04022":'%s parameter string set to string.',
    "TNS-04023":'Command failed.',
    "TNS-04031":'CMCTL: internal NT error',
    "TNS-04032":'CMCTL: internal NS error',
    "TNS-04033":'CMCTL: internal NL error',
    "TNS-04034":'CMCTL: internal NFP error',
    "TNS-04035":'CMCTL: error while constructing full file name',
    "TNS-04036":'CMCTL: error reading from Connection Manager error files',
    "TNS-04037":'Connections refer to string.',
    "TNS-04038":'CMCTL: Poorly formed address or command string',
    "TNS-04039":'CMCTL: error while spawning a process',
    "TNS-04040":'CMCTL: failed to initialize trace context- Continuing anyway',
    "TNS-04041":'CMCTL: Connection Manager already running. Start operation cancelled',
    "TNS-04042":'CMCTL: Connection Manager Admin already running. Start operation cancelled',
    "TNS-04043":'The Connection Manager has active connections. Do you still want to stop it (y/n)?',
    "TNS-04044":'Specified gateways do not exist.',
    "TNS-04045":'Invalid specification of time',
    "TNS-04046":'Invalid specification for source',
    "TNS-04047":'Invalid specification for destination',
    "TNS-04048":'Specified service does not exist.',
    "TNS-04049":'Specified connections do not exist',
    "TNS-04050":'Invalid specification for gateway ID.',
    "TNS-04060":'CMCTL: Bad command: only the STATUS command can be used on remote Connection Manager',
    "TNS-04061":'CMCTL: Bad command or syntax error: You must specify a trace level',
    "TNS-04062":'CMCTL: Bad command or syntax error: For help type help/h/?',
    "TNS-04063":'Remote administration disabled in the Oracle Connection Manager instance.',
    "TNS-04064":'The number of CMCTL sessions exceeds MAX_CMCTL_SESSIONS.',
    "TNS-04065":'The number of remote CMCTL sessions exceeds (MAX_CMCTL_SESSIONS-1)',
    "TNS-04066":'The following log events can be enabled or disabled:',
    "TNS-04067":'Number of connections: number.',
    "TNS-04068":'Cannot start an Oracle Connection Manager instance remotely.',
    "TNS-04069":'Sleeping for number seconds...',
    "TNS-04070":'Cannot administer a remote Oracle Connection Manager instance which is not yet started.',
    "TNS-04071":'Connections closed successfully. Number closed: number.',
    "TNS-04072":'Unable to suspend atleast one of the gateways.',
    "TNS-04073":'Passwords do not match.',
    "TNS-04074":'Invalid value for the parameter string.',
    "TNS-04075":'Cannot use ADMINISTER directly from the command line.',
    "TNS-04076":'Invalid specification for state.',
    "TNS-04077":'WARNING: No password set for the Oracle Connection Manager instance.',
    "TNS-04078":'Unable to resume atleast one of the gateways.',
    "TNS-04079":'Cannot administer Oracle Connection Manager with no CMAN.ORA, and port = number.',
    "TNS-04080":'Failed to reload',
    "TNS-04081":'Event groups:',
    "TNS-04082":'%s event string set to string.',
    "TNS-04083":'Failed to save password',
    "TNS-04084":'WARNING: Non-reloadable parameters have retained their values.',
    "TNS-04085":'Password not changed since last save.',
    "TNS-04086":'Invalid value for the event string.',
    "TNS-04087":'Unable to shutdown atleast one of the gateways.',
    "TNS-04088":'Unable to close atleast one of the connections.',
    "TNS-04089":'Alias name too long.',
    "TNS-04090":'string',
    "TNS-04091":'accept_connections [ON|OFF] : acc/deny subsequent connections (default is ON)',
    "TNS-04092":'show address : displays address list CMAN is listening on',
    "TNS-04093":'show ALL : displays all information about current CMAN',
    "TNS-04094":'set authentication_level [0|1]: default is 0',
    "TNS-04095":'change_password [<cman name>] : changes the password of the CMAN',
    "TNS-04096":'close_relay {number | ALL} : forces relay(s) to be shut down',
    "TNS-04097":'set|show current_cman [<cman_name>]: sets|shows current CMAN',
    "TNS-04098":'set|show displaymode [COMPAT|VERB] : sets|shows display mode',
    "TNS-04099":'set log_level [0-4] : default is 0',
    "TNS-04100":'set password : set the password for subsequent calls',
    "TNS-04101":'show profile : shows the parameter profile of the current CMAN',
    "TNS-04102":'set relay_statistics [ON|OFF] : default is OFF',
    "TNS-04103":'show relay {number|ACTive}: shows the status of relay(s) in the current CMAN',
    "TNS-04104":'reload_rules : re-reads rule list from profile',
    "TNS-04105":'set|show remote_admin ON|OFF : sets|shows remote administration capability',
    "TNS-04106":'show rules : shows rule list used by current CMAN for connection filtering',
    "TNS-04107":'save_config [<cman_name>] : saves configuration changes to parameter file',
    "TNS-04108":'shutdown [NORMAL|ABORT] [cman] : stops CMAN in NORMAL or ABORT modes',
    "TNS-04109":'start [cm|adm|cman] : starts selected CMAN process(es)',
    "TNS-04110":'stats [cm|cman] : shows connection statistics',
    "TNS-04111":'status [cm|adm|cman] : shows current status of selected CMAN process(es)',
    "TNS-04112":'stop [cm|adm|cman] : stops CMAN process(es) interactively',
    "TNS-04113":'stopnow [cm|adm|cman] : aborts CMAN process(es)',
    "TNS-04114":'set TNS_info [ON|OFF] : turns on/off TNS logging (default is off)',
    "TNS-04115":'set trc_level [<value>] : sets trace level of current CMAN',
    "TNS-04116":'version [cman] : displays CMAN version information',
    "TNS-04117":'show _dev_info <relay_num> : shows detailed device information about the relay',
    "TNS-04118":'quit | exit : exits CMCTL',
    "TNS-04119":'CMAN password encryption failed',
    "TNS-04120":'Current CMAN is string',
    "TNS-04121":'The command completed successfully',
    "TNS-04122":'CMAN state not running',
    "TNS-04123":'ADMIN state not running',
    "TNS-04124":'Current display mode is string',
    "TNS-04125":'The command was unsuccessful',
    "TNS-04126":'string Version string',
    "TNS-04127":'Connecting to string',
    "TNS-04128":'STATUS of the string',
    "TNS-04129":'Start-up time string',
    "TNS-04130":'Current state string',
    "TNS-04131":'Starting string: please wait...',
    "TNS-04132":'STATISTICS of CMAN',
    "TNS-04133":'Total number of connections handled string',
    "TNS-04134":'Number of currently active relays string',
    "TNS-04135":'Peak active relays string',
    "TNS-04136":'Total refusals due to max_relays exceeded string',
    "TNS-04137":'Total number of connections refused string',
    "TNS-04139":'Profile of the CMAN',
    "TNS-04140":'Migration completed successfully.',
    "TNS-04141":'Unable to find CMAN.ORA file.',
    "TNS-04142":'CMAN.ORA file has an invalid format.',
    "TNS-04143":'Unable to write the new CMAN.ORA file.',
    "TNS-04144":'Nothing to migrate',
    "TNS-04145":'ANSWER_TIMEOUT = string',
    "TNS-04146":'MAXIMUM_CONNECT_DATA = string',
    "TNS-04147":'USE_ASYNC_CALL = string',
    "TNS-04148":'TRACING = string',
    "TNS-04149":'TRACE_DIRECTORY = string',
    "TNS-04150":'MAX_FREELIST_BUFFERS = string',
    "TNS-04151":'REMOTE_ADMIN = string',
    "TNS-04152":'Relay Information',
    "TNS-04153":'Relay number string',
    "TNS-04154":'Src string',
    "TNS-04155":'Dest string',
    "TNS-04156":'Number of IN bytes string',
    "TNS-04157":'Number of IN packets string',
    "TNS-04158":'Number of IN DCD probes string',
    "TNS-04159":'Number of OUT bytes string',
    "TNS-04160":'Number of OUT packets string',
    "TNS-04161":'Number of OUT DCD probes string',
    "TNS-04162":'Address List',
    "TNS-04163":'Active Relays',
    "TNS-04164":'Rule List',
    "TNS-04165":'Relay is not active',
    "TNS-04201":'Trace Assistant Usage ERROR: Missing File name',
    "TNS-04202":'Trace Assistant Usage ERROR: Not enough arguments',
    "TNS-04203":'Trace Assistant Usage ERROR: Invalid options',
    "TNS-04204":'Trace Assistant Internal ERROR: Couldn"t Open trace file',
    "TNS-04205":'Trace Assistant Internal ERROR: Memory',
    "TNS-04206":'Trace Assistant Internal ERROR: Packet Type',
    "TNS-04207":'Trace Assistant Internal ERROR: Packet Length',
    "TNS-04208":'Trace Assistant Internal ERROR: Fatal',
    "TNS-04209":'Trace Assistant Internal ERROR: Type Error',
    "TNS-04210":'Trace Assistant Internal ERROR: End of File',
    "TNS-04211":'Trace Assistant Internal ERROR: CORE',
    "TNS-04212":'Trace Assistant Internal ERROR: NACOM Type Error',
    "TNS-04231":'Trace Assistant WARNING: Assuming Oracle trace format',
    "TNS-04232":'Trace Assistant WARNING: Not retrieving all rows',
    "TNS-04233":'Trace Assistant WARNING: Going beyond Packet length',
    "TNS-04234":'Trace Assistant WARNING: won"t decode TTC',
    "TNS-04235":'Trace Assistant WARNING: Unknown TTC protocol',
    "TNS-12150":'TNS:unable to send data',
    "TNS-12151":'TNS:received bad packet type from network layer',
    "TNS-12152":'TNS:unable to send break message',
    "TNS-12153":'TNS:not connected',
    "TNS-12154":'TNS:could not resolve the connect identifier specified',
    "TNS-12155":'TNS:received bad datatype in NSWMARKER packet',
    "TNS-12156":'TNS:tried to reset line from incorrect state',
    "TNS-12157":'TNS:internal network communication error',
    "TNS-12158":'TNS:could not initialize parameter subsystem',
    "TNS-12159":'TNS:trace file not writeable',
    "TNS-12160":'TNS:internal error: Bad error number',
    "TNS-12161":'TNS:internal error: partial data received',
    "TNS-12162":'TNS:net service name is incorrectly specified',
    "TNS-12163":'TNS:connect descriptor is too long',
    "TNS-12164":'TNS:Sqlnet.fdf file not present',
    "TNS-12165":'TNS:Trying to write trace file into swap space.',
    "TNS-12166":'TNS:Client can not connect to HO agent.',
    "TNS-12168":'TNS:Unable to contact LDAP Directory Server',
    "TNS-12169":'TNS:Net service name given as connect identifier is too long',
    "TNS-12170":'TNS:Connect timeout occurred',
    "TNS-12171":'TNS:could not resolve connect identifier: string',
    "TNS-12196":'TNS:received an error from TNS',
    "TNS-12197":'TNS:keyword-value resolution error',
    "TNS-12198":'TNS:could not find path to destination',
    "TNS-12200":'TNS:could not allocate memory',
    "TNS-12201":'TNS:encountered too small a connection buffer',
    "TNS-12202":'TNS:internal navigation error',
    "TNS-12203":'TNS:unable to connect to destination',
    "TNS-12204":'TNS:received data refused from an application',
    "TNS-12205":'TNS:could not get failed addresses',
    "TNS-12206":'TNS:received a TNS error during navigation',
    "TNS-12207":'TNS:unable to perform navigation',
    "TNS-12208":'TNS:could not find the TNSNAV.ORA file',
    "TNS-12209":'TNS:encountered uninitialized global',
    "TNS-12210":'TNS:error in finding Navigator data',
    "TNS-12211":'TNS:needs PREFERRED_CMANAGERS entry in TNSNAV.ORA',
    "TNS-12212":'TNS:incomplete PREFERRED_CMANAGERS binding in TNSNAV.ORA',
    "TNS-12213":'TNS:incomplete PREFERRED_CMANAGERS binding in TNSNAV.ORA',
    "TNS-12214":'TNS:missing local communities entry in TNSNAV.ORA',
    "TNS-12215":'TNS:poorly formed PREFERRED_NAVIGATORS Addresses in TNSNAV.ORA',
    "TNS-12216":'TNS:poorly formed PREFERRED_CMANAGERS addresses in TNSNAV.ORA',
    "TNS-12217":'TNS:could not contact PREFERRED_CMANAGERS in TNSNAV.ORA',
    "TNS-12218":'TNS:unacceptable network configuration data',
    "TNS-12219":'TNS:missing community name from address in ADDRESS_LIST',
    "TNS-12221":'TNS:illegal ADDRESS parameters',
    "TNS-12222":'TNS:no support is available for the protocol indicated',
    "TNS-12223":'TNS:internal limit restriction exceeded',
    "TNS-12224":'TNS:no listener',
    "TNS-12225":'TNS:destination host unreachable',
    "TNS-12226":'TNS:operating system resource quota exceeded',
    "TNS-12227":'TNS:syntax error',
    "TNS-12228":'TNS:protocol adapter not loadable',
    "TNS-12229":'TNS:Interchange has no more free connections',
    "TNS-12230":'TNS:Severe Network error occurred in making this connection',
    "TNS-12231":'TNS:No connection possible to destination',
    "TNS-12232":'TNS:No path available to destination',
    "TNS-12233":'TNS:Failure to accept a connection',
    "TNS-12234":'TNS:Redirect to destination',
    "TNS-12235":'TNS:Failure to redirect to destination',
    "TNS-12236":'TNS:protocol support not loaded',
    "TNS-12500":'TNS:listener failed to start a dedicated server process',
    "TNS-12502":'TNS:listener received no CONNECT_DATA from client',
    "TNS-12504":'TNS:listener was not given the SID in CONNECT_DATA',
    "TNS-12505":'TNS:listener does not currently know of SID given in connect descriptor',
    "TNS-12508":'TNS:listener could not resolve the COMMAND given',
    "TNS-12509":'TNS:listener failed to redirect client to service handler',
    "TNS-12510":'TNS:database temporarily lacks resources to handle the request',
    "TNS-12511":'TNS:service handler found but it is not accepting connections',
    "TNS-12512":'TNS:service handler found but it has not registered a redirect address',
    "TNS-12513":'TNS:service handler found but it has registered for a different protocol',
    "TNS-12514":'TNS:listener does not currently know of service requested in connect descriptor',
    "TNS-12515":'TNS:listener could not find a handler for this presentation',
    "TNS-12516":'TNS:listener could not find available handler with matching protocol stack',
    "TNS-12517":'TNS:listener could not find service handler supporting direct handoff',
    "TNS-12518":'TNS:listener could not hand off client connection',
    "TNS-12519":'TNS:no appropriate service handler found',
    "TNS-12520":'TNS:listener could not find available handler for requested type of server',
    "TNS-12521":'TNS:listener does not currently know of instance requested in connect descriptor',
    "TNS-12522":'TNS:listener could not find available instance with given INSTANCE_ROLE',
    "TNS-12523":'TNS:listener could not find instance appropriate for the client connection',
    "TNS-12524":'TNS:listener could not resolve HANDLER_NAME given in connect descriptor',
    "TNS-12525":'TNS:listener has not received client"s request in time allowed',
    "TNS-12526":'TNS:listener: all appropriate instances are in restricted mode',
    "TNS-12527":'TNS:listener: all instances are in restricted mode or blocking new connections',
    "TNS-12528":'TNS:listener: all appropriate instances are blocking new connections',
    "TNS-12529":'TNS:connect request rejected based on current filtering rules',
    "TNS-12531":'TNS:cannot allocate memory',
    "TNS-12532":'TNS:invalid argument',
    "TNS-12533":'TNS:illegal ADDRESS parameters',
    "TNS-12534":'TNS:operation not supported',
    "TNS-12535":'TNS:operation timed out',
    "TNS-12536":'TNS:operation would block',
    "TNS-12537":'TNS:connection closed',
    "TNS-12538":'TNS:no such protocol adapter',
    "TNS-12539":'TNS:buffer over- or under-flow',
    "TNS-12540":'TNS:internal limit restriction exceeded',
    "TNS-12541":'TNS:no listener',
    "TNS-12542":'TNS:address already in use',
    "TNS-12543":'TNS:destination host unreachable',
    "TNS-12544":'TNS:contexts have different wait/test functions',
    "TNS-12545":'Connect failed because target host or object does not exist',
    "TNS-12546":'TNS:permission denied',
    "TNS-12547":'TNS:lost contact',
    "TNS-12548":'TNS:incomplete read or write',
    "TNS-12549":'TNS:operating system resource quota exceeded',
    "TNS-12550":'TNS:syntax error',
    "TNS-12551":'TNS:missing keyword',
    "TNS-12552":'TNS:operation was interrupted',
    "TNS-12554":'TNS:current operation is still in progress',
    "TNS-12555":'TNS:permission denied',
    "TNS-12556":'TNS:no caller',
    "TNS-12557":'TNS:protocol adapter not loadable',
    "TNS-12558":'TNS:protocol adapter not loaded',
    "TNS-12560":'TNS:protocol adapter error',
    "TNS-12561":'TNS:unknown error',
    "TNS-12562":'TNS:bad global handle',
    "TNS-12564":'TNS:connection refused',
    "TNS-12566":'TNS:protocol error',
    "TNS-12569":'TNS:packet checksum failure',
    "TNS-12570":'TNS:packet reader failure',
    "TNS-12571":'TNS:packet writer failure',
    "TNS-12574":'TNS:redirection denied',
    "TNS-12582":'TNS:invalid operation',
    "TNS-12583":'TNS:no reader',
    "TNS-12585":'TNS:data truncation',
    "TNS-12589":'TNS:connection not bequeathable',
    "TNS-12590":'TNS:no I/O buffer',
    "TNS-12591":'TNS:event signal failure',
    "TNS-12592":'TNS:bad packet',
    "TNS-12593":'TNS:no registered connection',
    "TNS-12595":'TNS:no confirmation',
    "TNS-12596":'TNS:internal inconsistency',
    "TNS-12597":'TNS:connect descriptor already in use',
    "TNS-12598":'TNS:banner registration failed',
    "TNS-12599":'TNS:cryptographic checksum mismatch',
    "TNS-12600":'TNS: string open failed',
    "TNS-12601":'TNS:information flags check failed',
    "TNS-12602":'TNS: Connection Pooling limit reached',
    "TNS-12604":'TNS: Application timeout occurred',
    "TNS-12606":'TNS: Application timeout occurred',
    "TNS-12607":'TNS: Connect timeout occurred',
    "TNS-12608":'TNS: Send timeout occurred',
    "TNS-12609":'TNS: Receive timeout occurred',
    "TNS-12611":'TNS:operation is not portable',
    "TNS-12612":'TNS:connection is busy',
    "TNS-12615":'TNS:preempt error',
    "TNS-12616":'TNS:no event signals',
    "TNS-12617":"TNS:bad 'what' type",
    "TNS-12618":'TNS:versions are incompatible',
    "TNS-12619":'TNS:unable to grant requested service',
    "TNS-12620":'TNS:requested characteristic not available',
    "TNS-12622":'TNS:event notifications are not homogeneous',
    "TNS-12623":'TNS:operation is illegal in this state',
    "TNS-12624":'TNS:connection is already registered',
    "TNS-12625":'TNS:missing argument',
    "TNS-12626":'TNS:bad event type',
    "TNS-12628":'TNS:no event callbacks',
    "TNS-12629":'TNS:no event test',
    "TNS-12630":'Native service operation not supported',
    "TNS-12631":'Username retrieval failed',
    "TNS-12632":'Role fetch failed',
    "TNS-12633":'No shared authentication services',
    "TNS-12634":'Memory allocation failed',
    "TNS-12635":'No authentication adapters available',
    "TNS-12636":'Packet send failed',
    "TNS-12637":'Packet receive failed',
    "TNS-12638":'Credential retrieval failed',
    "TNS-12639":'Authentication service negotiation failed',
    "TNS-12640":'Authentication adapter initialization failed',
    "TNS-12641":'Authentication service failed to initialize',
    "TNS-12642":'No session key',
    "TNS-12643":'Client received internal error from server',
    "TNS-12644":'Authentication service initialization failed',
    "TNS-12645":'Parameter does not exist.',
    "TNS-12646":'Invalid value specified for boolean parameter',
    "TNS-12647":'Authentication required',
    "TNS-12648":'Encryption or data integrity algorithm list empty',
    "TNS-12649":'Unknown encryption or data integrity algorithm',
    "TNS-12650":'No common encryption or data integrity algorithm',
    "TNS-12651":'Encryption or data integrity algorithm unacceptable',
    "TNS-12652":'String truncated',
    "TNS-12653":'Authentication control function failed',
    "TNS-12654":'Authentication conversion failed',
    "TNS-12655":'Password check failed',
    "TNS-12656":'Cryptographic checksum mismatch',
    "TNS-12657":'No algorithms installed',
    "TNS-12658":'ANO service required but TNS version is incompatible',
    "TNS-12659":'Error received from other process',
    "TNS-12660":'Encryption or crypto-checksumming parameters incompatible',
    "TNS-12661":'Protocol authentication to be used',
    "TNS-12662":'proxy ticket retrieval failed',
    "TNS-12663":'Services required by client not available on the server',
    "TNS-12664":'Services required by server not available on the client',
    "TNS-12665":'NLS string open failed',
    "TNS-12666":'Dedicated server: outbound transport protocol different from inbound',
    "TNS-12667":'Shared server: outbound transport protocol different from inbound',
    "TNS-12668":'Dedicated server: outbound protocol does not support proxies',
    "TNS-12669":'Shared server: outbound protocol does not support proxies',
    "TNS-12670":'Incorrect role password',
    "TNS-12671":'Shared server: adapter failed to save context',
    "TNS-12672":'Database logon failure',
    "TNS-12673":'Dedicated server: context not saved',
    "TNS-12674":'Shared server: proxy context not saved',
    "TNS-12675":'External user name not available yet',
    "TNS-12676":'Server received internal error from client',
    "TNS-12677":'Authentication service not supported by database link',
    "TNS-12678":'Authentication disabled but required',
    "TNS-12679":'Native services disabled by other process but required',
    "TNS-12680":'Native services disabled but required',
    "TNS-12681":'Login failed: the SecurID card does not have a pincode yet',
    "TNS-12682":'Login failed: the SecurID card is in next PRN mode',
    "TNS-12683":'encryption/crypto-checksumming: no Diffie-Hellman seed',
    "TNS-12684":'encryption/crypto-checksumming: Diffie-Hellman seed too small',
    "TNS-12685":'Native service required remotely but disabled locally',
    "TNS-12686":'Invalid command specified for a service',
    "TNS-12687":'Credentials expired.',
    "TNS-12688":'Login failed: the SecurID server rejected the new pincode',
    "TNS-12689":'Server Authentication required, but not supported',
    "TNS-12690":'Server Authentication failed, login cancelled',
    "TNS-12696":'Double Encryption Turned On, login disallowed',
    "TNS-12699":'Native service internal error'
}

def getTnsErrorMessage(errCode):
    TNS_ERROR_CODES
    
    err = ""
    
    if len(errCode) < 5:
        errCode = "0"*(5-len(errCode)) + errCode

    if not errCode.upper().startswith("TNS-"):
        errCode = "TNS-%s" % errCode

    if TNS_ERROR_CODES.has_key(errCode):
        return TNS_ERROR_CODES[errCode]
    else:
        return None
