/*
 *  - Character editor menu tab
 */


#include <stdio.h>
#include "../ithelib.h"
#include "../gui/igui.hpp"
#include "../console.h"
#include "../core.hpp"
#include "../gamedata.h"
#include "../init.h"
#include "../gui/menusys.h"

// defines

#define VIEWX 64
#define VIEWY 112
#define STR_LEN 32
#define OVL_LEN 24

// variables

extern int focus,CH_Id;

static int curchr=0;
static int Polarity=0;

static int flag_id[32];
static int flag[32];

static int ChrName_Id,Desc_Id,Short_Id;
static int Up_Id,Down_Id,Left_Id,Right_Id,Light_Id,Tag_Id;
static int Edit_H_Id,Edit_V_Id,sol_x_Id,sol_y_Id,sol_w_Id,sol_h_Id,act_x_Id,act_y_Id,act_w_Id,act_h_Id;
static char Tag[]="0   ";
static char LightLevel[]="0   ";
static char ChrName[33];
static char Desc32[128];
static char SDesc32[33];
static char UpName[33];
static char DownName[33];
static char LeftName[33];
static char RightName[33];
static char none[]="-";

static char stats_hp_str[] =    "0          ";
static char stats_dex_str[] =   "0          ";
static char stats_str_str[] =   "0          ";
static char stats_intel_str[] = "0          ";
static char stats_weight_str[] ="0          ";
static char stats_damage_str[] ="0          ";
static char stats_mhealth_str[]="0          ";
static char stats_mdex_str[] =  "0          ";
static char stats_mstr_str[] =  "0          ";
static char stats_mintel_str[] ="0          ";
static int stats_hp_Id;
static int stats_dex_Id;
static int stats_str_Id;
static int stats_intel_Id;
static int stats_weight_Id;
static int stats_damage_Id;
static int stats_mhealth_Id;
static int stats_mdex_Id;
static int stats_mstr_Id;
static int stats_mintel_Id;

static char sol_x_str[] ="0  ";
static char sol_y_str[] ="0  ";
static char sol_w_str[] ="0  ";
static char sol_h_str[] ="0  ";

static char act_x_str[] ="0  ";
static char act_y_str[] ="0  ";
static char act_w_str[] ="0  ";
static char act_h_str[] ="0  ";

static char behave_str[40];
static int behave_Id,use_Id,kill_Id,look_Id,stand_Id,hurt_Id,init_Id,talk_Id,wield_Id,attack_Id,user1_Id,user2_Id;

static int item1_Id,item2_Id,item3_Id,item4_Id,item5_Id,item6_Id,item7_Id,item8_Id;
static char item1_str[33];
static char item2_str[33];
static char item3_str[33];
static char item4_str[33];
static char item5_str[33];
static char item6_str[33];
static char item7_str[33];
static char item8_str[33];

static char str32[STR_LEN+1];

// functions

extern void Toolbar();
extern void Snap();


static void Nothing();
static void ChrUpdate();                       // Update the displays
static void PickCharacter();
static void AddCharacter();
static void DelCharacter();
static void DupCharacter();
static void CharacterName();
static void LongDescription();
static void ShortDescription();
static short GetSequence(char *original);

static void UpAnim();
static void DownAnim();
static void LeftAnim();
static void RightAnim();
static void AllAnim();
static void settag();
static void setlight();

static void SetFlags();
static void SetFlags2();
static void FL_Read();
static void FL_Write();
static void FL_Read2();
static void FL_Write2();
static void Toggle();

static void EditStats();
static void Stats_Update();
static void SetHp();
static void SetDex();
static void SetStr();
static void SetIntel();
static void SetWeight();
static void SetDamage();
static void SetMHp();
static void SetMDex();
static void SetMStr();
static void SetMIntel();
static void Finish();
static int PickVrm(char *original);

static void EditActions();
static void EditActions2();
static void Behave_Update();
static void Behave_Update2();
static void SetBehave();
static void SetUse();
static void SetKill();
static void SetLook();
static void SetStand();
static void SetHurt();
static void SetInit();
static void SetWield();
static void SetTalk();
static void SetAttack();
static void SetUser1();
static void SetUser2();

static void EditSize();
static void Size_Update();
static void SetPolarityV();
static void SetPolarityH();
static void SetSolidX();
static void SetSolidY();
static void SetSolidW();
static void SetSolidH();
static void SetActiveX();
static void SetActiveY();
static void SetActiveW();
static void SetActiveH();

static void SetItem_generic(int no);
static void SetItem1();
static void SetItem2();
static void SetItem3();
static void SetItem4();
static void SetItem5();
static void SetItem6();
static void SetItem7();
static void SetItem8();
static void EditDefaultContents();
static void DefaultContentsUpdate();
static OBJECT *GetCharacter(char *original);

// GoFocal - The menu tab function.  This is called from the toolbar

void CH_GoFocal()
{
if(focus==3)            // Make sure we don't redraw if the user clicks again
	return;

memset(str32,' ',STR_LEN); str32[STR_LEN]=0;
memset(ChrName,' ',STR_LEN); ChrName[STR_LEN]=0;
memset(behave_str,' ',STR_LEN); behave_str[STR_LEN]=0;

focus=3;                // This is now the focus
Toolbar();              // Build up the menu system again from scratch
IG_SetFocus(CH_Id);     // And make the button stick inwards
/*
IG_TextButton(32,64," Add new character ",AddCharacter,NULL,NULL);
IG_AddKey(KEY_A,AddCharacter);

IG_TextButton(32,96," Pick a character  ",PickCharacter,NULL,NULL);
IG_AddKey(KEY_P,PickCharacter);

IG_TextButton(32,128," Delete character  ",DelCharacter,NULL,NULL);
IG_AddKey(KEY_D,DelCharacter);
*/

IG_TextButton(32,48," Add new character ",AddCharacter,NULL,NULL);
IG_AddKey(KEY_A,AddCharacter);

IG_TextButton(32,80," Pick a character  ",PickCharacter,NULL,NULL);
IG_AddKey(KEY_P,PickCharacter);

IG_TextButton(32,112," Delete character  ",DelCharacter,NULL,NULL);
IG_AddKey(KEY_D,DelCharacter);

IG_TextButton(32,144," Create duplicate  ",DupCharacter,NULL,NULL);
IG_AddKey(KEY_C,DupCharacter);


DrawScreenText(224,104,"Character:");
ChrName_Id = IG_InputButton(320,96,str32,CharacterName,NULL,NULL);

DrawScreenText(32,192,"Long description:");
Desc_Id = IG_InputButton(192,184,str32,LongDescription,NULL,NULL);
DrawScreenText(32,224,"Short description:");
Short_Id = IG_InputButton(192,216,str32,ShortDescription,NULL,NULL);

DrawScreenText(32,256,"Up    Animation:");
Up_Id = IG_InputButton(192,248,str32,UpAnim,NULL,NULL);
IG_TextButton(464,248,"Set all directions",AllAnim,NULL,NULL);

DrawScreenText(32,288,"Down  Animation:");
Down_Id = IG_InputButton(192,280,str32,DownAnim,NULL,NULL);
DrawScreenText(32,320,"Left  Animation:");
Left_Id = IG_InputButton(192,312,str32,LeftAnim,NULL,NULL);
DrawScreenText(32,352,"Right Animation:");
Right_Id = IG_InputButton(192,344,str32,RightAnim,NULL,NULL);

DrawScreenText(32,398,"Light level:");
Light_Id = IG_InputButton(144,390,LightLevel,setlight,NULL,NULL);

DrawScreenText(224,398,"Tag:");
Tag_Id = IG_InputButton(256,390,Tag,settag,NULL,NULL);

/*
IG_TextButton(32,432,"Edit Flags",SetFlags,NULL,NULL);
IG_TextButton(128,432,"Edit Statistics",EditStats,NULL,NULL);
IG_TextButton(264,432,"Edit Behaviour",EditBehaviour,NULL,NULL);
IG_TextButton(392,432,"Edit Size",EditSize,NULL,NULL);
IG_TextButton(480,432,"Default Pockets",EditDefaultContents,NULL,NULL);
*/

IG_TextButton(320,400,"Set Flags",SetFlags,NULL,NULL);
IG_TextButton(408,400,"Statistics",EditStats,NULL,NULL);
IG_TextButton(504,400,"Actions",EditActions,NULL,NULL);
IG_TextButton(576,400,"Size",EditSize,NULL,NULL);
IG_TextButton(320,432,"NPC Flags",SetFlags2,NULL,NULL);
IG_TextButton(408,432,"Default Pockets",EditDefaultContents,NULL,NULL);

ChrUpdate();
}

void AddCharacter()
{
char namebuf[33];
strcpy(namebuf,"");

for(long ctr=0;ctr<chr_alloc;ctr++)
    if(!CHlist[ctr].name)
        {
		InputString(-1,-1,"Enter the new description of the character",32,namebuf);
		if(!stricmp(namebuf,""))
			return; // Abort

		CHlist[ctr].name=(char *)M_get(1,32);
		strcpy(CHlist[ctr].name,namebuf);

		curchr=ctr;
		CHlist[ctr].maxstats = (STATS *)M_get(sizeof(STATS),1);
		CHlist[ctr].stats = (STATS *)M_get(sizeof(STATS),1);
		CHlist[ctr].funcs = (FUNCS *)M_get(sizeof(FUNCS),1);
		CHlist[ctr].funcs->ucache=-1;
		CHlist[ctr].funcs->tcache=-1;
		CHlist[ctr].funcs->kcache=-1;
		CHlist[ctr].funcs->lcache=-1;
		CHlist[ctr].funcs->scache=-1;
		CHlist[ctr].funcs->hcache=-1;
		CHlist[ctr].funcs->icache=-1;

		CHlist[ctr].vblock[BLK_X]=0;   // Partly-solid object
		CHlist[ctr].vblock[BLK_Y]=0;   // Solidity offset
		CHlist[ctr].vblock[BLK_W]=0;   // and size
		CHlist[ctr].vblock[BLK_H]=0;
		CHlist[ctr].hblock[BLK_X]=0;   // Partly-solid object
		CHlist[ctr].hblock[BLK_Y]=0;   // Solidity offset
		CHlist[ctr].hblock[BLK_W]=0;   // and size

		CHlist[ctr].target = NULL;

		CHlist[ctr].desc = (char *)M_get(1,1024);
		strcpy(CHlist[ctr].desc,"No description");

		CHlist[ctr].shortdesc = (char *)M_get(1,32);
		strcpy(CHlist[ctr].shortdesc,"No description");

		ChrUpdate();
//		CharacterName();
		return;
		}
Notify(-1,-1,"Cannot create a new sequence.","Increase the value of MAX_SEQUENCES in SCRIPTER.INI");
}

void PickCharacter()
{
char name[128];
char **mlist;
long num=0,ctr;

mlist = (char **)M_get(chr_alloc,sizeof(char *));

for(ctr=0;ctr<chr_alloc;ctr++)
    if(CHlist[ctr].name)
         mlist[num++]=CHlist[ctr].name;

qsort(mlist,num,sizeof(char *),CMP);

strcpy(name,CHlist[curchr].name);
InputNameFromListWithFunc(-1,-1,"Choose an object:",num-1,mlist,5,name,0,0,NULL);
if(!name[0])
    strcpy(name,CHlist[curchr].name);

M_free(mlist);

for(ctr=0;ctr<chr_alloc;ctr++)
    if(CHlist[ctr].name != NULL)
    if(!stricmp(CHlist[ctr].name,name))
        {
        curchr=ctr;
        ChrUpdate();
        return;
        }
Notify(-1,-1,"Oh Bugger!",NULL);
}

void DelCharacter()
{
if(curchr == 0)
    {
    Notify(-1,-1,"This character is special and cannot be deleted.","You can still change it to something else though..");
    return;
    }

if(!Confirm(-1,-1,"Really delete this character?",CHlist[curchr].name))
   return;

M_free(CHlist[curchr].name);
CHlist[curchr].name=NULL;

M_free(CHlist[curchr].maxstats);
M_free(CHlist[curchr].stats);
M_free(CHlist[curchr].funcs);
M_free(CHlist[curchr].desc);
M_free(CHlist[curchr].shortdesc);
curchr=0;
ChrUpdate();

/*
if(Confirm(-1,-1,"Really delete this sprite?",SPlist[curspr].name))
    {
    SPlist[curspr].image.free();
    M_free(SPlist[curspr].fname);
    M_free(SPlist[curspr].name);
    SPlist[curspr].fname = NULL;
    SPlist[curspr].name = NULL;
    curspr=0;
    SprUpdate();
    }
*/
}

void DupCharacter()
{
for(long ctr=0;ctr<chr_alloc;ctr++)
    if(!CHlist[ctr].name)
        {
        memcpy(&CHlist[ctr],&CHlist[curchr],sizeof(OBJECT));
        CHlist[ctr].name=(char *)M_get(1,32);

        CHlist[ctr].maxstats = (STATS *)M_get(sizeof(STATS),1);
        CHlist[ctr].stats = (STATS *)M_get(sizeof(STATS),1);
        CHlist[ctr].funcs = (FUNCS *)M_get(sizeof(FUNCS),1);

        memcpy(CHlist[ctr].maxstats,CHlist[curchr].maxstats,sizeof(STATS));
        memcpy(CHlist[ctr].stats,CHlist[curchr].stats,sizeof(STATS));
        memcpy(CHlist[ctr].funcs,CHlist[curchr].funcs,sizeof(FUNCS));

        CHlist[ctr].desc = (char *)M_get(1,1024);
        strcpy(CHlist[ctr].desc,CHlist[curchr].desc);

        CHlist[ctr].shortdesc = (char *)M_get(1,32);
        strcpy(CHlist[ctr].shortdesc,CHlist[curchr].shortdesc);

        curchr=ctr;
        ChrUpdate();
        CharacterName();
        return;
        }
Notify(-1,-1,"Cannot create a new sequence.","Increase the value of MAX_SEQUENCES in SCRIPTER.INI");
}


short GetSequence(char *original)
{
char name[128];
char **mlist;
long num=0,ctr;

mlist = (char **)M_get(seq_alloc,sizeof(char *));
mlist[num++]="-";

for(ctr=0;ctr<seq_alloc;ctr++)
    if(SQlist[ctr].name)
         mlist[num++]=SQlist[ctr].name;

qsort(mlist,num,sizeof(char *),CMP);

strcpy(name,original);
InputNameFromListWithFunc(-1,-1,"Choose an animation:",num-1,mlist,5,name,0,0,NULL);
if(!name[0])
    strcpy(name,original);

M_free(mlist);

for(ctr=0;ctr<seq_alloc;ctr++)
    if(SQlist[ctr].name != NULL)
    if(!stricmp(SQlist[ctr].name,name))
        return ctr;
//Notify(-1,-1,"Oh Bugger!",NULL);
return -1;         // This is NONE
}

int PickVrm(char *original)
{
char name[128];
char **mlist;
long num=0,ctr=0;

mlist = (char **)M_get(PEtot+1,sizeof(char *));

// If a null pointer
if(!original)
     original="-";

// If an empty string
if(!original[0])
     original="-";

mlist[num++]="-";
for(ctr=0;ctr<PEtot;ctr++)
	if(PElist[ctr].name)
		{
		mlist[num]=PElist[ctr].name;
		strupr(mlist[num++]);
		}

qsort(mlist,num,sizeof(char *),CMP);

strcpy(name,original);
strupr(name);

InputNameFromListWithFunc(-1,-1,"Choose a function to call:",num-1,mlist,5,name,0,0,NULL);
if(!name[0])
    strcpy(name,original);

M_free(mlist);

for(ctr=0;ctr<PEtot;ctr++)
	if(PElist[ctr].name != NULL)
		if(!stricmp(PElist[ctr].name,name))
			return ctr;
return -1;
}

/*
int PickVrm(char *original)
{
char name[128];
char **mlist;
long num=0,ctr;

mlist = (char **)M_get(vrm_alloc+1,sizeof(char *));

// If a null pointer
if(!original)
     original="-";

// If an empty string
if(!original[0])
     original="-";

mlist[num++]="-";
for(ctr=0;ctr<vrm_alloc;ctr++)
    if(COlist[ctr].name)
         mlist[num++]=COlist[ctr].name;

qsort(mlist,num,sizeof(char *),CMP);

strcpy(name,original);
strupr(name);

InputNameFromListWithFunc(-1,-1,"Choose a function to call:",num-1,mlist,5,name,0,0,NULL);
if(!name[0])
    strcpy(name,original);

M_free(mlist);

for(ctr=0;ctr<vrm_alloc;ctr++)
    if(COlist[ctr].name != NULL)
    if(!stricmp(COlist[ctr].name,name))
        return ctr;
return -1;
}
*/

// Callback for a null event

void Nothing()
{
return;
}


// Function for updating the display

void ChrUpdate()
{
int ctr;
strcpy(ChrName,CHlist[curchr].name);
for(ctr=strlen(ChrName);ctr<OVL_LEN;ctr++)
    ChrName[ctr]=' ';
ChrName[OVL_LEN]=0;
IG_UpdateText(ChrName_Id,ChrName);

strncpy(Desc32,CHlist[curchr].desc,32);
for(ctr=strlen(Desc32);ctr<32;ctr++)
    Desc32[ctr]=' ';
Desc32[32]=0;
IG_UpdateText(Desc_Id,Desc32);

strcpy(SDesc32,CHlist[curchr].shortdesc);
for(ctr=strlen(SDesc32);ctr<OVL_LEN;ctr++)
    SDesc32[ctr]=' ';
SDesc32[OVL_LEN]=0;
IG_UpdateText(Short_Id,SDesc32);

strcpy(UpName,SQlist[CHlist[curchr].dir[CHAR_U]].name);
for(ctr=strlen(UpName);ctr<OVL_LEN;ctr++)
    UpName[ctr]=' ';
UpName[OVL_LEN]=0;
IG_UpdateText(Up_Id,UpName);

strcpy(DownName,SQlist[CHlist[curchr].dir[CHAR_D]].name);
for(ctr=strlen(DownName);ctr<OVL_LEN;ctr++)
    DownName[ctr]=' ';
DownName[OVL_LEN]=0;
IG_UpdateText(Down_Id,DownName);

strcpy(LeftName,SQlist[CHlist[curchr].dir[CHAR_L]].name);
for(ctr=strlen(LeftName);ctr<OVL_LEN;ctr++)
    LeftName[ctr]=' ';
LeftName[OVL_LEN]=0;
IG_UpdateText(Left_Id,LeftName);

strcpy(RightName,SQlist[CHlist[curchr].dir[CHAR_R]].name);
for(ctr=strlen(RightName);ctr<OVL_LEN;ctr++)
    RightName[ctr]=' ';
RightName[OVL_LEN]=0;
IG_UpdateText(Right_Id,RightName);

sprintf(Tag,"%-4d",CHlist[curchr].tag);
IG_UpdateText(Tag_Id,Tag);

sprintf(LightLevel,"%-4d",CHlist[curchr].light);
IG_UpdateText(Light_Id,LightLevel);
}

void CharacterName()
{
InputString(-1,-1,"Enter the new description of the character",32,CHlist[curchr].name);
ChrUpdate();
}

void LongDescription()
{
InputIString(-1,-1,"Enter the full description:",1024,CHlist[curchr].desc);
ChrUpdate();
}

void ShortDescription()
{
InputIString(-1,-1,"Enter the noun for this object:",32,CHlist[curchr].shortdesc);
ChrUpdate();
}

void UpAnim()
{
int i;
i = GetSequence(SQlist[CHlist[curchr].dir[CHAR_U]].name);
if(i != -1)
    CHlist[curchr].dir[CHAR_U] = i;
ChrUpdate();
}

void DownAnim()
{
int i;
i = GetSequence(SQlist[CHlist[curchr].dir[CHAR_D]].name);
if(i != -1)
    CHlist[curchr].dir[CHAR_D] = i;
ChrUpdate();
}

void LeftAnim()
{
int i;
i = GetSequence(SQlist[CHlist[curchr].dir[CHAR_L]].name);
if(i != -1)
    CHlist[curchr].dir[CHAR_L] = i;
ChrUpdate();
}

void RightAnim()
{
int i;
i = GetSequence(SQlist[CHlist[curchr].dir[CHAR_R]].name);
if(i != -1)
    CHlist[curchr].dir[CHAR_R] = i;
ChrUpdate();
}

void AllAnim()
{
CHlist[curchr].dir[CHAR_D] = CHlist[curchr].dir[CHAR_U];
CHlist[curchr].dir[CHAR_L] = CHlist[curchr].dir[CHAR_U];
CHlist[curchr].dir[CHAR_R] = CHlist[curchr].dir[CHAR_U];
ChrUpdate();
}


void setlight()
{
CHlist[curchr].light = InputIntegerValue(-1,-1,-1,1,CHlist[curchr].light);
ChrUpdate();
}

void settag()
{
CHlist[curchr].tag = InputIntegerValue(-1,-1,-0x7fffffff,0x7fffffff,CHlist[curchr].tag);
ChrUpdate();
}

void Finish()
{
IG_WaitForRelease();
CH_GoFocal();
}

/*
 *
 *      EDIT FLAGS
 *
 */

void SetFlags()
{
int f=0;
int y;
focus=0;
IG_KillAll();

FL_Read();

DrawScreenBox3D(32,112,608,368);

y=136;
flag_id[f] = IG_ToggleButton(64,y,"Not solid    ",Toggle,NULL,NULL,&flag[f]);
IG_SetInText(flag_id[f++],        "Is solid     ");y+=32;

flag_id[f] = IG_ToggleButton(64,y,"Not fragile  ",Toggle,NULL,NULL,&flag[f]);
IG_SetInText(flag_id[f++],        "Is fragile   ");y+=32;

flag_id[f] = IG_ToggleButton(64,y,"Visible      ",Toggle,NULL,NULL,&flag[f]);
IG_SetInText(flag_id[f++],        "Invisible    ");y+=32;

flag_id[f] = IG_ToggleButton(64,y,"Can be moved ",Toggle,NULL,NULL,&flag[f]);
IG_SetInText(flag_id[f++],        "Immovable    ");y+=32;

flag_id[f] = IG_ToggleButton(64,y,"Not container",Toggle,NULL,NULL,&flag[f]);
IG_SetInText(flag_id[f++],         "Container    ");y+=32;

flag_id[f] = IG_ToggleButton(64,y,"Opaque       ",Toggle,NULL,NULL,&flag[f]);
IG_SetInText(flag_id[f++],         "Translucent  ");y=136;

flag_id[f] = IG_ToggleButton(192,y,"Will set off triggers ",Toggle,NULL,NULL,&flag[f]);
IG_SetInText(flag_id[f++],         "Won't set off triggers");y+=32;

flag_id[f] = IG_ToggleButton(192,y,"Doesn't block light   ",Toggle,NULL,NULL,&flag[f]);
IG_SetInText(flag_id[f++],         "Blocks light          ");y+=32;

flag_id[f] = IG_ToggleButton(192,y,"Not a table-top       ",Toggle,NULL,NULL,&flag[f]);
IG_SetInText(flag_id[f++],         "Is a table-top        ");y+=32;

flag_id[f] = IG_ToggleButton(192,y,"Not a window          ",Toggle,NULL,NULL,&flag[f]);
IG_SetInText(flag_id[f++],         "Is a window           ");y+=32;

flag_id[f] = IG_ToggleButton(192,y,"Is not a person       ",Toggle,NULL,NULL,&flag[f]);
IG_SetInText(flag_id[f++],         "Is a person           ");y+=32;

flag_id[f] = IG_ToggleButton(192,y,"Always only one object",Toggle,NULL,NULL,&flag[f]);
IG_SetInText(flag_id[f++],         "Can be a pile of objs ");y=136;

flag_id[f] = IG_ToggleButton(400,y,"Cannot be wielded ",Toggle,NULL,NULL,&flag[f]);
IG_SetInText(flag_id[f++],         "Can be wielded    ");y+=32;

flag_id[f] = IG_ToggleButton(400,y,"Cannot float      ",Toggle,NULL,NULL,&flag[f]);
IG_SetInText(flag_id[f++],         "Can float (ship)  ");y+=32;

flag_id[f] = IG_ToggleButton(400,y,"Fully visible     ",Toggle,NULL,NULL,&flag[f]);
IG_SetInText(flag_id[f++],         "Just a shadow     ");y+=32;

flag_id[f] = IG_ToggleButton(400,y,"Is not a door     ",Toggle,NULL,NULL,&flag[f]);
IG_SetInText(flag_id[f++],         "Is a door (opens) ");y+=32;

flag_id[f] = IG_ToggleButton(400,y,"Normal Object     ",Toggle,NULL,NULL,&flag[f]);
IG_SetInText(flag_id[f++],         "DECORATIVE Object ");y+=32;

IG_TextButton(256,328,"Finish",FL_Write,NULL,NULL);
IG_TextButton(320,328,"Abandon",Finish,NULL,NULL);
IG_AddKey(KEY_ESC,CH_GoFocal);     // ESC to quit this menu (not save changes)
IG_AddKey(KEY_F10,Snap);           // Add key binding for shift-F10
}

void FL_Read()
{
memset(flag,0,32*sizeof(int));
flag[0] = CHlist[curchr].flags.solid;
flag[1] = CHlist[curchr].flags.fragile;
flag[2] = CHlist[curchr].flags.invisible;
flag[3] = CHlist[curchr].flags.fixed;
flag[4] = CHlist[curchr].flags.container;
flag[5] = CHlist[curchr].flags.translucent;
flag[6] = CHlist[curchr].flags.spikeproof;
flag[7] = CHlist[curchr].flags.blocklight;
flag[8] = CHlist[curchr].flags.tabletop;
flag[9] = CHlist[curchr].flags.window;
flag[10] = CHlist[curchr].flags.person;
flag[11] = CHlist[curchr].flags.quantity;
flag[12] = CHlist[curchr].flags.wield;
flag[13] = CHlist[curchr].flags.watery;
flag[14] = CHlist[curchr].flags.shadow;
flag[15] = CHlist[curchr].flags.willopen;
flag[16] = CHlist[curchr].flags.decor;
}

void FL_Write()
{
CHlist[curchr].flags.solid = flag[0];
CHlist[curchr].flags.fragile = flag[1];
CHlist[curchr].flags.invisible = flag[2];
CHlist[curchr].flags.fixed = flag[3];
CHlist[curchr].flags.container = flag[4];
CHlist[curchr].flags.translucent = flag[5];
CHlist[curchr].flags.spikeproof = flag[6];
CHlist[curchr].flags.blocklight = flag[7];
CHlist[curchr].flags.tabletop = flag[8];
CHlist[curchr].flags.window = flag[9];
CHlist[curchr].flags.person = flag[10];
CHlist[curchr].flags.quantity = flag[11];
CHlist[curchr].flags.wield  = flag[12];
CHlist[curchr].flags.watery = flag[13];
CHlist[curchr].flags.shadow = flag[14];
CHlist[curchr].flags.willopen= flag[15];
CHlist[curchr].flags.decor = flag[16];
Finish();
}

void SetFlags2()
{
int f=0;
int y;
focus=0;
IG_KillAll();

FL_Read2();

DrawScreenBox3D(32,112,608,368);

y=136;
flag_id[f] = IG_ToggleButton(64,y,"Male         ",Toggle,NULL,NULL,&flag[f]);
IG_SetInText(flag_id[f++],        "Female       ");y+=32;

flag_id[f] = IG_ToggleButton(64,y,"Name unknown ",Toggle,NULL,NULL,&flag[f]);
IG_SetInText(flag_id[f++],        "Name is known");y+=32;

flag_id[f] = IG_ToggleButton(64,y,"Not the Hero ",Toggle,NULL,NULL,&flag[f]);
IG_SetInText(flag_id[f++],        "Is the Hero  ");y+=32;

flag_id[f] = IG_ToggleButton(64,y,"Can Eat+Drink",Toggle,NULL,NULL,&flag[f]);
IG_SetInText(flag_id[f++],        "Can't Eat/Dri");y+=32;

flag_id[f] = IG_ToggleButton(64,y,"Shuts doors  ",Toggle,NULL,NULL,&flag[f]);
IG_SetInText(flag_id[f++],        "Not shut door");y+=32;

flag_id[f] = IG_ToggleButton(64,y,"Not a symlink",Toggle,NULL,NULL,&flag[f]);
IG_SetInText(flag_id[f++],        "Link to a NPC");y=136;

flag_id[f] = IG_ToggleButton(192,y,"Can't be poisoned etc ",Toggle,NULL,NULL,&flag[f]);
IG_SetInText(flag_id[f++],         "Can be poisoned       ");y+=32;

flag_id[f] = IG_ToggleButton(192,y,"Not a guard/policeman ",Toggle,NULL,NULL,&flag[f]);
IG_SetInText(flag_id[f++],         "Guard (can arrest you)");y+=32;

// NEXT ONE IS IN THE SECOND COLUMN


IG_TextButton(256,328,"Finish",FL_Write2,NULL,NULL);
IG_TextButton(320,328,"Abandon",Finish,NULL,NULL);
IG_AddKey(KEY_ESC,CH_GoFocal);     // ESC to quit this menu (not save changes)
IG_AddKey(KEY_F10,Snap);           // Add key binding for shift-F10
}

void FL_Read2()
{
memset(flag,0,32*sizeof(int));
flag[0] = CHlist[curchr].stats->npcflags.female;
flag[1] = CHlist[curchr].stats->npcflags.know_name;
flag[2] = CHlist[curchr].stats->npcflags.is_hero;
flag[3] = CHlist[curchr].stats->npcflags.cant_eat;
flag[4] = CHlist[curchr].stats->npcflags.no_shutdoor;
flag[5] = CHlist[curchr].stats->npcflags.symlink;
flag[6] = CHlist[curchr].stats->npcflags.biological;
flag[7] = CHlist[curchr].stats->npcflags.guard;
}

void FL_Write2()
{
CHlist[curchr].stats->npcflags.female = flag[0];
CHlist[curchr].stats->npcflags.know_name = flag[1];
CHlist[curchr].stats->npcflags.is_hero = flag[2];
CHlist[curchr].stats->npcflags.cant_eat = flag[3];
CHlist[curchr].stats->npcflags.no_shutdoor = flag[4];
CHlist[curchr].stats->npcflags.symlink = flag[5];
CHlist[curchr].stats->npcflags.biological = flag[6];
CHlist[curchr].stats->npcflags.guard = flag[7];
Finish();
}

void Toggle()
{
//waitabit();
IG_WaitForRelease();
}

/*
 *
 *      EDIT STATISTICS
 *
 */

void EditStats()
{
focus=0;
IG_KillAll();

DrawScreenBox3D(32,128,608,384);

setcolor(ITG_WHITE);
DrawScreenText(48,160,"Health");
stats_hp_Id =    IG_InputButton(128,152,stats_hp_str,SetHp,NULL,NULL);
DrawScreenText(48,192,"Dexterity");
stats_dex_Id =   IG_InputButton(128,184,stats_dex_str,SetDex,NULL,NULL);
DrawScreenText(48,224,"Strength");
stats_str_Id =   IG_InputButton(128,216,stats_str_str,SetStr,NULL,NULL);
DrawScreenText(48,256,"Intellig.");
stats_intel_Id = IG_InputButton(128,248,stats_intel_str,SetIntel,NULL,NULL);

DrawScreenText(232,160,"Weight");
stats_weight_Id = IG_InputButton(320,152,stats_weight_str,SetWeight,NULL,NULL);
DrawScreenText(232,192,"Damage");
stats_damage_Id = IG_InputButton(320,184,stats_damage_str,SetDamage,NULL,NULL);

DrawScreenText(48,320,"Max Health");
stats_mhealth_Id = IG_InputButton(128,312,stats_mhealth_str,SetMHp,NULL,NULL);
DrawScreenText(232,320,"Max Str.");
stats_mstr_Id = IG_InputButton(320,312,stats_mstr_str,SetMStr,NULL,NULL);
DrawScreenText(48,352,"Max Dext.");
stats_mdex_Id = IG_InputButton(128,344,stats_mdex_str,SetMDex,NULL,NULL);
DrawScreenText(232,352,"Max Intel.");
stats_mintel_Id = IG_InputButton(320,344,stats_mintel_str,SetMIntel,NULL,NULL);

IG_TextButton(512,152,"Finish",Finish,NULL,NULL);
IG_AddKey(KEY_ESC,CH_GoFocal);     // ESC to quit this menu (not save changes)
IG_AddKey(KEY_F10,Snap);           // Add key binding for shift-F10

Stats_Update();
}

void Stats_Update()
{
sprintf(stats_hp_str,"%-10d",CHlist[curchr].stats->hp);
IG_UpdateText(stats_hp_Id,stats_hp_str);

sprintf(stats_dex_str,"%-10d",CHlist[curchr].stats->dex);
IG_UpdateText(stats_dex_Id,stats_dex_str);

sprintf(stats_str_str,"%-10d",CHlist[curchr].stats->str);
IG_UpdateText(stats_str_Id,stats_str_str);

sprintf(stats_intel_str,"%-10d",CHlist[curchr].stats->intel);
IG_UpdateText(stats_intel_Id,stats_intel_str);

sprintf(stats_weight_str,"%-10d",CHlist[curchr].stats->weight);
IG_UpdateText(stats_weight_Id,stats_weight_str);

sprintf(stats_damage_str,"%-10d",CHlist[curchr].stats->damage);
IG_UpdateText(stats_damage_Id,stats_damage_str);

sprintf(stats_mhealth_str,"%-10d",CHlist[curchr].maxstats->hp);
IG_UpdateText(stats_mhealth_Id,stats_mhealth_str);

sprintf(stats_mdex_str,"%-10d",CHlist[curchr].maxstats->dex);
IG_UpdateText(stats_mdex_Id,stats_mdex_str);

sprintf(stats_mstr_str,"%-10d",CHlist[curchr].maxstats->str);
IG_UpdateText(stats_mstr_Id,stats_mstr_str);

sprintf(stats_mintel_str,"%-10d",CHlist[curchr].maxstats->intel);
IG_UpdateText(stats_mintel_Id,stats_mintel_str);
}

void SetHp()
{
CHlist[curchr].stats->hp = InputIntegerValue(-1,-1,0,0x7fffffff,CHlist[curchr].stats->hp);
Stats_Update();
}

void SetDex()
{
CHlist[curchr].stats->dex = InputIntegerValue(-1,-1,0,0x7fffffff,CHlist[curchr].stats->dex);
Stats_Update();
}

void SetStr()
{
CHlist[curchr].stats->str = InputIntegerValue(-1,-1,0,0x7fffffff,CHlist[curchr].stats->str);
Stats_Update();
}


void SetIntel()
{
CHlist[curchr].stats->intel= InputIntegerValue(-1,-1,0,0x7fffffff,CHlist[curchr].stats->intel);
Stats_Update();
}

void SetWeight()
{
CHlist[curchr].stats->weight= InputIntegerValue(-1,-1,-1,0x7fffffff,CHlist[curchr].stats->weight);
Stats_Update();
}

void SetDamage()
{
CHlist[curchr].stats->damage= InputIntegerValue(-1,-1,-0x7fffffff,0x7fffffff,CHlist[curchr].stats->damage);
Stats_Update();
}

void SetMHp()
{
CHlist[curchr].maxstats->hp = InputIntegerValue(-1,-1,0,0x7fffffff,CHlist[curchr].maxstats->hp);
Stats_Update();
}

void SetMDex()
{
CHlist[curchr].maxstats->dex = InputIntegerValue(-1,-1,0,0x7fffffff,CHlist[curchr].maxstats->dex);
Stats_Update();
}

void SetMStr()
{
CHlist[curchr].maxstats->str = InputIntegerValue(-1,-1,0,0x7fffffff,CHlist[curchr].maxstats->str);
Stats_Update();
}

void SetMIntel()
{
CHlist[curchr].maxstats->intel= InputIntegerValue(-1,-1,0,0x7fffffff,CHlist[curchr].maxstats->intel);
Stats_Update();
}

/*
 *
 *      EDIT BEHAVIOUR
 *
 */

//behave

/*
char contains[8][32];
char contents;
// Up to 8 objects can be put in the object when it's first created
*/

void EditActions()
{
focus=0;
IG_KillAll();

DrawScreenBox3D(32,128,608,400);

setcolor(ITG_WHITE);
DrawScreenText(48,160,"Initial behaviour:");
behave_Id =    IG_InputButton(224,152,str32,SetBehave,NULL,NULL);
DrawScreenText(48,192,"When used:");
use_Id =   IG_InputButton(224,184,str32,SetUse,NULL,NULL);
DrawScreenText(48,224,"When killed:");
kill_Id =   IG_InputButton(224,216,str32,SetKill,NULL,NULL);
DrawScreenText(48,256,"When looked at:");
look_Id = IG_InputButton(224,248,str32,SetLook,NULL,NULL);

DrawScreenText(48,288,"When stood on:");
stand_Id = IG_InputButton(224,280,str32,SetStand,NULL,NULL);
DrawScreenText(48,320,"When hurt:");
hurt_Id = IG_InputButton(224,312,str32,SetHurt,NULL,NULL);
DrawScreenText(48,352,"When created:");
init_Id = IG_InputButton(224,344,str32,SetInit,NULL,NULL);


IG_TextButton(512,152,"Finish",Finish,NULL,NULL);
IG_TextButton(512,344,"Page 2",EditActions2,NULL,NULL);
IG_AddKey(KEY_ESC,CH_GoFocal);     // ESC to quit this menu (not save changes)
IG_AddKey(KEY_F10,Snap);           // Add key binding for shift-F10

Behave_Update();
}

void EditActions2()
{
focus=0;
IG_KillAll();

DrawScreenBox3D(32,128,608,400);

setcolor(ITG_WHITE);

DrawScreenText(48,160,"When wielded:");
wield_Id =    IG_InputButton(224,152,str32,SetWield,NULL,NULL);
DrawScreenText(48,192,"Attack Script:");
attack_Id =   IG_InputButton(224,184,str32,SetAttack,NULL,NULL);

DrawScreenText(48,224,"User string 1:");
user1_Id =   IG_InputButton(224,216,str32,SetUser1,NULL,NULL);
DrawScreenText(48,256,"User string 2:");
user2_Id = IG_InputButton(224,248,str32,SetUser2,NULL,NULL);
/*

DrawScreenText(48,288,"When stood on:");
stand_Id = IG_InputButton(224,280,str32,SetStand,NULL,NULL);
DrawScreenText(48,320,"When hurt:");
hurt_Id = IG_InputButton(224,312,str32,SetHurt,NULL,NULL);
*/
DrawScreenText(48,352,"Speech File:");
talk_Id = IG_InputButton(224,344,str32,SetTalk,NULL,NULL);


IG_TextButton(512,344,"Page 1",EditActions,NULL,NULL);
IG_TextButton(512,152,"Finish",Finish,NULL,NULL);
IG_AddKey(KEY_ESC,CH_GoFocal);     // ESC to quit this menu (not save changes)
IG_AddKey(KEY_F10,Snap);           // Add key binding for shift-F10

Behave_Update2();
}


void Behave_Update()
{
if(CHlist[curchr].activity== -1)
	IG_UpdateText(behave_Id,none);
else
	{
	strcpy(behave_str,PElist[CHlist[curchr].activity].name);
	IG_UpdateText(behave_Id,behave_str);
	}

if(CHlist[curchr].funcs->ucache == -1)
	IG_UpdateText(use_Id,none);
else
	IG_UpdateText(use_Id,PElist[CHlist[curchr].funcs->ucache].name);

if(CHlist[curchr].funcs->kcache == -1)
    IG_UpdateText(kill_Id,none);
else
    IG_UpdateText(kill_Id,PElist[CHlist[curchr].funcs->kcache].name);

if(CHlist[curchr].funcs->lcache == -1)
    IG_UpdateText(look_Id,none);
else
    IG_UpdateText(look_Id,PElist[CHlist[curchr].funcs->lcache].name);

if(CHlist[curchr].funcs->scache == -1)
    IG_UpdateText(stand_Id,none);
else
    IG_UpdateText(stand_Id,PElist[CHlist[curchr].funcs->scache].name);

if(CHlist[curchr].funcs->hcache == -1)
    IG_UpdateText(hurt_Id,none);
else
    IG_UpdateText(hurt_Id,PElist[CHlist[curchr].funcs->hcache].name);

if(CHlist[curchr].funcs->icache == -1)
    IG_UpdateText(init_Id,none);
else
    IG_UpdateText(init_Id,PElist[CHlist[curchr].funcs->icache].name);

IG_UpdateText(talk_Id,CHlist[curchr].funcs->talk);
}


void Behave_Update2()
{

if(CHlist[curchr].funcs->wcache == -1)
    IG_UpdateText(wield_Id,none);
else
    IG_UpdateText(wield_Id,PElist[CHlist[curchr].funcs->wcache].name);

if(CHlist[curchr].funcs->acache == -1)
    IG_UpdateText(attack_Id,none);
else
    IG_UpdateText(attack_Id,PElist[CHlist[curchr].funcs->acache].name);


IG_UpdateText(talk_Id,CHlist[curchr].funcs->talk);
}


void SetBehave()
{
if(CHlist[curchr].activity == -1)
    CHlist[curchr].activity = PickVrm(NULL);
else
    CHlist[curchr].activity = PickVrm(PElist[CHlist[curchr].activity].name);
Behave_Update();
}

void SetUse()
{
CHlist[curchr].funcs->ucache = PickVrm(CHlist[curchr].funcs->use);
if(CHlist[curchr].funcs->ucache != -1)
    strcpy(CHlist[curchr].funcs->use, PElist[CHlist[curchr].funcs->ucache].name);
Behave_Update();
}

void SetKill()
{
CHlist[curchr].funcs->kcache = PickVrm(CHlist[curchr].funcs->kill);
if(CHlist[curchr].funcs->kcache != -1)
    strcpy(CHlist[curchr].funcs->kill, PElist[CHlist[curchr].funcs->kcache].name);
Behave_Update();
}

void SetLook()
{
CHlist[curchr].funcs->lcache = PickVrm(CHlist[curchr].funcs->look);
if(CHlist[curchr].funcs->lcache != -1)
    strcpy(CHlist[curchr].funcs->look, PElist[CHlist[curchr].funcs->lcache].name);
Behave_Update();
}

void SetStand()
{
CHlist[curchr].funcs->scache = PickVrm(CHlist[curchr].funcs->stand);
if(CHlist[curchr].funcs->scache != -1)
    strcpy(CHlist[curchr].funcs->stand, PElist[CHlist[curchr].funcs->scache].name);
Behave_Update();
}

void SetHurt()
{
CHlist[curchr].funcs->hcache = PickVrm(CHlist[curchr].funcs->hurt);
if(CHlist[curchr].funcs->hcache != -1)
    strcpy(CHlist[curchr].funcs->hurt, PElist[CHlist[curchr].funcs->hcache].name);
Behave_Update();
}

void SetInit()
{
CHlist[curchr].funcs->icache = PickVrm(CHlist[curchr].funcs->init);
if(CHlist[curchr].funcs->icache != -1)
    strcpy(CHlist[curchr].funcs->init, PElist[CHlist[curchr].funcs->icache].name);
Behave_Update();
}



void SetWield()
{
CHlist[curchr].funcs->wcache = PickVrm(CHlist[curchr].funcs->wield);
if(CHlist[curchr].funcs->wcache != -1)
    strcpy(CHlist[curchr].funcs->wield, PElist[CHlist[curchr].funcs->wcache].name);
Behave_Update2();
}


void SetTalk()
{
InputFileName(-1,-1,"Choose this character's speech file:",32,CHlist[curchr].funcs->talk);
if(CHlist[curchr].funcs->talk[0])
	CHlist[curchr].funcs->tcache=1;
else
	{
	strcpy(CHlist[curchr].funcs->talk,"-");
	CHlist[curchr].funcs->tcache=-1;
	}
/*
InputString(-1,-1,"Enter the file with the character's speech (or '-' for none)",32,CHlist[curchr].funcs->talk);
if(!stricmp(CHlist[curchr].funcs->talk,"-"))
    CHlist[curchr].funcs->tcache=-1;
else
    {
    CHlist[curchr].funcs->tcache=1;
    if(!exist(CHlist[curchr].funcs->talk))
        Notify(-1,-1,"WARNING:  That file does not exist.","Make sure it's correct...");
    }
*/
Behave_Update2();
}

void SetAttack()
{
CHlist[curchr].funcs->acache = PickVrm(CHlist[curchr].funcs->attack);
if(CHlist[curchr].funcs->acache != -1)
    strcpy(CHlist[curchr].funcs->attack, PElist[CHlist[curchr].funcs->acache].name);
Behave_Update2();
}

void SetUser1()
{
char tmp[32];

strcpy(tmp,CHlist[curchr].funcs->user1);
InputIString(-1,-1,"Enter the user string:",32,tmp);
if(stricmp(CHlist[curchr].funcs->user1,tmp))
	strcpy(CHlist[curchr].funcs->user1, tmp);
Behave_Update2();
}

void SetUser2()
{
char tmp[32];

strcpy(tmp,CHlist[curchr].funcs->user2);
InputIString(-1,-1,"Enter the user string:",32,tmp);
if(stricmp(CHlist[curchr].funcs->user2,tmp))
	strcpy(CHlist[curchr].funcs->user2, tmp);
Behave_Update2();
}


/*
 *
 *      EDIT SIZE
 *
 */

void EditSize()
{
focus=0;
Polarity=0; // V
IG_KillAll();

DrawScreenBox3D(32,64,608,400);

setcolor(ITG_WHITE);
Edit_H_Id = IG_Tab(48,80,"Edit Horizontal",SetPolarityH,NULL,NULL);
Edit_V_Id = IG_Tab(192,80,"Edit Vertical",SetPolarityV,NULL,NULL);
IG_TextButton(512,80,"Finish",Finish,NULL,NULL);

IG_BlackPanel(VIEWX-2,VIEWY-2,260,260);

setcolor(ITG_WHITE);
DrawScreenText(384,128,"SOLID X offset:");
DrawScreenText(384,160,"SOLID Y offset:");
DrawScreenText(384,192,"SOLID Width:");
DrawScreenText(384,224,"SOLID Height:");

sol_x_Id = IG_InputButton(524,120,sol_x_str,SetSolidX,NULL,NULL);
sol_y_Id = IG_InputButton(524,152,sol_y_str,SetSolidY,NULL,NULL);
sol_w_Id = IG_InputButton(524,184,sol_w_str,SetSolidW,NULL,NULL);
sol_h_Id = IG_InputButton(524,216,sol_h_str,SetSolidH,NULL,NULL);

setcolor(ITG_DARKRED);
DrawScreenText(384,256,"ACTIVE X offset:");
DrawScreenText(384,288,"ACTIVE Y offset:");
DrawScreenText(384,320,"ACTIVE Width:");
DrawScreenText(384,352,"ACTIVE Height:");

act_x_Id = IG_InputButton(524,248,act_x_str,SetActiveX,NULL,NULL);
act_y_Id = IG_InputButton(524,280,act_y_str,SetActiveY,NULL,NULL);
act_w_Id = IG_InputButton(524,312,act_w_str,SetActiveW,NULL,NULL);
act_h_Id = IG_InputButton(524,344,act_h_str,SetActiveH,NULL,NULL);

IG_AddKey(KEY_ESC,CH_GoFocal);     // ESC to quit this menu (not save changes)
IG_AddKey(KEY_F10,Snap);           // Add key binding for shift-F10

Size_Update();
}

void Size_Update()
{
// Recalc WxH levels for this object
Init_Areas(&CHlist[curchr]);

if(Polarity == 0)
    {
    IG_SetFocus(Edit_H_Id);
    IG_ResetFocus(Edit_V_Id);
    }
else
    {
    IG_ResetFocus(Edit_H_Id);
    IG_SetFocus(Edit_V_Id);
    }

fbox2(0,0,256,256,ITG_BLUE,gamewin);
if(Polarity == 0)
    {
    // Horizontal
//    SQlist[CHlist[curchr].dir[CHAR_R]].seq[0]->image.cel_put_sprite(0,0,gamewin);
    draw_rle_sprite(gamewin,SQlist[CHlist[curchr].dir[CHAR_R]].seq[0]->image,0,0);
//    ClipBox(CHlist[curchr].hblock[BLK_X]*32,CHlist[curchr].hblock[BLK_Y]*32,(CHlist[curchr].hblock[BLK_X]*32)+(CHlist[curchr].hblock[BLK_W]*32),(CHlist[curchr].hblock[BLK_Y]*32)+(CHlist[curchr].hblock[BLK_H]*32),ITG_WHITE,gamewin);
//    ClipBox((CHlist[curchr].harea[BLK_X]*32)+1,CHlist[curchr].harea[BLK_Y]*32+1,(CHlist[curchr].harea[BLK_X]*32)+(CHlist[curchr].harea[BLK_W]*32)-1,(CHlist[curchr].harea[BLK_Y]*32)+(CHlist[curchr].harea[BLK_H]*32)-1,ITG_RED,gamewin);
    ClipBox(CHlist[curchr].hblock[BLK_X]*32,CHlist[curchr].hblock[BLK_Y]*32,(CHlist[curchr].hblock[BLK_W]*32),(CHlist[curchr].hblock[BLK_H]*32),ITG_WHITE,gamewin);
    ClipBox((CHlist[curchr].harea[BLK_X]*32)+1,CHlist[curchr].harea[BLK_Y]*32+1,(CHlist[curchr].harea[BLK_W]*32)-1,(CHlist[curchr].harea[BLK_H]*32)-1,ITG_RED,gamewin);
    sprintf(sol_x_str,"%-3d",CHlist[curchr].hblock[BLK_X]);
    sprintf(sol_y_str,"%-3d",CHlist[curchr].hblock[BLK_Y]);
    sprintf(sol_w_str,"%-3d",CHlist[curchr].hblock[BLK_W]);
    sprintf(sol_h_str,"%-3d",CHlist[curchr].hblock[BLK_H]);
    sprintf(act_x_str,"%-3d",CHlist[curchr].harea[BLK_X]);
    sprintf(act_y_str,"%-3d",CHlist[curchr].harea[BLK_Y]);
    sprintf(act_w_str,"%-3d",CHlist[curchr].harea[BLK_W]);
    sprintf(act_h_str,"%-3d",CHlist[curchr].harea[BLK_H]);
    }
else
    {
    // Vertical
//    SQlist[CHlist[curchr].dir[CHAR_D]].seq[0]->image.cel_put_sprite(0,0,bg_screen);
    draw_rle_sprite(gamewin,SQlist[CHlist[curchr].dir[CHAR_D]].seq[0]->image,0,0);
    ClipBox(CHlist[curchr].vblock[BLK_X]*32,CHlist[curchr].vblock[BLK_Y]*32,(CHlist[curchr].vblock[BLK_W]*32),(CHlist[curchr].vblock[BLK_H]*32),ITG_WHITE,gamewin);
    ClipBox((CHlist[curchr].varea[BLK_X]*32)+1,(CHlist[curchr].varea[BLK_Y]*32)+1,(CHlist[curchr].varea[BLK_W]*32)-1,(CHlist[curchr].varea[BLK_H]*32)-1,ITG_RED,gamewin);
//    ClipBox(CHlist[curchr].vblock[BLK_X]*32,CHlist[curchr].vblock[BLK_Y]*32,(CHlist[curchr].vblock[BLK_X]*32)+(CHlist[curchr].vblock[BLK_W]*32),(CHlist[curchr].vblock[BLK_Y]*32)+(CHlist[curchr].vblock[BLK_H]*32),ITG_WHITE,gamewin);
//    ClipBox((CHlist[curchr].varea[BLK_X]*32)+1,(CHlist[curchr].varea[BLK_Y]*32)+1,(CHlist[curchr].varea[BLK_X]*32)+(CHlist[curchr].varea[BLK_W]*32)-1,(CHlist[curchr].varea[BLK_Y]*32)+(CHlist[curchr].varea[BLK_H]*32)-1,ITG_RED,gamewin);

    sprintf(sol_x_str,"%-3d",CHlist[curchr].vblock[BLK_X]);
    sprintf(sol_y_str,"%-3d",CHlist[curchr].vblock[BLK_Y]);
    sprintf(sol_w_str,"%-3d",CHlist[curchr].vblock[BLK_W]);
    sprintf(sol_h_str,"%-3d",CHlist[curchr].vblock[BLK_H]);
    sprintf(act_x_str,"%-3d",CHlist[curchr].varea[BLK_X]);
    sprintf(act_y_str,"%-3d",CHlist[curchr].varea[BLK_Y]);
    sprintf(act_w_str,"%-3d",CHlist[curchr].varea[BLK_W]);
    sprintf(act_h_str,"%-3d",CHlist[curchr].varea[BLK_H]);
    }

IG_UpdateText(sol_x_Id,sol_x_str);
IG_UpdateText(sol_y_Id,sol_y_str);
IG_UpdateText(sol_w_Id,sol_w_str);
IG_UpdateText(sol_h_Id,sol_h_str);

IG_UpdateText(act_x_Id,act_x_str);
IG_UpdateText(act_y_Id,act_y_str);
IG_UpdateText(act_w_Id,act_w_str);
IG_UpdateText(act_h_Id,act_h_str);

// Draw it

//transfer.get_sprite(0,0,bg_screen);
//transfer.block_put_sprite(VIEWX,VIEWY,swapscreen);
draw_sprite(swapscreen,gamewin,VIEWX,VIEWY);
}

void SetPolarityH()
{
Polarity=0;
Size_Update();
}

void SetPolarityV()
{
Polarity=1;
Size_Update();
}

void SetSolidX()
{
int i;
if(Polarity == 0)
    {
    i = CHlist[curchr].hblock[BLK_X];
    CHlist[curchr].hblock[BLK_X] = InputIntegerValue(-1,-1,0,255,i);
    }
else
    {
    i = CHlist[curchr].vblock[BLK_X];
    CHlist[curchr].vblock[BLK_X]= InputIntegerValue(-1,-1,0,255,i);
    }
Size_Update();
}

void SetSolidY()
{
int i;
if(Polarity == 0)
    {
    i = CHlist[curchr].hblock[BLK_Y];
    CHlist[curchr].hblock[BLK_Y] = InputIntegerValue(-1,-1,0,255,i);
    }
else
    {
    i = CHlist[curchr].vblock[BLK_Y];
    CHlist[curchr].vblock[BLK_Y] = InputIntegerValue(-1,-1,0,255,i);
    }
Size_Update();
}

void SetSolidW()
{
int i;
if(Polarity == 0)
    {
    i = CHlist[curchr].hblock[BLK_W];
    CHlist[curchr].hblock[BLK_W]= InputIntegerValue(-1,-1,0,255,i);
    }
else
    {
    i = CHlist[curchr].vblock[BLK_W];
    CHlist[curchr].vblock[BLK_W]= InputIntegerValue(-1,-1,0,255,i);
    }
Size_Update();
}

void SetSolidH()
{
int i;
if(Polarity == 0)
    {
    i = CHlist[curchr].hblock[BLK_H];
    CHlist[curchr].hblock[BLK_H]= InputIntegerValue(-1,-1,0,255,i);
    }
else
    {
    i = CHlist[curchr].vblock[BLK_H];
    CHlist[curchr].vblock[BLK_H]= InputIntegerValue(-1,-1,0,255,i);
    }
Size_Update();
}

void SetActiveX()
{
int i;
if(Polarity == 0)
    {
    i = CHlist[curchr].harea[BLK_X];
    CHlist[curchr].harea[BLK_X]= InputIntegerValue(-1,-1,0,255,i);
    }
else
    {
    i = CHlist[curchr].varea[BLK_X];
    CHlist[curchr].varea[BLK_X]= InputIntegerValue(-1,-1,0,255,i);
    }
Size_Update();
}

void SetActiveY()
{
int i;
if(Polarity == 0)
    {
    i = CHlist[curchr].harea[BLK_Y];
    CHlist[curchr].harea[BLK_Y] = InputIntegerValue(-1,-1,0,255,i);
    }
else
    {
    i = CHlist[curchr].varea[BLK_Y];
    CHlist[curchr].varea[BLK_Y] = InputIntegerValue(-1,-1,0,255,i);
    }
Size_Update();
}

void SetActiveW()
{
int i;
if(Polarity == 0)
    {
    i = CHlist[curchr].harea[BLK_W];
    CHlist[curchr].harea[BLK_W] = InputIntegerValue(-1,-1,0,255,i);
    }
else
    {
    i = CHlist[curchr].varea[BLK_W];
    CHlist[curchr].varea[BLK_W] = InputIntegerValue(-1,-1,0,255,i);
    }
Size_Update();
}

void SetActiveH()
{
int i;
if(Polarity == 0)
    {
    i = CHlist[curchr].harea[BLK_H];
    CHlist[curchr].harea[BLK_H] = InputIntegerValue(-1,-1,0,255,i);
    }
else
    {
    i = CHlist[curchr].varea[BLK_H];
    CHlist[curchr].varea[BLK_H] = InputIntegerValue(-1,-1,0,255,i);
    }
Size_Update();
}

/*
 *
 *      EDIT DEFAULT CONTENTS
 *
 */

void EditDefaultContents()
{
focus=0;
IG_KillAll();

memset(item1_str,' ',STR_LEN); item1_str[STR_LEN]=0;
memset(item2_str,' ',STR_LEN); item2_str[STR_LEN]=0;
memset(item3_str,' ',STR_LEN); item3_str[STR_LEN]=0;
memset(item4_str,' ',STR_LEN); item4_str[STR_LEN]=0;
memset(item5_str,' ',STR_LEN); item5_str[STR_LEN]=0;
memset(item6_str,' ',STR_LEN); item6_str[STR_LEN]=0;
memset(item7_str,' ',STR_LEN); item7_str[STR_LEN]=0;
memset(item8_str,' ',STR_LEN); item8_str[STR_LEN]=0;

DrawScreenBox3D(32,64,608,400);

setcolor(ITG_WHITE);
IG_TextButton(512,96,"Finish",Finish,NULL,NULL);

DrawScreenText(96,104,"1st item:");
item1_Id = IG_InputButton(176,96,item1_str,SetItem1,NULL,NULL);

DrawScreenText(96,136,"2nd item:");
item2_Id = IG_InputButton(176,128,item2_str,SetItem2,NULL,NULL);

DrawScreenText(96,168,"3rd item:");
item3_Id = IG_InputButton(176,160,item3_str,SetItem3,NULL,NULL);

DrawScreenText(96,200,"4th item:");
item4_Id = IG_InputButton(176,192,item4_str,SetItem4,NULL,NULL);

DrawScreenText(96,232,"5th item:");
item5_Id = IG_InputButton(176,224,item5_str,SetItem5,NULL,NULL);

DrawScreenText(96,264,"6th item:");
item6_Id = IG_InputButton(176,256,item6_str,SetItem6,NULL,NULL);

DrawScreenText(96,296,"7th item:");
item7_Id = IG_InputButton(176,288,item7_str,SetItem7,NULL,NULL);

DrawScreenText(96,328,"8th item:");
item8_Id = IG_InputButton(176,320,item8_str,SetItem8,NULL,NULL);

IG_AddKey(KEY_ESC,CH_GoFocal);     // ESC to quit this menu (not save changes)
IG_AddKey(KEY_F10,Snap);           // Add key binding for shift-F10

DefaultContentsUpdate();
}

void DefaultContentsUpdate()
{
int a;

if(!strlen(CHlist[curchr].funcs->contains[0]))
    strcpy(item1_str,none);
else
    strcpy(item1_str,CHlist[curchr].funcs->contains[0]);
IG_UpdateText(item1_Id,item1_str);

if(!strlen(CHlist[curchr].funcs->contains[1]))
    strcpy(item2_str,none);
else
    strcpy(item2_str,CHlist[curchr].funcs->contains[1]);
IG_UpdateText(item2_Id,item2_str);

if(!strlen(CHlist[curchr].funcs->contains[2]))
    strcpy(item3_str,none);
else
    strcpy(item3_str,CHlist[curchr].funcs->contains[2]);
IG_UpdateText(item3_Id,item3_str);

if(!strlen(CHlist[curchr].funcs->contains[3]))
    strcpy(item4_str,none);
else
    strcpy(item4_str,CHlist[curchr].funcs->contains[3]);
IG_UpdateText(item4_Id,item4_str);

if(!strlen(CHlist[curchr].funcs->contains[4]))
    strcpy(item5_str,none);
else
    strcpy(item5_str,CHlist[curchr].funcs->contains[4]);
IG_UpdateText(item5_Id,item5_str);

if(!strlen(CHlist[curchr].funcs->contains[5]))
    strcpy(item6_str,none);
else
    strcpy(item6_str,CHlist[curchr].funcs->contains[5]);
IG_UpdateText(item6_Id,item6_str);

if(!strlen(CHlist[curchr].funcs->contains[6]))
    strcpy(item7_str,none);
else
    strcpy(item7_str,CHlist[curchr].funcs->contains[6]);
IG_UpdateText(item7_Id,item7_str);

if(!strlen(CHlist[curchr].funcs->contains[7]))
    strcpy(item8_str,none);
else
    strcpy(item8_str,CHlist[curchr].funcs->contains[7]);
IG_UpdateText(item8_Id,item8_str);

CHlist[curchr].funcs->contents=0;
for(a=0;a<8;a++)
    if(strlen(CHlist[curchr].funcs->contains[a]))
        CHlist[curchr].funcs->contents++;
}

void SetItem_generic(int no)
{
OBJECT *ob;

ob = GetCharacter(CHlist[curchr].funcs->contains[no]);
if(!ob)
    strcpy(CHlist[curchr].funcs->contains[no],"-");
else
    strcpy(CHlist[curchr].funcs->contains[no],ob->name);

DefaultContentsUpdate();
}

void SetItem1()
{
SetItem_generic(0);
}

void SetItem2()
{
SetItem_generic(1);
}

void SetItem3()
{
SetItem_generic(2);
}

void SetItem4()
{
SetItem_generic(3);
}

void SetItem5()
{
SetItem_generic(4);
}

void SetItem6()
{
SetItem_generic(5);
}

void SetItem7()
{
SetItem_generic(6);
}

void SetItem8()
{
SetItem_generic(7);
}

OBJECT *GetCharacter(char *original)
{
char name[128];
char **mlist;
long num=0,ctr;

mlist = (char **)M_get(chr_alloc,sizeof(char *));

for(ctr=0;ctr<chr_alloc;ctr++)
    if(CHlist[ctr].name)
         mlist[num++]=CHlist[ctr].name;

qsort(mlist,num,sizeof(char *),CMP);

if(!original)
    original="-";
if(!strlen(original))
    original="-";
strcpy(name,original);
InputNameFromListWithFunc(-1,-1,"Choose an object:",num-1,mlist,5,name,0,0,NULL);
if(!name[0])
    strcpy(name,CHlist[curchr].name);

M_free(mlist);

for(ctr=0;ctr<chr_alloc;ctr++)
    if(CHlist[ctr].name != NULL)
    if(!stricmp(CHlist[ctr].name,name))
        return &CHlist[ctr];
//Notify(-1,-1,"Oh Bugger!",NULL);
return NULL;
}


