/* ****************************************************************************
 *
 * Copyright (c) Microsoft Corporation. 
 *
 * This source code is subject to terms and conditions of the Microsoft Public
 * License. A  copy of the license can be found in the License.html file at the
 * root of this distribution. If  you cannot locate the  Microsoft Public
 * License, please send an email to  dlr@microsoft.com. By using this source
 * code in any fashion, you are agreeing to be bound by the terms of the 
 * Microsoft Public License.
 *
 * You must not remove this notice, or any other, from this software.
 *
 * ***************************************************************************/

using System;
using System.Collections.Generic;
using System.Text;

using IronPython.Runtime;
using IronPython.Runtime.Exceptions;

namespace IronPython.Modules {
    public static partial class Builtin {
        #region Generated builtin exceptions

        // *** BEGIN GENERATED CODE ***

        public static object ValueError = ExceptionConverter.GetPythonException("ValueError");
        public static object ImportError = ExceptionConverter.GetPythonException("ImportError");
        public static object RuntimeError = ExceptionConverter.GetPythonException("RuntimeError");
        public static object UnicodeTranslateError = ExceptionConverter.GetPythonException("UnicodeTranslateError");
        public static object KeyError = ExceptionConverter.GetPythonException("KeyError");
        public static object StopIteration = ExceptionConverter.GetPythonException("StopIteration");
        public static object PendingDeprecationWarning = ExceptionConverter.GetPythonException("PendingDeprecationWarning");
        public static object EnvironmentError = ExceptionConverter.GetPythonException("EnvironmentError");
        public static object LookupError = ExceptionConverter.GetPythonException("LookupError");
        public static object OSError = ExceptionConverter.GetPythonException("OSError");
        public static object DeprecationWarning = ExceptionConverter.GetPythonException("DeprecationWarning");
        public static object UnicodeError = ExceptionConverter.GetPythonException("UnicodeError");
        public static object UnicodeEncodeError = ExceptionConverter.GetPythonException("UnicodeEncodeError");
        public static object FloatingPointError = ExceptionConverter.GetPythonException("FloatingPointError");
        public static object ReferenceError = ExceptionConverter.GetPythonException("ReferenceError");
        public static object NameError = ExceptionConverter.GetPythonException("NameError");
        public static object OverflowWarning = ExceptionConverter.GetPythonException("OverflowWarning");
        public static object IOError = ExceptionConverter.GetPythonException("IOError");
        public static object SyntaxError = ExceptionConverter.GetPythonException("SyntaxError");
        public static object FutureWarning = ExceptionConverter.GetPythonException("FutureWarning");
        public static object SystemExit = ExceptionConverter.GetPythonException("SystemExit");
        public static object EOFError = ExceptionConverter.GetPythonException("EOFError");
        public static object StandardError = ExceptionConverter.GetPythonException("StandardError");
        public static object TabError = ExceptionConverter.GetPythonException("TabError");
        public static object ZeroDivisionError = ExceptionConverter.GetPythonException("ZeroDivisionError");
        public static object SystemError = ExceptionConverter.GetPythonException("SystemError");
        public static object IndentationError = ExceptionConverter.GetPythonException("IndentationError");
        public static object AssertionError = ExceptionConverter.GetPythonException("AssertionError");
        public static object UnicodeDecodeError = ExceptionConverter.GetPythonException("UnicodeDecodeError");
        public static object TypeError = ExceptionConverter.GetPythonException("TypeError");
        public static object IndexError = ExceptionConverter.GetPythonException("IndexError");
        public static object RuntimeWarning = ExceptionConverter.GetPythonException("RuntimeWarning");
        public static object KeyboardInterrupt = ExceptionConverter.GetPythonException("KeyboardInterrupt");
        public static object UserWarning = ExceptionConverter.GetPythonException("UserWarning");
        public static object SyntaxWarning = ExceptionConverter.GetPythonException("SyntaxWarning");
        public static object MemoryError = ExceptionConverter.GetPythonException("MemoryError");
        public static object UnboundLocalError = ExceptionConverter.GetPythonException("UnboundLocalError");
        public static object ArithmeticError = ExceptionConverter.GetPythonException("ArithmeticError");
        public static object Warning = ExceptionConverter.GetPythonException("Warning");
        public static object NotImplementedError = ExceptionConverter.GetPythonException("NotImplementedError");
        public static object AttributeError = ExceptionConverter.GetPythonException("AttributeError");
        public static object OverflowError = ExceptionConverter.GetPythonException("OverflowError");
        public static object WindowsError = ExceptionConverter.GetPythonException("WindowsError");
        public static object ImportWarning = ExceptionConverter.GetPythonException("ImportWarning");

        // *** END GENERATED CODE ***

        #endregion

    }
}
