#include <sys/stat.h>

struct DIR_BUILD {
  char *name;
  int size;
};

struct DIR_ITEM {
  int queued;
  int type;     /* 0 = directory  */
  int tree;
  int level;
  int parent;   /* parent directory */
  int offset;   /* offset to strings */
  int size;     /* string size */
};

struct DIR_INFO {
  char *strings;
  int size;
  struct DIR_ITEM *item;
  int items;
  int files;
  int trees;
};

char *dir_build_path (struct DIR_INFO *dinfo, int item);
int dir_recurse (struct DIR_INFO *dinfo, struct CONFIG *cfg,
		 char *path, int tree);
int dir_count_parent (struct DIR_INFO *dinfo, int parent);
int dir_match_parent (struct DIR_INFO *dinfo, int parent, int start_dir);
int dir_match_null_level (struct DIR_INFO *dinfo, int start_dir);
