#ifndef K3DSDK_ISELECTION_H
#define K3DSDK_ISELECTION_H

#include "iunknown.h"
#include "signal_system.h"

#include <set>

namespace k3d
{

// Forward declarations
class iobject;
class iselectable;
	
/// Abstract interface for a collection of references to "selected" objects
class iselection :
	public virtual iunknown
{
public:
	/// Defines a set of selectable objects
	typedef std::set<iselectable*> selection_t;

	/// Defines a signal that will be emitted whenever objects are selected
	typedef SigC::Signal1<void, const selection_t&> selected_signal_t;
	virtual selected_signal_t& selected_signal() = 0;

	/// Defines a signal that will be emitted whenever objects are deselected
	typedef SigC::Signal1<void, const selection_t&> deselected_signal_t;
	virtual deselected_signal_t& deselected_signal() = 0;

	/// Defines a signal that will be emitted to request that all objects should be deselected
	typedef SigC::Signal0<void> deselect_all_signal_t;
	virtual deselect_all_signal_t& deselect_all_signal() = 0;
			
protected:
	iselection() {}
	iselection(const iselection&) {}
	iselection& operator=(const iselection&) { return *this; }
	virtual ~iselection() {}
};

} // namespace k3d

#endif // !K3DSDK_ISELECTION_H
