// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Tim Shead (tshead@k-3d.com)
*/

#include "idocument.h"
#include "iobject_collection.h"
#include "iselectable.h"
#include "isnap_target.h"
#include "snap.h"

namespace k3d
{

bool snap(idocument& Document, const double MaxDistance, const vector3 InputCoordinates, vector3& SnapCoordinates, std::string& SnapDescription)
{
	// Keep track of the closest snap coordinate as we go ...
	double distance = MaxDistance * MaxDistance;
	bool result = false;
	
	// For each object in the document ...
	const iobject_collection::objects_t objects(Document.objects().collection());
	for(iobject_collection::objects_t::const_iterator i = objects.begin(); i != objects.end(); ++i)
		{
			iobject& object = **i;

			// Skip objects that aren't snap targets ...
			isnap_target* const snap_target = dynamic_cast<isnap_target*>(&object);
			if(!snap_target)
				continue;

/*
			// Skip hidden objects ...
			if(!object.state().QueryState(k3dIState::VISIBLE))
				continue;
			
			// Skip selected objects ...
			if(!object.selectable().is_selected())
				continue;
*/
			vector3 snap_coordinates;
			std::string snap_description;
			snap_target->snap(InputCoordinates, snap_coordinates, snap_description);

			if((snap_coordinates - InputCoordinates).Length2() < distance)
				{
					SnapCoordinates = snap_coordinates;
					SnapDescription = snap_description;
					distance = (snap_coordinates - InputCoordinates).Length2();
					result = true;
				}
		}

	return result;
}

} // namespace k3d

