// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Tim Shead (tshead@k-3d.com)
*/

#include "idocument.h"
#include "objects.h"
#include "property.h"
#include "time_source.h"

namespace k3d
{

namespace detail
{

iobject* time_object(idocument& Document)
{
	const objects_t objects = find_objects(Document.objects(), "TimeSource");
	return (1 == objects.size()) ? *objects.begin() : 0;
}

} // namespace detail

iproperty* get_start_time(idocument& Document)
{
	iobject* const object = detail::time_object(Document);
	return object ? get_typed_property<double>(*object, "start_time") : 0;
}

iproperty* get_end_time(idocument& Document)
{
	iobject* const object = detail::time_object(Document);
	return object ? get_typed_property<double>(*object, "end_time") : 0;
}

iproperty* get_frame_rate(idocument& Document)
{
	iobject* const object = detail::time_object(Document);
	return object ? get_typed_property<double>(*object, "frame_rate") : 0;
}

iproperty* get_time(idocument& Document)
{
	iobject* const object = detail::time_object(Document);
	return object ? get_typed_property<double>(*object, "time") : 0;
}

} // namespace k3d

