#ifndef K3DUI_CLIPBOARD_H
#define K3DUI_CLIPBOARD_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares the CClipboard class, which can supply data to X as the primary selection
		\author Tim Shead (tshead@k-3d.com)
*/

#include <sdpgtk/sdpgtkobjectcontainer.h>

namespace k3d
{

/////////////////////////////////////////////////////////////////////////////
// clipboard

/// Acts as a data source for the X primary selection
class clipboard :
	public sdpGtkObjectContainer
{
	typedef sdpGtkObjectContainer base;

public:
	clipboard();
	~clipboard();

	void set_text(const std::string& Text);

	bool grab_selection();
	bool have_selection() const;

private:
	void OnEvent(sdpGtkEvent* Event);
	void on_selection_get(sdpGtkEvent* Event);
	void on_selection_clear();

	std::string m_text;
	bool m_have_selection;
};

} // namespace k3d

#endif // K3DUI_CLIPBOARD_H
