#ifndef K3DUI_OPTIONS_DIALOG_H
#define K3DUI_OPTIONS_DIALOG_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares the options_dialog, which provides a UI for changing global user options
		\author Tim Shead (tshead@k-3d.com)
*/

#include "k3ddialog.h"
#include <k3dsdk/data.h>

namespace k3d
{

/////////////////////////////////////////////////////////////////////////////
// options_dialog

/// Provides a user interface for altering global user options.
class options_dialog :
	public k3dDialog
{
	typedef k3dDialog base;
	
public:
	options_dialog(k3d::icommand_node& Parent);

private:
	void on_apply();
	
	k3d_data(bool, k3d::no_name, k3d::change_signal, k3d::no_undo, k3d::local_storage, k3d::no_constraint) m_show_black_box_recorder;
	k3d_data(bool, k3d::no_name, k3d::change_signal, k3d::no_undo, k3d::local_storage, k3d::no_constraint) m_show_tutorial_menu;
	k3d_data(bool, k3d::no_name, k3d::change_signal, k3d::no_undo, k3d::local_storage, k3d::no_constraint) m_restore_windows;
};

} // namespace k3d

#endif // K3DUI_OPTIONS_DIALOG_H
