// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
          \author Anders Dahnielson (anders@dahnielson.com)
*/

#include <k3dsdk/module.h>
#include <k3dsdk/plugins.h>

#include "bitmap_composite_simple.h"

namespace libk3dbitmap
{

/////////////////////////////////////////////////////////////////////////////
// bitmap_image_min_implementation

class bitmap_image_min_implementation :
	public bitmap_composite_simple
{
	typedef bitmap_composite_simple base;

public:
	bitmap_image_min_implementation(k3d::idocument& Document) :
		base(Document)
	{
	}

	void on_value_change() {}

	void on_composite(const k3d::pixel& A, const k3d::pixel& B, k3d::pixel& O)
	{
		O.red   = std::min(A.red,   B.red);
		O.green = std::min(A.green, B.green);
		O.blue  = std::min(A.blue,  B.blue);
		O.alpha = std::min(A.alpha, B.alpha);		
	}

	k3d::iplugin_factory& factory()
	{
		return get_factory();
	}

	static k3d::iplugin_factory& get_factory()
	{
		static k3d::plugin_factory<
			k3d::document_plugin<bitmap_image_min_implementation>,
			k3d::interface_list<k3d::ibitmap_source,
			k3d::interface_list<k3d::ibitmap_sink> > > factory(
				k3d::uuid(0x9872aeba, 0x4ee44f63, 0x9fe63901, 0x7dfd9e29),
				"BitmapImageMin",
				"Compares two images and use the pixel with the lower value",
				"Objects",
				k3d::iplugin_factory::STABLE);

		return factory;
	}
};

/////////////////////////////////////////////////////////////////////////////
// bitmap_image_min_factory

k3d::iplugin_factory& bitmap_image_min_factory()
{
	return bitmap_image_min_implementation::get_factory();
}

} // namespace libk3dbitmap

