#ifndef PYTHON_H
#define PYTHON_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Define macros usefull when extending the python scripting engine
		\author Anders Dahnielson (anders@dahnielson.com)
*/

extern "C" {
#include <Python.h>
}

#include <string>

/// Common conversions

// From integer to Python integer
inline PyObject* IntToPyVal(int i)
{
	return Py_BuildValue("i", i);
}

// From long to Python integer
inline PyObject* LongToPyVal(long l)
{
	return Py_BuildValue("l", l);
}

// From double to Python float
inline PyObject* DoubleToPyVal(double d)
{
	return Py_BuildValue("d", d);
}

// From std::string to Python string
inline PyObject* StringToPyVal(std::string s)
{
	return Py_BuildValue("s", (char*)s.c_str());
}

/// Well known Python values
#define PYVAL_NONE             Py_BuildValue("")
#define PYVAL_ZERO             INT_TO_PYVAL(0)
#define PYVAL_ONE              INT_TO_PYVAL(1)
#define PYVAL_FALSE            0
#define PYVAL_TRUE             Py_BuildValue("i", 1)

#endif // !PYTHON_H


