#ifndef K3DSDK_IBITMAP_WRITE_FORMAT_H
#define K3DSDK_IBITMAP_WRITE_FORMAT_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares ibitmap_write_format, an abstract interface for objects capable of writing bitmaps to the filesystem
		\author Tim Shead (tshead@k-3d.com)
*/

#include "bitmap.h"
#include "iunknown.h"

// Forward declarations
namespace boost { namespace filesystem { class path; } }

namespace k3d
{

/// Abstract interface for objects capable of serializing k3dIBitmap objects
class ibitmap_write_format :
	public virtual k3d::iunknown
{
public:
	virtual bool write_file(const boost::filesystem::path& File, const bitmap& Bitmap) = 0;

protected:
	ibitmap_write_format() {}
	ibitmap_write_format(const ibitmap_write_format& RHS) {}
	ibitmap_write_format& operator = (const ibitmap_write_format& RHS) { return *this; }
	virtual ~ibitmap_write_format() {}
};

} // namespace k3d

#endif // K3DSDK_IBITMAP_WRITE_FORMAT_H


