/*
 * Copyright (C) 2003 Hans Karlsson <karlsson.h@home.se>
 */

#include "karamba.h"
karamba::karamba(QString fn)
        :  QWidget( 0,"karamba", Qt::WGroupLeader | WStyle_Customize |  WRepaintNoErase| WStyle_NoBorder | WDestructiveClose  )
{
    themePath = QFileInfo( fn ).dirPath(true);
    //qDebug( "themePath=" + themePath );
    connect(qApp,SIGNAL(lastWindowClosed()),qApp,SLOT(quit()));



    info = new NETWinInfo( qt_xdisplay(), winId(), qt_xrootwin(), NET::WMState );
    info->setDesktop( NETWinInfo::OnAllDesktops );
    info->setState( NETWinInfo::SkipTaskbar | NETWinInfo::SkipPager,NETWinInfo::SkipTaskbar | NETWinInfo::SkipPager );


    kWinModule = new KWinModule();
    connect( kWinModule,SIGNAL(currentDesktopChanged(int)), this,SLOT(currentDesktopChanged(int)) );


    kpop = new KPopupMenu( this );
    accColl = new KActionCollection( this );

    kpop->insertItem( SmallIconSet("reload"),"Update", this, SLOT(updateSensors()), Key_F5 );
    toggleLocked = new KToggleAction (  "Toggle &Locked position", CTRL+Key_L, this,
                                        SLOT( slotToggleLocked() ), accColl  , "Locked position" );
    accColl->insert(toggleLocked);
    toggleLocked->plug(kpop);

    kpop->insertSeparator();

    kpop->insertItem( SmallIconSet("fileopen"),"&Add new configuration", this, SLOT(startNewKaramba()), CTRL+Key_O );
    kpop->insertItem( SmallIconSet("edit"),"&Edit configuration",this,SLOT(editConfig()), CTRL+Key_E );
    kpop->insertItem( SmallIconSet("reload3"),"&Reload configuration",this,SLOT(reloadConfig()), CTRL+Key_R );
    kpop->insertItem( SmallIconSet("fileclose"),"&Close this configuration", this, SLOT(close()), CTRL+Key_C );

    kpop->insertSeparator();

    kpop->insertItem( SmallIconSet("exit"),"&Quit", qApp, SLOT(quit()), CTRL+Key_Q );

    kpop->polish();

    foundKaramba = false;
    onTop = false;
    fixedPosition = false;


    themeFile = fn;

    meterList = new QObjectList();
    meterList->setAutoDelete( true );
    sensorList = new QObjectList();
    sensorList->setAutoDelete( true );
    clickList = new QObjectList();


    client = kapp->dcopClient();
    if (!client->isAttached())
        client->attach();
    appId = client->registerAs(qApp->name());


    this->setBackgroundMode( NoBackground);
    if( !onTop)
        this->lower();


    if( !parseConfig() )
    {
        setFixedSize(0,0);
        QTimer::singleShot( 100, this, SLOT(close()) );

        qDebug("false");
    }
    else
    {
        kroot = new KarambaRootPixmap((QWidget*)this);
        kroot->start();


    }
}

karamba::~karamba()
{
    if(meterList != 0)
    {
        meterList->clear();
        delete meterList;
    }

    if( sensorList != 0 )
    {
        sensorList->clear();
        delete sensorList;
    }

    if( clickList != 0 )
    {
        clickList->clear();
        delete clickList;
    }

    if( toggleLocked != 0)
        delete toggleLocked;
    if( accColl != 0)
        delete accColl;

    if( kpop != 0)
        delete kpop;
    delete kWinModule;
}

bool karamba::parseConfig()
{
    QTimer *m_sysTimer = new QTimer(this);

    QFile file(themeFile);
    QString line;
    QString meter;
    int interval = 0;
    TextLabel *defaultTextLabel = 0;

    if ( file.open(IO_ReadOnly | IO_Translate) )
    {
        QTextStream t( &file );        // use a text stream
        QValueStack<QPoint> offsetStack;
        offsetStack.push(QPoint(0,0));

        int x=0;
        int y=0;
        int w=0;
        int h=0;
        while( ( line = t.readLine() ) !=0 )
        {
            QRegExp rx("^\\s*(\\S+)");
            rx.search(line);
            meter = rx.cap(1).upper();

            x = getInt("X",line)+offsetStack.top().x();
            y = getInt("Y",line)+offsetStack.top().y();
            w = getInt("W",line);
            h = getInt("H",line);

            //qDebug("x: " + QString::number(offsetStack.top().x()) + "  y: " + QString::number(offsetStack.top().y() ));


            if( meter == "KARAMBA" && !foundKaramba )
            {
                qDebug("karamba");
                toggleLocked->setChecked( getBoolean( "LOCKED", line ) );
                slotToggleLocked();


                getInt( "X",line );
                getInt( "Y",line );

                x = ( x < 0 ) ? 0:x;
                y = ( y < 0 ) ? 0:y;
                move(x,y);


                if( w == 0 ||  h == 0)
                {
                    w = 300;
                    h = 300;
                }
                setFixedSize(w,h);

                if( getBoolean( "RIGHT", line ) )
                {
                    QDesktopWidget *d = QApplication::desktop();
                    x = d->width() - w;
                }
                else
                    if( getBoolean( "LEFT", line ) )
                    {
                        x = 0;
                    }

                if( getBoolean( "BOTTOM", line ) )
                {
                    QDesktopWidget *d = QApplication::desktop();
                    y = d->height() - h;
                }
                else
                    if( getBoolean( "TOP", line ) )
                    {
                        y = 0;
                    }

                pm = QPixmap(size());

                if( getBoolean("ONTOP", line ) )
                {
                    onTop = true;
                    KWin::setState( winId(), NET::StaysOnTop );
                }

                if( getBoolean("TOPBAR", line ) )
                {
                    move(x,0);
                    KWin::setStrut( winId(), 0, 0, h, 0 );
                    toggleLocked->setChecked( true );
                    slotToggleLocked();
                    toggleLocked->setEnabled(false);

                }

                if( getBoolean("BOTTOMBAR", line ) )
                {
                    int dh = QApplication::desktop()->height();
                    move( x, dh - h );
                    KWin::setStrut( winId(), 0, 0, 0, h );
                    toggleLocked->setChecked( true );
                    slotToggleLocked();
                    toggleLocked->setEnabled(false);


                }




                interval = getInt("INTERVAL",line);
                interval = ( interval == 0 ) ? 5000 : interval;
                foundKaramba = true;
            }

            if( meter == "THEME" )
            {
                QString path = getString( "PATH", line );
                QFileInfo info(path);
                if( info.isRelative())
                    path = themePath +"/" + path;
                qDebug("path: "+path);
                (new karamba( path ))->show();
            }

            if( meter == "<GROUP>" )
            {
                int offsetX = offsetStack.top().x();
                int offsetY = offsetStack.top().y();
                offsetStack.push( QPoint( offsetX + getInt("X",line),
                                          offsetY + getInt("Y",line) ) );
            }

            if( meter == "</GROUP>" )
            {
                offsetStack.pop();
            }

            if( meter == "CLICKAREA" )
            {
                if( !hasMouseTracking() )
                    setMouseTracking(true);
                ClickArea *tmp = new ClickArea( x, y, w, h );
                tmp->setOnClick( getString( "ONCLICK", line ) );

                setSensor( line, (Meter*) tmp );
                clickList->append( tmp );
                if( getBoolean( "PREVIEW", line ) )
                    meterList->append( tmp );
            }

            // program sensor without a meter
            if(meter == "SENSOR=PROGRAM")
            {
                setSensor(line, 0 );
            }

            if(meter == "IMAGE")
            {
                QString file = getString("PATH",line);

                ImageLabel *tmp = new ImageLabel(x,y,0,0);
                tmp->setThemePath( themePath );
                tmp->setValue( file );

                //bool sensorFound = false;
                //getString( "SENSOR", line, sensorFound );
                //if( !sensorFound )

                setSensor(line, (Meter*) tmp );
                meterList->append (tmp );
            }

            if( meter == "DEFAULTFONT" )
            {
                int r,g,b;

                delete defaultTextLabel;
                defaultTextLabel = new TextLabel(x, y, w, h );

                get3Int( "COLOR", line, r, g, b );
                defaultTextLabel->setColor( r, g, b );
                get3Int( "BGCOLOR", line, r, g, b );
                defaultTextLabel->setBGColor( r, g, b );

                defaultTextLabel->setFont( getString( "FONT", line ) );
                defaultTextLabel->setFontSize( getInt( "FONTSIZE", line ) );
                defaultTextLabel->setAlignment( getString( "ALIGN", line ) );
                defaultTextLabel->setFixedPitch( getBoolean( "FIXEDPITCH", line ) );
                defaultTextLabel->setShadow( getInt( "SHADOW", line ) );

                qDebug(QString::number( getInt( "SHADOW", line ) ));

                qDebug("default font: " + defaultTextLabel->getFont());
            }


            if(meter == "TEXT")
            {
                int r,g,b;

                TextLabel *tmp = new TextLabel(x, y, w, h );
                bool paramFound = false;

                get3Int( "COLOR", line, r, g, b, paramFound );
                if ( paramFound || !defaultTextLabel )
                    tmp->setColor ( r, g, b );
                else
                    if ( defaultTextLabel )
                    {
                        defaultTextLabel->getColor().rgb ( &r, &g, &b );
                        tmp->setColor( r, g, b );
                    }

                get3Int( "BGCOLOR", line, r, g, b, paramFound );
                if ( paramFound  || !defaultTextLabel )
                    tmp->setBGColor( r, g, b );
                else
                    if ( defaultTextLabel )
                    {
                        defaultTextLabel->getBGColor().rgb ( &r, &g, &b );
                        tmp->setBGColor( r, g, b );
                    }

                QString dFont = getString("FONT", line, paramFound);
                if( paramFound || !defaultTextLabel )
                    tmp->setFont( dFont );
                else
                    if( defaultTextLabel )
                        tmp->setFont( defaultTextLabel->getFont() );


                int dFontSize = getInt( "FONTSIZE", line, paramFound );
                if( paramFound || !defaultTextLabel )
                    tmp->setFontSize( dFontSize );
                else
                    if( defaultTextLabel )
                        tmp->setFontSize( defaultTextLabel->getFontSize() );

                QString dAlign = getString( "ALIGN", line, paramFound );
                if( paramFound || !defaultTextLabel )
                    tmp->setAlignment( dAlign );
                else
                    if( defaultTextLabel )
                        tmp->setAlignment( defaultTextLabel->getAlignment() );

                bool dFp = getBoolean( "FIXEDPITCH", line, paramFound );
                if( paramFound || !defaultTextLabel )
                    tmp->setFixedPitch( dFp );
                else
                    if( defaultTextLabel )
                        tmp->setFixedPitch( defaultTextLabel->getFixedPitch() );

                int dShadow = getInt( "SHADOW", line, paramFound );
                if( paramFound || !defaultTextLabel )
                    tmp->setShadow( dShadow );
                else
                    if( defaultTextLabel )
                        tmp->setShadow( defaultTextLabel->getShadow() );

                tmp->setValue( getString( "VALUE", line ) );

                setSensor( line, (Meter*)tmp );
                meterList->append ( tmp );

            }

            if(meter == "BAR")
            {
                Bar *tmp =
                    new Bar( x, y, w, h );
                tmp->setThemePath( themePath );
                tmp->setImage( getString( "PATH", line ) );
                tmp->setVertical( getBoolean( "VERTICAL", line ) );
                bool maxFound = false;
                int max = getInt( "MAX", line, maxFound );
                if( maxFound )
                    tmp->setMax( max );
                bool minFound = false;
                int min = getInt( "MIN", line, minFound );
                if( minFound )
                    tmp->setMin( min );
                tmp->setValue( getInt( "VALUE", line ) );
                setSensor( line, (Meter*)tmp );
                meterList->append ( tmp );
            }

            if(meter == "GRAPH")
            {
                int r, g, b;
                int points = getInt("POINTS",line);
                get3Int("COLOR", line, r, g, b);

                Graph *tmp = new Graph( x, y, w, h, points );
                bool maxFound = false;
                int max = getInt( "MAX", line, maxFound );
                if( maxFound )
                    tmp->setMax( max );
                bool minFound = false;
                int min = getInt( "MIN", line, minFound );
                if( minFound )
                    tmp->setMin( min );

                tmp->setColor( r , g, b );

                setSensor( line, (Graph*)tmp );
                meterList->append ( tmp );
            }
        }
    }
    if( !foundKaramba )
    {
        //  interval = initKaramba( "", 0, 0, 0, 0 );
        //   this->close(true);
        //delete this;
        return false;
    }
    else
    {
        connect(m_sysTimer, SIGNAL(timeout()), SLOT(step()));

        interval = interval == 0 ? 1000 : interval;
        m_sysTimer->start(interval);
        QTimer::singleShot( 1000, this, SLOT(step()) );
        QTimer::singleShot( 5000, this, SLOT(step()) );
        QTimer::singleShot( 10000, this, SLOT(step()) );

        if( !onTop )
            lowerTimer.start();
        //update();
        //QTimer::singleShot( 0, this, SLOT(update()) );
        return true;
    }
}

void karamba::startNewKaramba()
{
    QStringList fileNames;
    fileNames = KFileDialog::getOpenFileNames(QString::null, "*.theme", 0, "Open configurations");
    for ( QStringList::Iterator it = fileNames.begin(); it != fileNames.end(); ++it )
    {
        QFileInfo file( *it );
        if( file.exists() )
        {
            (new karamba( *it ))->show();
        }
    }
}

void karamba::reloadConfig()
{
    QFileInfo file( themeFile );
    qDebug(themeFile);
    if( file.exists() )
    {
        (new karamba( themeFile ))->show();
    }
    close();
}

void karamba::editConfig()
{
    QFileInfo fileInfo( themeFile );
    QString path;

    if( fileInfo.isRelative() )
    {
        path = themePath + "/" + themeFile;
    }
    else
    {
        path = themeFile;
    }
    //    qDebug("krun:"+path);
    KRun::runURL( KURL( path ), "text/plain" );

}


int karamba::getInt(QString w, QString &line )
{
    bool b;
    return getInt( w, line, b );
}

int karamba::getInt(QString w, QString &line, bool &found )
{
    QRegExp rx( "\\W+" + w +"=([-]?\\d+)", false );
    found = (rx.search(line)==-1)?false:true;
    return rx.cap(1).toInt();
}

void karamba::get3Int(QString w, QString &line, int &a, int &b, int &c )
{
    bool bo;
    get3Int ( w, line, a, b, c, bo );
}

void karamba::get3Int(QString w, QString &line, int &a, int &b, int &c, bool &found )
{
    QRegExp rx( "\\W+" + w + "=([-]?\\d+),([-]?\\d+),([-]?\\d+)", false );
    found = (rx.search(line)==-1)?false:true;
    a = rx.cap(1).toInt();
    b = rx.cap(2).toInt();
    c = rx.cap(3).toInt();
}

QString karamba::getString(QString w, QString &line)
{
    bool b;
    return getString ( w, line, b );
}

QString karamba::getString(QString w, QString &line, bool &found)
{
    QRegExp rx( "\\W+" + w + "=\"([^\"]*)\"", false );
    found = (rx.search(line)==-1)?false:true;
    if (rx.cap(1).isEmpty())
    {
        rx = QRegExp(w + "=(\\S+)", false);
        rx.search(line);
        return rx.cap(1);
    }
    else
    {
        return rx.cap(1);
    }

}

bool karamba::getBoolean( QString w, QString &line )
{
    bool b;
    return getBoolean ( w, line, b );
}

bool karamba::getBoolean( QString w, QString &line, bool &found )
{
    return  ( getString( w, line, found ).lower() == "true")?true:false;
}

void karamba::setSensor(QString &line, Meter* meter)
{
    Sensor* sensor = 0;

    QString sens = getString("SENSOR",line).upper();

    if( sens == "CPU" )
    {
        QString cpuNbr = getString( "CPU", line );
        sensor = sensorMap["CPU"+cpuNbr];
        if (sensor == 0)
        {
            int interval = getInt("INTERVAL",line);
            interval = (interval == 0)?1000:interval;
            sensor = ( sensorMap["CPU"+cpuNbr] = new CPUSensor( cpuNbr, interval ) );
            sensorList->append( sensor );
        }
        SensorParams *sp = new SensorParams(meter);
        sp->addParam("FORMAT",getString("FORMAT",line));
        sp->addParam("DECIMALS",getString("DECIMALS",line));

        sensor->addMeter(sp);
        sensor->setMaxValue(sp);

    }

    if( sens == "MEMORY" )
    {
        sensor = sensorMap["MEMORY"];
        if (sensor == 0)
        {
            int interval = getInt("INTERVAL",line);
            interval = (interval == 0)?3000:interval;
            sensor = ( sensorMap["MEMORY"] = new MemSensor( interval ) );
            sensorList->append( sensor );
        }
        SensorParams *sp = new SensorParams(meter);
        sp->addParam("FORMAT",getString("FORMAT",line));

        sensor->addMeter(sp);
        sensor->setMaxValue(sp);
    }


    if( sens == "DISK" )
    {
        sensor = sensorMap["DISK"];
        if (sensor == 0)
        {
            int interval = getInt("INTERVAL",line);
            interval = (interval == 0)?5000:interval;
            sensor = ( sensorMap["DISK"] = new DiskSensor( interval ) );
            sensorList->append( sensor );
        }
        // meter->setMax( ((DiskSensor*)sensor)->getTotalSpace(mntPt)/1024 );
        SensorParams *sp = new SensorParams(meter);
        QString mntPt = getString("MOUNTPOINT",line);
        if( mntPt == ""  )
            mntPt = "/";

        sp->addParam("MOUNTPOINT",mntPt);
        sp->addParam("FORMAT",getString("FORMAT",line));
        sensor->addMeter(sp);
        sensor->setMaxValue(sp);
    }

    if( sens == "NETWORK")
    {
        int interval = getInt("INTERVAL",line );
        interval = (interval == 0)?2000:interval;
        QString device = getString("DEVICE", line );
        sensor = sensorMap["NETWORK"+device];
        if (sensor == 0)
        {
            sensor = ( sensorMap["NETWORK"+device] = new NetworkSensor( device, interval ) );
            sensorList->append( sensor );
        }
        SensorParams *sp = new SensorParams(meter);
        sp->addParam( "FORMAT", getString( "FORMAT", line ) );
        sp->addParam( "DECIMALS", getString( "DECIMALS", line ) );
        sensor->addMeter(sp);
    }

    if( sens == "UPTIME" )
    {
        sensor = sensorMap["UPTIME"];
        if (sensor == 0)
        {
            int interval = getInt("INTERVAL",line);
            interval = (interval == 0)?60000:interval;
            sensor = ( sensorMap["UPTIME"] = new UptimeSensor( interval ));
            sensorList->append( sensor );

        }
        SensorParams *sp = new SensorParams(meter);
        sp->addParam( "FORMAT", getString( "FORMAT", line ) );
        sensor->addMeter(sp);
    }

    if( sens == "SENSOR" )
    {
        sensor = sensorMap["SENSOR"];
        if (sensor == 0)
        {
            int interval = getInt("INTERVAL",line);
            interval = (interval == 0)?30000:interval;
            sensor = ( sensorMap["SENSOR"] = new SensorSensor( interval ) );
            sensorList->append( sensor );
        }
        SensorParams *sp = new SensorParams(meter);
        sp->addParam("FORMAT",getString("FORMAT",line));
        sp->addParam("TYPE",getString("TYPE",line));
        sensor->addMeter(sp);
    }


    if( sens == "TEXTFILE" )
    {
        QString path = getString( "PATH", line );
        bool rdf = getBoolean( "RDF", line );
        sensor = sensorMap["TEXTFILE"+path];
        if (sensor == 0)
        {
            int interval = getInt( "INTERVAL", line );
            interval = ( interval == 0 )?60000:interval;
            QString encoding = getString( "ENCODING", line );

            sensor = ( sensorMap["TEXTFILE"+path] =
                           new TextFileSensor( path, rdf, interval, encoding ) );
            sensorList->append( sensor );
        }
        SensorParams *sp = new SensorParams(meter);
        sp->addParam("LINE",QString::number(getInt("LINE",line)));
        sensor->addMeter(sp);
    }


    if( sens == "TIME")
    {
        sensor = sensorMap["DATE"];
        if (sensor == 0)
        {
            int interval = getInt("INTERVAL",line);
            interval = (interval == 0)?60000:interval;
            sensor = ( sensorMap["DATE"] = new DateSensor( interval ) );
            sensorList->append( sensor );
        }
        SensorParams *sp = new SensorParams(meter);
        sp->addParam("FORMAT",getString("FORMAT",line));
        sensor->addMeter(sp);
    }

#ifdef HAVE_XMMS

    if( sens == "XMMS" )
    {
        sensor = sensorMap["XMMS"];
        if (sensor == 0)
        {
            int interval = getInt("INTERVAL",line);
            interval = (interval == 0)?1000:interval;
            QString encoding = getString( "ENCODING", line );

            sensor = ( sensorMap["XMMS"] = new XMMSSensor( interval, encoding ) );
            sensorList->append( sensor );
        }
        SensorParams *sp = new SensorParams(meter);
        sp->addParam("FORMAT",getString("FORMAT",line));
        sensor->addMeter(sp);
        sensor->setMaxValue(sp);
    }
#endif // HAVE_XMMS


    if( sens == "NOATUN" )
    {
        sensor = sensorMap["NOATUN"];
        if (sensor == 0)
        {
            int interval = getInt("INTERVAL",line);
            interval = (interval == 0)?1000:interval;
            sensor = ( sensorMap["NOATUN"] = new NoatunSensor( interval, client ) );
            sensorList->append( sensor );
        }
        SensorParams *sp = new SensorParams(meter);
        sp->addParam("FORMAT",getString("FORMAT",line));
        sensor->addMeter(sp);
        sensor->setMaxValue(sp);
    }

    if( sens == "PROGRAM")
    {
        QString progName = getString("PROGRAM",line);
        sensor = sensorMap["PROGRAM"+progName];
        if (sensor == 0)
        {
            int interval = getInt("INTERVAL",line);
            interval = (interval == 0)?3600000:interval;
            QString encoding = getString( "ENCODING", line );

            sensor = (sensorMap["PROGRAM"+progName] =
                          new ProgramSensor( progName, interval, encoding ) );
            sensorList->append( sensor );
        }
        SensorParams *sp = new SensorParams(meter);
        sp->addParam( "LINE", QString::number( getInt( "LINE", line ) ) );
        sp->addParam( "THEMAPATH", themePath );
        sensor->addMeter(sp);
    }

    if (sensor != 0)
    {
        QTimer::singleShot( 0, sensor, SLOT(update()) );
        sensor->start();
    }
}


void karamba::passClick( QMouseEvent *e )
{
    QObjectListIt it( *clickList ); // iterate over meters
    while ( it != 0 )
    {
        (( ClickArea* ) *it)->click( e );
        ++it;
    }
}

void karamba::mousePressEvent( QMouseEvent *e )
{

    if( e->button() == RightButton )
    {

        kpop->exec(QCursor::pos());
    }
    else
    {

        clickPos = e->pos();
        if( locked )
            passClick( e );
        if( !onTop )
            lower();
    }
}


void karamba::mouseReleaseEvent( QMouseEvent *e )
{
    /*if( ks != 0)
    {
        ks->loadFromShared("DESKTOP1",
                           QRect(QPoint(x(),y()), QPoint(x()+width()-1,y()+height()-1)));
    }
    */
    clickPos = e->pos();
    qDebug("Click   X="+QString::number( clickPos.x() )+" Y="+QString::number( clickPos .y() ) );
    qDebug("Window  X="+QString::number( ( e->globalPos() - clickPos ).x())+" Y="+QString::number( ( e->globalPos() - clickPos ).y()));

    //update();
    step();
}

void karamba::mouseDoubleClickEvent( QMouseEvent *e )
{
    if( !locked )
    {
        passClick( e );
    }
}


void karamba::mouseMoveEvent( QMouseEvent *e )
{
    // qDebug(QString::number(e->button()));
    // qDebug(QString::number(e->state()));
    //  qDebug(QString::number(e->stateAfter()));
    if( e->state() !=  0 && e->state() < 16 && !locked )
    {
        move( e->globalPos() - clickPos );
    }
    else
    {
        // Change cursor over ClickArea
        QObjectListIt it( *clickList ); // iterate over meters
        bool insideArea = false;
        while ( it != 0 && !insideArea )
        {
            insideArea = (((ClickArea*) *it)->getRectangle()).contains(e->pos());
            ++it;
        }
        if(insideArea)
        {
            if( cursor().shape() != PointingHandCursor )
                setCursor( PointingHandCursor );
        }
        else
        {
            if( cursor().shape() != ArrowCursor )
                setCursor( ArrowCursor );
        }
    }
}

void karamba::closeEvent ( QCloseEvent *  )
{
    this->close(true);
    delete this;
}

void karamba::paintEvent ( QPaintEvent *e)
{
    if( !onTop )
        if( lowerTimer.elapsed() > 100 )
        {
            this->lower();
            lowerTimer.restart();
        }
    QRect rect = e->rect();
    bitBlt(this,rect.topLeft(),&pm,rect,Qt::CopyROP);
}

void karamba::updateSensors()
{
    QObjectListIt it( *sensorList ); // iterate over meters
    while ( it != 0 )
    {
        ((Sensor*) *it)->update();
        ++it;
    }
    QTimer::singleShot( 500, this, SLOT(step()) );
}

void karamba::updateBackground(KSharedPixmap* kpm)
{
    background = QPixmap(*kpm);
    step();
}

void karamba::currentDesktopChanged( int )
{
    kroot->repaint( true );
}



void karamba::step()
{
    pm = QPixmap(size());

    QObjectListIt it( *meterList ); // iterate over meters
    p.begin(&pm);
    bitBlt(&pm,0,0,&background,0,Qt::CopyROP);

    while ( it != 0 )
    {
        ((Meter*) *it)->mUpdate(&p);
        ++it;
    }
    p.end();
    update();

}

void karamba::slotToggleLocked()
{
    qDebug("toggleLocked");
    locked = toggleLocked->isChecked();
    if( locked )
    {
        toggleLocked->setIconSet(SmallIconSet("encrypted"));
    }
    else
    {
        toggleLocked->setIconSet(SmallIconSet("lockoverlay"));
    }

}


#include "karamba.moc"
